/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import com.google.common.collect.ImmutableList;
import gregtech.api.items.metaitem.stats.IItemNameProvider;
import gregtech.api.items.metaitem.stats.ISubItemHandler;
import gregtech.api.util.LocalizationUtils;
import gregtech.common.ConfigHolder;
import gregtech.common.covers.facade.FacadeHelper;
import java.util.Objects;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class FacadeItem
implements IItemNameProvider,
ISubItemHandler {
    @Override
    public String getItemStackDisplayName(ItemStack itemStack, String unlocalizedName) {
        ItemStack facadeStack = FacadeItem.getFacadeStack(itemStack);
        String name = facadeStack.func_77973_b().func_77653_i(facadeStack);
        return LocalizationUtils.format(unlocalizedName, name);
    }

    @Override
    public void getSubItems(ItemStack itemStack, CreativeTabs creativeTab, NonNullList<ItemStack> subItems) {
        ImmutableList validFacades = creativeTab == CreativeTabs.field_78027_g && !ConfigHolder.compat.hideFacadesInJEI ? FacadeHelper.getValidFacadeItems() : ImmutableList.of((Object)new ItemStack(Blocks.field_150348_b));
        for (ItemStack facadeStack : validFacades) {
            ItemStack resultStack = itemStack.func_77946_l();
            FacadeItem.setFacadeStack(resultStack, facadeStack);
            subItems.add((Object)resultStack);
        }
    }

    @Override
    public String getItemSubType(ItemStack itemStack) {
        ItemStack facadeStack = FacadeItem.getFacadeStack(itemStack);
        ResourceLocation registryName = Objects.requireNonNull(facadeStack.func_77973_b().getRegistryName());
        return String.format("%s:%s@%d", registryName.func_110624_b(), registryName.func_110623_a(), Items.field_151008_G.getDamage(facadeStack));
    }

    public static void setFacadeStack(ItemStack itemStack, ItemStack facadeStack) {
        facadeStack = facadeStack.func_77946_l();
        facadeStack.func_190920_e(1);
        if (!FacadeHelper.isValidFacade(facadeStack)) {
            facadeStack = new ItemStack(Blocks.field_150348_b);
        }
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tagCompound = Objects.requireNonNull(itemStack.func_77978_p());
        tagCompound.func_74782_a("Facade", (NBTBase)facadeStack.func_77955_b(new NBTTagCompound()));
    }

    public static ItemStack getFacadeStack(ItemStack itemStack) {
        ItemStack unsafeStack = FacadeItem.getFacadeStackUnsafe(itemStack);
        if (unsafeStack == null) {
            return new ItemStack(Blocks.field_150348_b);
        }
        return unsafeStack;
    }

    private static ItemStack getFacadeStackUnsafe(ItemStack itemStack) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null || !tagCompound.func_150297_b("Facade", 10)) {
            return null;
        }
        ItemStack facadeStack = new ItemStack(tagCompound.func_74775_l("Facade"));
        if (facadeStack.func_190926_b() || !FacadeHelper.isValidFacade(facadeStack)) {
            return null;
        }
        return facadeStack;
    }
}

