/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.armor;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.items.armor.ArmorLogicSuite;
import gregtech.api.items.armor.ArmorUtils;
import gregtech.api.util.GTUtility;
import gregtech.api.util.input.KeyBind;
import gregtech.common.items.armor.IJetpack;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class Jetpack
extends ArmorLogicSuite
implements IJetpack {
    @SideOnly(value=Side.CLIENT)
    protected ArmorUtils.ModularHUD HUD;

    public Jetpack(int energyPerUse, long capacity, int tier) {
        super(energyPerUse, capacity, tier, EntityEquipmentSlot.CHEST);
        if (ArmorUtils.SIDE.isClient() && this.shouldDrawHUD()) {
            this.HUD = new ArmorUtils.ModularHUD();
        }
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, @NotNull ItemStack stack) {
        NBTTagCompound data = GTUtility.getOrCreateNbtCompound(stack);
        byte toggleTimer = 0;
        boolean hover = false;
        if (data.func_74764_b("toggleTimer")) {
            toggleTimer = data.func_74771_c("toggleTimer");
        }
        if (data.func_74764_b("hover")) {
            hover = data.func_74767_n("hover");
        }
        if (toggleTimer == 0 && KeyBind.ARMOR_HOVER.isKeyDown(player)) {
            hover = !hover;
            toggleTimer = 5;
            data.func_74757_a("hover", hover);
            if (!world.field_72995_K) {
                if (hover) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("metaarmor.jetpack.hover.enable", new Object[0]), true);
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("metaarmor.jetpack.hover.disable", new Object[0]), true);
                }
            }
        }
        this.performFlying(player, hover, stack);
        if (toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
        }
        data.func_74757_a("hover", hover);
        data.func_74774_a("toggleTimer", toggleTimer);
        player.field_71069_bz.func_75142_b();
    }

    @Override
    public boolean canUseEnergy(@NotNull ItemStack stack, int amount) {
        IElectricItem container = Jetpack.getIElectricItem(stack);
        if (container == null) {
            return false;
        }
        return container.canUse(amount);
    }

    @Override
    public void drainEnergy(@NotNull ItemStack stack, int amount) {
        IElectricItem container = Jetpack.getIElectricItem(stack);
        if (container == null) {
            return;
        }
        container.discharge(amount, this.tier, true, false, false);
    }

    @Override
    public boolean hasEnergy(@NotNull ItemStack stack) {
        IElectricItem container = Jetpack.getIElectricItem(stack);
        if (container == null) {
            return false;
        }
        return container.getCharge() > 0L;
    }

    private static IElectricItem getIElectricItem(@NotNull ItemStack stack) {
        return (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "gregtech:textures/armor/jetpack.png";
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @NotNull ItemStack armor, DamageSource source, double damage, EntityEquipmentSlot equipmentSlot) {
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawHUD(ItemStack item) {
        Jetpack.addCapacityHUD(item, this.HUD);
        NBTTagCompound data = item.func_77978_p();
        if (data != null && data.func_74764_b("hover")) {
            String status = data.func_74767_n("hover") ? I18n.func_135052_a((String)"metaarmor.hud.status.enabled", (Object[])new Object[0]) : I18n.func_135052_a((String)"metaarmor.hud.status.disabled", (Object[])new Object[0]);
            String result = I18n.func_135052_a((String)"metaarmor.hud.hover_mode", (Object[])new Object[]{status});
            this.HUD.newString(result);
        }
        this.HUD.draw();
        this.HUD.reset();
    }

    @Override
    public void addInfo(ItemStack itemStack, List<String> lines) {
        super.addInfo(itemStack, lines);
        NBTTagCompound data = itemStack.func_77978_p();
        if (data != null) {
            String status = I18n.func_135052_a((String)"metaarmor.hud.status.disabled", (Object[])new Object[0]);
            if (data.func_74764_b("hover") && data.func_74767_n("hover")) {
                status = I18n.func_135052_a((String)"metaarmor.hud.status.enabled", (Object[])new Object[0]);
            }
            lines.add(I18n.func_135052_a((String)"metaarmor.hud.hover_mode", (Object[])new Object[]{status}));
        }
    }

    @Override
    public double getVerticalHoverSlowSpeed() {
        return 0.1;
    }

    @Override
    public double getVerticalAcceleration() {
        return 0.12;
    }

    @Override
    public double getVerticalSpeed() {
        return 0.3;
    }

    @Override
    public double getSidewaysSpeed() {
        return 0.08;
    }

    @Override
    public EnumParticleTypes getParticle() {
        return EnumParticleTypes.SMOKE_NORMAL;
    }
}

