/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.inventory.appeng;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import appeng.fluids.util.AEFluidStack;
import appeng.fluids.util.MeaningfulFluidIterator;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class SerializableFluidList
implements IItemList<IAEFluidStack>,
INBTSerializable<NBTTagList> {
    private final Reference2ObjectMap<Fluid, IAEFluidStack> records = new Reference2ObjectOpenHashMap();

    public void add(IAEFluidStack fluid) {
        if (fluid != null) {
            this.getOrCreateRecord(fluid).add(fluid);
        }
    }

    public IAEFluidStack findPrecise(IAEFluidStack fluid) {
        if (fluid == null) {
            return null;
        }
        return (IAEFluidStack)this.records.get((Object)fluid.getFluid());
    }

    public Collection<IAEFluidStack> findFuzzy(IAEFluidStack filter, FuzzyMode fuzzy) {
        IAEFluidStack stack = this.findPrecise(filter);
        return stack != null ? Collections.singleton(stack) : Collections.emptyList();
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    private IAEFluidStack getOrCreateRecord(@NotNull IAEFluidStack fluid) {
        return (IAEFluidStack)this.records.computeIfAbsent((Object)fluid.getFluid(), key -> AEFluidStack.fromFluidStack((FluidStack)new FluidStack(key, 0)));
    }

    private IAEFluidStack getRecord(@NotNull IAEFluidStack fluid) {
        return (IAEFluidStack)this.records.get((Object)fluid.getFluid());
    }

    public void addStorage(IAEFluidStack fluid) {
        if (fluid != null) {
            this.getOrCreateRecord(fluid).incStackSize(fluid.getStackSize());
        }
    }

    public void addCrafting(IAEFluidStack fluid) {
        IAEFluidStack record;
        if (fluid != null && (record = this.getRecord(fluid)) != null) {
            record.setCraftable(true);
        }
    }

    public void addRequestable(IAEFluidStack fluid) {
        IAEFluidStack record;
        if (fluid != null && (record = this.getRecord(fluid)) != null) {
            record.setCountRequestable(record.getCountRequestable() + fluid.getCountRequestable());
        }
    }

    public IAEFluidStack getFirstItem() {
        Iterator<IAEFluidStack> iterator = this.iterator();
        if (iterator.hasNext()) {
            IAEFluidStack fluid = iterator.next();
            return fluid;
        }
        return null;
    }

    public int size() {
        return this.records.size();
    }

    public Iterator<IAEFluidStack> iterator() {
        return new MeaningfulFluidIterator((Iterator)this.records.values().iterator());
    }

    public void resetStatus() {
        Iterator<IAEFluidStack> iterator = this.iterator();
        while (iterator.hasNext()) {
            IAEFluidStack i = iterator.next();
            i.reset();
        }
    }

    public NBTTagList serializeNBT() {
        NBTTagList list = new NBTTagList();
        Iterator<IAEFluidStack> iterator = this.iterator();
        while (iterator.hasNext()) {
            IAEFluidStack fluid = iterator.next();
            if (fluid == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            fluid.writeToNBT(tag);
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }

    public void deserializeNBT(NBTTagList list) {
        for (NBTBase tag : list) {
            IAEFluidStack fluid;
            if (!(tag instanceof NBTTagCompound) || (fluid = AEFluidStack.fromNBT((NBTTagCompound)((NBTTagCompound)tag))) == null) continue;
            this.records.put((Object)fluid.getFluid(), (Object)fluid);
        }
    }
}

