/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget.appeng.slot;

import appeng.api.storage.data.IAEFluidStack;
import com.google.common.collect.Lists;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.util.FluidTooltipUtil;
import gregtech.api.util.GTUtility;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.utils.RenderUtil;
import gregtech.common.gui.widget.appeng.AEConfigWidget;
import gregtech.common.gui.widget.appeng.slot.AEConfigSlot;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.IConfigurableSlot;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.stack.WrappedFluidStack;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class AEFluidConfigSlot
extends AEConfigSlot<IAEFluidStack> {
    public AEFluidConfigSlot(int x, int y, AEConfigWidget<IAEFluidStack> widget, int index) {
        super(new Position(x, y), new Size(18, 36), widget, index);
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        String amountStr;
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
        Position position = this.getPosition();
        IConfigurableSlot slot = this.parentWidget.getDisplay(this.index);
        IAEFluidStack config = (IAEFluidStack)slot.getConfig();
        IAEFluidStack stock = (IAEFluidStack)slot.getStock();
        GuiTextures.FLUID_SLOT.draw(position.x, position.y, 18, 18);
        GuiTextures.FLUID_SLOT.draw(position.x, position.y + 18, 18, 18);
        GuiTextures.CONFIG_ARROW.draw(position.x, position.y, 18, 18);
        if (this.select) {
            GuiTextures.SELECT_BOX.draw(position.x, position.y, 18, 18);
        }
        int stackX = position.x + 1;
        int stackY = position.y + 1;
        if (config != null) {
            RenderUtil.drawFluidForGui(config.getFluidStack(), config.getFluidStack().amount, stackX, stackY, 17, 17);
            amountStr = TextFormattingUtil.formatLongToCompactString(config.getStackSize(), 4) + "L";
            AEFluidConfigSlot.drawStringFixedCorner(amountStr, stackX + 17, stackY + 17, 0xFFFFFF, true, 0.5f);
        }
        if (stock != null) {
            RenderUtil.drawFluidForGui(stock.getFluidStack(), stock.getFluidStack().amount, stackX, stackY + 18, 17, 17);
            amountStr = TextFormattingUtil.formatLongToCompactString(stock.getStackSize(), 4) + "L";
            AEFluidConfigSlot.drawStringFixedCorner(amountStr, stackX + 17, stackY + 18 + 17, 0xFFFFFF, true, 0.5f);
        }
        if (this.mouseOverConfig(mouseX, mouseY)) {
            AEFluidConfigSlot.drawSelectionOverlay(stackX, stackY, 16, 16);
        } else if (this.mouseOverStock(mouseX, mouseY)) {
            AEFluidConfigSlot.drawSelectionOverlay(stackX, stackY + 18, 16, 16);
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        super.drawInForeground(mouseX, mouseY);
        IAEFluidStack fluid = null;
        boolean displayAmt = false;
        IConfigurableSlot slot = this.parentWidget.getDisplay(this.index);
        if (this.mouseOverConfig(mouseX, mouseY)) {
            fluid = (IAEFluidStack)slot.getConfig();
        } else if (this.mouseOverStock(mouseX, mouseY)) {
            fluid = (IAEFluidStack)slot.getStock();
            displayAmt = true;
        }
        if (fluid != null) {
            List<String> formula;
            ArrayList<String> hoverStringList = new ArrayList<String>();
            hoverStringList.add(fluid.getFluidStack().getLocalizedName());
            if (displayAmt) {
                hoverStringList.add(String.format("%,d L", fluid.getStackSize()));
            }
            if ((formula = FluidTooltipUtil.getFluidTooltip(fluid.getFluidStack())) != null) {
                for (String s : formula) {
                    if (s.isEmpty()) continue;
                    hoverStringList.add(s);
                }
            }
            this.drawHoveringText(ItemStack.field_190927_a, hoverStringList, -1, mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.mouseOverConfig(mouseX, mouseY)) {
            if (button == 1) {
                this.parentWidget.disableAmount();
                this.writeClientAction(1000, buf -> {});
            } else if (button == 0) {
                ItemStack hold = this.gui.entityPlayer.field_71071_by.func_70445_o();
                FluidStack fluid = FluidUtil.getFluidContained((ItemStack)hold);
                if (fluid != null) {
                    this.writeClientAction(1001, buf -> {
                        buf.func_180714_a(fluid.getFluid().getName());
                        buf.func_150787_b(fluid.amount);
                    });
                }
                this.parentWidget.enableAmount(this.index);
                this.select = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        FluidStack fluid;
        super.handleClientAction(id, buffer);
        IConfigurableSlot<WrappedFluidStack> slot = this.parentWidget.getConfig(this.index);
        if (id == 1000) {
            slot.setConfig(null);
            this.parentWidget.disableAmount();
            this.writeUpdateInfo(1000, buf -> {});
        }
        if (id == 1001) {
            fluid = FluidRegistry.getFluidStack((String)buffer.func_150789_c(0x7FFFFFF), (int)buffer.func_150792_a());
            slot.setConfig(WrappedFluidStack.fromFluidStack(fluid));
            this.parentWidget.enableAmount(this.index);
            if (fluid != null) {
                this.writeUpdateInfo(1001, buf -> {
                    buf.func_180714_a(fluid.getFluid().getName());
                    buf.func_150787_b(fluid.amount);
                });
            }
        }
        if (id == 1002 && slot.getConfig() != null) {
            int amt = buffer.readInt();
            ((IAEFluidStack)slot.getConfig()).setStackSize((long)amt);
            this.writeUpdateInfo(1002, buf -> buf.writeInt(amt));
        }
        if (id == GregtechDataCodes.LOAD_PHANTOM_FLUID_STACK_FROM_NBT) {
            try {
                fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)buffer.func_150793_b());
                slot.setConfig(WrappedFluidStack.fromFluidStack(fluid));
                this.parentWidget.enableAmount(this.index);
                if (fluid != null) {
                    this.writeUpdateInfo(1001, buf -> {
                        buf.func_180714_a(fluid.getFluid().getName());
                        buf.func_150787_b(fluid.amount);
                    });
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        super.readUpdateInfo(id, buffer);
        IConfigurableSlot<WrappedFluidStack> slot = this.parentWidget.getDisplay(this.index);
        if (id == 1000) {
            slot.setConfig(null);
        }
        if (id == 1001) {
            FluidStack fluid = FluidRegistry.getFluidStack((String)buffer.func_150789_c(0x7FFFFFF), (int)buffer.func_150792_a());
            slot.setConfig(WrappedFluidStack.fromFluidStack(fluid));
        }
        if (id == 1002 && slot.getConfig() != null) {
            int amt = buffer.readInt();
            ((IAEFluidStack)slot.getConfig()).setStackSize((long)amt);
        }
    }

    @Override
    public List<IGhostIngredientHandler.Target<?>> getPhantomTargets(Object ingredient) {
        if (GTUtility.getFluidFromContainer(ingredient) == null) {
            return Collections.emptyList();
        }
        final Rectangle rectangle = this.toRectangleBox();
        rectangle.height /= 2;
        return Lists.newArrayList((Object[])new IGhostIngredientHandler.Target[]{new IGhostIngredientHandler.Target<Object>(){

            @NotNull
            public Rectangle getArea() {
                return rectangle;
            }

            public void accept(@NotNull Object ingredient) {
                FluidStack stack = GTUtility.getFluidFromContainer(ingredient);
                if (stack != null) {
                    NBTTagCompound compound = stack.writeToNBT(new NBTTagCompound());
                    AEFluidConfigSlot.this.writeClientAction(GregtechDataCodes.LOAD_PHANTOM_FLUID_STACK_FROM_NBT, buf -> buf.func_150786_a(compound));
                }
            }
        }});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseWheelMove(int mouseX, int mouseY, int wheelDelta) {
        long amt;
        IConfigurableSlot slot = this.parentWidget.getDisplay(this.index);
        Rectangle rectangle = this.toRectangleBox();
        rectangle.height /= 2;
        if (slot.getConfig() == null || wheelDelta == 0 || !rectangle.contains(mouseX, mouseY)) {
            return false;
        }
        FluidStack fluid = ((IAEFluidStack)slot.getConfig()).getFluidStack();
        if (AEFluidConfigSlot.isCtrlDown()) {
            amt = wheelDelta > 0 ? (long)fluid.amount * 2L : (long)fluid.amount / 2L;
        } else {
            long l = amt = wheelDelta > 0 ? (long)fluid.amount + 1L : (long)fluid.amount - 1L;
        }
        if (amt > 0L && amt < 0x80000000L) {
            int finalAmt = (int)amt;
            this.writeClientAction(1002, buf -> buf.writeInt(finalAmt));
            return true;
        }
        return false;
    }
}

