/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget.appeng;

import appeng.api.storage.data.IAEFluidStack;
import gregtech.common.gui.widget.appeng.AEConfigWidget;
import gregtech.common.gui.widget.appeng.slot.AEFluidConfigSlot;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.IConfigurableSlot;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.MetaTileEntityMEInputHatch;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.stack.WrappedFluidStack;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.PacketBuffer;

public class AEFluidConfigWidget
extends AEConfigWidget<IAEFluidStack> {
    public AEFluidConfigWidget(int x, int y, IConfigurableSlot<IAEFluidStack>[] config) {
        super(x, y, config);
    }

    @Override
    void init() {
        this.displayList = new IConfigurableSlot[this.config.length];
        this.cached = new IConfigurableSlot[this.config.length];
        for (int index = 0; index < this.config.length; ++index) {
            this.displayList[index] = new MetaTileEntityMEInputHatch.ExportOnlyAEFluid();
            this.cached[index] = new MetaTileEntityMEInputHatch.ExportOnlyAEFluid();
            int line = index / 8;
            this.addWidget(new AEFluidConfigSlot((index - line * 8) * 18, line * 38, this, index));
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 1000) {
            int size = buffer.func_150792_a();
            for (int i = 0; i < size; ++i) {
                int index = buffer.func_150792_a();
                IConfigurableSlot slot = this.displayList[index];
                if (buffer.readBoolean()) {
                    slot.setConfig(WrappedFluidStack.fromPacket((ByteBuf)buffer));
                } else {
                    slot.setConfig(null);
                }
                if (buffer.readBoolean()) {
                    slot.setStock(WrappedFluidStack.fromPacket((ByteBuf)buffer));
                    continue;
                }
                slot.setStock(null);
            }
        }
    }
}

