/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget.appeng;

import appeng.api.storage.data.IAEStack;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.AbstractWidgetGroup;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.common.gui.widget.appeng.slot.AEConfigSlot;
import gregtech.common.gui.widget.appeng.slot.AmountSetSlot;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.IConfigurableSlot;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;

public abstract class AEConfigWidget<T extends IAEStack<T>>
extends AbstractWidgetGroup {
    protected final IConfigurableSlot<T>[] config;
    protected IConfigurableSlot<T>[] cached;
    protected Int2ObjectMap<IConfigurableSlot<T>> changeMap = new Int2ObjectOpenHashMap();
    protected IConfigurableSlot<T>[] displayList;
    protected AmountSetSlot<T> amountSetWidget;
    protected static final int UPDATE_ID = 1000;

    public AEConfigWidget(int x, int y, IConfigurableSlot<T>[] config) {
        super(new Position(x, y), new Size(config.length * 18, 36));
        this.config = config;
        this.init();
        this.amountSetWidget = new AmountSetSlot(80, -40, this);
        this.addWidget(this.amountSetWidget);
        this.addWidget(this.amountSetWidget.getText());
        this.amountSetWidget.setVisible(false);
        this.amountSetWidget.getText().setVisible(false);
    }

    public void enableAmount(int slotIndex) {
        this.amountSetWidget.setSlotIndex(slotIndex);
        this.amountSetWidget.setVisible(true);
        this.amountSetWidget.getText().setVisible(true);
    }

    public void disableAmount() {
        this.amountSetWidget.setSlotIndex(-1);
        this.amountSetWidget.setVisible(false);
        this.amountSetWidget.getText().setVisible(false);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.amountSetWidget.isVisible() && this.amountSetWidget.getText().mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        for (Widget w : this.widgets) {
            if (!(w instanceof AEConfigSlot)) continue;
            ((AEConfigSlot)w).setSelect(false);
        }
        this.disableAmount();
        return super.mouseClicked(mouseX, mouseY, button);
    }

    abstract void init();

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        this.changeMap.clear();
        for (int index = 0; index < this.config.length; ++index) {
            IConfigurableSlot<T> newSlot = this.config[index];
            IConfigurableSlot<T> oldSlot = this.cached[index];
            IAEStack nConfig = (IAEStack)newSlot.getConfig();
            IAEStack nStock = (IAEStack)newSlot.getStock();
            IAEStack oConfig = (IAEStack)oldSlot.getConfig();
            IAEStack oStock = (IAEStack)oldSlot.getStock();
            if (this.areAEStackCountEquals(nConfig, oConfig) && this.areAEStackCountEquals(nStock, oStock)) continue;
            this.changeMap.put(index, newSlot.copy());
            this.cached[index] = this.config[index].copy();
            this.gui.holder.markAsDirty();
        }
        if (!this.changeMap.isEmpty()) {
            this.writeUpdateInfo(1000, buf -> {
                try {
                    buf.func_150787_b(this.changeMap.size());
                    IntIterator intIterator = this.changeMap.keySet().iterator();
                    while (intIterator.hasNext()) {
                        int index = (Integer)intIterator.next();
                        IAEStack sConfig = (IAEStack)((IConfigurableSlot)this.changeMap.get(index)).getConfig();
                        IAEStack sStock = (IAEStack)((IConfigurableSlot)this.changeMap.get(index)).getStock();
                        buf.func_150787_b(index);
                        if (sConfig != null) {
                            buf.writeBoolean(true);
                            sConfig.writeToPacket((ByteBuf)buf);
                        } else {
                            buf.writeBoolean(false);
                        }
                        if (sStock != null) {
                            buf.writeBoolean(true);
                            sStock.writeToPacket((ByteBuf)buf);
                            continue;
                        }
                        buf.writeBoolean(false);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    }

    public final IConfigurableSlot<T> getConfig(int index) {
        return this.config[index];
    }

    public final IConfigurableSlot<T> getDisplay(int index) {
        return this.displayList[index];
    }

    protected final boolean areAEStackCountEquals(T s1, T s2) {
        if (s2 == s1) {
            return true;
        }
        if (s1 != null && s2 != null) {
            return s1.getStackSize() == s2.getStackSize() && s1.equals(s2);
        }
        return false;
    }
}

