/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.crafting;

import gregtech.common.crafting.GTShapedOreRecipe;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;

public class FluidReplaceRecipe
extends GTShapedOreRecipe {
    public FluidReplaceRecipe(boolean isClearing, ResourceLocation group, @NotNull ItemStack result, Object ... recipe) {
        super(isClearing, group, result, recipe);
    }

    @Override
    @NotNull
    public NonNullList<ItemStack> func_179532_b(@NotNull InventoryCrafting inv) {
        if (this.isClearing) {
            return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        }
        NonNullList ret = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < ret.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                ret.set(i, (Object)ItemStack.field_190927_a);
                continue;
            }
            ret.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)stack));
        }
        return ret;
    }

    @NotNull
    public ItemStack func_77572_b(@NotNull InventoryCrafting inv) {
        IFluidHandlerItem recipeCap = (IFluidHandlerItem)this.output.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (recipeCap == null) {
            throw new IllegalStateException("FluidReplaceRecipe output did not have an IFluidHandlerItem capability");
        }
        FluidStack outputFluid = recipeCap.drain(Integer.MAX_VALUE, false);
        if (outputFluid == null) {
            throw new IllegalStateException("FluidReplaceRecipe output did not have a fluid");
        }
        if (outputFluid.amount != 1000) {
            throw new IllegalStateException("FluidReplaceRecipe output must have exactly 1000mB of fluid");
        }
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            boolean isBucket;
            ItemStack output;
            FluidStack inputFluid;
            ItemStack input = inv.func_70301_a(i);
            IFluidHandlerItem inputCap = (IFluidHandlerItem)input.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (inputCap == null || (inputFluid = inputCap.drain(Integer.MAX_VALUE, false)) != null && inputFluid.amount != 1000) continue;
            if (FluidReplaceRecipe.isBucket(input.func_77973_b())) {
                output = new ItemStack((Item)ForgeModContainer.getInstance().universalBucket);
                isBucket = true;
            } else {
                output = input.func_77946_l();
                isBucket = false;
            }
            IFluidHandlerItem outputCap = (IFluidHandlerItem)output.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (outputCap == null) {
                return ItemStack.field_190927_a;
            }
            outputCap.drain(Integer.MAX_VALUE, true);
            FluidStack drained = inputCap.drain(1000, false);
            if (drained != null && drained.amount == 1000) {
                if (isBucket) {
                    if (FluidRegistry.hasBucket((Fluid)outputFluid.getFluid())) {
                        return FluidUtil.getFilledBucket((FluidStack)outputFluid.copy());
                    }
                    return ItemStack.field_190927_a;
                }
                if (outputCap.fill(outputFluid.copy(), true) == 1000) {
                    return output;
                }
            }
            return ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    private static boolean isBucket(@NotNull Item item) {
        return item == Items.field_151131_as || item == Items.field_151129_at || item == Items.field_151117_aB || item == ForgeModContainer.getInstance().universalBucket;
    }
}

