/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter.oreglob.node;

import com.google.common.collect.Lists;
import gregtech.common.covers.filter.oreglob.node.AnyCharNode;
import gregtech.common.covers.filter.oreglob.node.BranchNode;
import gregtech.common.covers.filter.oreglob.node.BranchType;
import gregtech.common.covers.filter.oreglob.node.EmptyNode;
import gregtech.common.covers.filter.oreglob.node.ErrorNode;
import gregtech.common.covers.filter.oreglob.node.EverythingNode;
import gregtech.common.covers.filter.oreglob.node.GroupNode;
import gregtech.common.covers.filter.oreglob.node.MatchDescription;
import gregtech.common.covers.filter.oreglob.node.MatchNode;
import gregtech.common.covers.filter.oreglob.node.OreGlobNode;
import java.util.List;

public class OreGlobNodes {
    public static OreGlobNode match(String match) {
        return OreGlobNodes.match(match, true);
    }

    public static OreGlobNode match(String match, boolean ignoreCase) {
        if (match.isEmpty()) {
            return OreGlobNodes.empty();
        }
        return new MatchNode(match, ignoreCase);
    }

    public static OreGlobNode chars(int amount, boolean more) {
        if (amount == 0) {
            return more ? OreGlobNodes.everything() : OreGlobNodes.empty();
        }
        if (amount == 1 && more) {
            return OreGlobNodes.nonempty();
        }
        return new AnyCharNode(amount, more);
    }

    public static OreGlobNode group(OreGlobNode node) {
        return new GroupNode(node);
    }

    public static OreGlobNode everything() {
        return new EverythingNode();
    }

    public static OreGlobNode nothing() {
        return OreGlobNodes.not(OreGlobNodes.everything());
    }

    public static OreGlobNode nonempty() {
        return OreGlobNodes.not(OreGlobNodes.empty());
    }

    public static OreGlobNode empty() {
        return new EmptyNode();
    }

    public static OreGlobNode or(OreGlobNode ... expressions) {
        return OreGlobNodes.or(Lists.newArrayList((Object[])expressions));
    }

    public static OreGlobNode or(List<OreGlobNode> expressions) {
        OreGlobNode oreGlobNode;
        MatchDescription union = MatchDescription.NOTHING;
        for (int i = 0; i < expressions.size(); ++i) {
            OreGlobNode expr = expressions.get(i);
            if (expr.is(MatchDescription.EVERYTHING)) {
                return expr;
            }
            if (union.covers(expr.getMatchDescription())) {
                expressions.remove(i--);
                continue;
            }
            if (expr.getMatchDescription().covers(union)) {
                while (i != 0) {
                    expressions.remove(0);
                    --i;
                }
                union = expr.getMatchDescription();
            } else {
                union = union.or(expr.getMatchDescription());
            }
            if (union != MatchDescription.EVERYTHING) continue;
            return OreGlobNodes.everything();
        }
        switch (expressions.size()) {
            case 0: {
                oreGlobNode = OreGlobNodes.nothing();
                break;
            }
            case 1: {
                oreGlobNode = expressions.get(0);
                break;
            }
            default: {
                oreGlobNode = new BranchNode(BranchType.OR, expressions);
            }
        }
        return oreGlobNode;
    }

    public static OreGlobNode and(OreGlobNode ... expressions) {
        return OreGlobNodes.and(Lists.newArrayList((Object[])expressions));
    }

    public static OreGlobNode and(List<OreGlobNode> expressions) {
        OreGlobNode oreGlobNode;
        MatchDescription intersection = MatchDescription.EVERYTHING;
        for (int i = 0; i < expressions.size(); ++i) {
            OreGlobNode expr = expressions.get(i);
            if (expr.is(MatchDescription.NOTHING)) {
                return expr;
            }
            if (expr.getMatchDescription().covers(intersection)) {
                expressions.remove(i--);
                continue;
            }
            if (intersection.covers(expr.getMatchDescription())) {
                while (i != 0) {
                    expressions.remove(0);
                    --i;
                }
                intersection = expr.getMatchDescription();
            } else {
                intersection = intersection.and(expr.getMatchDescription());
            }
            if (intersection != MatchDescription.NOTHING) continue;
            return OreGlobNodes.nothing();
        }
        switch (expressions.size()) {
            case 0: {
                oreGlobNode = OreGlobNodes.everything();
                break;
            }
            case 1: {
                oreGlobNode = expressions.get(0);
                break;
            }
            default: {
                oreGlobNode = new BranchNode(BranchType.AND, expressions);
            }
        }
        return oreGlobNode;
    }

    public static OreGlobNode xor(OreGlobNode ... expressions) {
        return OreGlobNodes.xor(Lists.newArrayList((Object[])expressions));
    }

    public static OreGlobNode xor(List<OreGlobNode> expressions) {
        OreGlobNode oreGlobNode;
        boolean not = false;
        for (int i1 = 0; i1 < expressions.size(); ++i1) {
            OreGlobNode expr = expressions.get(i1);
            if (expr.is(MatchDescription.NOTHING)) {
                expressions.remove(i1--);
                continue;
            }
            if (expr.is(MatchDescription.EVERYTHING)) {
                expressions.remove(i1--);
                not = !not;
                continue;
            }
            MatchDescription desc = expr.getMatchDescription();
            if (!desc.isComplete()) continue;
            for (int i2 = 0; i2 < i1; ++i2) {
                MatchDescription desc2 = expressions.get(i2).getMatchDescription();
                if (desc == desc2) {
                    expressions.remove(i1--);
                    expressions.remove(i2--);
                    continue;
                }
                if (desc.complement() != desc2) continue;
                expressions.remove(i1--);
                expressions.remove(i2--);
                not = !not;
            }
        }
        switch (expressions.size()) {
            case 0: {
                oreGlobNode = OreGlobNodes.nothing();
                break;
            }
            case 1: {
                oreGlobNode = expressions.get(0);
                break;
            }
            default: {
                oreGlobNode = new BranchNode(BranchType.XOR, expressions);
            }
        }
        OreGlobNode node = oreGlobNode;
        return not ? OreGlobNodes.not(node) : node;
    }

    public static OreGlobNode error() {
        return new ErrorNode();
    }

    public static OreGlobNode not(OreGlobNode node) {
        if (node.hasNext()) {
            GroupNode newNode = new GroupNode(node);
            newNode.setNegated(true);
            return newNode;
        }
        node.setNegated(!node.isNegated());
        node.clearMatchDescriptionCache();
        return node;
    }

    public static OreGlobNode append(OreGlobNode node, OreGlobNode next) {
        if (node.is(MatchDescription.NOTHING) || next.is(MatchDescription.EMPTY)) {
            return node;
        }
        if (next.is(MatchDescription.NOTHING) || node.is(MatchDescription.EMPTY)) {
            return next;
        }
        if (node instanceof MatchNode) {
            MatchNode n1 = (MatchNode)node;
            if (next instanceof MatchNode) {
                MatchNode n2 = (MatchNode)next;
                if (!node.isNegated() && !next.isNegated()) {
                    if (n1.ignoreCase == n2.ignoreCase) {
                        if (!n2.match.isEmpty()) {
                            n1.match = n1.match + n2.match;
                            n1.clearMatchDescriptionCache();
                        }
                        n1.setNext(n2.getNext());
                        return n1;
                    }
                } else if (node.isNegated() && next.isNegated() && !n1.match.isEmpty() && !n2.match.isEmpty()) {
                    if (n1.getMatchLength() > 1 || n2.getMatchLength() > 1) {
                        return OreGlobNodes.everything();
                    }
                    if (n1.isMatchEquals(n2)) {
                        n1.setNext(n2.getNext());
                        return n1;
                    }
                    OreGlobNode newNode = OreGlobNodes.or(n1, n2);
                    newNode.setNext(n2.getNext());
                    n1.setNext(null);
                    n2.setNext(null);
                    return newNode;
                }
            }
        } else if (node instanceof AnyCharNode) {
            AnyCharNode n1 = (AnyCharNode)node;
            if (!node.isNegated()) {
                if (next.is(MatchDescription.EVERYTHING)) {
                    if (n1.amount == 0) {
                        return OreGlobNodes.everything();
                    }
                    if (n1.amount == 1) {
                        return OreGlobNodes.nonempty();
                    }
                    if (!n1.more) {
                        n1.more = true;
                        n1.clearMatchDescriptionCache();
                    }
                    n1.setNext(null);
                    return n1;
                }
                if (next.is(MatchDescription.NONEMPTY)) {
                    if (n1.amount == 0) {
                        return OreGlobNodes.nonempty();
                    }
                    ++n1.amount;
                    if (!n1.more) {
                        n1.more = true;
                        n1.clearMatchDescriptionCache();
                    }
                    n1.clearMatchDescriptionCache();
                    n1.setNext(null);
                    return n1;
                }
                if (next instanceof AnyCharNode) {
                    AnyCharNode n2 = (AnyCharNode)next;
                    if (!next.isNegated()) {
                        n1.amount += n2.amount;
                        n1.more |= n2.more;
                        if (n1.amount == 0) {
                            return n1.more ? OreGlobNodes.everything() : OreGlobNodes.empty();
                        }
                        if (n1.amount == 1 && n1.more) {
                            return OreGlobNodes.nonempty();
                        }
                        n1.setNext(n2.getNext());
                        n1.clearMatchDescriptionCache();
                        return n1;
                    }
                }
            }
        }
        node.setNext(next);
        return node;
    }

    public static OreGlobNode append(OreGlobNode ... nodes) {
        if (nodes.length == 0) {
            throw new IllegalArgumentException("No nodes provided");
        }
        for (int i = nodes.length - 2; i >= 0; --i) {
            nodes[i] = OreGlobNodes.append(nodes[i], nodes[i + 1]);
        }
        return nodes[0];
    }

    public static boolean isNegatedMatch(OreGlobNode node) {
        return node.isNegated() && node instanceof MatchNode;
    }
}

