/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter.oreglob.node;

import gregtech.common.covers.filter.oreglob.node.MatchDescription;
import gregtech.common.covers.filter.oreglob.node.NodeVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OreGlobNode {
    @Nullable
    private OreGlobNode next;
    private boolean negated;
    @Nullable
    private MatchDescription descriptionCache;

    OreGlobNode() {
    }

    @Nullable
    public final OreGlobNode getNext() {
        return this.next;
    }

    public final boolean hasNext() {
        return this.next != null;
    }

    final void setNext(@Nullable OreGlobNode next) {
        if (this.next != next) {
            this.next = next;
            this.clearMatchDescriptionCache();
        }
    }

    public final boolean isNegated() {
        return this.negated;
    }

    final void setNegated(boolean negated) {
        if (this.negated != negated) {
            this.negated = negated;
            this.clearMatchDescriptionCache();
        }
    }

    public abstract void visit(NodeVisitor var1);

    public boolean isStructurallyEqualTo(@NotNull OreGlobNode node) {
        if (this == node) {
            return true;
        }
        if (this.isNegated() != node.isNegated()) {
            return false;
        }
        return this.isPropertyEqualTo(node) && OreGlobNode.isStructurallyEqualTo(this.getNext(), node.getNext());
    }

    public final MatchDescription getMatchDescription() {
        if (this.descriptionCache == null) {
            MatchDescription t = this.getIndividualNodeMatchDescription();
            if (t != MatchDescription.NOTHING && this.getNext() != null) {
                t = t.append(this.getNext().getMatchDescription());
            }
            this.descriptionCache = t;
            return this.descriptionCache;
        }
        return this.descriptionCache;
    }

    public final boolean is(MatchDescription description) {
        return this.getMatchDescription() == description;
    }

    public abstract boolean isPropertyEqualTo(@NotNull OreGlobNode var1);

    protected abstract MatchDescription getIndividualNodeMatchDescription();

    final void clearMatchDescriptionCache() {
        this.descriptionCache = null;
    }

    public static boolean isStructurallyEqualTo(@Nullable OreGlobNode node1, @Nullable OreGlobNode node2) {
        if (node1 == node2) {
            return true;
        }
        if (node1 == null) {
            return node2.is(MatchDescription.EMPTY);
        }
        if (node2 == null) {
            return node1.is(MatchDescription.EMPTY);
        }
        return node1.isStructurallyEqualTo(node2);
    }
}

