/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.DrawableWidget;
import gregtech.api.gui.widgets.ImageCycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.stack.ItemVariantMap;
import gregtech.api.unification.stack.MultiItemVariantMap;
import gregtech.api.unification.stack.SingleItemVariantMap;
import gregtech.api.util.function.BooleanConsumer;
import gregtech.api.util.oreglob.OreGlob;
import gregtech.api.util.oreglob.OreGlobCompileResult;
import gregtech.common.covers.filter.ItemFilter;
import gregtech.common.covers.filter.oreglob.impl.ImpossibleOreGlob;
import gregtech.common.gui.widget.HighlightedTextField;
import gregtech.common.gui.widget.orefilter.ItemOreFilterTestSlot;
import gregtech.common.gui.widget.orefilter.OreGlobCompileStatusWidget;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OreDictionaryItemFilter
extends ItemFilter {
    private final Map<Item, ItemVariantMap.Mutable<Boolean>> matchCache = new Object2ObjectOpenHashMap();
    private final SingleItemVariantMap<Boolean> noOreDictMatch = new SingleItemVariantMap();
    protected String expression = "";
    private OreGlob glob = ImpossibleOreGlob.getInstance();
    private boolean error;
    private boolean caseSensitive;
    private boolean matchAll;

    @NotNull
    public String getExpression() {
        return this.expression;
    }

    @NotNull
    public OreGlob getGlob() {
        return this.glob;
    }

    protected void recompile(@Nullable @Nullable Consumer<@Nullable OreGlobCompileResult> callback) {
        this.clearCache();
        String expr = this.expression;
        if (!expr.isEmpty()) {
            OreGlobCompileResult result = OreGlob.compile(expr, !this.caseSensitive);
            this.glob = result.getInstance();
            this.error = result.hasError();
            if (callback != null) {
                callback.accept(result);
            }
        } else {
            this.glob = ImpossibleOreGlob.getInstance();
            this.error = true;
            if (callback != null) {
                callback.accept(null);
            }
        }
    }

    protected void clearCache() {
        this.matchCache.clear();
        this.noOreDictMatch.clear();
    }

    @Override
    public void initUI(Consumer<Widget> widgetGroup) {
        ItemOreFilterTestSlot[] testSlot = new ItemOreFilterTestSlot[5];
        for (int i2 = 0; i2 < testSlot.length; ++i2) {
            ItemOreFilterTestSlot slot = new ItemOreFilterTestSlot(20 + 22 * i2, 0);
            slot.setGlob(this.getGlob());
            slot.setMatchAll(this.matchAll);
            widgetGroup.accept(slot);
            testSlot[i2] = slot;
        }
        OreGlobCompileStatusWidget compilationStatus = new OreGlobCompileStatusWidget(10, 10);
        Consumer<@Nullable OreGlobCompileResult> compileCallback = result -> {
            compilationStatus.setCompileResult((OreGlobCompileResult)result);
            for (ItemOreFilterTestSlot slot : testSlot) {
                slot.setGlob(this.getGlob());
            }
        };
        HighlightedTextField textField = new HighlightedTextField(14, 26, 152, 14, () -> this.expression, s -> {
            if (s.equals(this.expression)) {
                return;
            }
            this.expression = s;
            this.markDirty();
            this.recompile(compileCallback);
        });
        compilationStatus.setTextField(textField);
        widgetGroup.accept(new ImageWidget(10, 0, 7, 7, GuiTextures.ORE_FILTER_INFO).setTooltip("cover.ore_dictionary_filter.info"));
        widgetGroup.accept(compilationStatus);
        widgetGroup.accept(new DrawableWidget(10, 22, 156, 16).setBackgroundDrawer((mouseX, mouseY, partialTicks, context, widget) -> {
            Widget.drawGradientRect(widget.getPosition().x, widget.getPosition().y, widget.getSize().width, widget.getSize().height, -8355712, -8355712, false);
            Widget.drawGradientRect(widget.getPosition().x + 1, widget.getPosition().y + 1, widget.getSize().width - 2, widget.getSize().height - 2, -16777216, -16777216, false);
        }));
        widgetGroup.accept(textField.setHighlightRule(h -> {
            String t = h.getOriginalText();
            block11: for (int i = 0; i < t.length(); ++i) {
                block0 : switch (t.charAt(i)) {
                    case '&': 
                    case '(': 
                    case ')': 
                    case '^': 
                    case '|': {
                        h.format(i, TextFormatting.GOLD);
                        break;
                    }
                    case '*': 
                    case '?': {
                        h.format(i, TextFormatting.GREEN);
                        break;
                    }
                    case '!': {
                        h.format(i, TextFormatting.RED);
                        break;
                    }
                    case '\\': {
                        h.format(i++, TextFormatting.YELLOW);
                        break;
                    }
                    case '$': {
                        h.format(i, TextFormatting.DARK_GREEN);
                        while (i < t.length()) {
                            switch (t.charAt(i)) {
                                case '\t': 
                                case '\n': 
                                case '\r': 
                                case ' ': {
                                    break block0;
                                }
                                case '\\': {
                                    ++i;
                                    break;
                                }
                            }
                            ++i;
                        }
                        break;
                    }
                    default: {
                        continue block11;
                    }
                }
                h.format(i + 1, TextFormatting.RESET);
            }
        }).setMaxLength(64));
        widgetGroup.accept(new ForcedInitialSyncImageCycleButtonWidget(130, 38, 18, 18, GuiTextures.ORE_FILTER_BUTTON_CASE_SENSITIVE, () -> this.caseSensitive, caseSensitive -> {
            if (this.caseSensitive == caseSensitive) {
                return;
            }
            this.caseSensitive = caseSensitive;
            this.markDirty();
            this.recompile(compileCallback);
        }).setTooltipHoverString(i -> "cover.ore_dictionary_filter.button.case_sensitive." + (i == 0 ? "disabled" : "enabled")));
        widgetGroup.accept(new ForcedInitialSyncImageCycleButtonWidget(148, 38, 18, 18, GuiTextures.ORE_FILTER_BUTTON_MATCH_ALL, () -> this.matchAll, matchAll -> {
            if (this.matchAll == matchAll) {
                return;
            }
            this.matchAll = matchAll;
            this.markDirty();
            this.clearCache();
            for (ItemOreFilterTestSlot slot : testSlot) {
                slot.setMatchAll(matchAll);
            }
        }).setTooltipHoverString(i -> "cover.ore_dictionary_filter.button.match_all." + (i == 0 ? "disabled" : "enabled")));
    }

    @Override
    public Object matchItemStack(ItemStack itemStack) {
        return this.matchesItemStack(itemStack) ? "wtf is this system?? i can put any non null object here and it i will work??? $arch" : null;
    }

    public boolean matchesItemStack(@NotNull ItemStack itemStack) {
        Boolean cached;
        if (this.error) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        ItemVariantMap<Set<String>> oreDictEntry = OreDictUnifier.getOreDictionaryEntry(item);
        if (oreDictEntry == null) {
            Boolean cached2 = this.noOreDictMatch.getEntry();
            if (cached2 == null) {
                cached2 = this.glob.matches("");
            }
            this.matchCache.put(item, this.noOreDictMatch);
            return cached2;
        }
        ItemVariantMap.Mutable<Boolean> cacheEntry = this.matchCache.get(item);
        if (cacheEntry != null && (cached = (Boolean)cacheEntry.get(itemStack)) != null) {
            return cached;
        }
        if (cacheEntry == null) {
            if (oreDictEntry.isEmpty()) {
                cached = this.noOreDictMatch.getEntry();
                if (cached == null) {
                    cached = this.glob.matches("");
                    this.noOreDictMatch.put(cached);
                }
                this.matchCache.put(item, this.noOreDictMatch);
                return cached;
            }
            cacheEntry = !item.func_77614_k() || !oreDictEntry.hasNonWildcardEntry() ? new SingleItemVariantMap<Boolean>() : new MultiItemVariantMap<Boolean>();
            this.matchCache.put(item, cacheEntry);
        }
        boolean matches = this.matchAll ? this.glob.matchesAll(itemStack) : this.glob.matchesAny(itemStack);
        cacheEntry.put(itemStack, (Boolean)matches);
        return matches;
    }

    @Override
    public int getSlotTransferLimit(Object matchSlot, int globalTransferLimit) {
        return globalTransferLimit;
    }

    @Override
    public boolean showGlobalTransferLimitSlider() {
        return true;
    }

    @Override
    public int getTotalOccupiedHeight() {
        return 37;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("OreDictionaryFilter", this.expression);
        if (this.caseSensitive) {
            tag.func_74757_a("caseSensitive", true);
        }
        if (this.matchAll) {
            tag.func_74757_a("matchAll", true);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.expression = tag.func_74779_i("OreDictionaryFilter");
        this.caseSensitive = tag.func_74767_n("caseSensitive");
        this.matchAll = tag.func_74767_n("matchAll");
        this.recompile(null);
    }

    public static class ForcedInitialSyncImageCycleButtonWidget
    extends ImageCycleButtonWidget {
        private final BooleanConsumer updater;

        public ForcedInitialSyncImageCycleButtonWidget(int xPosition, int yPosition, int width, int height, TextureArea buttonTexture, BooleanSupplier supplier, BooleanConsumer updater) {
            super(xPosition, yPosition, width, height, buttonTexture, supplier, updater);
            this.currentOption = 0;
            this.updater = updater;
        }

        @Override
        public void readUpdateInfo(int id, PacketBuffer buffer) {
            if (id == 1) {
                int currentOptionCache = this.currentOption;
                super.readUpdateInfo(id, buffer);
                if (this.currentOption != currentOptionCache) {
                    this.updater.apply(this.currentOption >= 1);
                }
            } else {
                super.readUpdateInfo(id, buffer);
            }
        }
    }
}

