/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverableView;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.FacingPos;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.covers.CoverDigitalInterface;
import gregtech.common.items.behaviors.CoverDigitalInterfaceWirelessPlaceBehaviour;
import gregtech.common.metatileentities.multi.electric.centralmonitor.MetaTileEntityCentralMonitor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverDigitalInterfaceWireless
extends CoverDigitalInterface {
    private BlockPos remote;

    public CoverDigitalInterfaceWireless(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide) {
        super(definition, coverableView, attachedSide);
    }

    @Override
    public void setMode(CoverDigitalInterface.MODE mode, int slot, EnumFacing spin) {
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        if (this.remote != null) {
            tagCompound.func_74782_a("cdiRemote", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.remote));
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.remote = tagCompound.func_74764_b("cdiRemote") ? NBTUtil.func_186861_c((NBTTagCompound)tagCompound.func_74775_l("cdiRemote")) : null;
    }

    @Override
    public void writeInitialSyncData(PacketBuffer packetBuffer) {
        packetBuffer.writeBoolean(this.remote != null);
        if (this.remote != null) {
            packetBuffer.func_179255_a(this.remote);
        }
        super.writeInitialSyncData(packetBuffer);
    }

    @Override
    public void readInitialSyncData(PacketBuffer packetBuffer) {
        if (packetBuffer.readBoolean()) {
            this.remote = packetBuffer.func_179259_c();
        }
        super.readInitialSyncData(packetBuffer);
    }

    @Override
    public void onAttachment(@NotNull CoverableView coverableView, @NotNull EnumFacing side, @Nullable EntityPlayer player, @NotNull ItemStack itemStack) {
        this.remote = CoverDigitalInterfaceWirelessPlaceBehaviour.getRemotePos(itemStack);
    }

    @Override
    public void func_73660_a() {
        IGregTechTileEntity igtte;
        MetaTileEntity metaTileEntity;
        TileEntity te;
        super.func_73660_a();
        if (this.remote != null && !this.isRemote() && this.getOffsetTimer() % 20L == 0L && (te = this.getWorld().func_175625_s(this.remote)) instanceof IGregTechTileEntity && (metaTileEntity = (igtte = (IGregTechTileEntity)te).getMetaTileEntity()) instanceof MetaTileEntityCentralMonitor) {
            MetaTileEntityCentralMonitor monitor = (MetaTileEntityCentralMonitor)metaTileEntity;
            monitor.addRemoteCover(new FacingPos(this.getPos(), this.getAttachedSide()));
        }
    }

    @Override
    @NotNull
    public EnumActionResult onScrewdriverClick(@NotNull EntityPlayer playerIn, @NotNull EnumHand hand, @NotNull CuboidRayTraceResult hitResult) {
        return EnumActionResult.SUCCESS;
    }

    @Override
    @NotNull
    public ItemStack getPickItem() {
        ItemStack drop = super.getPickItem();
        if (this.remote != null) {
            drop.func_77982_d(NBTUtil.func_186859_a((BlockPos)this.remote));
        }
        return drop;
    }

    @Override
    public void renderCover(CCRenderState ccRenderState, Matrix4 translation, IVertexOperation[] ops, Cuboid6 cuboid6, BlockRenderLayer blockRenderLayer) {
        Textures.COVER_INTERFACE_WIRELESS.renderSided(this.getAttachedSide(), cuboid6, ccRenderState, ops, translation);
    }
}

