/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import gregtech.api.capability.FeCompat;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IWorkable;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.FluidHandlerProxy;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.capability.impl.ItemHandlerProxy;
import gregtech.api.cover.CoverBase;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.CoverableView;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.metatileentity.IFastRenderMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.util.GTLog;
import gregtech.api.util.Position;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.RenderUtil;
import gregtech.common.terminal.app.prospector.widget.WidgetOreList;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverDigitalInterface
extends CoverBase
implements IFastRenderMetaTileEntity,
ITickable,
CoverWithUI {
    private FluidTankProperties[] fluids = new FluidTankProperties[0];
    private ItemStack[] items = new ItemStack[0];
    private int maxItemCapability = 0;
    private long energyStored = 0L;
    private long energyCapability = 0L;
    private long energyInputPerDur = 0L;
    private long energyOutputPerDur = 0L;
    private final List<Long> inputEnergyList = new LinkedList<Long>();
    private final List<Long> outputEnergyList = new LinkedList<Long>();
    private int progress = 0;
    private int maxProgress = 0;
    private boolean isActive = true;
    private boolean isWorkingEnabled = false;
    private long lastClickTime;
    private UUID lastClickUUID;
    protected int slot = 0;
    protected MODE mode = MODE.PROXY;
    protected EnumFacing spin = EnumFacing.NORTH;
    protected final int[] proxyMode = new int[]{0, 0, 0, 0};
    static String[][] units = new String[][]{{"", "mB", "", "EU"}, {"", "B", "K", "KEU"}, {"", "KB", "M", "MEU"}, {"", "MB", "G", "GEU"}, {"", "GB", "T", "TEU"}, {"", "TB", "P", "PEU"}};

    public CoverDigitalInterface(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide) {
        super(definition, coverableView, attachedSide);
    }

    public MODE getMode() {
        return this.mode;
    }

    public boolean isProxy() {
        return this.mode == MODE.PROXY;
    }

    public void setMode(MODE mode, int slot, EnumFacing spin) {
        if (this.mode == mode && (this.slot == slot || slot < 0) && this.spin == spin) {
            return;
        }
        if (!this.isRemote()) {
            if (this.mode != MODE.PROXY && mode == MODE.PROXY) {
                this.proxyMode[0] = 0;
                this.proxyMode[1] = 0;
                this.proxyMode[2] = 0;
                this.proxyMode[3] = 0;
            }
            this.mode = mode;
            this.slot = slot;
            this.spin = spin;
            this.writeCustomData(GregtechDataCodes.UPDATE_COVER_MODE, packetBuffer -> {
                packetBuffer.writeByte(mode.ordinal());
                packetBuffer.writeInt(slot);
                packetBuffer.writeByte(spin.func_176745_a());
            });
            this.notifyBlockUpdate();
            this.markDirty();
        } else {
            if (this.mode != mode || this.spin != spin) {
                this.scheduleRenderUpdate();
            }
            this.mode = mode;
            this.slot = slot;
            this.spin = spin;
        }
    }

    public void setMode(EnumFacing spin) {
        this.setMode(this.mode, this.slot, spin);
    }

    public void setMode(int slot) {
        this.setMode(this.mode, slot, this.spin);
    }

    public void setMode(MODE mode) {
        this.setMode(mode, this.slot, this.spin);
    }

    public boolean subProxyMode(MODE mode) {
        if (this.mode == MODE.PROXY) {
            int n = mode.ordinal();
            this.proxyMode[n] = this.proxyMode[n] + 1;
            this.markAsDirty();
            return true;
        }
        return false;
    }

    public boolean unSubProxyMode(MODE mode) {
        if (this.mode == MODE.PROXY && this.proxyMode[mode.ordinal()] > 0) {
            int n = mode.ordinal();
            this.proxyMode[n] = this.proxyMode[n] - 1;
            this.markAsDirty();
            return true;
        }
        return false;
    }

    @Nullable
    public TileEntity getCoveredTE() {
        CoverableView coverableView = this.getCoverableView();
        if (coverableView instanceof MetaTileEntity) {
            MetaTileEntity metaTileEntity = (MetaTileEntity)coverableView;
            return (TileEntity)metaTileEntity.getHolder();
        }
        return null;
    }

    public EnumFacing getCoveredFacing() {
        return this.getAttachedSide();
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74774_a("cdiMode", (byte)this.mode.ordinal());
        tagCompound.func_74774_a("cdiSpin", (byte)this.spin.ordinal());
        tagCompound.func_74768_a("cdiSlot", this.slot);
        tagCompound.func_74768_a("cdi0", this.proxyMode[0]);
        tagCompound.func_74768_a("cdi1", this.proxyMode[1]);
        tagCompound.func_74768_a("cdi2", this.proxyMode[2]);
        tagCompound.func_74768_a("cdi3", this.proxyMode[3]);
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.mode = tagCompound.func_74764_b("cdiMode") ? MODE.VALUES[tagCompound.func_74771_c("cdiMode")] : MODE.PROXY;
        this.spin = tagCompound.func_74764_b("cdiSpin") ? EnumFacing.func_82600_a((int)tagCompound.func_74771_c("cdiSpin")) : EnumFacing.NORTH;
        this.slot = tagCompound.func_74764_b("cdiSlot") ? tagCompound.func_74762_e("cdiSlot") : 0;
        this.proxyMode[0] = tagCompound.func_74764_b("cdi0") ? tagCompound.func_74762_e("cdi0") : 0;
        this.proxyMode[1] = tagCompound.func_74764_b("cdi1") ? tagCompound.func_74762_e("cdi1") : 0;
        this.proxyMode[2] = tagCompound.func_74764_b("cdi2") ? tagCompound.func_74762_e("cdi2") : 0;
        this.proxyMode[3] = tagCompound.func_74764_b("cdi3") ? tagCompound.func_74762_e("cdi3") : 0;
    }

    @Override
    public void onAttachment(@NotNull CoverableView coverableView, @NotNull EnumFacing side, @Nullable EntityPlayer player, @NotNull ItemStack itemStack) {
        if (this.getFluidCapability() != null) {
            this.fluids = new FluidTankProperties[this.getFluidCapability().getTankProperties().length];
            this.mode = MODE.FLUID;
        } else if (this.getItemCapability() != null) {
            this.items = new ItemStack[this.getItemCapability().getSlots()];
            this.mode = MODE.ITEM;
        } else if (this.getEnergyCapability() != null) {
            this.mode = MODE.ENERGY;
        } else if (this.getMachineCapability() != null) {
            this.mode = MODE.MACHINE;
        }
        if (player != null) {
            this.spin = player.func_174811_aO();
        }
    }

    @Override
    public void writeInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        super.writeInitialSyncData(packetBuffer);
        packetBuffer.func_179249_a((Enum)this.mode);
        packetBuffer.func_179249_a((Enum)this.spin);
        packetBuffer.writeInt(this.slot);
        this.syncAllInfo();
        this.writeAllFluids(packetBuffer);
        this.writeAllItems(packetBuffer);
        packetBuffer.writeInt(this.maxItemCapability);
        packetBuffer.writeLong(this.energyStored);
        packetBuffer.writeLong(this.energyCapability);
        packetBuffer.writeInt(this.inputEnergyList.size());
        for (Long aLong : this.inputEnergyList) {
            packetBuffer.writeLong(aLong.longValue());
        }
        for (Long aLong : this.outputEnergyList) {
            packetBuffer.writeLong(aLong.longValue());
        }
        packetBuffer.writeInt(this.progress);
        packetBuffer.writeInt(this.maxProgress);
        packetBuffer.writeBoolean(this.isActive);
        packetBuffer.writeBoolean(this.isWorkingEnabled);
    }

    @Override
    public void readInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        int i;
        super.readInitialSyncData(packetBuffer);
        this.mode = (MODE)packetBuffer.func_179257_a(MODE.class);
        this.spin = (EnumFacing)packetBuffer.func_179257_a(EnumFacing.class);
        this.slot = packetBuffer.readInt();
        this.readFluids(packetBuffer);
        this.readItems(packetBuffer);
        this.maxItemCapability = packetBuffer.readInt();
        this.energyStored = packetBuffer.readLong();
        this.energyCapability = packetBuffer.readLong();
        int size = packetBuffer.readInt();
        this.inputEnergyList.clear();
        this.outputEnergyList.clear();
        for (i = 0; i < size; ++i) {
            this.inputEnergyList.add(packetBuffer.readLong());
        }
        for (i = 0; i < size; ++i) {
            this.outputEnergyList.add(packetBuffer.readLong());
        }
        this.progress = packetBuffer.readInt();
        this.maxProgress = packetBuffer.readInt();
        this.isActive = packetBuffer.readBoolean();
        this.isWorkingEnabled = packetBuffer.readBoolean();
    }

    public void func_73660_a() {
        if (!this.isRemote() && this.getOffsetTimer() % 2L == 0L) {
            this.syncAllInfo();
        }
    }

    @Override
    @NotNull
    public EnumActionResult onScrewdriverClick(@NotNull EntityPlayer playerIn, @NotNull EnumHand hand, @NotNull CuboidRayTraceResult hitResult) {
        if (!this.getWorld().field_72995_K) {
            this.openUI((EntityPlayerMP)playerIn);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    @NotNull
    public EnumActionResult onRightClick(@NotNull EntityPlayer playerIn, @NotNull EnumHand hand, @NotNull CuboidRayTraceResult rayTraceResult) {
        if (!this.isRemote()) {
            if (this.getWorld().func_82737_E() - this.lastClickTime < 2L && playerIn.getPersistentID().equals(this.lastClickUUID)) {
                return EnumActionResult.SUCCESS;
            }
            this.lastClickTime = this.getWorld().func_82737_E();
            this.lastClickUUID = playerIn.getPersistentID();
            if (playerIn.func_70093_af() && playerIn.func_184614_ca().func_190926_b() && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
                int maxSlotLimit = Integer.MAX_VALUE;
                CoverableView coverableView = this.getCoverableView();
                if (coverableView instanceof MetaTileEntity) {
                    MetaTileEntity metaTileEntity = (MetaTileEntity)coverableView;
                    maxSlotLimit = this.mode == MODE.ITEM ? metaTileEntity.getImportItems().getSlots() : metaTileEntity.getImportFluids().getTanks();
                }
                double x = 0.0;
                double y = 1.0 - rayTraceResult.field_72307_f.field_72448_b + (double)rayTraceResult.func_178782_a().func_177956_o();
                if (rayTraceResult.field_178784_b == EnumFacing.EAST) {
                    x = 1.0 - rayTraceResult.field_72307_f.field_72449_c + (double)rayTraceResult.func_178782_a().func_177952_p();
                } else if (rayTraceResult.field_178784_b == EnumFacing.SOUTH) {
                    x = rayTraceResult.field_72307_f.field_72450_a - (double)rayTraceResult.func_178782_a().func_177958_n();
                } else if (rayTraceResult.field_178784_b == EnumFacing.WEST) {
                    x = rayTraceResult.field_72307_f.field_72449_c - (double)rayTraceResult.func_178782_a().func_177952_p();
                } else if (rayTraceResult.field_178784_b == EnumFacing.NORTH) {
                    x = 1.0 - rayTraceResult.field_72307_f.field_72450_a + (double)rayTraceResult.func_178782_a().func_177958_n();
                }
                if (0.0625 < x && x < 0.25 && 0.0625 < y && y < 0.25) {
                    this.setMode(this.slot - 1 >= 0 ? this.slot - 1 : maxSlotLimit);
                    return EnumActionResult.SUCCESS;
                }
                if (0.75 < x && x < 0.9375 && 0.0625 < y && y < 0.25) {
                    this.setMode(this.slot + 1 >= maxSlotLimit ? 0 : this.slot + 1);
                    return EnumActionResult.SUCCESS;
                }
            }
            return this.modeRightClick(playerIn, hand, this.mode, this.slot);
        }
        return EnumActionResult.PASS;
    }

    @Override
    public boolean onLeftClick(@NotNull EntityPlayer entityPlayer, @NotNull CuboidRayTraceResult hitResult) {
        if (!this.isRemote()) {
            if (this.getWorld().func_82737_E() - this.lastClickTime < 2L && entityPlayer.getPersistentID().equals(this.lastClickUUID)) {
                return true;
            }
            this.lastClickTime = this.getWorld().func_82737_E();
            this.lastClickUUID = entityPlayer.getPersistentID();
            return this.modeLeftClick(entityPlayer, this.mode, this.slot);
        }
        return false;
    }

    public EnumActionResult modeRightClick(EntityPlayer playerIn, EnumHand hand, MODE mode, int slot) {
        IFluidHandler fluidHandler = this.getFluidCapability();
        if (mode == MODE.FLUID && fluidHandler != null) {
            if (!FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (IFluidHandler)fluidHandler)) {
                if (fluidHandler instanceof FluidHandlerProxy && FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (IFluidHandler)((FluidHandlerProxy)fluidHandler).input)) {
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.PASS;
            }
            return EnumActionResult.SUCCESS;
        }
        IItemHandler itemHandler = this.getItemCapability();
        if (mode == MODE.ITEM && itemHandler != null) {
            ItemStack hold;
            if (itemHandler.getSlots() > slot && slot >= 0 && !(hold = playerIn.func_184614_ca()).func_190926_b()) {
                ItemStack origin = hold.func_77946_l();
                boolean flag = false;
                if (playerIn.func_70093_af()) {
                    int size = playerIn.func_184614_ca().func_190916_E();
                    playerIn.func_184611_a(EnumHand.MAIN_HAND, itemHandler.insertItem(slot, hold, false));
                    flag = playerIn.func_184614_ca().func_190916_E() != size;
                } else {
                    ItemStack itemStack = hold.func_77946_l();
                    itemStack.func_190920_e(1);
                    if (itemHandler.insertItem(slot, itemStack, false).func_190926_b()) {
                        hold.func_190920_e(hold.func_190916_E() - 1);
                        flag = true;
                    }
                }
                if (playerIn.func_184614_ca().func_190926_b()) {
                    for (ItemStack itemStack : playerIn.field_71071_by.field_70462_a) {
                        if (!origin.func_77969_a(itemStack)) continue;
                        playerIn.func_184611_a(EnumHand.MAIN_HAND, itemStack.func_77946_l());
                        itemStack.func_190920_e(0);
                        break;
                    }
                }
                return flag ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
            }
            return EnumActionResult.PASS;
        }
        IWorkable workable = this.getMachineCapability();
        if (mode == MODE.MACHINE && workable != null && playerIn.func_70093_af()) {
            workable.setWorkingEnabled(!this.isWorkingEnabled);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean modeLeftClick(EntityPlayer entityPlayer, MODE mode, int slot) {
        IItemHandler itemHandler = this.getItemCapability();
        if (mode == MODE.ITEM && itemHandler != null) {
            if (itemHandler.getSlots() > slot && slot >= 0) {
                IItemHandler insertHandler;
                ItemStack itemStack = entityPlayer.func_70093_af() ? itemHandler.extractItem(slot, 64, false) : itemHandler.extractItem(slot, 1, false);
                if (itemStack.func_190926_b() && itemHandler instanceof ItemHandlerProxy && slot < (insertHandler = (IItemHandler)ObfuscationReflectionHelper.getPrivateValue(ItemHandlerProxy.class, (Object)((ItemHandlerProxy)itemHandler), (String)"insertHandler")).getSlots()) {
                    itemStack = entityPlayer.func_70093_af() ? insertHandler.extractItem(slot, 64, false) : insertHandler.extractItem(slot, 1, false);
                }
                if (!itemStack.func_190926_b()) {
                    EntityItem entity = new EntityItem(entityPlayer.field_70170_p, entityPlayer.field_70165_t + 0.5, entityPlayer.field_70163_u + (double)0.3f, entityPlayer.field_70161_v + 0.5, itemStack);
                    entity.func_70024_g(-entity.field_70159_w, -entity.field_70181_x, -entity.field_70179_y);
                    entityPlayer.field_70170_p.func_72838_d((Entity)entity);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        WidgetGroup primaryGroup = new WidgetGroup(new Position(0, 10));
        primaryGroup.addWidget(new LabelWidget(10, 5, "metaitem.cover.digital.name", 0));
        ToggleButtonWidget[] buttons = new ToggleButtonWidget[]{new ToggleButtonWidget(40, 20, 20, 20, GuiTextures.BUTTON_FLUID, () -> this.mode == MODE.FLUID, pressed -> {
            if (pressed) {
                this.setMode(MODE.FLUID);
            }
        }).setTooltipText("metaitem.cover.digital.mode.fluid", new Object[0]), new ToggleButtonWidget(60, 20, 20, 20, GuiTextures.BUTTON_ITEM, () -> this.mode == MODE.ITEM, pressed -> {
            if (pressed) {
                this.setMode(MODE.ITEM);
            }
        }).setTooltipText("metaitem.cover.digital.mode.item", new Object[0]), new ToggleButtonWidget(80, 20, 20, 20, GuiTextures.BUTTON_ENERGY, () -> this.mode == MODE.ENERGY, pressed -> {
            if (pressed) {
                this.setMode(MODE.ENERGY);
            }
        }).setTooltipText("metaitem.cover.digital.mode.energy", new Object[0]), new ToggleButtonWidget(100, 20, 20, 20, GuiTextures.BUTTON_MACHINE, () -> this.mode == MODE.MACHINE, pressed -> {
            if (pressed) {
                this.setMode(MODE.MACHINE);
            }
        }).setTooltipText("metaitem.cover.digital.mode.machine", new Object[0]), new ToggleButtonWidget(140, 20, 20, 20, GuiTextures.BUTTON_INTERFACE, () -> this.mode == MODE.PROXY, pressed -> {
            if (pressed) {
                this.setMode(MODE.PROXY);
            }
        }).setTooltipText("metaitem.cover.digital.mode.proxy", new Object[0])};
        primaryGroup.addWidget(new LabelWidget(10, 25, "metaitem.cover.digital.title.mode", 0));
        primaryGroup.addWidget(buttons[0]);
        primaryGroup.addWidget(buttons[1]);
        primaryGroup.addWidget(buttons[2]);
        primaryGroup.addWidget(buttons[3]);
        primaryGroup.addWidget(buttons[4]);
        primaryGroup.addWidget(new LabelWidget(10, 50, "monitor.gui.title.slot", 0));
        primaryGroup.addWidget(new ClickButtonWidget(40, 45, 20, 20, "-1", data -> this.setMode(this.slot - (data.isShiftClick ? 10 : 1))));
        primaryGroup.addWidget(new ClickButtonWidget(140, 45, 20, 20, "+1", data -> this.setMode(this.slot + (data.isShiftClick ? 10 : 1))));
        primaryGroup.addWidget(new ImageWidget(60, 45, 80, 20, GuiTextures.DISPLAY));
        primaryGroup.addWidget(new SimpleTextWidget(100, 55, "", 0xFFFFFF, () -> Integer.toString(this.slot)));
        primaryGroup.addWidget(new LabelWidget(10, 75, "metaitem.cover.digital.title.spin", 0));
        primaryGroup.addWidget(new ClickButtonWidget(40, 70, 20, 20, "R", data -> this.setMode(this.spin.func_176746_e())));
        primaryGroup.addWidget(new ImageWidget(60, 70, 80, 20, GuiTextures.DISPLAY));
        primaryGroup.addWidget(new SimpleTextWidget(100, 80, "", 0xFFFFFF, () -> this.spin.toString()));
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, 176, 202).widget(primaryGroup).bindPlayerInventory(player.field_71071_by, GuiTextures.SLOT, 8, 120);
        return builder.build(this, player);
    }

    private void syncAllInfo() {
        IWorkable workable;
        IEnergyContainer energyContainer;
        FluidStack content;
        int i;
        ArrayList<Integer> toUpdate;
        boolean syncFlag;
        if (this.mode == MODE.FLUID || this.mode == MODE.PROXY && this.proxyMode[0] > 0) {
            syncFlag = false;
            IFluidHandler fluidHandler = this.getFluidCapability();
            if (fluidHandler != null) {
                IFluidTankProperties[] fluidTankProperties = fluidHandler.getTankProperties();
                if (fluidTankProperties.length != this.fluids.length) {
                    this.fluids = new FluidTankProperties[fluidTankProperties.length];
                    syncFlag = true;
                }
                toUpdate = new ArrayList<Integer>();
                for (i = 0; i < fluidTankProperties.length; ++i) {
                    content = fluidTankProperties[i].getContents();
                    if (this.fluids[i] == null || content == null && this.fluids[i].getContents() != null || content != null && this.fluids[i].getContents() == null || fluidTankProperties[i].getCapacity() != this.fluids[i].getCapacity() || fluidTankProperties[i].canDrain() != this.fluids[i].canDrain() || fluidTankProperties[i].canFill() != this.fluids[i].canFill()) {
                        syncFlag = true;
                        this.fluids[i] = new FluidTankProperties(content, fluidTankProperties[i].getCapacity(), fluidTankProperties[i].canFill(), fluidTankProperties[i].canDrain());
                        toUpdate.add(i);
                        continue;
                    }
                    if (content == null || this.fluids[i] == null || this.fluids[i].getContents() == null || content.amount == this.fluids[i].getContents().amount && content.isFluidEqual(this.fluids[i].getContents())) continue;
                    syncFlag = true;
                    this.fluids[i] = new FluidTankProperties(content, fluidTankProperties[i].getCapacity(), fluidTankProperties[i].canFill(), fluidTankProperties[i].canDrain());
                    toUpdate.add(i);
                }
                if (syncFlag) {
                    this.writeCustomData(GregtechDataCodes.UPDATE_FLUID, packetBuffer -> {
                        packetBuffer.func_150787_b(this.fluids.length);
                        packetBuffer.func_150787_b(toUpdate.size());
                        for (Integer index : toUpdate) {
                            this.writeFluid((PacketBuffer)packetBuffer, index);
                        }
                    });
                }
            }
        }
        if (this.mode == MODE.ITEM || this.mode == MODE.PROXY && this.proxyMode[1] > 0) {
            syncFlag = false;
            IItemHandler itemHandler = this.getItemCapability();
            if (itemHandler != null) {
                int maxStoredItems;
                int size = itemHandler.getSlots();
                if (this.slot < size && (maxStoredItems = itemHandler.getSlotLimit(this.slot)) != this.maxItemCapability) {
                    this.maxItemCapability = maxStoredItems;
                    syncFlag = true;
                }
                toUpdate = new ArrayList();
                if (this.items.length != size) {
                    this.items = new ItemStack[size];
                    syncFlag = true;
                }
                for (i = 0; i < size; ++i) {
                    if (this.items[i] == null) {
                        this.items[i] = ItemStack.field_190927_a;
                    }
                    if (ItemStack.func_77989_b((ItemStack)this.items[i], (ItemStack)(content = itemHandler.getStackInSlot(i)))) continue;
                    syncFlag = true;
                    this.items[i] = content.func_77946_l();
                    toUpdate.add(i);
                }
                if (syncFlag) {
                    this.writeCustomData(GregtechDataCodes.UPDATE_ITEM, packetBuffer -> {
                        packetBuffer.func_150787_b(this.maxItemCapability);
                        packetBuffer.func_150787_b(this.items.length);
                        packetBuffer.func_150787_b(toUpdate.size());
                        for (Integer index : toUpdate) {
                            packetBuffer.func_150787_b(index.intValue());
                            packetBuffer.func_150786_a(CoverDigitalInterface.fixItemStackSer(this.items[index]));
                        }
                    });
                }
            }
        }
        if ((this.mode == MODE.ENERGY || this.mode == MODE.PROXY && this.proxyMode[2] > 0) && (energyContainer = this.getEnergyCapability()) != null) {
            if (this.energyStored != energyContainer.getEnergyStored() || this.energyCapability != energyContainer.getEnergyCapacity()) {
                this.energyStored = energyContainer.getEnergyStored();
                this.energyCapability = energyContainer.getEnergyCapacity();
                this.writeCustomData(GregtechDataCodes.UPDATE_ENERGY, packetBuffer -> {
                    packetBuffer.writeLong(this.energyStored);
                    packetBuffer.writeLong(this.energyCapability);
                });
            }
            if (this.getOffsetTimer() % 20L == 0L) {
                this.writeCustomData(GregtechDataCodes.UPDATE_ENERGY_PER, packetBuffer -> {
                    packetBuffer.writeLong(energyContainer.getInputPerSec());
                    packetBuffer.writeLong(energyContainer.getOutputPerSec());
                    this.inputEnergyList.add(this.energyInputPerDur);
                    this.outputEnergyList.add(this.energyOutputPerDur);
                    if (this.inputEnergyList.size() > 13) {
                        this.inputEnergyList.remove(0);
                        this.outputEnergyList.remove(0);
                    }
                });
            }
        }
        if ((this.mode == MODE.MACHINE || this.mode == MODE.PROXY && this.proxyMode[3] > 0) && (workable = this.getMachineCapability()) != null) {
            IEnergyContainer energyContainer2;
            int progress = workable.getProgress();
            int maxProgress = workable.getMaxProgress();
            boolean isActive = workable.isActive();
            boolean isWorkingEnable = workable.isWorkingEnabled();
            if (isActive != this.isActive || isWorkingEnable != this.isWorkingEnabled || this.progress != progress || this.maxProgress != maxProgress) {
                this.progress = progress;
                this.maxProgress = maxProgress;
                this.isWorkingEnabled = isWorkingEnable;
                this.isActive = isActive;
                this.writeCustomData(GregtechDataCodes.UPDATE_MACHINE, packetBuffer -> {
                    packetBuffer.writeInt(progress);
                    packetBuffer.writeInt(maxProgress);
                    packetBuffer.writeBoolean(isActive);
                    packetBuffer.writeBoolean(isWorkingEnable);
                });
            }
            if (this.getOffsetTimer() % 20L == 0L && (energyContainer2 = this.getEnergyCapability()) != null && (this.energyStored != energyContainer2.getEnergyStored() || this.energyCapability != energyContainer2.getEnergyCapacity())) {
                this.energyStored = energyContainer2.getEnergyStored();
                this.energyCapability = energyContainer2.getEnergyCapacity();
                this.writeCustomData(GregtechDataCodes.UPDATE_ENERGY, packetBuffer -> {
                    packetBuffer.writeLong(this.energyStored);
                    packetBuffer.writeLong(this.energyCapability);
                });
            }
        }
    }

    private void writeAllFluids(PacketBuffer packetBuffer) {
        packetBuffer.func_150787_b(this.fluids.length);
        packetBuffer.func_150787_b(this.fluids.length);
        for (int i = 0; i < this.fluids.length; ++i) {
            this.writeFluid(packetBuffer, i);
        }
    }

    private void writeFluid(PacketBuffer packetBuffer, int i) {
        packetBuffer.func_150787_b(i);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("Capacity", this.fluids[i].getCapacity());
        FluidStack fluidStack = this.fluids[i].getContents();
        if (fluidStack != null) {
            fluidStack.writeToNBT(nbt);
        }
        packetBuffer.func_150786_a(nbt);
    }

    private void readFluids(PacketBuffer packetBuffer) {
        int size = packetBuffer.func_150792_a();
        if (this.fluids == null || this.fluids.length != size) {
            this.fluids = new FluidTankProperties[size];
        }
        size = packetBuffer.func_150792_a();
        try {
            for (int i = 0; i < size; ++i) {
                int index = packetBuffer.func_150792_a();
                NBTTagCompound nbt = packetBuffer.func_150793_b();
                if (nbt == null) continue;
                this.fluids[index] = new FluidTankProperties(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt), nbt.func_74762_e("Capacity"));
            }
        }
        catch (IOException e) {
            GTLog.logger.error("Could not read fluids from NBT buffer", (Throwable)e);
        }
    }

    private void writeAllItems(PacketBuffer packetBuffer) {
        packetBuffer.func_150787_b(this.maxItemCapability);
        packetBuffer.func_150787_b(this.items.length);
        packetBuffer.func_150787_b(this.items.length);
        for (int i = 0; i < this.items.length; ++i) {
            packetBuffer.func_150787_b(i);
            packetBuffer.func_150786_a(CoverDigitalInterface.fixItemStackSer(this.items[i]));
        }
    }

    private void readItems(PacketBuffer packetBuffer) {
        this.maxItemCapability = packetBuffer.func_150792_a();
        int size = packetBuffer.func_150792_a();
        if (this.items == null || this.items.length != size) {
            this.items = new ItemStack[size];
        }
        size = packetBuffer.func_150792_a();
        try {
            for (int i = 0; i < size; ++i) {
                int index = packetBuffer.func_150792_a();
                NBTTagCompound nbt = packetBuffer.func_150793_b();
                if (nbt != null) {
                    this.items[index] = new ItemStack(nbt);
                    this.items[index].func_190920_e(nbt.func_74762_e("count"));
                    continue;
                }
                this.items[index] = ItemStack.field_190927_a;
            }
        }
        catch (IOException e) {
            GTLog.logger.error("Could not read items from NBT buffer", (Throwable)e);
        }
    }

    public static NBTTagCompound fixItemStackSer(ItemStack itemStack) {
        NBTTagCompound nbt = itemStack.serializeNBT();
        nbt.func_74768_a("count", itemStack.func_190916_E());
        return nbt;
    }

    public IFluidHandler getFluidCapability() {
        CoverableView coverableView;
        IFluidHandler capability;
        TileEntity te = this.getCoveredTE();
        IFluidHandler iFluidHandler = capability = te == null ? null : (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getCoveredFacing());
        if (capability == null && (coverableView = this.getCoverableView()) instanceof MultiblockControllerBase) {
            MultiblockControllerBase controllerBase = (MultiblockControllerBase)coverableView;
            List<IFluidTank> input = controllerBase.getAbilities(MultiblockAbility.IMPORT_FLUIDS);
            List<IFluidTank> output = controllerBase.getAbilities(MultiblockAbility.EXPORT_FLUIDS);
            ArrayList<IFluidTank> list = new ArrayList<IFluidTank>();
            if (input.size() > 0) {
                list.addAll(input);
            }
            if (output.size() > 0) {
                list.addAll(output);
            }
            capability = new FluidTankList(true, list);
        }
        return capability;
    }

    public IItemHandler getItemCapability() {
        CoverableView coverableView;
        Object capability;
        TileEntity te = this.getCoveredTE();
        IItemHandler iItemHandler = capability = te == null ? null : (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getCoveredFacing());
        if (capability == null && (coverableView = this.getCoverableView()) instanceof MultiblockControllerBase) {
            MultiblockControllerBase controllerBase = (MultiblockControllerBase)coverableView;
            List<IItemHandlerModifiable> input = controllerBase.getAbilities(MultiblockAbility.IMPORT_ITEMS);
            List<IItemHandlerModifiable> output = controllerBase.getAbilities(MultiblockAbility.EXPORT_ITEMS);
            ArrayList<IItemHandlerModifiable> list = new ArrayList<IItemHandlerModifiable>();
            if (input.size() > 0) {
                list.addAll(input);
            }
            if (output.size() > 0) {
                list.addAll(output);
            }
            capability = new ItemHandlerList(list);
        }
        return capability;
    }

    public IEnergyContainer getEnergyCapability() {
        IEnergyStorage fe;
        CoverableView coverableView;
        IEnergyContainer capability;
        TileEntity te = this.getCoveredTE();
        IEnergyContainer iEnergyContainer = capability = te == null ? null : (IEnergyContainer)te.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, this.getCoveredFacing());
        if (capability == null && (coverableView = this.getCoverableView()) instanceof MultiblockControllerBase) {
            MultiblockControllerBase controllerBase = (MultiblockControllerBase)coverableView;
            List<IEnergyContainer> input = controllerBase.getAbilities(MultiblockAbility.INPUT_ENERGY);
            List<IEnergyContainer> output = controllerBase.getAbilities(MultiblockAbility.OUTPUT_ENERGY);
            ArrayList<IEnergyContainer> list = new ArrayList<IEnergyContainer>();
            if (input.size() > 0) {
                list.addAll(input);
            }
            if (output.size() > 0) {
                list.addAll(output);
            }
            capability = new EnergyContainerList(list);
        } else if (capability == null && te != null && (fe = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, this.getCoveredFacing())) != null) {
            return new IEnergyContainer(){

                @Override
                public long acceptEnergyFromNetwork(EnumFacing enumFacing, long l, long l1) {
                    return 0L;
                }

                @Override
                public boolean inputsEnergy(EnumFacing enumFacing) {
                    return false;
                }

                @Override
                public long changeEnergy(long l) {
                    return 0L;
                }

                @Override
                public long getEnergyStored() {
                    return FeCompat.toEu(fe.getEnergyStored(), FeCompat.ratio(false));
                }

                @Override
                public long getEnergyCapacity() {
                    return FeCompat.toEu(fe.getMaxEnergyStored(), FeCompat.ratio(false));
                }

                @Override
                public long getInputAmperage() {
                    return 0L;
                }

                @Override
                public long getInputVoltage() {
                    return 0L;
                }
            };
        }
        return capability;
    }

    public IWorkable getMachineCapability() {
        TileEntity te = this.getCoveredTE();
        return te == null ? null : (IWorkable)te.getCapability(GregtechTileCapabilities.CAPABILITY_WORKABLE, this.getCoveredFacing());
    }

    @Override
    public void readCustomData(int id, @NotNull PacketBuffer packetBuffer) {
        super.readCustomData(id, packetBuffer);
        if (id == GregtechDataCodes.UPDATE_COVER_MODE) {
            this.setMode(MODE.VALUES[packetBuffer.readByte()], packetBuffer.readInt(), EnumFacing.func_82600_a((int)packetBuffer.readByte()));
        } else if (id == GregtechDataCodes.UPDATE_FLUID) {
            this.readFluids(packetBuffer);
        } else if (id == GregtechDataCodes.UPDATE_ITEM) {
            this.readItems(packetBuffer);
        } else if (id == GregtechDataCodes.UPDATE_ENERGY) {
            this.energyStored = packetBuffer.readLong();
            this.energyCapability = packetBuffer.readLong();
        } else if (id == GregtechDataCodes.UPDATE_ENERGY_PER) {
            this.energyInputPerDur = packetBuffer.readLong();
            this.energyOutputPerDur = packetBuffer.readLong();
            this.inputEnergyList.add(this.energyInputPerDur);
            this.outputEnergyList.add(this.energyOutputPerDur);
            if (this.inputEnergyList.size() > 13) {
                this.inputEnergyList.remove(0);
                this.outputEnergyList.remove(0);
            }
        } else if (id == GregtechDataCodes.UPDATE_MACHINE) {
            this.progress = packetBuffer.readInt();
            this.maxProgress = packetBuffer.readInt();
            this.isActive = packetBuffer.readBoolean();
            boolean isWorkingEnable = packetBuffer.readBoolean();
            if (this.isWorkingEnabled != isWorkingEnable && this.mode == MODE.MACHINE) {
                this.isWorkingEnabled = isWorkingEnable;
                this.scheduleRenderUpdate();
            }
            this.isWorkingEnabled = isWorkingEnable;
        }
    }

    @Override
    public boolean canAttach(@NotNull CoverableView coverable, @NotNull EnumFacing side) {
        return this.canCapabilityAttach();
    }

    public boolean canCapabilityAttach() {
        return this.getFluidCapability() != null || this.getItemCapability() != null || this.getEnergyCapability() != null || this.getMachineCapability() != null;
    }

    @Override
    public <T> T getCapability(@NotNull Capability<T> capability, T defaultValue) {
        if (this.mode == MODE.PROXY && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER && defaultValue == null) {
            return (T)GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER.cast((Object)IEnergyContainer.DEFAULT);
        }
        return defaultValue;
    }

    @Override
    public void renderCover(CCRenderState ccRenderState, Matrix4 translation, IVertexOperation[] ops, Cuboid6 cuboid6, BlockRenderLayer blockRenderLayer) {
        Rotation rotation = new Rotation(0.0, 0.0, 1.0, 0.0);
        if (this.getAttachedSide().func_176740_k().func_176720_b()) {
            if (this.spin == EnumFacing.WEST) {
                translation.translate(0.0, 0.0, 1.0);
                rotation = new Rotation(1.5707963267948966, 0.0, 1.0, 0.0);
            } else if (this.spin == EnumFacing.EAST) {
                translation.translate(1.0, 0.0, 0.0);
                rotation = new Rotation(-1.5707963267948966, 0.0, 1.0, 0.0);
            } else if (this.spin == EnumFacing.SOUTH) {
                translation.translate(1.0, 0.0, 1.0);
                rotation = new Rotation(Math.PI, 0.0, 1.0, 0.0);
            }
            translation.apply((Transformation)rotation);
        }
        if (this.mode == MODE.PROXY) {
            Textures.COVER_INTERFACE_PROXY.renderSided(this.getAttachedSide(), cuboid6, ccRenderState, ops, translation);
        } else if (this.mode == MODE.FLUID) {
            Textures.COVER_INTERFACE_FLUID.renderSided(this.getAttachedSide(), cuboid6, ccRenderState, (IVertexOperation[])ArrayUtils.addAll((Object[])ops, (Object[])new IVertexOperation[]{rotation}), translation);
            Textures.COVER_INTERFACE_FLUID_GLASS.renderSided(this.getAttachedSide(), cuboid6, ccRenderState, (IVertexOperation[])ArrayUtils.addAll((Object[])ops, (Object[])new IVertexOperation[]{rotation}), RenderUtil.adjustTrans(translation, this.getAttachedSide(), 3));
        } else if (this.mode == MODE.ITEM) {
            Textures.COVER_INTERFACE_ITEM.renderSided(this.getAttachedSide(), cuboid6, ccRenderState, (IVertexOperation[])ArrayUtils.addAll((Object[])ops, (Object[])new IVertexOperation[]{rotation}), translation);
        } else if (this.mode == MODE.ENERGY) {
            Textures.COVER_INTERFACE_ENERGY.renderSided(this.getAttachedSide(), cuboid6, ccRenderState, (IVertexOperation[])ArrayUtils.addAll((Object[])ops, (Object[])new IVertexOperation[]{rotation}), translation);
        } else if (this.mode == MODE.MACHINE) {
            if (this.isWorkingEnabled) {
                Textures.COVER_INTERFACE_MACHINE_ON.renderSided(this.getAttachedSide(), cuboid6, ccRenderState, (IVertexOperation[])ArrayUtils.addAll((Object[])ops, (Object[])new IVertexOperation[]{rotation}), translation);
            } else {
                Textures.COVER_INTERFACE_MACHINE_OFF.renderSided(this.getAttachedSide(), cuboid6, ccRenderState, (IVertexOperation[])ArrayUtils.addAll((Object[])ops, (Object[])new IVertexOperation[]{rotation}), translation);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderMetaTileEntityFast(CCRenderState renderState, Matrix4 translation, float partialTicks) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderMetaTileEntity(double x, double y, double z, float partialTicks) {
        GlStateManager.func_179094_E();
        RenderHelper.func_74518_a();
        float lastBrightnessX = OpenGlHelper.lastBrightnessX;
        float lastBrightnessY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        RenderUtil.moveToFace(x, y, z, this.getAttachedSide());
        RenderUtil.rotateToFace(this.getAttachedSide(), this.getAttachedSide().func_176740_k() == EnumFacing.Axis.Y ? this.spin : EnumFacing.NORTH);
        if (!this.renderSneakingLookAt(this.getPos(), this.getAttachedSide(), this.slot, partialTicks)) {
            this.renderMode(this.mode, this.slot, partialTicks);
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean shouldRenderInPass(int pass) {
        return pass == 0 && this.mode != MODE.PROXY;
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderSneakingLookAt(BlockPos blockPos, EnumFacing side, int slot, float partialTicks) {
        RayTraceResult rayTraceResult;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.func_70093_af() && player.func_184614_ca().func_190926_b() && (rayTraceResult = player.func_174822_a((double)Minecraft.func_71410_x().field_71442_b.func_78757_d(), partialTicks)) != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK && rayTraceResult.field_178784_b == side && rayTraceResult.func_178782_a().equals((Object)blockPos)) {
            RenderUtil.renderRect(-0.4375f, -0.4375f, 0.1875f, 0.1875f, 0.002f, -8157821);
            RenderUtil.renderRect(0.25f, -0.4375f, 0.1875f, 0.1875f, 0.002f, -8157821);
            RenderUtil.renderText(-0.34375f, -0.34375f, 0.0f, 0.014285714f, -1, "<", true);
            RenderUtil.renderText(0.35625f, -0.34375f, 0.0f, 0.014285714f, -1, ">", true);
            RenderUtil.renderText(0.0f, -0.34375f, 0.0f, 0.008333334f, -1, "Slot: " + slot, true);
            TileEntity te = this.getCoveredTE();
            if (te != null) {
                ItemStack itemStack;
                if (te instanceof IGregTechTileEntity) {
                    itemStack = ((IGregTechTileEntity)te).getMetaTileEntity().getStackForm();
                } else {
                    BlockPos pos = te.func_174877_v();
                    itemStack = te.func_145838_q().getPickBlock(te.func_145831_w().func_180495_p(pos), new RayTraceResult(new Vec3d(0.5, 0.5, 0.5), this.getCoveredFacing(), pos), te.func_145831_w(), pos, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                }
                String name = itemStack.func_82833_r();
                RenderUtil.renderRect(-0.4375f, -0.25f, 0.875f, 0.0625f, 0.002f, -16777216);
                RenderUtil.renderText(0.0f, -0.21875f, 0.0f, 0.005f, -1, name, true);
                RenderUtil.renderItemOverLay(-0.5f, -0.3125f, 0.002f, 0.03125f, itemStack);
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderMode(MODE mode, int slot, float partialTicks) {
        if (mode == MODE.FLUID && this.fluids.length > slot && slot >= 0 && this.fluids[slot] != null && this.fluids[slot].getContents() != null) {
            this.renderFluidMode(slot);
        } else if (mode == MODE.ITEM && this.items.length > slot && slot >= 0 && this.items[slot] != null) {
            this.renderItemMode(slot);
        } else if (mode == MODE.ENERGY) {
            this.renderEnergyMode();
        } else if (mode == MODE.MACHINE) {
            this.renderMachineMode(partialTicks);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderMachineMode(float partialTicks) {
        int color;
        int n = this.energyCapability > 10L * this.energyStored ? -53447 : (color = this.isWorkingEnabled ? -16711936 : -39378);
        if (this.isActive && this.maxProgress != 0) {
            float offset = ((float)(this.getOffsetTimer() % 20L) + partialTicks) * 0.875f / 20.0f;
            float start = Math.max(-0.4375f, -0.875f + 2.0f * offset);
            float width = Math.min(0.4375f, -0.4375f + 2.0f * offset) - start;
            int startAlpha = 0;
            int endAlpha = 255;
            if (offset < 0.4375f) {
                startAlpha = (int)(255.0 - 582.8571428571429 * (double)offset);
            } else if ((double)start > 0.4375) {
                endAlpha = (int)(510.0 - 582.8571428571429 * (double)offset);
            }
            RenderUtil.renderRect(-0.4375f, -0.4375f, (float)this.progress * 14.0f / (float)(this.maxProgress * 16), 0.1875f, 0.002f, -41148);
            RenderUtil.renderText(0.0f, -0.34375f, 0.0f, 1.0f / (float)(this.isProxy() ? 110 : 70), -1, CoverDigitalInterface.readAmountOrCountOrEnergy((long)this.progress * 100L / (long)this.maxProgress, MODE.MACHINE), true);
            RenderUtil.renderGradientRect(start, -0.25f, width, 0.0625f, 0.002f, color & 0xFFFFFF | startAlpha << 24, color & 0xFFFFFF | endAlpha << 24, true);
        } else {
            RenderUtil.renderRect(-0.4375f, -0.25f, 0.875f, 0.0625f, 0.002f, color);
        }
        if (this.isProxy()) {
            if (this.isWorkingEnabled) {
                RenderUtil.renderTextureArea(GuiTextures.COVER_INTERFACE_MACHINE_ON_PROXY, -0.4375f, 0.0625f, 0.875f, 0.1875f, 0.002f);
            } else {
                RenderUtil.renderTextureArea(GuiTextures.COVER_INTERFACE_MACHINE_OFF_PROXY, -0.4375f, -0.0625f, 0.875f, 0.3125f, 0.002f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderEnergyMode() {
        if (this.inputEnergyList.isEmpty()) {
            return;
        }
        long max = Long.MIN_VALUE;
        for (long d : this.inputEnergyList) {
            max = Math.max(max, d);
        }
        for (long d : this.outputEnergyList) {
            max = Math.max(max, d);
        }
        RenderUtil.renderLineChart(this.inputEnergyList, max, -0.34375f, 0.34375f, 0.75f, 0.375f, 0.005f, -16515328);
        RenderUtil.renderLineChart(this.outputEnergyList, max, -0.34375f, 0.34375f, 0.75f, 0.375f, 0.005f, -53447);
        RenderUtil.renderText(-0.35625f, -0.14375f, 0.0f, 0.0037037036f, -16515328, "EU I: " + TextFormattingUtil.formatNumbers(this.energyInputPerDur / 20L) + "EU/t", false);
        RenderUtil.renderText(-0.35625f, -0.1f, 0.0f, 0.0037037036f, -65536, "EU O: " + TextFormattingUtil.formatNumbers(this.energyOutputPerDur / 20L) + "EU/t", false);
        RenderUtil.renderRect(-0.4375f, -0.4375f, Math.max(0.0f, (float)this.energyStored * 14.0f / (float)(this.energyCapability * 16L)), 0.1875f, 0.002f, -10217);
        RenderUtil.renderText(0.0f, -0.34375f, 0.0f, 1.0f / (float)(this.isProxy() ? 110 : 70), -1, CoverDigitalInterface.readAmountOrCountOrEnergy(this.energyStored, MODE.ENERGY), true);
    }

    @SideOnly(value=Side.CLIENT)
    private void renderItemMode(int slot) {
        ItemStack itemStack = this.items[slot];
        if (!itemStack.func_190926_b()) {
            RenderUtil.renderItemOverLay(-0.5f, -0.3125f, 0.0f, 0.03125f, itemStack);
            if (this.maxItemCapability != 0) {
                RenderUtil.renderRect(-0.4375f, -0.4375f, Math.max((float)itemStack.func_190916_E() * 14.0f / (float)(this.maxItemCapability * 16), 0.001f), 0.1875f, 0.002f, -14304769);
            } else {
                RenderUtil.renderRect(-0.4375f, -0.4375f, Math.max((float)itemStack.func_190916_E() * 14.0f / (float)(itemStack.func_77976_d() * 16), 0.001f), 0.1875f, 0.002f, -14304769);
            }
            RenderUtil.renderText(0.0f, -0.34375f, 0.0f, 1.0f / (float)(this.isProxy() ? 110 : 70), -1, CoverDigitalInterface.readAmountOrCountOrEnergy(itemStack.func_190916_E(), MODE.ITEM), true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderFluidMode(int slot) {
        FluidStack fluidStack = this.fluids[slot].getContents();
        assert (fluidStack != null);
        float height = 0.625f * Math.max((float)fluidStack.amount * 1.0f / (float)this.fluids[slot].getCapacity(), 0.001f);
        RenderUtil.renderFluidOverLay(-0.4375f, 0.4375f - height, 0.875f, height, 0.002f, fluidStack, 0.8f);
        int fluidColor = WidgetOreList.getFluidColor(fluidStack.getFluid());
        int textColor = ((fluidColor & 0xFF) + (fluidColor >> 8 & 0xFF) + (fluidColor >> 16 & 0xFF)) / 3 > 127 ? 0 : -1;
        RenderUtil.renderRect(-0.4375f, -0.4375f, 0.875f, 0.1875f, 0.002f, fluidColor | 0xFF000000);
        RenderUtil.renderText(0.0f, -0.34375f, 0.0f, 1.0f / (float)(this.isProxy() ? 110 : 70), textColor, CoverDigitalInterface.readAmountOrCountOrEnergy(fluidStack.amount, MODE.FLUID), true);
    }

    @SideOnly(value=Side.CLIENT)
    private static String readAmountOrCountOrEnergy(long number, MODE mode) {
        int i;
        int unit;
        int n = mode == MODE.FLUID ? 1 : (mode == MODE.ITEM ? 2 : (unit = mode == MODE.ENERGY ? 3 : 0));
        if (mode == MODE.MACHINE) {
            return number + "%";
        }
        if (number / 1000L == 0L) {
            return number + units[0][unit];
        }
        for (i = 1; number / 10000000L != 0L && i < units.length; ++i) {
            number /= 1000L;
        }
        return new DecimalFormat("#.#").format((float)number * 1.0f / 1000.0f) + units[i][unit];
    }

    public static enum MODE {
        FLUID,
        ITEM,
        ENERGY,
        MACHINE,
        PROXY;

        public static MODE[] VALUES;

        static {
            VALUES = MODE.values();
        }
    }
}

