/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.impl.ItemHandlerDelegate;
import gregtech.api.cover.CoverBase;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.CoverableView;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.ImageCycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.IncrementButtonWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.TextFieldWidget2;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.ItemStackHashStrategy;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleSidedCubeRenderer;
import gregtech.common.covers.DistributionMode;
import gregtech.common.covers.IIOMode;
import gregtech.common.covers.ManualImportExportMode;
import gregtech.common.covers.filter.ItemFilterContainer;
import gregtech.common.pipelike.itempipe.tile.TileEntityItemPipe;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class CoverConveyor
extends CoverBase
implements CoverWithUI,
ITickable,
IControllable {
    public final int tier;
    public final int maxItemTransferRate;
    private int transferRate;
    protected ConveyorMode conveyorMode;
    protected DistributionMode distributionMode;
    protected ManualImportExportMode manualImportExportMode = ManualImportExportMode.DISABLED;
    protected final ItemFilterContainer itemFilterContainer;
    protected int itemsLeftToTransferLastSecond;
    private CoverableItemHandlerWrapper itemHandlerWrapper;
    protected boolean isWorkingAllowed = true;

    public CoverConveyor(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide, int tier, int itemsPerSecond) {
        super(definition, coverableView, attachedSide);
        this.tier = tier;
        this.itemsLeftToTransferLastSecond = this.transferRate = (this.maxItemTransferRate = itemsPerSecond);
        this.conveyorMode = ConveyorMode.EXPORT;
        this.distributionMode = DistributionMode.INSERT_FIRST;
        this.itemFilterContainer = new ItemFilterContainer(this);
    }

    public void setTransferRate(int transferRate) {
        this.transferRate = transferRate;
        CoverableView coverable = this.getCoverableView();
        coverable.markDirty();
        if (this.getWorld() != null && this.getWorld().field_72995_K) {
            TileEntity te = this.getTileEntityHere();
            if (te instanceof TileEntityItemPipe) {
                ((TileEntityItemPipe)te).resetTransferred();
            }
            if ((te = this.getNeighbor(this.getAttachedSide())) instanceof TileEntityItemPipe) {
                ((TileEntityItemPipe)te).resetTransferred();
            }
        }
    }

    public int getTransferRate() {
        return this.transferRate;
    }

    protected void adjustTransferRate(int amount) {
        this.setTransferRate(MathHelper.func_76125_a((int)(this.transferRate + amount), (int)1, (int)this.maxItemTransferRate));
    }

    public void setConveyorMode(ConveyorMode conveyorMode) {
        this.conveyorMode = conveyorMode;
        this.writeCustomData(GregtechDataCodes.UPDATE_COVER_MODE, buf -> buf.func_179249_a((Enum)conveyorMode));
        this.markDirty();
    }

    public ConveyorMode getConveyorMode() {
        return this.conveyorMode;
    }

    public DistributionMode getDistributionMode() {
        return this.distributionMode;
    }

    public void setDistributionMode(DistributionMode distributionMode) {
        this.distributionMode = distributionMode;
        this.markDirty();
    }

    public ManualImportExportMode getManualImportExportMode() {
        return this.manualImportExportMode;
    }

    protected void setManualImportExportMode(ManualImportExportMode manualImportExportMode) {
        this.manualImportExportMode = manualImportExportMode;
        this.markDirty();
    }

    public ItemFilterContainer getItemFilterContainer() {
        return this.itemFilterContainer;
    }

    public void func_73660_a() {
        CoverableView coverable = this.getCoverableView();
        long timer = coverable.getOffsetTimer();
        if (timer % 5L == 0L && this.isWorkingAllowed && this.itemsLeftToTransferLastSecond > 0) {
            EnumFacing side = this.getAttachedSide();
            TileEntity tileEntity = coverable.getNeighbor(side);
            IItemHandler itemHandler = tileEntity == null ? null : (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d());
            IItemHandler myItemHandler = (IItemHandler)coverable.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            if (itemHandler != null && myItemHandler != null) {
                int totalTransferred = this.doTransferItems(itemHandler, myItemHandler, this.itemsLeftToTransferLastSecond);
                this.itemsLeftToTransferLastSecond -= totalTransferred;
            }
        }
        if (timer % 20L == 0L) {
            this.itemsLeftToTransferLastSecond = this.transferRate;
        }
    }

    protected int doTransferItems(IItemHandler itemHandler, IItemHandler myItemHandler, int maxTransferAmount) {
        return this.doTransferItemsAny(itemHandler, myItemHandler, maxTransferAmount);
    }

    protected int doTransferItemsAny(IItemHandler itemHandler, IItemHandler myItemHandler, int maxTransferAmount) {
        if (this.conveyorMode == ConveyorMode.IMPORT) {
            return this.moveInventoryItems(itemHandler, myItemHandler, maxTransferAmount);
        }
        if (this.conveyorMode == ConveyorMode.EXPORT) {
            return this.moveInventoryItems(myItemHandler, itemHandler, maxTransferAmount);
        }
        return 0;
    }

    protected int doTransferItemsByGroup(IItemHandler itemHandler, IItemHandler myItemHandler, Map<Object, GroupItemInfo> itemInfos, int maxTransferAmount) {
        if (this.conveyorMode == ConveyorMode.IMPORT) {
            return this.moveInventoryItems(itemHandler, myItemHandler, itemInfos, maxTransferAmount);
        }
        if (this.conveyorMode == ConveyorMode.EXPORT) {
            return this.moveInventoryItems(myItemHandler, itemHandler, itemInfos, maxTransferAmount);
        }
        return 0;
    }

    protected Map<Object, GroupItemInfo> doCountDestinationInventoryItemsByMatchIndex(IItemHandler itemHandler, IItemHandler myItemHandler) {
        if (this.conveyorMode == ConveyorMode.IMPORT) {
            return this.countInventoryItemsByMatchSlot(myItemHandler);
        }
        if (this.conveyorMode == ConveyorMode.EXPORT) {
            return this.countInventoryItemsByMatchSlot(itemHandler);
        }
        return Collections.emptyMap();
    }

    protected Map<ItemStack, TypeItemInfo> doCountSourceInventoryItemsByType(IItemHandler itemHandler, IItemHandler myItemHandler) {
        if (this.conveyorMode == ConveyorMode.IMPORT) {
            return this.countInventoryItemsByType(itemHandler);
        }
        if (this.conveyorMode == ConveyorMode.EXPORT) {
            return this.countInventoryItemsByType(myItemHandler);
        }
        return Collections.emptyMap();
    }

    protected boolean doTransferItemsExact(IItemHandler itemHandler, IItemHandler myItemHandler, TypeItemInfo itemInfo) {
        if (this.conveyorMode == ConveyorMode.IMPORT) {
            return CoverConveyor.moveInventoryItemsExact(itemHandler, myItemHandler, itemInfo);
        }
        if (this.conveyorMode == ConveyorMode.EXPORT) {
            return CoverConveyor.moveInventoryItemsExact(myItemHandler, itemHandler, itemInfo);
        }
        return false;
    }

    protected static boolean moveInventoryItemsExact(IItemHandler sourceInventory, IItemHandler targetInventory, TypeItemInfo itemInfo) {
        ItemStack resultStack = itemInfo.itemStack.func_77946_l();
        int totalExtractedCount = 0;
        int itemsLeftToExtract = itemInfo.totalCount;
        for (int i = 0; i < itemInfo.slots.size(); ++i) {
            int slotIndex = (Integer)itemInfo.slots.get(i);
            ItemStack extractedStack = sourceInventory.extractItem(slotIndex, itemsLeftToExtract, true);
            if (!extractedStack.func_190926_b() && ItemStack.func_179545_c((ItemStack)resultStack, (ItemStack)extractedStack) && ItemStack.func_77970_a((ItemStack)resultStack, (ItemStack)extractedStack)) {
                totalExtractedCount += extractedStack.func_190916_E();
                itemsLeftToExtract -= extractedStack.func_190916_E();
            }
            if (itemsLeftToExtract == 0) break;
        }
        if (totalExtractedCount != itemInfo.totalCount) {
            return false;
        }
        resultStack.func_190920_e(totalExtractedCount);
        ItemStack remainder = GTTransferUtils.insertItem(targetInventory, resultStack, true);
        if (!remainder.func_190926_b()) {
            return false;
        }
        GTTransferUtils.insertItem(targetInventory, resultStack, false);
        itemsLeftToExtract = itemInfo.totalCount;
        for (int i = 0; i < itemInfo.slots.size(); ++i) {
            int slotIndex = (Integer)itemInfo.slots.get(i);
            ItemStack extractedStack = sourceInventory.extractItem(slotIndex, itemsLeftToExtract, false);
            if (!extractedStack.func_190926_b() && ItemStack.func_179545_c((ItemStack)resultStack, (ItemStack)extractedStack) && ItemStack.func_77970_a((ItemStack)resultStack, (ItemStack)extractedStack)) {
                itemsLeftToExtract -= extractedStack.func_190916_E();
            }
            if (itemsLeftToExtract == 0) break;
        }
        return true;
    }

    protected int moveInventoryItems(IItemHandler sourceInventory, IItemHandler targetInventory, Map<Object, GroupItemInfo> itemInfos, int maxTransferAmount) {
        int itemsLeftToTransfer = maxTransferAmount;
        for (int i = 0; i < sourceInventory.getSlots(); ++i) {
            Object matchSlotIndex;
            ItemStack itemStack = sourceInventory.getStackInSlot(i);
            if (itemStack.func_190926_b() || (matchSlotIndex = this.itemFilterContainer.matchItemStack(itemStack)) == null || !itemInfos.containsKey(matchSlotIndex)) continue;
            GroupItemInfo itemInfo = itemInfos.get(matchSlotIndex);
            ItemStack extractedStack = sourceInventory.extractItem(i, Math.min(itemInfo.totalCount, itemsLeftToTransfer), true);
            ItemStack remainderStack = GTTransferUtils.insertItem(targetInventory, extractedStack, true);
            int amountToInsert = extractedStack.func_190916_E() - remainderStack.func_190916_E();
            if (amountToInsert <= 0 || (extractedStack = sourceInventory.extractItem(i, amountToInsert, false)).func_190926_b()) continue;
            GTTransferUtils.insertItem(targetInventory, extractedStack, false);
            itemsLeftToTransfer -= extractedStack.func_190916_E();
            itemInfo.totalCount -= extractedStack.func_190916_E();
            if (itemInfo.totalCount == 0) {
                itemInfos.remove(matchSlotIndex);
                if (itemInfos.isEmpty()) break;
            }
            if (itemsLeftToTransfer == 0) break;
        }
        return maxTransferAmount - itemsLeftToTransfer;
    }

    protected int moveInventoryItems(IItemHandler sourceInventory, IItemHandler targetInventory, int maxTransferAmount) {
        int itemsLeftToTransfer = maxTransferAmount;
        for (int srcIndex = 0; srcIndex < sourceInventory.getSlots(); ++srcIndex) {
            ItemStack sourceStack = sourceInventory.extractItem(srcIndex, itemsLeftToTransfer, true);
            if (sourceStack.func_190926_b() || !this.itemFilterContainer.testItemStack(sourceStack)) continue;
            ItemStack remainder = GTTransferUtils.insertItem(targetInventory, sourceStack, true);
            int amountToInsert = sourceStack.func_190916_E() - remainder.func_190916_E();
            if (amountToInsert <= 0 || (sourceStack = sourceInventory.extractItem(srcIndex, amountToInsert, false)).func_190926_b()) continue;
            GTTransferUtils.insertItem(targetInventory, sourceStack, false);
            if ((itemsLeftToTransfer -= sourceStack.func_190916_E()) == 0) break;
        }
        return maxTransferAmount - itemsLeftToTransfer;
    }

    @NotNull
    protected Map<ItemStack, TypeItemInfo> countInventoryItemsByType(@NotNull IItemHandler inventory) {
        Object2ObjectOpenCustomHashMap result = new Object2ObjectOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount());
        for (int srcIndex = 0; srcIndex < inventory.getSlots(); ++srcIndex) {
            TypeItemInfo itemInfo;
            Object transferSlotIndex;
            ItemStack itemStack = inventory.getStackInSlot(srcIndex);
            if (itemStack.func_190926_b() || (transferSlotIndex = this.itemFilterContainer.matchItemStack(itemStack)) == null) continue;
            if (!result.containsKey(itemStack)) {
                itemInfo = new TypeItemInfo(itemStack.func_77946_l(), transferSlotIndex, (IntList)new IntArrayList(), 0);
                itemInfo.totalCount += itemStack.func_190916_E();
                itemInfo.slots.add(srcIndex);
                result.put(itemStack.func_77946_l(), itemInfo);
                continue;
            }
            itemInfo = (TypeItemInfo)result.get(itemStack);
            itemInfo.totalCount += itemStack.func_190916_E();
            itemInfo.slots.add(srcIndex);
        }
        return result;
    }

    @NotNull
    protected Map<Object, GroupItemInfo> countInventoryItemsByMatchSlot(@NotNull IItemHandler inventory) {
        Object2ObjectOpenHashMap result = new Object2ObjectOpenHashMap();
        for (int srcIndex = 0; srcIndex < inventory.getSlots(); ++srcIndex) {
            GroupItemInfo itemInfo;
            Object transferSlotIndex;
            ItemStack itemStack = inventory.getStackInSlot(srcIndex);
            if (itemStack.func_190926_b() || (transferSlotIndex = this.itemFilterContainer.matchItemStack(itemStack)) == null) continue;
            if (!result.containsKey(transferSlotIndex)) {
                itemInfo = new GroupItemInfo(transferSlotIndex, (Set<ItemStack>)new ObjectOpenCustomHashSet((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount()), 0);
                itemInfo.itemStackTypes.add(itemStack.func_77946_l());
                itemInfo.totalCount += itemStack.func_190916_E();
                result.put(transferSlotIndex, itemInfo);
                continue;
            }
            itemInfo = (GroupItemInfo)result.get(transferSlotIndex);
            itemInfo.itemStackTypes.add(itemStack.func_77946_l());
            itemInfo.totalCount += itemStack.func_190916_E();
        }
        return result;
    }

    @Override
    public boolean canAttach(@NotNull CoverableView coverable, @NotNull EnumFacing side) {
        return coverable.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getAttachedSide()) != null;
    }

    @Override
    public boolean canInteractWithOutputSide() {
        return true;
    }

    @Override
    public void onRemoval() {
        this.dropInventoryContents((IItemHandlerModifiable)this.itemFilterContainer.getFilterInventory());
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        if (this.conveyorMode == ConveyorMode.EXPORT) {
            Textures.CONVEYOR_OVERLAY.renderSided(this.getAttachedSide(), plateBox, renderState, pipeline, translation);
        } else {
            Textures.CONVEYOR_OVERLAY_INVERTED.renderSided(this.getAttachedSide(), plateBox, renderState, pipeline, translation);
        }
    }

    @Override
    @NotNull
    public EnumActionResult onScrewdriverClick(@NotNull EntityPlayer playerIn, @NotNull EnumHand hand, @NotNull CuboidRayTraceResult hitResult) {
        if (!this.getCoverableView().getWorld().field_72995_K) {
            this.openUI((EntityPlayerMP)playerIn);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, T defaultValue) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (defaultValue == null) {
                return null;
            }
            IItemHandler delegate = (IItemHandler)defaultValue;
            if (this.itemHandlerWrapper == null || this.itemHandlerWrapper.delegate != delegate) {
                this.itemHandlerWrapper = new CoverableItemHandlerWrapper(delegate);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandlerWrapper);
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return defaultValue;
    }

    protected String getUITitle() {
        return "cover.conveyor.title";
    }

    protected ModularUI buildUI(ModularUI.Builder builder, EntityPlayer player) {
        return builder.build(this, player);
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        WidgetGroup primaryGroup = new WidgetGroup();
        primaryGroup.addWidget(new LabelWidget(10, 5, this.getUITitle(), GTValues.VN[this.tier]));
        primaryGroup.addWidget(new IncrementButtonWidget(136, 20, 30, 20, 1, 8, 64, 512, this::adjustTransferRate).setDefaultTooltip().setShouldClientCallback(false));
        primaryGroup.addWidget(new IncrementButtonWidget(10, 20, 30, 20, -1, -8, -64, -512, this::adjustTransferRate).setDefaultTooltip().setShouldClientCallback(false));
        primaryGroup.addWidget(new ImageWidget(40, 20, 96, 20, GuiTextures.DISPLAY));
        primaryGroup.addWidget(new TextFieldWidget2(42, 26, 92, 20, () -> String.valueOf(this.transferRate), val -> {
            if (val != null && !val.isEmpty()) {
                this.setTransferRate(MathHelper.func_76125_a((int)Integer.parseInt(val), (int)1, (int)this.maxItemTransferRate));
            }
        }).setNumbersOnly(1, this.maxItemTransferRate).setMaxLength(4).setPostFix("cover.conveyor.transfer_rate"));
        primaryGroup.addWidget(new CycleButtonWidget(10, 45, 75, 20, ConveyorMode.class, this::getConveyorMode, this::setConveyorMode));
        primaryGroup.addWidget(new CycleButtonWidget(7, 166, 116, 20, ManualImportExportMode.class, this::getManualImportExportMode, this::setManualImportExportMode).setTooltipHoverString("cover.universal.manual_import_export.mode.description"));
        if (this.getTileEntityHere() instanceof TileEntityItemPipe || this.getNeighbor(this.getAttachedSide()) instanceof TileEntityItemPipe) {
            ImageCycleButtonWidget distributionModeButton = new ImageCycleButtonWidget(149, 166, 20, 20, GuiTextures.DISTRIBUTION_MODE, 3, () -> this.distributionMode.ordinal(), val -> this.setDistributionMode(DistributionMode.values()[val])).setTooltipHoverString(val -> DistributionMode.values()[val].func_176610_l());
            primaryGroup.addWidget(distributionModeButton);
        }
        this.itemFilterContainer.initUI(70, primaryGroup::addWidget);
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, 176, 272).widget(primaryGroup).bindPlayerInventory(player.field_71071_by, GuiTextures.SLOT, 7, 190);
        return this.buildUI(builder, player);
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isWorkingAllowed;
    }

    @Override
    public void setWorkingEnabled(boolean isActivationAllowed) {
        this.isWorkingAllowed = isActivationAllowed;
    }

    @Override
    public void readCustomData(int discriminator, @NotNull PacketBuffer buf) {
        super.readCustomData(discriminator, buf);
        if (discriminator == GregtechDataCodes.UPDATE_COVER_MODE) {
            this.conveyorMode = (ConveyorMode)buf.func_179257_a(ConveyorMode.class);
            this.getCoverableView().scheduleRenderUpdate();
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer packetBuffer) {
        super.writeInitialSyncData(packetBuffer);
        packetBuffer.func_179249_a((Enum)this.conveyorMode);
        packetBuffer.func_179249_a((Enum)this.distributionMode);
    }

    @Override
    public void readInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        super.readInitialSyncData(packetBuffer);
        this.conveyorMode = (ConveyorMode)packetBuffer.func_179257_a(ConveyorMode.class);
        this.distributionMode = (DistributionMode)packetBuffer.func_179257_a(DistributionMode.class);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("TransferRate", this.transferRate);
        tagCompound.func_74768_a("ConveyorMode", this.conveyorMode.ordinal());
        tagCompound.func_74768_a("DistributionMode", this.distributionMode.ordinal());
        tagCompound.func_74757_a("WorkingAllowed", this.isWorkingAllowed);
        tagCompound.func_74768_a("ManualImportExportMode", this.manualImportExportMode.ordinal());
        tagCompound.func_74782_a("Filter", (NBTBase)this.itemFilterContainer.serializeNBT());
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.transferRate = tagCompound.func_74762_e("TransferRate");
        this.conveyorMode = ConveyorMode.values()[tagCompound.func_74762_e("ConveyorMode")];
        this.distributionMode = DistributionMode.values()[tagCompound.func_74762_e("DistributionMode")];
        this.isWorkingAllowed = tagCompound.func_74767_n("WorkingAllowed");
        this.manualImportExportMode = ManualImportExportMode.values()[tagCompound.func_74762_e("ManualImportExportMode")];
        this.itemFilterContainer.deserializeNBT(tagCompound.func_74775_l("Filter"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected TextureAtlasSprite getPlateSprite() {
        return Textures.VOLTAGE_CASINGS[this.tier].getSpriteOnSide(SimpleSidedCubeRenderer.RenderSide.SIDE);
    }

    public static enum ConveyorMode implements IStringSerializable,
    IIOMode
    {
        IMPORT("cover.conveyor.mode.import"),
        EXPORT("cover.conveyor.mode.export");

        public final String localeName;

        private ConveyorMode(String localeName) {
            this.localeName = localeName;
        }

        @NotNull
        public String func_176610_l() {
            return this.localeName;
        }

        @Override
        public boolean isImport() {
            return this == IMPORT;
        }
    }

    protected static class TypeItemInfo {
        public final ItemStack itemStack;
        public final Object filterSlot;
        public final IntList slots;
        public int totalCount;

        public TypeItemInfo(ItemStack itemStack, Object filterSlot, IntList slots, int totalCount) {
            this.itemStack = itemStack;
            this.filterSlot = filterSlot;
            this.slots = slots;
            this.totalCount = totalCount;
        }
    }

    protected static class GroupItemInfo {
        public final Object filterSlot;
        public final Set<ItemStack> itemStackTypes;
        public int totalCount;

        public GroupItemInfo(Object filterSlot, Set<ItemStack> itemStackTypes, int totalCount) {
            this.filterSlot = filterSlot;
            this.itemStackTypes = itemStackTypes;
            this.totalCount = totalCount;
        }
    }

    private class CoverableItemHandlerWrapper
    extends ItemHandlerDelegate {
        public CoverableItemHandlerWrapper(IItemHandler delegate) {
            super(delegate);
        }

        @Override
        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (CoverConveyor.this.conveyorMode == ConveyorMode.EXPORT && CoverConveyor.this.manualImportExportMode == ManualImportExportMode.DISABLED) {
                return stack;
            }
            if (CoverConveyor.this.manualImportExportMode == ManualImportExportMode.FILTERED && !CoverConveyor.this.itemFilterContainer.testItemStack(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (CoverConveyor.this.conveyorMode == ConveyorMode.IMPORT && CoverConveyor.this.manualImportExportMode == ManualImportExportMode.DISABLED) {
                return ItemStack.field_190927_a;
            }
            if (CoverConveyor.this.manualImportExportMode == ManualImportExportMode.FILTERED) {
                ItemStack result = super.extractItem(slot, amount, true);
                if (result.func_190926_b() || !CoverConveyor.this.itemFilterContainer.testItemStack(result)) {
                    return ItemStack.field_190927_a;
                }
                return simulate ? result : super.extractItem(slot, amount, false);
            }
            return super.extractItem(slot, amount, simulate);
        }
    }
}

