/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import com.google.common.collect.ImmutableMap;
import gregtech.api.GregTechAPI;
import gregtech.api.block.machines.BlockMachine;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.material.BlockMaterialPipe;
import gregtech.api.pipenet.longdist.BlockLongDistancePipe;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.material.registry.MaterialRegistry;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.ore.StoneType;
import gregtech.api.util.BlockUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.function.TriConsumer;
import gregtech.client.model.SimpleStateMapper;
import gregtech.client.model.modelfactories.BakedModelHandler;
import gregtech.client.renderer.handler.MetaTileEntityRenderer;
import gregtech.client.renderer.handler.MetaTileEntityTESR;
import gregtech.client.renderer.pipe.CableRenderer;
import gregtech.client.renderer.pipe.FluidPipeRenderer;
import gregtech.client.renderer.pipe.ItemPipeRenderer;
import gregtech.client.renderer.pipe.LaserPipeRenderer;
import gregtech.client.renderer.pipe.OpticalPipeRenderer;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockAsphalt;
import gregtech.common.blocks.BlockBatteryPart;
import gregtech.common.blocks.BlockBoilerCasing;
import gregtech.common.blocks.BlockBrittleCharcoal;
import gregtech.common.blocks.BlockCleanroomCasing;
import gregtech.common.blocks.BlockColored;
import gregtech.common.blocks.BlockCompressed;
import gregtech.common.blocks.BlockComputerCasing;
import gregtech.common.blocks.BlockFireboxCasing;
import gregtech.common.blocks.BlockFrame;
import gregtech.common.blocks.BlockFusionCasing;
import gregtech.common.blocks.BlockGlassCasing;
import gregtech.common.blocks.BlockGregStairs;
import gregtech.common.blocks.BlockHermeticCasing;
import gregtech.common.blocks.BlockLamp;
import gregtech.common.blocks.BlockLampBorderless;
import gregtech.common.blocks.BlockMachineCasing;
import gregtech.common.blocks.BlockMaterialBase;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockMultiblockCasing;
import gregtech.common.blocks.BlockOre;
import gregtech.common.blocks.BlockSteamCasing;
import gregtech.common.blocks.BlockSurfaceRock;
import gregtech.common.blocks.BlockTurbineCasing;
import gregtech.common.blocks.BlockWarningSign;
import gregtech.common.blocks.BlockWarningSign1;
import gregtech.common.blocks.BlockWireCoil;
import gregtech.common.blocks.StoneVariantBlock;
import gregtech.common.blocks.foam.BlockFoam;
import gregtech.common.blocks.foam.BlockPetrifiedFoam;
import gregtech.common.blocks.wood.BlockGregFence;
import gregtech.common.blocks.wood.BlockGregFenceGate;
import gregtech.common.blocks.wood.BlockGregPlanks;
import gregtech.common.blocks.wood.BlockGregWoodSlab;
import gregtech.common.blocks.wood.BlockRubberDoor;
import gregtech.common.blocks.wood.BlockRubberLeaves;
import gregtech.common.blocks.wood.BlockRubberLog;
import gregtech.common.blocks.wood.BlockRubberSapling;
import gregtech.common.blocks.wood.BlockWoodenDoor;
import gregtech.common.items.MetaItems;
import gregtech.common.pipelike.cable.BlockCable;
import gregtech.common.pipelike.cable.Insulation;
import gregtech.common.pipelike.cable.tile.TileEntityCable;
import gregtech.common.pipelike.cable.tile.TileEntityCableTickable;
import gregtech.common.pipelike.fluidpipe.BlockFluidPipe;
import gregtech.common.pipelike.fluidpipe.FluidPipeType;
import gregtech.common.pipelike.fluidpipe.longdistance.LDFluidPipeType;
import gregtech.common.pipelike.fluidpipe.tile.TileEntityFluidPipe;
import gregtech.common.pipelike.fluidpipe.tile.TileEntityFluidPipeTickable;
import gregtech.common.pipelike.itempipe.BlockItemPipe;
import gregtech.common.pipelike.itempipe.ItemPipeType;
import gregtech.common.pipelike.itempipe.longdistance.LDItemPipeType;
import gregtech.common.pipelike.itempipe.tile.TileEntityItemPipe;
import gregtech.common.pipelike.itempipe.tile.TileEntityItemPipeTickable;
import gregtech.common.pipelike.laser.BlockLaserPipe;
import gregtech.common.pipelike.laser.LaserPipeType;
import gregtech.common.pipelike.laser.tile.TileEntityLaserPipe;
import gregtech.common.pipelike.optical.BlockOpticalPipe;
import gregtech.common.pipelike.optical.OpticalPipeType;
import gregtech.common.pipelike.optical.tile.TileEntityOpticalPipe;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class MetaBlocks {
    public static BlockMachine MACHINE;
    public static final Map<String, BlockCable[]> CABLES;
    public static final Map<String, BlockFluidPipe[]> FLUID_PIPES;
    public static final Map<String, BlockItemPipe[]> ITEM_PIPES;
    public static final BlockOpticalPipe[] OPTICAL_PIPES;
    public static final BlockLaserPipe[] LASER_PIPES;
    public static BlockLongDistancePipe LD_ITEM_PIPE;
    public static BlockLongDistancePipe LD_FLUID_PIPE;
    public static BlockBoilerCasing BOILER_CASING;
    public static BlockFireboxCasing BOILER_FIREBOX_CASING;
    public static BlockMetalCasing METAL_CASING;
    public static BlockTurbineCasing TURBINE_CASING;
    public static BlockMachineCasing MACHINE_CASING;
    public static BlockSteamCasing STEAM_CASING;
    public static BlockMultiblockCasing MULTIBLOCK_CASING;
    public static BlockGlassCasing TRANSPARENT_CASING;
    public static BlockWireCoil WIRE_COIL;
    public static BlockFusionCasing FUSION_CASING;
    public static BlockWarningSign WARNING_SIGN;
    public static BlockWarningSign1 WARNING_SIGN_1;
    public static BlockHermeticCasing HERMETIC_CASING;
    public static BlockCleanroomCasing CLEANROOM_CASING;
    public static BlockComputerCasing COMPUTER_CASING;
    public static BlockBatteryPart BATTERY_BLOCK;
    public static final EnumMap<EnumDyeColor, BlockLamp> LAMPS;
    public static final EnumMap<EnumDyeColor, BlockLamp> BORDERLESS_LAMPS;
    public static BlockAsphalt ASPHALT;
    public static final EnumMap<StoneVariantBlock.StoneVariant, StoneVariantBlock> STONE_BLOCKS;
    public static BlockFoam FOAM;
    public static BlockFoam REINFORCED_FOAM;
    public static BlockPetrifiedFoam PETRIFIED_FOAM;
    public static BlockPetrifiedFoam REINFORCED_PETRIFIED_FOAM;
    public static BlockRubberLog RUBBER_LOG;
    public static BlockRubberLeaves RUBBER_LEAVES;
    public static BlockRubberSapling RUBBER_SAPLING;
    public static BlockGregPlanks PLANKS;
    public static BlockGregWoodSlab WOOD_SLAB;
    public static BlockGregWoodSlab DOUBLE_WOOD_SLAB;
    public static BlockStairs RUBBER_WOOD_STAIRS;
    public static BlockStairs TREATED_WOOD_STAIRS;
    public static BlockFence RUBBER_WOOD_FENCE;
    public static BlockFence TREATED_WOOD_FENCE;
    public static BlockFenceGate RUBBER_WOOD_FENCE_GATE;
    public static BlockFenceGate TREATED_WOOD_FENCE_GATE;
    public static BlockWoodenDoor RUBBER_WOOD_DOOR;
    public static BlockWoodenDoor TREATED_WOOD_DOOR;
    public static BlockBrittleCharcoal BRITTLE_CHARCOAL;
    public static BlockColored METAL_SHEET;
    public static BlockColored LARGE_METAL_SHEET;
    public static BlockColored STUDS;
    public static final Map<Material, BlockCompressed> COMPRESSED;
    public static final Map<Material, BlockFrame> FRAMES;
    public static final Map<Material, BlockSurfaceRock> SURFACE_ROCK;
    public static final List<BlockCompressed> COMPRESSED_BLOCKS;
    public static final List<BlockFrame> FRAME_BLOCKS;
    public static final List<BlockSurfaceRock> SURFACE_ROCK_BLOCKS;
    public static final List<BlockOre> ORES;
    public static final List<BlockFluidBase> FLUID_BLOCKS;

    private MetaBlocks() {
    }

    public static void init() {
        GregTechAPI.MACHINE = MACHINE = new BlockMachine();
        MACHINE.setRegistryName("machine");
        for (MaterialRegistry registry : GregTechAPI.materialManager.getRegistries()) {
            String modid = registry.getModid();
            BlockCable[] blockCableArray = new BlockCable[Insulation.VALUES.length];
            for (Insulation ins : Insulation.VALUES) {
                blockCableArray[ins.ordinal()] = new BlockCable(ins, registry);
                blockCableArray[ins.ordinal()].setRegistryName(modid, ins.func_176610_l());
            }
            CABLES.put(modid, blockCableArray);
            BlockFluidPipe[] fluidPipes = new BlockFluidPipe[FluidPipeType.VALUES.length];
            for (FluidPipeType type : FluidPipeType.VALUES) {
                fluidPipes[type.ordinal()] = new BlockFluidPipe(type, registry);
                fluidPipes[type.ordinal()].setRegistryName(modid, String.format("fluid_pipe_%s", type.name));
            }
            FLUID_PIPES.put(modid, fluidPipes);
            BlockItemPipe[] itemPipes = new BlockItemPipe[ItemPipeType.VALUES.length];
            for (ItemPipeType type : ItemPipeType.VALUES) {
                itemPipes[type.ordinal()] = new BlockItemPipe(type, registry);
                itemPipes[type.ordinal()].setRegistryName(modid, String.format("item_pipe_%s", type.name));
            }
            ITEM_PIPES.put(modid, itemPipes);
        }
        for (OpticalPipeType opticalPipeType : OpticalPipeType.values()) {
            MetaBlocks.OPTICAL_PIPES[opticalPipeType.ordinal()] = new BlockOpticalPipe(opticalPipeType);
            OPTICAL_PIPES[opticalPipeType.ordinal()].setRegistryName(String.format("optical_pipe_%s", opticalPipeType.func_176610_l()));
            OPTICAL_PIPES[opticalPipeType.ordinal()].func_149663_c(String.format("optical_pipe_%s", opticalPipeType.func_176610_l()));
        }
        for (Enum enum_ : LaserPipeType.values()) {
            MetaBlocks.LASER_PIPES[enum_.ordinal()] = new BlockLaserPipe((LaserPipeType)enum_);
            LASER_PIPES[enum_.ordinal()].setRegistryName(String.format("laser_pipe_%s", ((LaserPipeType)enum_).func_176610_l()));
            LASER_PIPES[enum_.ordinal()].func_149663_c(String.format("laser_pipe_%s", ((LaserPipeType)enum_).func_176610_l()));
        }
        LD_ITEM_PIPE = new BlockLongDistancePipe(LDItemPipeType.INSTANCE);
        LD_ITEM_PIPE.setRegistryName("ld_item_pipe");
        LD_FLUID_PIPE = new BlockLongDistancePipe(LDFluidPipeType.INSTANCE);
        LD_FLUID_PIPE.setRegistryName("ld_fluid_pipe");
        BOILER_CASING = new BlockBoilerCasing();
        BOILER_CASING.setRegistryName("boiler_casing");
        BOILER_FIREBOX_CASING = new BlockFireboxCasing();
        BOILER_FIREBOX_CASING.setRegistryName("boiler_firebox_casing");
        METAL_CASING = new BlockMetalCasing();
        METAL_CASING.setRegistryName("metal_casing");
        TURBINE_CASING = new BlockTurbineCasing();
        TURBINE_CASING.setRegistryName("turbine_casing");
        MACHINE_CASING = new BlockMachineCasing();
        MACHINE_CASING.setRegistryName("machine_casing");
        STEAM_CASING = new BlockSteamCasing();
        STEAM_CASING.setRegistryName("steam_casing");
        MULTIBLOCK_CASING = new BlockMultiblockCasing();
        MULTIBLOCK_CASING.setRegistryName("multiblock_casing");
        TRANSPARENT_CASING = new BlockGlassCasing();
        TRANSPARENT_CASING.setRegistryName("transparent_casing");
        WIRE_COIL = new BlockWireCoil();
        WIRE_COIL.setRegistryName("wire_coil");
        FUSION_CASING = new BlockFusionCasing();
        FUSION_CASING.setRegistryName("fusion_casing");
        WARNING_SIGN = new BlockWarningSign();
        WARNING_SIGN.setRegistryName("warning_sign");
        WARNING_SIGN_1 = new BlockWarningSign1();
        WARNING_SIGN_1.setRegistryName("warning_sign_1");
        HERMETIC_CASING = new BlockHermeticCasing();
        HERMETIC_CASING.setRegistryName("hermetic_casing");
        CLEANROOM_CASING = new BlockCleanroomCasing();
        CLEANROOM_CASING.setRegistryName("cleanroom_casing");
        COMPUTER_CASING = new BlockComputerCasing();
        COMPUTER_CASING.setRegistryName("computer_casing");
        BATTERY_BLOCK = new BlockBatteryPart();
        BATTERY_BLOCK.setRegistryName("battery_block");
        for (Enum enum_ : EnumDyeColor.values()) {
            BlockLamp block = new BlockLamp((EnumDyeColor)enum_);
            block.setRegistryName(enum_.func_176610_l() + "_lamp");
            block.func_149663_c("gregtech_lamp." + enum_.func_176610_l());
            LAMPS.put((EnumDyeColor)enum_, block);
            block = new BlockLampBorderless((EnumDyeColor)enum_);
            block.setRegistryName("borderless_" + enum_.func_176610_l() + "_lamp");
            block.func_149663_c("gregtech_lamp_borderless." + enum_.func_176610_l());
            BORDERLESS_LAMPS.put((EnumDyeColor)enum_, block);
        }
        ASPHALT = new BlockAsphalt();
        ASPHALT.setRegistryName("asphalt");
        for (Enum enum_ : StoneVariantBlock.StoneVariant.values()) {
            STONE_BLOCKS.put((StoneVariantBlock.StoneVariant)enum_, new StoneVariantBlock((StoneVariantBlock.StoneVariant)enum_));
        }
        FOAM = new BlockFoam(false);
        FOAM.setRegistryName("foam");
        REINFORCED_FOAM = new BlockFoam(true);
        REINFORCED_FOAM.setRegistryName("reinforced_foam");
        PETRIFIED_FOAM = new BlockPetrifiedFoam(false);
        PETRIFIED_FOAM.setRegistryName("petrified_foam");
        REINFORCED_PETRIFIED_FOAM = new BlockPetrifiedFoam(true);
        REINFORCED_PETRIFIED_FOAM.setRegistryName("reinforced_petrified_foam");
        RUBBER_LOG = new BlockRubberLog();
        RUBBER_LOG.setRegistryName("rubber_log");
        RUBBER_LEAVES = new BlockRubberLeaves();
        RUBBER_LEAVES.setRegistryName("rubber_leaves");
        RUBBER_SAPLING = new BlockRubberSapling();
        RUBBER_SAPLING.setRegistryName("rubber_sapling");
        PLANKS = new BlockGregPlanks();
        PLANKS.setRegistryName("planks");
        WOOD_SLAB = new BlockGregWoodSlab.Half();
        WOOD_SLAB.setRegistryName("wood_slab");
        DOUBLE_WOOD_SLAB = new BlockGregWoodSlab.Double();
        DOUBLE_WOOD_SLAB.setRegistryName("double_wood_slab");
        RUBBER_WOOD_STAIRS = new BlockGregStairs(PLANKS.getState(BlockGregPlanks.BlockType.RUBBER_PLANK));
        ((Block)RUBBER_WOOD_STAIRS.setRegistryName("rubber_wood_stairs")).func_149663_c("rubber_wood_stairs");
        TREATED_WOOD_STAIRS = new BlockGregStairs(PLANKS.getState(BlockGregPlanks.BlockType.TREATED_PLANK));
        ((Block)TREATED_WOOD_STAIRS.setRegistryName("treated_wood_stairs")).func_149663_c("treated_wood_stairs");
        RUBBER_WOOD_FENCE = new BlockGregFence();
        ((Block)RUBBER_WOOD_FENCE.setRegistryName("rubber_wood_fence")).func_149663_c("rubber_wood_fence");
        TREATED_WOOD_FENCE = new BlockGregFence();
        ((Block)TREATED_WOOD_FENCE.setRegistryName("treated_wood_fence")).func_149663_c("treated_wood_fence");
        RUBBER_WOOD_FENCE_GATE = new BlockGregFenceGate();
        ((Block)RUBBER_WOOD_FENCE_GATE.setRegistryName("rubber_wood_fence_gate")).func_149663_c("rubber_wood_fence_gate");
        TREATED_WOOD_FENCE_GATE = new BlockGregFenceGate();
        ((Block)TREATED_WOOD_FENCE_GATE.setRegistryName("treated_wood_fence_gate")).func_149663_c("treated_wood_fence_gate");
        RUBBER_WOOD_DOOR = new BlockRubberDoor(() -> MetaItems.RUBBER_WOOD_DOOR.getStackForm());
        ((Block)RUBBER_WOOD_DOOR.setRegistryName("rubber_wood_door")).func_149663_c("rubber_wood_door");
        TREATED_WOOD_DOOR = new BlockWoodenDoor(() -> MetaItems.TREATED_WOOD_DOOR.getStackForm());
        ((Block)TREATED_WOOD_DOOR.setRegistryName("treated_wood_door")).func_149663_c("treated_wood_door");
        BRITTLE_CHARCOAL = new BlockBrittleCharcoal();
        BRITTLE_CHARCOAL.setRegistryName("brittle_charcoal");
        METAL_SHEET = new BlockColored(net.minecraft.block.material.Material.field_151573_f, "metal_sheet", 2.0f, 5.0f, SoundType.field_185852_e, EnumDyeColor.WHITE);
        METAL_SHEET.setRegistryName("metal_sheet");
        LARGE_METAL_SHEET = new BlockColored(net.minecraft.block.material.Material.field_151573_f, "large_metal_sheet", 2.0f, 5.0f, SoundType.field_185852_e, EnumDyeColor.WHITE);
        LARGE_METAL_SHEET.setRegistryName("large_metal_sheet");
        STUDS = new BlockColored(net.minecraft.block.material.Material.field_151593_r, "studs", 1.5f, 2.5f, SoundType.field_185854_g, EnumDyeColor.BLACK);
        STUDS.setRegistryName("studs");
        MetaBlocks.createGeneratedBlock(m -> m.hasProperty(PropertyKey.DUST) && m.hasFlag(MaterialFlags.GENERATE_FRAME), MetaBlocks::createFrameBlock);
        MetaBlocks.createGeneratedBlock(m -> m.hasProperty(PropertyKey.ORE) && m.hasProperty(PropertyKey.DUST), MetaBlocks::createSurfaceRockBlock);
        MetaBlocks.createGeneratedBlock(material -> (material.hasProperty(PropertyKey.INGOT) || material.hasProperty(PropertyKey.GEM) || material.hasFlag(MaterialFlags.FORCE_GENERATE_BLOCK)) && !OrePrefix.block.isIgnored((Material)material), MetaBlocks::createCompressedBlock);
        MetaBlocks.registerTileEntity();
        Blocks.field_150480_ab.func_180686_a((Block)RUBBER_LOG, 5, 5);
        Blocks.field_150480_ab.func_180686_a((Block)RUBBER_LEAVES, 30, 60);
        Blocks.field_150480_ab.func_180686_a((Block)PLANKS, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)WOOD_SLAB, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)DOUBLE_WOOD_SLAB, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)RUBBER_WOOD_STAIRS, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)TREATED_WOOD_STAIRS, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)RUBBER_WOOD_FENCE, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)TREATED_WOOD_FENCE, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)RUBBER_WOOD_FENCE_GATE, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)TREATED_WOOD_FENCE_GATE, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)RUBBER_WOOD_DOOR, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)TREATED_WOOD_DOOR, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)BRITTLE_CHARCOAL, 5, 5);
    }

    protected static void createGeneratedBlock(Predicate<Material> materialPredicate, TriConsumer<String, Material[], Integer> blockGenerator) {
        for (MaterialRegistry registry : GregTechAPI.materialManager.getRegistries()) {
            Int2ObjectAVLTreeMap blocksToGenerate = new Int2ObjectAVLTreeMap();
            Iterator iterator = registry.iterator();
            while (iterator.hasNext()) {
                Material material = (Material)iterator.next();
                if (!materialPredicate.test(material)) continue;
                int id = material.getId();
                int metaBlockID = id / 16;
                int subBlockID = id % 16;
                if (!blocksToGenerate.containsKey(metaBlockID)) {
                    Object[] materials = new Material[16];
                    Arrays.fill(materials, Materials.NULL);
                    blocksToGenerate.put(metaBlockID, (Object)materials);
                }
                ((Material[])blocksToGenerate.get((int)metaBlockID))[subBlockID] = material;
            }
            blocksToGenerate.forEach((key, value) -> blockGenerator.accept(registry.getModid(), (Material[])value, (Integer)key));
        }
    }

    private static void createCompressedBlock(String modid, Material[] materials, int index) {
        BlockCompressed block = BlockCompressed.create(materials);
        block.setRegistryName(modid, "meta_block_compressed_" + index);
        for (Material m : materials) {
            COMPRESSED.put(m, block);
        }
        COMPRESSED_BLOCKS.add(block);
    }

    private static void createFrameBlock(String modid, Material[] materials, int index) {
        BlockFrame block = BlockFrame.create(materials);
        block.setRegistryName(modid, "meta_block_frame_" + index);
        for (Material m : materials) {
            FRAMES.put(m, block);
        }
        FRAME_BLOCKS.add(block);
    }

    private static void createSurfaceRockBlock(String modid, Material[] materials, int index) {
        BlockSurfaceRock block = BlockSurfaceRock.create(materials);
        block.setRegistryName(modid, "meta_block_surface_rock_" + index);
        for (Material m : materials) {
            SURFACE_ROCK.put(m, block);
        }
        SURFACE_ROCK_BLOCKS.add(block);
    }

    public static void registerTileEntity() {
        GameRegistry.registerTileEntity(MetaTileEntityHolder.class, (ResourceLocation)GTUtility.gregtechId("machine"));
        GameRegistry.registerTileEntity(TileEntityCable.class, (ResourceLocation)GTUtility.gregtechId("cable"));
        GameRegistry.registerTileEntity(TileEntityCableTickable.class, (ResourceLocation)GTUtility.gregtechId("cable_tickable"));
        GameRegistry.registerTileEntity(TileEntityFluidPipe.class, (ResourceLocation)GTUtility.gregtechId("fluid_pipe"));
        GameRegistry.registerTileEntity(TileEntityItemPipe.class, (ResourceLocation)GTUtility.gregtechId("item_pipe"));
        GameRegistry.registerTileEntity(TileEntityOpticalPipe.class, (ResourceLocation)GTUtility.gregtechId("optical_pipe"));
        GameRegistry.registerTileEntity(TileEntityLaserPipe.class, (ResourceLocation)GTUtility.gregtechId("laser_pipe"));
        GameRegistry.registerTileEntity(TileEntityFluidPipeTickable.class, (ResourceLocation)GTUtility.gregtechId("fluid_pipe_active"));
        GameRegistry.registerTileEntity(TileEntityItemPipeTickable.class, (ResourceLocation)GTUtility.gregtechId("item_pipe_active"));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemModels() {
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)MACHINE), stack -> MetaTileEntityRenderer.MODEL_LOCATION);
        for (MaterialRegistry registry : GregTechAPI.materialManager.getRegistries()) {
            for (BlockCable blockCable : CABLES.get(registry.getModid())) {
                blockCable.onModelRegister();
            }
            for (BlockMaterialPipe blockMaterialPipe : FLUID_PIPES.get(registry.getModid())) {
                blockMaterialPipe.onModelRegister();
            }
            for (BlockMaterialPipe blockMaterialPipe : ITEM_PIPES.get(registry.getModid())) {
                blockMaterialPipe.onModelRegister();
            }
        }
        for (BlockOpticalPipe blockOpticalPipe : OPTICAL_PIPES) {
            ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)blockOpticalPipe), stack -> OpticalPipeRenderer.INSTANCE.getModelLocation());
        }
        for (BlockPipe blockPipe : LASER_PIPES) {
            ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)blockPipe), stack -> LaserPipeRenderer.INSTANCE.getModelLocation());
        }
        MetaBlocks.registerItemModel(BOILER_CASING);
        MetaBlocks.registerItemModel(METAL_CASING);
        MetaBlocks.registerItemModel(TURBINE_CASING);
        MetaBlocks.registerItemModel(MACHINE_CASING);
        MetaBlocks.registerItemModel(STEAM_CASING);
        MetaBlocks.registerItemModel(WARNING_SIGN);
        MetaBlocks.registerItemModel(WARNING_SIGN_1);
        MetaBlocks.registerItemModel(HERMETIC_CASING);
        MetaBlocks.registerItemModel(CLEANROOM_CASING);
        MetaBlocks.registerItemModel(COMPUTER_CASING);
        MetaBlocks.registerItemModel(BATTERY_BLOCK);
        MetaBlocks.registerItemModel(ASPHALT);
        for (StoneVariantBlock block : STONE_BLOCKS.values()) {
            MetaBlocks.registerItemModel(block);
        }
        MetaBlocks.registerItemModelWithOverride((Block)RUBBER_LOG, ImmutableMap.of((Object)BlockLog.field_176299_a, (Object)BlockLog.EnumAxis.Y));
        MetaBlocks.registerItemModel((Block)RUBBER_LEAVES);
        MetaBlocks.registerItemModel((Block)RUBBER_SAPLING);
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)RUBBER_SAPLING), (int)0, (ModelResourceLocation)new ModelResourceLocation(Objects.requireNonNull(RUBBER_SAPLING.getRegistryName()), "inventory"));
        MetaBlocks.registerItemModel(PLANKS);
        MetaBlocks.registerItemModel(LD_ITEM_PIPE);
        MetaBlocks.registerItemModel(LD_FLUID_PIPE);
        MetaBlocks.registerItemModelWithOverride((Block)WOOD_SLAB, ImmutableMap.of((Object)BlockSlab.field_176554_a, (Object)BlockSlab.EnumBlockHalf.BOTTOM));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)RUBBER_WOOD_STAIRS), (int)0, (ModelResourceLocation)new ModelResourceLocation(Objects.requireNonNull(RUBBER_WOOD_STAIRS.getRegistryName()), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)TREATED_WOOD_STAIRS), (int)0, (ModelResourceLocation)new ModelResourceLocation(Objects.requireNonNull(TREATED_WOOD_STAIRS.getRegistryName()), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)RUBBER_WOOD_FENCE), (int)0, (ModelResourceLocation)new ModelResourceLocation(Objects.requireNonNull(RUBBER_WOOD_FENCE.getRegistryName()), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)TREATED_WOOD_FENCE), (int)0, (ModelResourceLocation)new ModelResourceLocation(Objects.requireNonNull(TREATED_WOOD_FENCE.getRegistryName()), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)RUBBER_WOOD_FENCE_GATE), (int)0, (ModelResourceLocation)new ModelResourceLocation(Objects.requireNonNull(RUBBER_WOOD_FENCE_GATE.getRegistryName()), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)TREATED_WOOD_FENCE_GATE), (int)0, (ModelResourceLocation)new ModelResourceLocation(Objects.requireNonNull(TREATED_WOOD_FENCE_GATE.getRegistryName()), "inventory"));
        MetaBlocks.registerItemModel(BRITTLE_CHARCOAL);
        MetaBlocks.registerItemModel(METAL_SHEET);
        MetaBlocks.registerItemModel(LARGE_METAL_SHEET);
        MetaBlocks.registerItemModel(STUDS);
        BOILER_FIREBOX_CASING.onModelRegister();
        WIRE_COIL.onModelRegister();
        FUSION_CASING.onModelRegister();
        MULTIBLOCK_CASING.onModelRegister();
        TRANSPARENT_CASING.onModelRegister();
        for (BlockLamp lamp : LAMPS.values()) {
            lamp.onModelRegister();
        }
        for (BlockLamp lamp : BORDERLESS_LAMPS.values()) {
            lamp.onModelRegister();
        }
        for (BlockCompressed block : COMPRESSED_BLOCKS) {
            block.onModelRegister();
        }
        for (BlockFrame block : FRAME_BLOCKS) {
            block.onModelRegister();
        }
        for (BlockOre block : ORES) {
            block.onModelRegister();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerItemModel(Block block) {
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)block.func_176201_c(state), (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), MetaBlocks.statePropertiesToString(state.func_177228_b())));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerItemModelWithOverride(Block block, Map<IProperty<?>, Comparable<?>> stateOverrides) {
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            Object2ObjectOpenHashMap stringProperties = new Object2ObjectOpenHashMap((Map)state.func_177228_b());
            stringProperties.putAll(stateOverrides);
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)block.func_176201_c(state), (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), MetaBlocks.statePropertiesToString(stringProperties)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerStateMappers() {
        SimpleStateMapper normalStateMapper;
        ModelLoader.setCustomStateMapper((Block)MACHINE, (IStateMapper)new SimpleStateMapper(MetaTileEntityRenderer.MODEL_LOCATION));
        for (MaterialRegistry registry : GregTechAPI.materialManager.getRegistries()) {
            normalStateMapper = new SimpleStateMapper(CableRenderer.INSTANCE.getModelLocation());
            for (BlockCable blockCable : CABLES.get(registry.getModid())) {
                ModelLoader.setCustomStateMapper((Block)blockCable, (IStateMapper)normalStateMapper);
            }
            normalStateMapper = new SimpleStateMapper(FluidPipeRenderer.INSTANCE.getModelLocation());
            for (BlockMaterialPipe blockMaterialPipe : FLUID_PIPES.get(registry.getModid())) {
                ModelLoader.setCustomStateMapper((Block)blockMaterialPipe, (IStateMapper)normalStateMapper);
            }
            normalStateMapper = new SimpleStateMapper(ItemPipeRenderer.INSTANCE.getModelLocation());
            for (BlockMaterialPipe blockMaterialPipe : ITEM_PIPES.get(registry.getModid())) {
                ModelLoader.setCustomStateMapper((Block)blockMaterialPipe, (IStateMapper)normalStateMapper);
            }
        }
        normalStateMapper = new SimpleStateMapper(OpticalPipeRenderer.INSTANCE.getModelLocation());
        for (BlockOpticalPipe blockOpticalPipe : OPTICAL_PIPES) {
            ModelLoader.setCustomStateMapper((Block)blockOpticalPipe, (IStateMapper)normalStateMapper);
        }
        normalStateMapper = new SimpleStateMapper(LaserPipeRenderer.INSTANCE.getModelLocation());
        for (BlockPipe blockPipe : LASER_PIPES) {
            ModelLoader.setCustomStateMapper((Block)blockPipe, (IStateMapper)normalStateMapper);
        }
        normalStateMapper = new SimpleStateMapper(BlockSurfaceRock.MODEL_LOCATION);
        for (BlockSurfaceRock surfaceRock : SURFACE_ROCK_BLOCKS) {
            ModelLoader.setCustomStateMapper((Block)surfaceRock, (IStateMapper)normalStateMapper);
        }
        normalStateMapper = new StateMapperBase(){

            @NotNull
            protected ModelResourceLocation func_178132_a(@NotNull IBlockState state) {
                return new ModelResourceLocation((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c()), "normal");
            }
        };
        ModelLoader.setCustomStateMapper((Block)FOAM, (IStateMapper)normalStateMapper);
        ModelLoader.setCustomStateMapper((Block)REINFORCED_FOAM, (IStateMapper)normalStateMapper);
        ModelLoader.setCustomStateMapper((Block)PETRIFIED_FOAM, (IStateMapper)normalStateMapper);
        ModelLoader.setCustomStateMapper((Block)REINFORCED_PETRIFIED_FOAM, (IStateMapper)normalStateMapper);
        BakedModelHandler modelHandler = new BakedModelHandler();
        MinecraftForge.EVENT_BUS.register((Object)modelHandler);
        FLUID_BLOCKS.forEach(modelHandler::addFluidBlock);
        ClientRegistry.bindTileEntitySpecialRenderer(MetaTileEntityHolder.class, (TileEntitySpecialRenderer)new MetaTileEntityTESR());
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerColors() {
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        blockColors.func_186722_a((s, w, p, i) -> ((EnumDyeColor)s.func_177229_b((IProperty)net.minecraft.block.BlockColored.field_176581_a)).field_193351_w, new Block[]{FOAM, REINFORCED_FOAM, PETRIFIED_FOAM, REINFORCED_PETRIFIED_FOAM});
        int rubberLeavesColor = 10018379;
        blockColors.func_186722_a((s, w, p, i) -> 10018379, new Block[]{RUBBER_LEAVES});
        itemColors.func_186731_a((s, i) -> 10018379, new Block[]{RUBBER_LEAVES});
        for (BlockCompressed blockCompressed : COMPRESSED_BLOCKS) {
            blockColors.func_186722_a((s, w, p, i) -> blockCompressed.getGtMaterial(s).getMaterialRGB(), new Block[]{blockCompressed});
            itemColors.func_186731_a((s, i) -> blockCompressed.getGtMaterial(s).getMaterialRGB(), new Block[]{blockCompressed});
        }
        for (BlockFrame blockFrame : FRAME_BLOCKS) {
            blockColors.func_186722_a((s, w, p, i) -> blockFrame.getGtMaterial(s).getMaterialRGB(), new Block[]{blockFrame});
            itemColors.func_186731_a((s, i) -> blockFrame.getGtMaterial(s).getMaterialRGB(), new Block[]{blockFrame});
        }
        for (BlockSurfaceRock blockSurfaceRock : SURFACE_ROCK_BLOCKS) {
            blockColors.func_186722_a((s, w, p, i) -> i == 1 ? blockSurfaceRock.getGtMaterial(s).getMaterialRGB() : -1, new Block[]{blockSurfaceRock});
        }
        for (BlockOre blockOre : ORES) {
            blockColors.func_186722_a((s, w, p, i) -> i == 1 ? block.field_149764_J.getMaterialRGB() : 0xFFFFFF, new Block[]{blockOre});
            itemColors.func_186731_a((s, i) -> i == 1 ? block.field_149764_J.getMaterialRGB() : 0xFFFFFF, new Block[]{blockOre});
        }
        blockColors.func_186722_a((s, w, p, i) -> MACHINE_CASING.getState(s) == BlockMachineCasing.MachineCasingType.ULV ? 0xFFFFFF : ConfigHolder.client.defaultPaintingColor, new Block[]{MACHINE_CASING});
        itemColors.func_186731_a((s, i) -> MACHINE_CASING.getState(s) == BlockMachineCasing.MachineCasingType.ULV ? 0xFFFFFF : ConfigHolder.client.defaultPaintingColor, new Block[]{MACHINE_CASING});
        blockColors.func_186722_a((s, w, p, i) -> ConfigHolder.client.defaultPaintingColor, new Block[]{HERMETIC_CASING});
        itemColors.func_186731_a((s, i) -> ConfigHolder.client.defaultPaintingColor, new Block[]{HERMETIC_CASING});
    }

    public static void registerWalkingSpeedBonus() {
        for (IBlockState state : ASPHALT.func_176194_O().func_177619_a()) {
            BlockUtility.setWalkingSpeedBonus(state, 0.6);
        }
        for (IBlockState state : STUDS.func_176194_O().func_177619_a()) {
            BlockUtility.setWalkingSpeedBonus(state, 0.25);
        }
        for (StoneVariantBlock block : STONE_BLOCKS.values()) {
            BlockUtility.setWalkingSpeedBonus(block.getState(StoneVariantBlock.StoneType.CONCRETE_DARK), 0.6);
            BlockUtility.setWalkingSpeedBonus(block.getState(StoneVariantBlock.StoneType.CONCRETE_LIGHT), 0.6);
        }
    }

    public static void registerOreDict() {
        ItemStack itemStack;
        BlockMaterialBase block;
        Material material;
        OreDictUnifier.registerOre(new ItemStack((Block)RUBBER_LEAVES), "treeLeaves");
        OreDictUnifier.registerOre(new ItemStack((Block)RUBBER_SAPLING), "treeSapling");
        for (BlockLamp blockLamp : LAMPS.values()) {
            blockLamp.registerOreDict();
        }
        for (BlockLamp blockLamp : BORDERLESS_LAMPS.values()) {
            blockLamp.registerOreDict();
        }
        for (Map.Entry entry : COMPRESSED.entrySet()) {
            material = (Material)entry.getKey();
            block = (BlockCompressed)((Object)entry.getValue());
            itemStack = block.getItem(material);
            OreDictUnifier.registerOre(itemStack, OrePrefix.block, material);
        }
        for (Map.Entry entry : FRAMES.entrySet()) {
            material = (Material)entry.getKey();
            block = (BlockFrame)((Object)entry.getValue());
            itemStack = block.getItem(material);
            OreDictUnifier.registerOre(itemStack, OrePrefix.frameGt, material);
        }
        for (BlockOre blockOre : ORES) {
            material = blockOre.field_149764_J;
            for (StoneType stoneType : blockOre.STONE_TYPE.getAllowedValues()) {
                if (stoneType == null) continue;
                ItemStack normalStack = GTUtility.toItem(blockOre.func_176223_P().func_177226_a((IProperty)blockOre.STONE_TYPE, (Comparable)stoneType));
                OreDictUnifier.registerOre(normalStack, stoneType.processingPrefix, material);
            }
        }
        for (MaterialRegistry materialRegistry : GregTechAPI.materialManager.getRegistries()) {
            ItemStack itemStack2;
            for (BlockCable cable : CABLES.get(materialRegistry.getModid())) {
                for (Material pipeMaterial : cable.getEnabledMaterials()) {
                    itemStack2 = cable.getItem(pipeMaterial);
                    OreDictUnifier.registerOre(itemStack2, cable.getPrefix(), pipeMaterial);
                }
            }
            for (BlockMaterialPipe pipe : FLUID_PIPES.get(materialRegistry.getModid())) {
                for (Material pipeMaterial : ((BlockFluidPipe)pipe).getEnabledMaterials()) {
                    itemStack2 = pipe.getItem(pipeMaterial);
                    OreDictUnifier.registerOre(itemStack2, pipe.getPrefix(), pipeMaterial);
                }
            }
            for (BlockMaterialPipe pipe : ITEM_PIPES.get(materialRegistry.getModid())) {
                for (Material pipeMaterial : ((BlockItemPipe)pipe).getEnabledMaterials()) {
                    itemStack2 = pipe.getItem(pipeMaterial);
                    OreDictUnifier.registerOre(itemStack2, pipe.getPrefix(), pipeMaterial);
                }
            }
        }
    }

    public static String statePropertiesToString(Map<IProperty<?>, Comparable<?>> properties) {
        StringBuilder stringbuilder = new StringBuilder();
        List entries = properties.entrySet().stream().sorted(Comparator.comparing(c -> ((IProperty)c.getKey()).func_177701_a())).collect(Collectors.toList());
        for (Map.Entry entry : entries) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(",");
            }
            IProperty property = (IProperty)entry.getKey();
            stringbuilder.append(property.func_177701_a());
            stringbuilder.append("=");
            stringbuilder.append(MetaBlocks.getPropertyName(property, (Comparable)entry.getValue()));
        }
        if (stringbuilder.length() == 0) {
            stringbuilder.append("normal");
        }
        return stringbuilder.toString();
    }

    private static <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> value) {
        return property.func_177702_a(value);
    }

    static {
        CABLES = new Object2ObjectOpenHashMap();
        FLUID_PIPES = new Object2ObjectOpenHashMap();
        ITEM_PIPES = new Object2ObjectOpenHashMap();
        OPTICAL_PIPES = new BlockOpticalPipe[OpticalPipeType.values().length];
        LASER_PIPES = new BlockLaserPipe[OpticalPipeType.values().length];
        LAMPS = new EnumMap(EnumDyeColor.class);
        BORDERLESS_LAMPS = new EnumMap(EnumDyeColor.class);
        STONE_BLOCKS = new EnumMap(StoneVariantBlock.StoneVariant.class);
        COMPRESSED = new Object2ObjectOpenHashMap();
        FRAMES = new Object2ObjectOpenHashMap();
        SURFACE_ROCK = new Object2ObjectOpenHashMap();
        COMPRESSED_BLOCKS = new ArrayList<BlockCompressed>();
        FRAME_BLOCKS = new ArrayList<BlockFrame>();
        SURFACE_ROCK_BLOCKS = new ArrayList<BlockSurfaceRock>();
        ORES = new ArrayList<BlockOre>();
        FLUID_BLOCKS = new ArrayList<BlockFluidBase>();
    }
}

