/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import gregtech.api.GregTechAPI;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.StoneType;
import gregtech.api.unification.ore.StoneTypes;
import gregtech.api.util.GTUtility;
import gregtech.api.util.IBlockOre;
import gregtech.api.worldgen.config.OreConfigUtils;
import gregtech.client.model.OreBakedModel;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.common.blocks.properties.PropertyStoneType;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockOre
extends Block
implements IBlockOre {
    public final PropertyStoneType STONE_TYPE;
    public final gregtech.api.unification.material.Material field_149764_J;

    public BlockOre(gregtech.api.unification.material.Material material, StoneType[] allowedValues) {
        super(Material.field_151576_e);
        this.func_149663_c("ore_block");
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.field_149764_J = Objects.requireNonNull(material, "Material in BlockOre can not be null!");
        this.STONE_TYPE = PropertyStoneType.create("stone_type", allowedValues);
        this.initBlockState();
        this.func_149647_a(GregTechAPI.TAB_GREGTECH_ORES);
    }

    @NotNull
    public Material func_149688_o(@NotNull IBlockState state) {
        String harvestTool = this.getHarvestTool(state);
        if (harvestTool != null && harvestTool.equals("shovel")) {
            return Material.field_151578_c;
        }
        return Material.field_151576_e;
    }

    @NotNull
    protected final BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[0]);
    }

    protected void initBlockState() {
        BlockStateContainer stateContainer;
        this.field_176227_L = stateContainer = this.createStateContainer();
        this.func_180632_j(stateContainer.func_177621_b());
    }

    @NotNull
    public Item func_180660_a(@NotNull IBlockState state, @NotNull Random rand, int fortune) {
        StoneType stoneType = (StoneType)state.func_177229_b((IProperty)this.STONE_TYPE);
        if (stoneType.shouldBeDroppedAsItem || StoneType.STONE_TYPE_REGISTRY.func_148757_b(stoneType) < 16) {
            return super.func_180660_a(state, rand, fortune);
        }
        IBlockState stoneOre = OreConfigUtils.getOreForMaterial(this.field_149764_J).get(StoneTypes.STONE);
        return Item.func_150898_a((Block)stoneOre.func_177230_c());
    }

    public int func_180651_a(@NotNull IBlockState state) {
        StoneType stoneType = (StoneType)state.func_177229_b((IProperty)this.STONE_TYPE);
        if (stoneType.shouldBeDroppedAsItem) {
            return this.func_176201_c(state);
        }
        return 0;
    }

    @NotNull
    public SoundType getSoundType(IBlockState state, @NotNull World world, @NotNull BlockPos pos, @Nullable Entity entity) {
        StoneType stoneType = (StoneType)state.func_177229_b((IProperty)this.STONE_TYPE);
        return stoneType.soundType;
    }

    public String getHarvestTool(IBlockState state) {
        StoneType stoneType = (StoneType)state.func_177229_b((IProperty)this.STONE_TYPE);
        IBlockState stoneState = stoneType.stone.get();
        return stoneState.func_177230_c().getHarvestTool(stoneState);
    }

    public int getHarvestLevel(IBlockState state) {
        return Math.max(((StoneType)state.func_177229_b((IProperty)this.STONE_TYPE)).stoneMaterial.getBlockHarvestLevel(), this.field_149764_J.getBlockHarvestLevel());
    }

    @NotNull
    protected ItemStack func_180643_i(IBlockState state) {
        StoneType stoneType = (StoneType)state.func_177229_b((IProperty)this.STONE_TYPE);
        if (stoneType.shouldBeDroppedAsItem) {
            return super.func_180643_i(state);
        }
        return super.func_180643_i(this.func_176223_P());
    }

    @NotNull
    public IBlockState func_176203_a(int meta) {
        if (meta >= this.STONE_TYPE.getAllowedValues().size()) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a((IProperty)this.STONE_TYPE, (Comparable)((StoneType)this.STONE_TYPE.getAllowedValues().get(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return this.STONE_TYPE.getAllowedValues().indexOf((Object)state.func_177229_b((IProperty)this.STONE_TYPE));
    }

    @NotNull
    public ItemStack getPickBlock(@NotNull IBlockState state, @NotNull RayTraceResult target, @NotNull World world, @NotNull BlockPos pos, @NotNull EntityPlayer player) {
        return GTUtility.toItem(state);
    }

    public boolean isFireSource(@NotNull World world, @NotNull BlockPos pos, @NotNull EnumFacing side) {
        if (side != EnumFacing.UP) {
            return false;
        }
        StoneType stoneType = (StoneType)world.func_180495_p(pos).func_177229_b((IProperty)this.STONE_TYPE);
        return stoneType.stoneMaterial.hasFlag(MaterialFlags.FLAMMABLE);
    }

    public void func_149666_a(@NotNull CreativeTabs tab, @NotNull NonNullList<ItemStack> list) {
        if (tab == CreativeTabs.field_78027_g || tab == GregTechAPI.TAB_GREGTECH_ORES) {
            this.field_176227_L.func_177619_a().stream().filter(state -> ((StoneType)state.func_177229_b((IProperty)this.STONE_TYPE)).shouldBeDroppedAsItem).forEach(blockState -> list.add((Object)GTUtility.toItem(blockState)));
        }
    }

    public boolean canRenderInLayer(@NotNull IBlockState state, @NotNull BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT_MIPPED || this.field_149764_J.getProperty(PropertyKey.ORE).isEmissive() && layer == BloomEffectUtil.getEffectiveBloomLayer();
    }

    private BlockStateContainer createStateContainer() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.STONE_TYPE});
    }

    @Override
    public IBlockState getOreBlock(StoneType stoneType) {
        return this.func_176223_P().func_177226_a((IProperty)this.STONE_TYPE, (Comparable)stoneType);
    }

    @SideOnly(value=Side.CLIENT)
    public void onModelRegister() {
        ModelLoader.setCustomStateMapper((Block)this, b -> b.func_176194_O().func_177619_a().stream().collect(Collectors.toMap(s -> s, s -> OreBakedModel.registerOreEntry((StoneType)s.func_177229_b((IProperty)this.STONE_TYPE), this.field_149764_J))));
        for (IBlockState state : this.func_176194_O().func_177619_a()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)this.func_176201_c(state), (ModelResourceLocation)OreBakedModel.registerOreEntry((StoneType)state.func_177229_b((IProperty)this.STONE_TYPE), this.field_149764_J));
        }
    }
}

