/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.utils;

import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Matrix4;
import gregtech.api.gui.resources.TextureArea;
import java.awt.image.BufferedImage;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderUtil {
    private static final Deque<int[]> scissorFrameStack = new ArrayDeque<int[]>();
    private static final Map<TextureAtlasSprite, Integer> textureMap = new HashMap<TextureAtlasSprite, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void useScissor(int x, int y, int width, int height, Runnable codeBlock) {
        RenderUtil.pushScissorFrame(x, y, width, height);
        try {
            codeBlock.run();
        }
        finally {
            RenderUtil.popScissorFrame();
        }
    }

    private static int[] peekFirstScissorOrFullScreen() {
        int[] currentTopFrame;
        int[] nArray = currentTopFrame = scissorFrameStack.isEmpty() ? null : scissorFrameStack.peek();
        if (currentTopFrame == null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            return new int[]{0, 0, minecraft.field_71443_c, minecraft.field_71440_d};
        }
        return currentTopFrame;
    }

    public static void pushScissorFrame(int x, int y, int width, int height) {
        int[] parentScissor = RenderUtil.peekFirstScissorOrFullScreen();
        int parentX = parentScissor[0];
        int parentY = parentScissor[1];
        int parentWidth = parentScissor[2];
        int parentHeight = parentScissor[3];
        boolean pushedFrame = false;
        if (x <= parentX + parentWidth && y <= parentY + parentHeight) {
            int newX = Math.max(x, parentX);
            int newY = Math.max(y, parentY);
            int newWidth = width - (newX - x);
            int newHeight = height - (newY - y);
            if (newWidth > 0 && newHeight > 0) {
                int maxWidth = parentWidth - (x - parentX);
                int maxHeight = parentHeight - (y - parentY);
                newWidth = Math.min(maxWidth, newWidth);
                newHeight = Math.min(maxHeight, newHeight);
                RenderUtil.applyScissor(newX, newY, newWidth, newHeight);
                if (scissorFrameStack.isEmpty()) {
                    GL11.glEnable((int)3089);
                }
                scissorFrameStack.push(new int[]{newX, newY, newWidth, newHeight});
                pushedFrame = true;
            }
        }
        if (!pushedFrame) {
            if (scissorFrameStack.isEmpty()) {
                GL11.glEnable((int)3089);
            }
            scissorFrameStack.push(new int[]{parentX, parentY, parentWidth, parentHeight});
        }
    }

    public static void popScissorFrame() {
        scissorFrameStack.pop();
        int[] parentScissor = RenderUtil.peekFirstScissorOrFullScreen();
        int parentX = parentScissor[0];
        int parentY = parentScissor[1];
        int parentWidth = parentScissor[2];
        int parentHeight = parentScissor[3];
        RenderUtil.applyScissor(parentX, parentY, parentWidth, parentHeight);
        if (scissorFrameStack.isEmpty()) {
            GL11.glDisable((int)3089);
        }
    }

    private static void applyScissor(int x, int y, int w, int h) {
        ScaledResolution r = ((GuiIngameForge)Minecraft.func_71410_x().field_71456_v).getResolution();
        int s = r == null ? 1 : r.func_78325_e();
        int translatedY = r == null ? 0 : r.func_78328_b() - y - h;
        GL11.glScissor((int)(x * s), (int)(translatedY * s), (int)(w * s), (int)(h * s));
    }

    public static void useStencil(Runnable mask, Runnable renderInMask, boolean shouldRenderMask) {
        GL11.glStencilMask((int)255);
        GL11.glClearStencil((int)0);
        GL11.glClear((int)1024);
        GL11.glEnable((int)2960);
        GL11.glStencilFunc((int)519, (int)1, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7681);
        if (!shouldRenderMask) {
            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            GL11.glDepthMask((boolean)false);
        }
        mask.run();
        if (!shouldRenderMask) {
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GL11.glDepthMask((boolean)true);
        }
        GL11.glStencilMask((int)0);
        GL11.glStencilFunc((int)514, (int)1, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        renderInMask.run();
        GL11.glDisable((int)2960);
    }

    public static void useLightMap(float x, float y, Runnable codeBlock) {
        GL11.glPushAttrib((int)64);
        RenderHelper.func_74518_a();
        float lastBrightnessX = OpenGlHelper.lastBrightnessX;
        float lastBrightnessY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)x, (float)y);
        if (codeBlock != null) {
            codeBlock.run();
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
        RenderHelper.func_74519_b();
        GL11.glPopAttrib();
    }

    public static void moveToFace(double x, double y, double z, EnumFacing face) {
        GlStateManager.func_179137_b((double)(x + 0.5 + (double)face.func_82601_c() * 0.5), (double)(y + 0.5 + (double)face.func_96559_d() * 0.5), (double)(z + 0.5 + (double)face.func_82599_e() * 0.5));
    }

    public static void rotateToFace(EnumFacing face, @Nullable EnumFacing spin) {
        int angle = spin == EnumFacing.EAST ? 90 : (spin == EnumFacing.SOUTH ? 180 : (spin == EnumFacing.WEST ? -90 : 0));
        switch (face) {
            case UP: {
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case DOWN: {
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(spin == EnumFacing.EAST ? 90.0f : (spin == EnumFacing.NORTH ? 180.0f : (spin == EnumFacing.WEST ? -90.0f : 0.0f))), (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case NORTH: {
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
        }
    }

    public static void bindTextureAtlasSprite(TextureAtlasSprite textureAtlasSprite) {
        if (textureAtlasSprite == null) {
            return;
        }
        if (textureMap.containsKey(textureAtlasSprite)) {
            GlStateManager.func_179144_i((int)textureMap.get(textureAtlasSprite));
            return;
        }
        int iconWidth = textureAtlasSprite.func_94211_a();
        int iconHeight = textureAtlasSprite.func_94216_b();
        int frameCount = textureAtlasSprite.func_110970_k();
        if (iconWidth <= 0 || iconHeight <= 0 || frameCount <= 0) {
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(iconWidth, iconHeight * frameCount, 6);
        for (int i = 0; i < frameCount; ++i) {
            int[][] frameTextureData = textureAtlasSprite.func_147965_a(i);
            int[] largestMipMapTextureData = frameTextureData[0];
            bufferedImage.setRGB(0, i * iconHeight, iconWidth, iconHeight, largestMipMapTextureData, 0, iconWidth);
        }
        int glTextureId = TextureUtil.func_110996_a();
        if (glTextureId != -1) {
            TextureUtil.func_110989_a((int)glTextureId, (BufferedImage)bufferedImage, (boolean)false, (boolean)false);
            textureMap.put(textureAtlasSprite, glTextureId);
            GlStateManager.func_179144_i((int)textureMap.get(textureAtlasSprite));
        }
    }

    public static Matrix4 adjustTrans(Matrix4 translation, EnumFacing side, int layer) {
        Matrix4 trans = translation.copy();
        switch (side) {
            case DOWN: {
                trans.translate(0.0, -5.0E-4 * (double)layer, 0.0);
                break;
            }
            case UP: {
                trans.translate(0.0, 5.0E-4 * (double)layer, 0.0);
                break;
            }
            case NORTH: {
                trans.translate(0.0, 0.0, -5.0E-4 * (double)layer);
                break;
            }
            case SOUTH: {
                trans.translate(0.0, 0.0, 5.0E-4 * (double)layer);
                break;
            }
            case EAST: {
                trans.translate(5.0E-4 * (double)layer, 0.0, 0.0);
                break;
            }
            case WEST: {
                trans.translate(-5.0E-4 * (double)layer, 0.0, 0.0);
            }
        }
        return trans;
    }

    public static int interpolateColor(int color1, int color2, float blend) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 * (1.0f - blend) + (float)a2 * blend);
        int r = (int)((float)r1 * (1.0f - blend) + (float)r2 * blend);
        int g = (int)((float)g1 * (1.0f - blend) + (float)g2 * blend);
        int b = (int)((float)b1 * (1.0f - blend) + (float)b2 * blend);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static void renderRect(float x, float y, float width, float height, float z, int color) {
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b((double)(x + width), (double)y, (double)z).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, (double)z).func_181675_d();
        buffer.func_181662_b((double)x, (double)(y + height), (double)z).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderGradientRect(float x, float y, float width, float height, float z, int startColor, int endColor, boolean horizontal) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        if (horizontal) {
            buffer.func_181662_b((double)(x + width), (double)y, (double)z).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, (double)z).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
            buffer.func_181662_b((double)x, (double)(y + height), (double)z).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        } else {
            buffer.func_181662_b((double)(x + width), (double)y, (double)z).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, (double)z).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
            buffer.func_181662_b((double)x, (double)(y + height), (double)z).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        }
        buffer.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void renderText(float x, float y, float z, float scale, int color, String renderedText, boolean centered) {
        GlStateManager.func_179094_E();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int width = fr.func_78256_a(renderedText);
        GlStateManager.func_179109_b((float)x, (float)(y - scale * 4.0f), (float)z);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179109_b((float)(-0.5f * (float)(centered ? 1 : 0) * (float)width), (float)0.0f, (float)0.5f);
        fr.func_78276_b(renderedText, 0, 0, color);
        GlStateManager.func_179121_F();
    }

    public static void renderItemOverLay(float x, float y, float z, float scale, ItemStack itemStack) {
        RenderHelper.func_74519_b();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0E-4f);
        GlStateManager.func_179109_b((float)(x * 16.0f), (float)(y * 16.0f), (float)(z * 16.0f));
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        renderItem.func_180450_b(itemStack, 0, 0);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
    }

    public static void renderFluidOverLay(float x, float y, float width, float height, float z, FluidStack fluidStack, float alpha) {
        if (fluidStack != null) {
            int color = fluidStack.getFluid().getColor(fluidStack);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            TextureAtlasSprite sprite = TextureUtils.getTexture((ResourceLocation)fluidStack.getFluid().getStill(fluidStack));
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179118_c();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder buf = tess.func_178180_c();
            buf.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            double uMin = sprite.func_94214_a(16.0 - (double)width * 16.0);
            double uMax = sprite.func_94214_a((double)width * 16.0);
            double vMin = sprite.func_94206_g();
            double vMax = sprite.func_94207_b((double)height * 16.0);
            buf.func_181662_b((double)x, (double)y, (double)z).func_187315_a(uMin, vMin).func_181666_a(r, g, b, alpha).func_181675_d();
            buf.func_181662_b((double)x, (double)(y + height), (double)z).func_187315_a(uMin, vMax).func_181666_a(r, g, b, alpha).func_181675_d();
            buf.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a(uMax, vMax).func_181666_a(r, g, b, alpha).func_181675_d();
            buf.func_181662_b((double)(x + width), (double)y, (double)z).func_187315_a(uMax, vMin).func_181666_a(r, g, b, alpha).func_181675_d();
            tess.func_78381_a();
            GlStateManager.func_179141_d();
            GlStateManager.func_179084_k();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void renderTextureArea(TextureArea textureArea, float x, float y, float width, float height, float z) {
        double imageU = textureArea.offsetX;
        double imageV = textureArea.offsetY;
        double imageWidth = textureArea.imageWidth;
        double imageHeight = textureArea.imageHeight;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(textureArea.imageLocation);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), (double)z).func_187315_a(imageU, imageV + imageHeight).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a(imageU + imageWidth, imageV + imageHeight).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, (double)z).func_187315_a(imageU + imageWidth, imageV).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, (double)z).func_187315_a(imageU, imageV).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderLineChart(List<Long> data, long max, float x, float y, float width, float height, float lineWidth, int color) {
        float durX = data.size() > 1 ? width / (float)(data.size() - 1) : 0.0f;
        float hY = max > 0L ? height / (float)max : 0.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)773);
        GlStateManager.func_179131_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        float last_x = x + 0.0f * durX;
        float last_y = y - (float)data.get(0).longValue() * hY;
        for (int i = 0; i < data.size(); ++i) {
            float _x = x + (float)i * durX;
            float _y = y - (float)data.get(i).longValue() * hY;
            if (i != 0) {
                bufferbuilder.func_181662_b((double)last_x, (double)(last_y - lineWidth), 0.01).func_181675_d();
                bufferbuilder.func_181662_b((double)last_x, (double)(last_y + lineWidth), 0.01).func_181675_d();
                bufferbuilder.func_181662_b((double)_x, (double)(_y + lineWidth), 0.01).func_181675_d();
                bufferbuilder.func_181662_b((double)_x, (double)(_y - lineWidth), 0.01).func_181675_d();
                last_x = _x;
                last_y = _y;
            }
            bufferbuilder.func_181662_b((double)(_x - 3.0f * lineWidth), (double)_y, 0.01).func_181675_d();
            bufferbuilder.func_181662_b((double)_x, (double)(_y + 3.0f * lineWidth), 0.01).func_181675_d();
            bufferbuilder.func_181662_b((double)(_x + 3.0f * lineWidth), (double)_y, 0.01).func_181675_d();
            bufferbuilder.func_181662_b((double)_x, (double)(_y - 3.0f * lineWidth), 0.01).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
    }

    public static void renderLine(float x1, float y1, float x2, float y2, float lineWidth, int color) {
        float hypo = (float)Math.sqrt((y1 - y2) * (y1 - y2) + (x1 - x2) * (x1 - x2));
        float w = (x2 - x1) / hypo * lineWidth;
        float h = (y1 - y2) / hypo * lineWidth;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)773);
        GlStateManager.func_179131_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        if (w * h > 0.0f) {
            bufferbuilder.func_181662_b((double)(x1 - w), (double)(y1 - h), 0.01).func_181675_d();
            bufferbuilder.func_181662_b((double)(x1 + w), (double)(y1 + h), 0.01).func_181675_d();
            bufferbuilder.func_181662_b((double)(x2 + w), (double)(y2 + h), 0.01).func_181675_d();
            bufferbuilder.func_181662_b((double)(x2 - w), (double)(y2 - h), 0.01).func_181675_d();
        } else {
            h = (y2 - y1) / hypo * lineWidth;
            bufferbuilder.func_181662_b((double)(x1 + w), (double)(y1 - h), 0.01).func_181675_d();
            bufferbuilder.func_181662_b((double)(x1 - w), (double)(y1 + h), 0.01).func_181675_d();
            bufferbuilder.func_181662_b((double)(x2 - w), (double)(y2 + h), 0.01).func_181675_d();
            bufferbuilder.func_181662_b((double)(x2 + w), (double)(y2 - h), 0.01).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawFluidTexture(double xCoord, double yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, double zLevel) {
        double uMin = textureSprite.func_94209_e();
        double uMax = textureSprite.func_94212_f();
        double vMin = textureSprite.func_94206_g();
        double vMax = textureSprite.func_94210_h();
        uMax -= (double)maskRight / 16.0 * (uMax - uMin);
        vMax -= (double)maskTop / 16.0 * (vMax - vMin);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(xCoord, yCoord + 16.0, zLevel).func_187315_a(uMin, vMax).func_181675_d();
        buffer.func_181662_b(xCoord + 16.0 - (double)maskRight, yCoord + 16.0, zLevel).func_187315_a(uMax, vMax).func_181675_d();
        buffer.func_181662_b(xCoord + 16.0 - (double)maskRight, yCoord + (double)maskTop, zLevel).func_187315_a(uMax, vMin).func_181675_d();
        buffer.func_181662_b(xCoord, yCoord + (double)maskTop, zLevel).func_187315_a(uMin, vMin).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawFluidForGui(FluidStack contents, int tankCapacity, int startX, int startY, int widthT, int heightT) {
        --widthT;
        Fluid fluid = contents.getFluid();
        ResourceLocation fluidStill = fluid.getStill(contents);
        TextureAtlasSprite fluidStillSprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluidStill.toString());
        int fluidColor = fluid.getColor(contents);
        int scaledAmount = contents.amount == tankCapacity ? heightT : contents.amount * --heightT / tankCapacity;
        if (contents.amount > 0 && scaledAmount < 1) {
            scaledAmount = 1;
        }
        if (scaledAmount > heightT) {
            scaledAmount = heightT;
        }
        GlStateManager.func_179147_l();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderUtil.setGlColorFromInt(fluidColor, 255);
        int xTileCount = widthT / 16;
        int xRemainder = widthT - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        int yStart = startY + heightT;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int width = xTile == xTileCount ? xRemainder : 16;
                int height = yTile == yTileCount ? yRemainder : 16;
                int x = startX + xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (width <= 0 || height <= 0) continue;
                int maskTop = 16 - height;
                int maskRight = 16 - width;
                RenderUtil.drawFluidTexture(x, y, fluidStillSprite, maskTop, maskRight, 0.0);
            }
        }
        GlStateManager.func_179084_k();
    }

    public static int packColor(int red, int green, int blue, int alpha) {
        return (red & 0xFF) << 24 | (green & 0xFF) << 16 | (blue & 0xFF) << 8 | alpha & 0xFF;
    }

    public static void setGlColorFromInt(int colorValue, int opacity) {
        int i = (colorValue & 0xFF0000) >> 16;
        int j = (colorValue & 0xFF00) >> 8;
        int k = colorValue & 0xFF;
        GlStateManager.func_179131_c((float)((float)i / 255.0f), (float)((float)j / 255.0f), (float)((float)k / 255.0f), (float)((float)opacity / 255.0f));
    }

    public static void setGlClearColorFromInt(int colorValue, int opacity) {
        int i = (colorValue & 0xFF0000) >> 16;
        int j = (colorValue & 0xFF00) >> 8;
        int k = colorValue & 0xFF;
        GlStateManager.func_179082_a((float)((float)i / 255.0f), (float)((float)j / 255.0f), (float)((float)k / 255.0f), (float)((float)opacity / 255.0f));
    }

    public static int getFluidColor(FluidStack fluidStack) {
        if (fluidStack.getFluid() == FluidRegistry.WATER) {
            return 3183823;
        }
        if (fluidStack.getFluid() == FluidRegistry.LAVA) {
            return 16766720;
        }
        return fluidStack.getFluid().getColor(fluidStack);
    }

    public static boolean updateFBOSize(Framebuffer fbo, int width, int height) {
        if (fbo.field_147621_c != width || fbo.field_147618_d != height) {
            fbo.func_147613_a(width, height);
            return true;
        }
        return false;
    }

    public static void hookDepthBuffer(Framebuffer fbo, int depthBuffer) {
        OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)fbo.field_147616_f);
        if (fbo.isStencilEnabled()) {
            OpenGlHelper.func_153190_b((int)OpenGlHelper.field_153198_e, (int)36096, (int)OpenGlHelper.field_153199_f, (int)depthBuffer);
            OpenGlHelper.func_153190_b((int)OpenGlHelper.field_153198_e, (int)36128, (int)OpenGlHelper.field_153199_f, (int)depthBuffer);
        } else {
            OpenGlHelper.func_153190_b((int)OpenGlHelper.field_153198_e, (int)OpenGlHelper.field_153201_h, (int)OpenGlHelper.field_153199_f, (int)depthBuffer);
        }
    }

    public static void hookDepthTexture(Framebuffer fbo, int depthTexture) {
        OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)fbo.field_147616_f);
        if (fbo.isStencilEnabled()) {
            OpenGlHelper.func_153188_a((int)OpenGlHelper.field_153198_e, (int)33306, (int)3553, (int)depthTexture, (int)0);
        } else {
            OpenGlHelper.func_153188_a((int)OpenGlHelper.field_153198_e, (int)OpenGlHelper.field_153201_h, (int)3553, (int)depthTexture, (int)0);
        }
    }

    public static BakedQuad makeEmissive(BakedQuad quad) {
        if (FMLClientHandler.instance().hasOptifine()) {
            return quad;
        }
        VertexFormat format = quad.getFormat();
        if (!format.func_177343_g().contains(DefaultVertexFormats.field_181716_p)) {
            format = new VertexFormat(quad.getFormat());
            format.func_181721_a(DefaultVertexFormats.field_181716_p);
        }
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format){

            public void put(int element, float ... data) {
                if (this.getVertexFormat().func_177348_c(element) == DefaultVertexFormats.field_181716_p) {
                    super.put(element, new float[]{0.0073243305f, 0.0073243305f});
                } else {
                    super.put(element, data);
                }
            }
        };
        quad.pipe((IVertexConsumer)builder);
        builder.setApplyDiffuseLighting(false);
        return builder.build();
    }
}

