/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.utils;

import java.util.Objects;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EffectRenderContext {
    private static final EffectRenderContext instance = new EffectRenderContext();
    @Nullable
    private Entity renderViewEntity;
    private float partialTicks;
    private double cameraX;
    private double cameraY;
    private double cameraZ;
    @NotNull
    private Vec3d cameraViewDir = Vec3d.field_186680_a;
    private float rotationX;
    private float rotationZ;
    private float rotationYZ;
    private float rotationXY;
    private float rotationXZ;

    public static EffectRenderContext getInstance() {
        return instance;
    }

    @NotNull
    public EffectRenderContext update(@NotNull Entity renderViewEntity, float partialTicks) {
        this.renderViewEntity = renderViewEntity;
        this.partialTicks = partialTicks;
        this.cameraX = renderViewEntity.field_70142_S + (renderViewEntity.field_70165_t - renderViewEntity.field_70142_S) * (double)partialTicks;
        this.cameraY = renderViewEntity.field_70137_T + (renderViewEntity.field_70163_u - renderViewEntity.field_70137_T) * (double)partialTicks;
        this.cameraZ = renderViewEntity.field_70136_U + (renderViewEntity.field_70161_v - renderViewEntity.field_70136_U) * (double)partialTicks;
        this.cameraViewDir = renderViewEntity.func_70676_i(partialTicks);
        this.rotationX = ActiveRenderInfo.func_178808_b();
        this.rotationZ = ActiveRenderInfo.func_178803_d();
        this.rotationYZ = ActiveRenderInfo.func_178805_e();
        this.rotationXY = ActiveRenderInfo.func_178807_f();
        this.rotationXZ = ActiveRenderInfo.func_178809_c();
        return this;
    }

    @NotNull
    public Entity renderViewEntity() {
        return Objects.requireNonNull(this.renderViewEntity, "renderViewEntity not available yet");
    }

    public float partialTicks() {
        return this.partialTicks;
    }

    public double cameraX() {
        return this.cameraX;
    }

    public double cameraY() {
        return this.cameraY;
    }

    public double cameraZ() {
        return this.cameraZ;
    }

    @NotNull
    public Vec3d cameraViewDir() {
        return this.cameraViewDir;
    }

    public float rotationX() {
        return this.rotationX;
    }

    public float rotationZ() {
        return this.rotationZ;
    }

    public float rotationYZ() {
        return this.rotationYZ;
    }

    public float rotationXY() {
        return this.rotationXY;
    }

    public float rotationXZ() {
        return this.rotationXZ;
    }
}

