/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.texture.custom;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.gui.resources.TextTexture;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleSidedCubeRenderer;
import gregtech.client.utils.RenderUtil;
import gregtech.common.metatileentities.storage.MetaTileEntityQuantumChest;
import java.util.EnumMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class QuantumStorageRenderer
implements TextureUtils.IIconRegister {
    private static final Cuboid6 glassBox = new Cuboid6(0.0625, 0.0625, 0.0625, 0.9375, 0.9375, 0.9375);
    private static final EnumMap<EnumFacing, Cuboid6> boxFacingMap = new EnumMap(EnumFacing.class);
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite glassTexture;

    public QuantumStorageRenderer() {
        Textures.iconRegisters.add(this);
    }

    public void registerIcons(TextureMap textureMap) {
        this.glassTexture = textureMap.func_174942_a(new ResourceLocation("gregtech:blocks/overlay/machine/overlay_screen_glass"));
    }

    public void renderMachine(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, EnumFacing frontFacing, int tier) {
        Textures.renderFace(renderState, translation, pipeline, frontFacing, glassBox, this.glassTexture, BlockRenderLayer.CUTOUT_MIPPED);
        TextureAtlasSprite hullTexture = Textures.VOLTAGE_CASINGS[tier].getSpriteOnSide(SimpleSidedCubeRenderer.RenderSide.bySide(EnumFacing.NORTH));
        boxFacingMap.keySet().forEach(facing -> {
            for (EnumFacing box : EnumFacing.field_82609_l) {
                if (facing == frontFacing && box == frontFacing || facing == EnumFacing.DOWN && !box.func_176740_k().func_176720_b()) continue;
                Textures.renderFace(renderState, translation, pipeline, facing, boxFacingMap.get(box), hullTexture, BlockRenderLayer.CUTOUT_MIPPED);
            }
        });
    }

    public static void renderChestStack(double x, double y, double z, MetaTileEntityQuantumChest machine, ItemStack stack, long count, float partialTicks) {
        if (stack.func_190926_b() || count == 0L) {
            return;
        }
        float lastBrightnessX = OpenGlHelper.lastBrightnessX;
        float lastBrightnessY = OpenGlHelper.lastBrightnessY;
        World world = machine.getWorld();
        QuantumStorageRenderer.setLightingCorrectly((IBlockAccess)world, machine.getPos());
        EnumFacing frontFacing = machine.getFrontFacing();
        RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();
        float tick = (float)world.func_72820_D() + partialTicks;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.func_179114_b((float)(tick * (float)Math.PI * 2.0f / 40.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.6f, (float)0.6f, (float)0.6f);
        itemRenderer.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.func_179121_F();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        QuantumStorageRenderer.renderAmountText(x, y, z, count, frontFacing);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
    }

    public static void renderTankFluid(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, FluidTank tank, IBlockAccess world, BlockPos pos, EnumFacing frontFacing) {
        FluidStack stack;
        float lastBrightnessX = OpenGlHelper.lastBrightnessX;
        float lastBrightnessY = OpenGlHelper.lastBrightnessY;
        if (world != null) {
            renderState.setBrightness(world, pos);
        }
        if ((stack = tank.getFluid()) == null || stack.amount == 0) {
            return;
        }
        Cuboid6 partialFluidBox = new Cuboid6(0.06640625, 0.12890625, 0.06640625, 0.93359375, 0.93359375, 0.93359375);
        double fillFraction = (double)stack.amount / (double)tank.getCapacity();
        if (tank.getFluid().getFluid().isGaseous()) {
            partialFluidBox.min.y = Math.max(13.9375 - 11.875 * fillFraction, 2.0) / 16.0;
        } else {
            partialFluidBox.max.y = Math.min(11.875 * fillFraction + 2.0625, 14.0) / 16.0;
        }
        renderState.setFluidColour(stack);
        ResourceLocation fluidStill = stack.getFluid().getStill(stack);
        TextureAtlasSprite fluidStillSprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluidStill.toString());
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            Textures.renderFace(renderState, translation, pipeline, facing, partialFluidBox, fluidStillSprite, BlockRenderLayer.CUTOUT_MIPPED);
        }
        GlStateManager.func_179117_G();
        renderState.reset();
    }

    public static void renderTankAmount(double x, double y, double z, EnumFacing frontFacing, long amount) {
        float lastBrightnessX = OpenGlHelper.lastBrightnessX;
        float lastBrightnessY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        QuantumStorageRenderer.renderAmountText(x, y, z, amount, frontFacing);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
    }

    public static void renderAmountText(double x, double y, double z, long amount, EnumFacing frontFacing) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179109_b((float)((float)(frontFacing.func_82601_c() * -1) / 16.0f), (float)((float)(frontFacing.func_96559_d() * -1) / 16.0f), (float)((float)(frontFacing.func_82599_e() * -1) / 16.0f));
        RenderUtil.moveToFace(0.0, 0.0, 0.0, frontFacing);
        if (frontFacing.func_176740_k() == EnumFacing.Axis.Y) {
            RenderUtil.rotateToFace(frontFacing, EnumFacing.SOUTH);
        } else {
            RenderUtil.rotateToFace(frontFacing, null);
        }
        String amountText = TextFormattingUtil.formatLongToCompactString(amount, 4);
        GlStateManager.func_179152_a((float)0.015625f, (float)0.015625f, (float)0.0f);
        GlStateManager.func_179109_b((float)-32.0f, (float)-32.0f, (float)0.0f);
        GlStateManager.func_179140_f();
        new TextTexture(amountText, 0xFFFFFF).draw(0.0, 24.0, 64, 28);
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    public static void setLightingCorrectly(IBlockAccess world, BlockPos pos) {
        int actualLight = world.func_175626_b(pos, 0);
        float lightmapXCoord = actualLight & 0xFFFF;
        float lightmapYCoord = actualLight >> 16;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightmapXCoord, (float)lightmapYCoord);
    }

    static {
        boxFacingMap.put(EnumFacing.UP, new Cuboid6(0.0, 0.875, 0.0, 1.0, 1.0, 1.0));
        boxFacingMap.put(EnumFacing.DOWN, new Cuboid6(0.0, 0.0, 0.0, 1.0, 0.125, 1.0));
        boxFacingMap.put(EnumFacing.WEST, new Cuboid6(0.0, 0.0, 0.0, 0.125, 1.0, 1.0));
        boxFacingMap.put(EnumFacing.EAST, new Cuboid6(0.875, 0.0, 0.0, 1.0, 1.0, 1.0));
        boxFacingMap.put(EnumFacing.SOUTH, new Cuboid6(0.0, 0.0, 0.875, 1.0, 1.0, 1.0));
        boxFacingMap.put(EnumFacing.NORTH, new Cuboid6(0.0, 0.0, 0.0, 1.0, 1.0, 0.125));
    }
}

