/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.texture.custom;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.cclop.ColourOperation;
import gregtech.client.renderer.cclop.LightMapOperation;
import gregtech.client.renderer.texture.Textures;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public class LargeTurbineRenderer
implements TextureUtils.IIconRegister {
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite baseRingSprite;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite baseBackgroundSprite;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite idleBladeSprite;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite activeBladeSprite;

    public LargeTurbineRenderer() {
        Textures.iconRegisters.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(TextureMap textureMap) {
        this.baseRingSprite = textureMap.func_174942_a(GTUtility.gregtechId("blocks/multiblock/large_turbine/base_ring"));
        this.baseBackgroundSprite = textureMap.func_174942_a(GTUtility.gregtechId("blocks/multiblock/large_turbine/base_bg"));
        this.idleBladeSprite = textureMap.func_174942_a(GTUtility.gregtechId("blocks/multiblock/large_turbine/rotor_idle"));
        this.activeBladeSprite = textureMap.func_174942_a(GTUtility.gregtechId("blocks/multiblock/large_turbine/rotor_spinning"));
    }

    @SideOnly(value=Side.CLIENT)
    public void renderSided(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, EnumFacing side, boolean hasBase, boolean hasRotor, boolean isActive, int rotorRGB) {
        Matrix4 cornerOffset = null;
        switch (side.func_176740_k()) {
            case X: {
                cornerOffset = translation.copy().translate(0.01 * (double)side.func_82601_c(), -1.0, -1.0);
                cornerOffset.scale(1.0, 3.0, 3.0);
                break;
            }
            case Z: {
                cornerOffset = translation.copy().translate(-1.0, -1.0, 0.01 * (double)side.func_82599_e());
                cornerOffset.scale(3.0, 3.0, 1.0);
                break;
            }
            case Y: {
                cornerOffset = translation.copy().translate(-1.0, 0.01 * (double)side.func_96559_d(), -1.0);
                cornerOffset.scale(3.0, 1.0, 3.0);
            }
        }
        if (hasBase) {
            Textures.renderFace(renderState, cornerOffset, (IVertexOperation[])ArrayUtils.addAll((Object[])pipeline, (Object[])new IVertexOperation[]{new LightMapOperation(240, 240)}), side, Cuboid6.full, this.baseRingSprite, BlockRenderLayer.CUTOUT_MIPPED);
            Textures.renderFace(renderState, cornerOffset, (IVertexOperation[])ArrayUtils.addAll((Object[])pipeline, (Object[])new IVertexOperation[]{new LightMapOperation(240, 240), new ColourOperation(-1)}), side, Cuboid6.full, this.baseBackgroundSprite, BlockRenderLayer.CUTOUT_MIPPED);
        }
        if (hasRotor) {
            TextureAtlasSprite sprite = isActive ? this.activeBladeSprite : this.idleBladeSprite;
            IVertexOperation[] color = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(rotorRGB)));
            Textures.renderFace(renderState, cornerOffset, color, side, Cuboid6.full, sprite, BlockRenderLayer.CUTOUT_MIPPED);
        }
    }
}

