/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.pipe;

import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.uv.IconTransformation;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.IPipeType;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.recipes.ModHandler;
import gregtech.api.unification.material.Material;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.pipe.PipeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.pipelike.fluidpipe.FluidPipeType;
import java.util.EnumMap;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import org.jetbrains.annotations.Nullable;

public class FluidPipeRenderer
extends PipeRenderer {
    public static final FluidPipeRenderer INSTANCE = new FluidPipeRenderer();
    private final EnumMap<FluidPipeType, TextureAtlasSprite> pipeTextures = new EnumMap(FluidPipeType.class);
    private final EnumMap<FluidPipeType, TextureAtlasSprite> pipeTexturesWood = new EnumMap(FluidPipeType.class);

    private FluidPipeRenderer() {
        super("gt_fluid_pipe", GTUtility.gregtechId("fluid_pipe"));
    }

    @Override
    public void registerIcons(TextureMap map) {
        this.pipeTextures.put(FluidPipeType.TINY, Textures.PIPE_TINY);
        this.pipeTextures.put(FluidPipeType.SMALL, Textures.PIPE_SMALL);
        this.pipeTextures.put(FluidPipeType.NORMAL, Textures.PIPE_NORMAL);
        this.pipeTextures.put(FluidPipeType.LARGE, Textures.PIPE_LARGE);
        this.pipeTextures.put(FluidPipeType.HUGE, Textures.PIPE_HUGE);
        this.pipeTextures.put(FluidPipeType.QUADRUPLE, Textures.PIPE_QUADRUPLE);
        this.pipeTextures.put(FluidPipeType.NONUPLE, Textures.PIPE_NONUPLE);
        this.pipeTexturesWood.put(FluidPipeType.SMALL, Textures.PIPE_SMALL_WOOD);
        this.pipeTexturesWood.put(FluidPipeType.NORMAL, Textures.PIPE_NORMAL_WOOD);
        this.pipeTexturesWood.put(FluidPipeType.LARGE, Textures.PIPE_LARGE_WOOD);
    }

    @Override
    public void buildRenderer(PipeRenderer.PipeRenderContext renderContext, BlockPipe<?, ?, ?> blockPipe, IPipeTile<?, ?> pipeTile, IPipeType<?> pipeType, @Nullable Material material) {
        if (material == null || !(pipeType instanceof FluidPipeType)) {
            return;
        }
        if (ModHandler.isMaterialWood(material)) {
            TextureAtlasSprite sprite = this.pipeTexturesWood.get(pipeType);
            if (sprite != null) {
                renderContext.addOpenFaceRender(new IVertexOperation[]{new IconTransformation(sprite)});
            } else {
                renderContext.addOpenFaceRender(new IVertexOperation[]{new IconTransformation(this.pipeTextures.get(pipeType))});
            }
            renderContext.addSideRender(new IVertexOperation[]{new IconTransformation(Textures.PIPE_SIDE_WOOD)});
        } else {
            renderContext.addOpenFaceRender(new IVertexOperation[]{new IconTransformation(this.pipeTextures.get(pipeType))}).addSideRender(new IVertexOperation[]{new IconTransformation(Textures.PIPE_SIDE)});
        }
    }

    @Override
    public TextureAtlasSprite getParticleTexture(IPipeType<?> pipeType, @Nullable Material material) {
        return Textures.PIPE_SIDE;
    }
}

