/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.handler;

import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.ICCBlockRenderer;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import gregtech.api.metatileentity.IFastRenderMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.CubeRendererState;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.ItemRenderCompat;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class MetaTileEntityRenderer
implements ICCBlockRenderer,
IItemRenderer {
    public static final ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation(GTUtility.gregtechId("machine"), "normal");
    public static final MetaTileEntityRenderer INSTANCE = new MetaTileEntityRenderer();
    public static EnumBlockRenderType BLOCK_RENDER_TYPE;

    public static void preInit() {
        BLOCK_RENDER_TYPE = BlockRenderingRegistry.createRenderType((String)"meta_tile_entity");
        BlockRenderingRegistry.registerRenderer((EnumBlockRenderType)BLOCK_RENDER_TYPE, (ICCBlockRenderer)INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        TextureUtils.addIconRegister(Textures::register);
    }

    @SubscribeEvent
    public void onModelsBake(ModelBakeEvent event) {
        GTLog.logger.info("Injected MetaTileEntity render model");
        event.getModelRegistry().func_82595_a((Object)MODEL_LOCATION, (Object)this);
    }

    public void renderItem(ItemStack rawStack, ItemCameraTransforms.TransformType transformType) {
        ItemStack stack = ItemRenderCompat.getRepresentedStack(rawStack);
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity(stack);
        if (metaTileEntity == null) {
            return;
        }
        GlStateManager.func_179147_l();
        CCRenderState renderState = CCRenderState.instance();
        renderState.reset();
        renderState.startDrawing(7, DefaultVertexFormats.field_176599_b);
        metaTileEntity.setRenderContextStack(stack);
        metaTileEntity.renderMetaTileEntity(renderState, new Matrix4(), new IVertexOperation[0]);
        if (metaTileEntity instanceof IFastRenderMetaTileEntity) {
            ((IFastRenderMetaTileEntity)((Object)metaTileEntity)).renderMetaTileEntityFast(renderState, new Matrix4(), 0.0f);
        }
        metaTileEntity.setRenderContextStack(null);
        renderState.draw();
        GlStateManager.func_179084_k();
    }

    public boolean renderBlock(IBlockAccess world, BlockPos pos, IBlockState state, BufferBuilder buffer) {
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity(world, pos);
        if (metaTileEntity == null) {
            return false;
        }
        CCRenderState renderState = CCRenderState.instance();
        renderState.reset();
        renderState.bind(buffer);
        Matrix4 translation = new Matrix4().translate((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        BlockRenderLayer renderLayer = MinecraftForgeClient.getRenderLayer();
        boolean[] sideMask = new boolean[EnumFacing.field_82609_l.length];
        for (EnumFacing side : EnumFacing.field_82609_l) {
            sideMask[side.func_176745_a()] = state.func_185894_c(world, pos, side);
        }
        Textures.RENDER_STATE.set(new CubeRendererState(renderLayer, sideMask, world));
        if (metaTileEntity.canRenderInLayer(renderLayer)) {
            renderState.lightMatrix.locate(world, pos);
            IVertexOperation[] pipeline = new IVertexOperation[]{renderState.lightMatrix};
            metaTileEntity.renderMetaTileEntity(renderState, translation.copy(), pipeline);
        }
        metaTileEntity.renderCovers(renderState, translation.copy(), renderLayer);
        Textures.RENDER_STATE.remove();
        return true;
    }

    public IModelState getTransforms() {
        return TransformUtils.DEFAULT_BLOCK;
    }

    public boolean func_188618_c() {
        return true;
    }

    public void renderBrightness(IBlockState state, float brightness) {
    }

    public void handleRenderBlockDamage(IBlockAccess world, BlockPos pos, IBlockState state, TextureAtlasSprite sprite, BufferBuilder buffer) {
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity(world, pos);
        ArrayList<IndexedCuboid6> boundingBox = new ArrayList<IndexedCuboid6>();
        if (metaTileEntity != null) {
            metaTileEntity.addCollisionBoundingBox(boundingBox);
            metaTileEntity.addCoverCollisionBoundingBox(boundingBox);
        }
        CCRenderState renderState = CCRenderState.instance();
        renderState.reset();
        renderState.bind(buffer);
        renderState.setPipeline(new IVertexOperation[]{new Vector3(new Vec3d((Vec3i)pos)).translation(), new IconTransformation(sprite)});
        for (Cuboid6 cuboid6 : boundingBox) {
            BlockRenderer.renderCuboid((CCRenderState)renderState, (Cuboid6)cuboid6, (int)0);
        }
    }

    public static Pair<TextureAtlasSprite, Integer> getParticleTexture(IBlockAccess world, BlockPos pos) {
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity(world, pos);
        if (metaTileEntity == null) {
            return Pair.of((Object)TextureUtils.getMissingSprite(), (Object)0xFFFFFF);
        }
        return metaTileEntity.getParticleTexture();
    }

    public TextureAtlasSprite func_177554_e() {
        return TextureUtils.getMissingSprite();
    }

    public void registerTextures(TextureMap map) {
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }
}

