/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.particle;

import gregtech.api.GTValues;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.client.particle.IMachineParticleEffect;
import java.util.function.Consumer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public enum VanillaParticleEffects implements IMachineParticleEffect
{
    TOP_SMOKE_SMALL(mte -> {
        if (mte.getWorld() == null || mte.getPos() == null) {
            return;
        }
        if (mte.getFrontFacing() == EnumFacing.UP || mte.hasCover(EnumFacing.UP)) {
            return;
        }
        BlockPos pos = mte.getPos();
        float x = (float)pos.func_177958_n() + 0.8f - GTValues.RNG.nextFloat() * 0.6f;
        float y = (float)pos.func_177956_o() + 0.9f + GTValues.RNG.nextFloat() * 0.2f;
        float z = (float)pos.func_177952_p() + 0.8f - GTValues.RNG.nextFloat() * 0.6f;
        mte.getWorld().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0, new int[0]);
    }),
    PBF_SMOKE(mte -> {
        if (mte.getWorld() == null || mte.getPos() == null) {
            return;
        }
        BlockPos pos = mte.getPos();
        EnumFacing facing = mte.getFrontFacing().func_176734_d();
        float xPos = (float)facing.func_82601_c() * 0.76f + (float)pos.func_177958_n() + 0.5f;
        float yPos = (float)facing.func_96559_d() * 0.76f + (float)pos.func_177956_o() + 0.25f;
        float zPos = (float)facing.func_82599_e() * 0.76f + (float)pos.func_177952_p() + 0.5f;
        float ySpd = (float)facing.func_96559_d() * 0.1f + 0.2f + 0.1f * GTValues.RNG.nextFloat();
        mte.getWorld().func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)xPos, (double)yPos, (double)zPos, 0.0, (double)ySpd, 0.0, new int[0]);
    }),
    RANDOM_LAVA_SMOKE(mte -> {
        double z;
        double x;
        if (mte.getWorld() == null || mte.getPos() == null) {
            return;
        }
        EnumFacing facing = mte.getFrontFacing();
        if (facing.func_176740_k() == EnumFacing.Axis.Y || mte.hasCover(facing)) {
            return;
        }
        BlockPos pos = mte.getPos();
        double offX = (double)(pos.func_177958_n() + facing.func_82601_c()) + 0.5;
        double offY = pos.func_177956_o() + facing.func_96559_d();
        double offZ = (double)(pos.func_177952_p() + facing.func_82599_e()) + 0.5;
        double offset = -0.48;
        double horizontal = (double)GTValues.RNG.nextFloat() * 0.625 - 0.3125;
        double y = offY + (double)GTValues.RNG.nextFloat() * 0.375;
        if (facing == EnumFacing.WEST) {
            x = offX - -0.48;
            z = offZ + horizontal;
        } else if (facing == EnumFacing.EAST) {
            x = offX + -0.48;
            z = offZ + horizontal;
        } else if (facing == EnumFacing.NORTH) {
            x = offX + horizontal;
            z = offZ - -0.48;
        } else {
            x = offX + horizontal;
            z = offZ + -0.48;
        }
        mte.getWorld().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        mte.getWorld().func_175688_a(EnumParticleTypes.LAVA, x, y, z, 0.0, 0.0, 0.0, new int[0]);
    }),
    RANDOM_SPARKS(mte -> {
        if (mte.getWorld() == null || mte.getPos() == null) {
            return;
        }
        EnumFacing facing = mte.getFrontFacing();
        if (facing.func_176740_k() == EnumFacing.Axis.Y || mte.hasCover(facing)) {
            return;
        }
        if (GTValues.RNG.nextInt(3) == 0) {
            double mZ;
            double z;
            double mX;
            double x;
            BlockPos pos = mte.getPos();
            double offset = 0.02;
            double horizontal = 0.5 + (double)GTValues.RNG.nextFloat() * 0.5 - 0.25;
            double y = (double)pos.func_177956_o() + (double)GTValues.RNG.nextFloat() * 0.625 + 0.3125;
            if (facing == EnumFacing.WEST) {
                x = (double)pos.func_177958_n() - 0.02;
                mX = -0.05;
                z = (double)pos.func_177952_p() + horizontal;
                mZ = 0.0;
            } else if (facing == EnumFacing.EAST) {
                x = (double)pos.func_177958_n() + 0.02;
                mX = 0.05;
                z = (double)pos.func_177952_p() + horizontal;
                mZ = 0.0;
            } else if (facing == EnumFacing.NORTH) {
                x = (double)pos.func_177958_n() + horizontal;
                mX = 0.0;
                z = (double)pos.func_177952_p() - 0.02;
                mZ = -0.05;
            } else {
                x = (double)pos.func_177958_n() + horizontal;
                mX = 0.0;
                z = (double)pos.func_177952_p() + 0.02;
                mZ = 0.05;
            }
            mte.getWorld().func_175688_a(EnumParticleTypes.LAVA, x, y, z, mX, 0.0, mZ, new int[0]);
        }
    }),
    COMBUSTION_SMOKE(mte -> {
        if (mte.getWorld() == null || mte.getPos() == null) {
            return;
        }
        if (mte.hasCover(EnumFacing.UP)) {
            return;
        }
        BlockPos pos = mte.getPos();
        float x = (float)pos.func_177958_n() + 0.125f + GTValues.RNG.nextFloat() * 0.875f;
        float y = (float)pos.func_177956_o() + 1.03125f;
        float z = (float)pos.func_177952_p() + 0.125f + GTValues.RNG.nextFloat() * 0.875f;
        mte.getWorld().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0, new int[0]);
    });

    private final Consumer<MetaTileEntity> effectConsumer;

    private VanillaParticleEffects(Consumer<MetaTileEntity> effectConsumer) {
        this.effectConsumer = effectConsumer;
    }

    @Override
    public void runEffect(@NotNull MetaTileEntity metaTileEntity) {
        this.effectConsumer.accept(metaTileEntity);
    }

    @SideOnly(value=Side.CLIENT)
    public static void defaultFrontEffect(@NotNull MetaTileEntity mte, EnumParticleTypes ... particles) {
        VanillaParticleEffects.defaultFrontEffect(mte, 0.0f, particles);
    }

    @SideOnly(value=Side.CLIENT)
    public static void defaultFrontEffect(@NotNull MetaTileEntity mte, float yOffset, EnumParticleTypes ... particles) {
        if (particles == null || particles.length == 0) {
            return;
        }
        if (mte.getWorld() == null || mte.getPos() == null) {
            return;
        }
        BlockPos pos = mte.getPos();
        EnumFacing facing = mte.getFrontFacing();
        if (facing.func_176740_k() == EnumFacing.Axis.Y || mte.hasCover(facing)) {
            return;
        }
        float x = (float)pos.func_177958_n() + 0.5f;
        float z = (float)pos.func_177952_p() + 0.5f;
        float horizontalOffset = GTValues.RNG.nextFloat() * 0.6f - 0.3f + yOffset;
        float y = (float)pos.func_177956_o() + GTValues.RNG.nextFloat() * 0.375f;
        if (facing.func_176740_k() == EnumFacing.Axis.X) {
            x = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? (x += 0.52f) : (x -= 0.52f);
            z += horizontalOffset;
        } else if (facing.func_176740_k() == EnumFacing.Axis.Z) {
            z = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? (z += 0.52f) : (z -= 0.52f);
            x += horizontalOffset;
        }
        for (EnumParticleTypes particle : particles) {
            mte.getWorld().func_175688_a(particle, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void mufflerEffect(@NotNull MetaTileEntity mte, @NotNull EnumParticleTypes particle) {
        float zSpd;
        float xSpd;
        if (mte.getWorld() == null || mte.getPos() == null) {
            return;
        }
        BlockPos pos = mte.getPos();
        EnumFacing facing = mte.getFrontFacing();
        float xPos = (float)facing.func_82601_c() * 0.76f + (float)pos.func_177958_n() + 0.25f;
        float yPos = (float)facing.func_96559_d() * 0.76f + (float)pos.func_177956_o() + 0.25f;
        float zPos = (float)facing.func_82599_e() * 0.76f + (float)pos.func_177952_p() + 0.25f;
        float ySpd = (float)facing.func_96559_d() * 0.1f + 0.2f + 0.1f * GTValues.RNG.nextFloat();
        if (facing.func_96559_d() == -1) {
            float temp = GTValues.RNG.nextFloat() * 2.0f * (float)Math.PI;
            xSpd = (float)Math.sin(temp) * 0.1f;
            zSpd = (float)Math.cos(temp) * 0.1f;
        } else {
            xSpd = (float)facing.func_82601_c() * (0.1f + 0.2f * GTValues.RNG.nextFloat());
            zSpd = (float)facing.func_82599_e() * (0.1f + 0.2f * GTValues.RNG.nextFloat());
        }
        mte.getWorld().func_175688_a(particle, (double)(xPos += GTValues.RNG.nextFloat() * 0.5f), (double)(yPos += GTValues.RNG.nextFloat() * 0.5f), (double)(zPos += GTValues.RNG.nextFloat() * 0.5f), (double)xSpd, (double)ySpd, (double)zSpd, new int[0]);
    }
}

