/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.event;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import gregtech.api.GTValues;
import gregtech.api.items.armor.ArmorMetaItem;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.items.metaitem.stats.IItemHUDProvider;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.util.CapesRegistry;
import gregtech.client.particle.GTParticleManager;
import gregtech.client.renderer.handler.BlockPosHighlightRenderer;
import gregtech.client.renderer.handler.MultiblockPreviewRenderer;
import gregtech.client.renderer.handler.TerminalARRenderer;
import gregtech.client.utils.DepthTextureUtil;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.ConfigHolder;
import gregtech.common.metatileentities.multi.electric.centralmonitor.MetaTileEntityMonitorScreen;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientEventHandler {
    private static final Map<UUID, ResourceLocation> DEFAULT_CAPES = new Object2ObjectOpenHashMap();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onDrawBlockHighlight(DrawBlockHighlightEvent event) {
        if (event.getTarget().func_178782_a() == null) {
            return;
        }
        TileEntity tileEntity = event.getPlayer().field_70170_p.func_175625_s(event.getTarget().func_178782_a());
        if (tileEntity instanceof MetaTileEntityHolder && ((MetaTileEntityHolder)tileEntity).getMetaTileEntity() instanceof MetaTileEntityMonitorScreen) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPreWorldRender(TickEvent.RenderTickEvent event) {
        DepthTextureUtil.onPreWorldRender(event);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        GTParticleManager.clientTick(event);
        TerminalARRenderer.onClientTick(event);
        TooltipHelper.onClientTick(event);
        if (event.phase == TickEvent.Phase.END) {
            ++GTValues.CLIENT_TIME;
        }
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderWorldLastEvent event) {
        DepthTextureUtil.renderWorld(event);
        MultiblockPreviewRenderer.renderWorldLastEvent(event);
        BlockPosHighlightRenderer.renderWorldLastEvent(event);
        TerminalARRenderer.renderWorldLastEvent(event);
        GTParticleManager.renderWorld(event);
    }

    @SubscribeEvent
    public static void onRenderGameOverlayPre(RenderGameOverlayEvent.Pre event) {
        TerminalARRenderer.renderGameOverlayEvent(event);
        if (ConfigHolder.misc.debug && event instanceof RenderGameOverlayEvent.Text) {
            RenderGameOverlayEvent.Text text = (RenderGameOverlayEvent.Text)event;
            GTParticleManager.debugOverlay(text);
        }
    }

    @SubscribeEvent
    public static void onRenderSpecificHand(RenderSpecificHandEvent event) {
        TerminalARRenderer.renderHandEvent(event);
    }

    @SubscribeEvent
    public static void onPlayerRender(RenderPlayerEvent.Pre event) {
        AbstractClientPlayer clientPlayer = (AbstractClientPlayer)event.getEntityPlayer();
        if (clientPlayer.func_152122_n() && clientPlayer.field_175157_a != null) {
            ResourceLocation defaultPlayerCape;
            Map playerTextures = clientPlayer.field_175157_a.field_187107_a;
            UUID uuid = clientPlayer.getPersistentID();
            if (!DEFAULT_CAPES.containsKey(uuid)) {
                defaultPlayerCape = (ResourceLocation)playerTextures.get(MinecraftProfileTexture.Type.CAPE);
                DEFAULT_CAPES.put(uuid, defaultPlayerCape);
            } else {
                defaultPlayerCape = DEFAULT_CAPES.get(uuid);
            }
            ResourceLocation cape = CapesRegistry.getPlayerCape(uuid);
            playerTextures.put(MinecraftProfileTexture.Type.CAPE, cape == null ? defaultPlayerCape : cape);
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.PostConfigChangedEvent event) {
        if ("gregtech".equals(event.getModID()) && event.isWorldRunning()) {
            Minecraft.func_71410_x().field_71438_f.func_72712_a();
        }
    }

    @SubscribeEvent
    public static void onRenderArmorHUD(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71415_G && mc.field_71441_e != null && !mc.field_71474_y.field_74330_P && Minecraft.func_71382_s()) {
            ClientEventHandler.renderHUDMetaArmor(mc.field_71439_g.field_71071_by.func_70440_f(EntityEquipmentSlot.HEAD.func_188454_b()));
            ClientEventHandler.renderHUDMetaArmor(mc.field_71439_g.field_71071_by.func_70440_f(EntityEquipmentSlot.CHEST.func_188454_b()));
            ClientEventHandler.renderHUDMetaArmor(mc.field_71439_g.field_71071_by.func_70440_f(EntityEquipmentSlot.LEGS.func_188454_b()));
            ClientEventHandler.renderHUDMetaArmor(mc.field_71439_g.field_71071_by.func_70440_f(EntityEquipmentSlot.FEET.func_188454_b()));
            ClientEventHandler.renderHUDMetaItem(mc.field_71439_g.func_184586_b(EnumHand.MAIN_HAND));
            ClientEventHandler.renderHUDMetaItem(mc.field_71439_g.func_184586_b(EnumHand.OFF_HAND));
        }
    }

    private static void renderHUDMetaArmor(@NotNull ItemStack stack) {
        if (stack.func_77973_b() instanceof ArmorMetaItem) {
            ArmorMetaItem.ArmorMetaValueItem valueItem = (ArmorMetaItem.ArmorMetaValueItem)((ArmorMetaItem)stack.func_77973_b()).getItem(stack);
            if (valueItem == null) {
                return;
            }
            if (valueItem.getArmorLogic() instanceof IItemHUDProvider) {
                IItemHUDProvider.tryDrawHud((IItemHUDProvider)((Object)valueItem.getArmorLogic()), stack);
            }
        }
    }

    private static void renderHUDMetaItem(@NotNull ItemStack stack) {
        if (stack.func_77973_b() instanceof MetaItem) {
            Object valueItem = ((MetaItem)stack.func_77973_b()).getItem(stack);
            if (valueItem == null) {
                return;
            }
            for (IItemBehaviour behaviour : ((MetaItem.MetaValueItem)valueItem).getBehaviours()) {
                if (!(behaviour instanceof IItemHUDProvider)) continue;
                IItemHUDProvider.tryDrawHud((IItemHUDProvider)((Object)behaviour), stack);
            }
        }
    }
}

