/*
 * Decompiled with CFR 0.152.
 */
package gregtech.asm;

import gregtech.asm.util.ObfMapping;
import gregtech.asm.util.TargetClassVisitor;
import gregtech.asm.visitors.AbstractCTMBakedModelVisitor;
import gregtech.asm.visitors.BlockVisitor;
import gregtech.asm.visitors.CCLVisitor;
import gregtech.asm.visitors.ConcretePowderVisitor;
import gregtech.asm.visitors.DamageSourceVisitor;
import gregtech.asm.visitors.EnchantmentCanApplyVisitor;
import gregtech.asm.visitors.EntityRendererVisitor;
import gregtech.asm.visitors.JEIVisitor;
import gregtech.asm.visitors.LayerArmorBaseVisitor;
import gregtech.asm.visitors.LayerCustomHeadVisitor;
import gregtech.asm.visitors.LittleTilesVisitor;
import gregtech.asm.visitors.MinecraftVisitor;
import gregtech.asm.visitors.ModelCTMVisitor;
import gregtech.asm.visitors.ModelLoaderRegistryVisitor;
import gregtech.asm.visitors.NuclearCraftRecipeHelperVisitor;
import gregtech.asm.visitors.RecipeRepairItemVisitor;
import gregtech.asm.visitors.RegionRenderCacheBuilderVisitor;
import gregtech.asm.visitors.RenderChunkVisitor;
import gregtech.asm.visitors.RenderItemVisitor;
import gregtech.asm.visitors.SpecialArmorApplyVisitor;
import gregtech.asm.visitors.SpecialArmorClassVisitor;
import gregtech.asm.visitors.TheOneProbeVisitor;
import gregtech.asm.visitors.WorldVisitor;
import gregtech.common.ConfigHolder;
import java.util.Iterator;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class GregTechTransformer
implements IClassTransformer,
Opcodes {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        String internalName;
        switch (internalName = transformedName.replace('.', '/')) {
            case "mezz/jei/startup/ForgeModIdHelper": {
                ClassReader classReader = new ClassReader(basicClass);
                ClassWriter classWriter = new ClassWriter(0);
                classReader.accept((ClassVisitor)new TargetClassVisitor((ClassVisitor)classWriter, JEIVisitor.TARGET_METHOD, JEIVisitor::new), 0);
                return classWriter.toByteArray();
            }
            case "net/minecraft/block/BlockConcretePowder": {
                if (!ConfigHolder.recipes.disableConcreteInWorld) break;
                ClassReader classReader = new ClassReader(basicClass);
                ClassWriter classWriter = new ClassWriter(3);
                classReader.accept((ClassVisitor)new TargetClassVisitor((ClassVisitor)classWriter, ConcretePowderVisitor.TARGET_METHOD, ConcretePowderVisitor::new), 0);
                return classWriter.toByteArray();
            }
            case "net/minecraft/client/renderer/entity/layers/LayerCustomHead": {
                ClassReader classReader = new ClassReader(basicClass);
                ClassWriter classWriter = new ClassWriter(3);
                classReader.accept((ClassVisitor)new TargetClassVisitor((ClassVisitor)classWriter, LayerCustomHeadVisitor.TARGET_METHOD, LayerCustomHeadVisitor::new), 0);
                return classWriter.toByteArray();
            }
            case "net/minecraftforge/common/ISpecialArmor$ArmorProperties": {
                ClassReader classReader = new ClassReader(basicClass);
                ClassWriter classWriter = new ClassWriter(3);
                classReader.accept((ClassVisitor)new SpecialArmorClassVisitor((ClassVisitor)classWriter, SpecialArmorApplyVisitor.TARGET_METHOD, SpecialArmorApplyVisitor::new), 0);
                return classWriter.toByteArray();
            }
            case "net/minecraft/client/renderer/entity/layers/LayerArmorBase": {
                ClassReader classReader = new ClassReader(basicClass);
                ClassWriter classWriter = new ClassWriter(3);
                classReader.accept((ClassVisitor)new TargetClassVisitor((ClassVisitor)classWriter, LayerArmorBaseVisitor.TARGET_METHOD, LayerArmorBaseVisitor::new), 0);
                return classWriter.toByteArray();
            }
            case "net/minecraft/client/renderer/RegionRenderCacheBuilder": {
                ClassReader classReader = new ClassReader(basicClass);
                ClassWriter classWriter = new ClassWriter(3);
                classReader.accept((ClassVisitor)new TargetClassVisitor((ClassVisitor)classWriter, RegionRenderCacheBuilderVisitor.TARGET_METHOD, RegionRenderCacheBuilderVisitor::new), 0);
                return classWriter.toByteArray();
            }
            case "net/minecraft/client/renderer/chunk/RenderChunk": {
                ClassReader classReader = new ClassReader(basicClass);
                ClassWriter classWriter = new ClassWriter(3);
                classReader.accept((ClassVisitor)new TargetClassVisitor((ClassVisitor)classWriter, RenderChunkVisitor.TARGET_METHOD, RenderChunkVisitor::new), 0);
                return classWriter.toByteArray();
            }
            case "net/minecraft/client/renderer/EntityRenderer": {
                ClassReader classReader = new ClassReader(basicClass);
                ClassWriter classWriter = new ClassWriter(3);
                classReader.accept((ClassVisitor)new TargetClassVisitor((ClassVisitor)classWriter, EntityRendererVisitor.TARGET_METHOD, EntityRendererVisitor::new), 0);
                return classWriter.toByteArray();
            }
            case "net/minecraft/block/Block": {
                try {
                    Class.forName("team.chisel.ctm.CTM", false, (ClassLoader)Launch.classLoader);
                    break;
                }
                catch (ClassNotFoundException ignored) {
                    ClassReader classReader = new ClassReader(basicClass);
                    ClassWriter classWriter = new ClassWriter(3);
                    ClassNode classNode = new ClassNode();
                    classReader.accept((ClassVisitor)classNode, 0);
                    BlockVisitor.handleClassNode(classNode).accept((ClassVisitor)classWriter);
                    return classWriter.toByteArray();
                }
            }
            case "net/minecraft/world/World": {
                ClassReader classReader = new ClassReader(basicClass);
                ClassWriter classWriter = new ClassWriter(3);
                classReader.accept((ClassVisitor)new TargetClassVisitor((ClassVisitor)classWriter, WorldVisitor.TARGET_METHOD, WorldVisitor::new), 0);
                return classWriter.toByteArray();
            }
            case "team/chisel/ctm/client/asm/CTMCoreMethods": {
                ClassReader classReader = new ClassReader(basicClass);
                ClassWriter classWriter = new ClassWriter(3);
                classReader.accept((ClassVisitor)new TargetClassVisitor((ClassVisitor)classWriter, ModelCTMVisitor.TARGET_METHOD, ModelCTMVisitor::new), 0);
                return classWriter.toByteArray();
            }
            case "team/chisel/ctm/client/model/AbstractCTMBakedModel": {
                ClassReader classReader = new ClassReader(basicClass);
                ClassWriter classWriter = new ClassWriter(3);
                classReader.accept((ClassVisitor)new TargetClassVisitor((ClassVisitor)classWriter, AbstractCTMBakedModelVisitor.TARGET_METHOD, AbstractCTMBakedModelVisitor::new), 0);
                return classWriter.toByteArray();
            }
            case "com/creativemd/littletiles/client/render/world/TileEntityRenderManager": {
                ClassReader classReader = new ClassReader(basicClass);
                ClassWriter classWriter = new ClassWriter(3);
                classReader.accept((ClassVisitor)new TargetClassVisitor((ClassVisitor)classWriter, LittleTilesVisitor.TARGET_METHOD, LittleTilesVisitor::new), 0);
                return classWriter.toByteArray();
            }
            case "codechicken/lib/internal/ModDescriptionEnhancer": {
                ClassReader classReader = new ClassReader(basicClass);
                ClassWriter classWriter = new ClassWriter(3);
                classReader.accept((ClassVisitor)new TargetClassVisitor((ClassVisitor)classWriter, CCLVisitor.TARGET_METHOD, CCLVisitor::new), 0);
                return classWriter.toByteArray();
            }
            case "nc/integration/gtce/GTCERecipeHelper": {
                ClassReader classReader = new ClassReader(basicClass);
                ClassWriter classWriter = new ClassWriter(0);
                ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get("nuclearcraft");
                if (container.getVersion().contains("2o")) {
                    classReader.accept((ClassVisitor)new TargetClassVisitor((ClassVisitor)classWriter, NuclearCraftRecipeHelperVisitor.TARGET_METHOD_NCO, NuclearCraftRecipeHelperVisitor::new), 0);
                } else {
                    classReader.accept((ClassVisitor)new TargetClassVisitor((ClassVisitor)classWriter, NuclearCraftRecipeHelperVisitor.TARGET_METHOD_NC, NuclearCraftRecipeHelperVisitor::new), 0);
                }
                return classWriter.toByteArray();
            }
            case "net/minecraft/client/renderer/RenderItem": {
                ClassNode classNode = new ClassNode();
                ClassReader classReader = new ClassReader(basicClass);
                classReader.accept((ClassVisitor)classNode, 0);
                Iterator<MethodNode> methods = classNode.methods.iterator();
                RenderItemVisitor.transform(methods);
                ClassWriter classWriter = new ClassWriter(0);
                classNode.accept((ClassVisitor)classWriter);
                return classWriter.toByteArray();
            }
            case "net/minecraft/item/crafting/RecipeRepairItem": {
                ClassReader classReader = new ClassReader(basicClass);
                ClassWriter classWriter = new ClassWriter(3);
                ClassNode classNode = new ClassNode();
                classReader.accept((ClassVisitor)classNode, 0);
                RecipeRepairItemVisitor.handleClassNode(classNode).accept((ClassVisitor)classWriter);
                return classWriter.toByteArray();
            }
            case "net/minecraft/util/DamageSource": {
                ClassReader classReader = new ClassReader(basicClass);
                ClassWriter classWriter = new ClassWriter(3);
                ClassNode classNode = new ClassNode();
                classReader.accept((ClassVisitor)classNode, 0);
                DamageSourceVisitor.handleClassNode(classNode).accept((ClassVisitor)classWriter);
                return classWriter.toByteArray();
            }
            case "mcjty/theoneprobe/network/PacketGetInfo": {
                ClassReader classReader = new ClassReader(basicClass);
                ClassWriter classWriter = new ClassWriter(0);
                classReader.accept((ClassVisitor)new TargetClassVisitor((ClassVisitor)classWriter, TheOneProbeVisitor.TARGET_METHOD, TheOneProbeVisitor::new), 0);
                return classWriter.toByteArray();
            }
            case "net/minecraft/client/Minecraft": {
                ClassReader classReader = new ClassReader(basicClass);
                ClassWriter classWriter = new ClassWriter(0);
                classReader.accept((ClassVisitor)new TargetClassVisitor((ClassVisitor)classWriter, MinecraftVisitor.PROCESS_KEY_F3, MinecraftVisitor::new), 8);
                return classWriter.toByteArray();
            }
            case "net/minecraftforge/client/model/ModelLoaderRegistry": {
                ClassReader classReader = new ClassReader(basicClass);
                ClassWriter classWriter = new ClassWriter(0);
                classReader.accept((ClassVisitor)new TargetClassVisitor((ClassVisitor)classWriter, ModelLoaderRegistryVisitor.TARGET_METHOD, ModelLoaderRegistryVisitor::new), 8);
                return classWriter.toByteArray();
            }
        }
        if (EnchantmentCanApplyVisitor.CLASS_TO_MAPPING_MAP.containsKey(internalName)) {
            ObfMapping methodMapping = EnchantmentCanApplyVisitor.CLASS_TO_MAPPING_MAP.get(internalName);
            ClassReader classReader = new ClassReader(basicClass);
            ClassWriter classWriter = new ClassWriter(3);
            classReader.accept((ClassVisitor)new TargetClassVisitor((ClassVisitor)classWriter, methodMapping, mv -> new EnchantmentCanApplyVisitor((MethodVisitor)mv, methodMapping)), 8);
            return classWriter.toByteArray();
        }
        return basicClass;
    }
}

