/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.util.GTUtility;
import java.text.NumberFormat;

public class TextFormattingUtil {
    private static final long[] metricSuffixValues = new long[]{1000L, 1000000L, 1000000000L, 1000000000000L, 1000000000000000L, 1000000000000000000L};
    private static final char[] metricSuffixChars = new char[]{'k', 'M', 'G', 'T', 'P', 'E'};
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();

    public static String formatLongToCompactString(long value, int precision) {
        int i;
        if (value == 0L || (double)Math.abs(value) < Math.pow(10.0, precision)) {
            return Long.toString(value);
        }
        StringBuilder stb = new StringBuilder();
        if (value < 0L) {
            stb.append('-');
            long l = value = value == Long.MIN_VALUE ? Long.MAX_VALUE : -value;
        }
        if ((i = GTUtility.nearestLesserOrEqual(metricSuffixValues, value)) == -1) {
            return stb.append(value).toString();
        }
        long suffixValue = metricSuffixValues[i];
        stb.append(value / suffixValue);
        long truncatedDigit = value % suffixValue / (suffixValue / 10L);
        if (truncatedDigit > 0L) {
            stb.append('.').append(truncatedDigit);
        }
        return stb.append(metricSuffixChars[i]).toString();
    }

    public static String formatLongToCompactString(long value) {
        return TextFormattingUtil.formatLongToCompactString(value, 3);
    }

    public static String formatNumbers(long number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String formatNumbers(double number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String formatNumbers(Object number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String formatStringWithNewlines(String toFormat, int maxLength) {
        String[] name = toFormat.split(" ");
        StringBuilder builder = new StringBuilder();
        int length = 0;
        for (String s : name) {
            if ((length += s.length()) > maxLength) {
                builder.append("\n");
                builder.append(s);
                length = 0;
                continue;
            }
            if (builder.length() != 0) {
                builder.append(" ");
            }
            builder.append(s);
        }
        return builder.toString();
    }
}

