/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.google.common.collect.Lists;
import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.block.machines.MachineItemBlock;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.fluids.GTFluid;
import gregtech.api.items.behavior.CoverItemBehavior;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.SimpleGeneratorMetaTileEntity;
import gregtech.api.metatileentity.WorkableTieredMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.ItemStackHashStrategy;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.AbstractList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTUtility {
    public static final Function<Integer, Integer> defaultTankSizeFunction = tier -> {
        if (tier <= 1) {
            return 8000;
        }
        if (tier == 2) {
            return 12000;
        }
        if (tier == 3) {
            return 16000;
        }
        if (tier == 4) {
            return 32000;
        }
        return 64000;
    };
    public static final Function<Integer, Integer> hvCappedTankSizeFunction = tier -> {
        if (tier <= 1) {
            return 8000;
        }
        if (tier == 2) {
            return 12000;
        }
        return 16000;
    };
    public static final Function<Integer, Integer> largeTankSizeFunction = tier -> {
        if (tier <= 1) {
            return 32000;
        }
        if (tier == 2) {
            return 48000;
        }
        return 64000;
    };
    public static final Function<Integer, Integer> steamGeneratorTankSizeFunction = tier -> Math.min(16000 * (1 << tier - 1), 64000);
    public static final Function<Integer, Integer> genericGeneratorTankSizeFunction = tier -> Math.min(4000 * (1 << tier - 1), 16000);

    public static <T> String[] mapToString(T[] array, Function<T, String> mapper) {
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = mapper.apply(array[i]);
        }
        return result;
    }

    public static int convertRGBtoOpaqueRGBA_CL(int colorValue) {
        return GTUtility.convertRGBtoRGBA_CL(colorValue, 255);
    }

    public static int convertRGBtoRGBA_CL(int colorValue, int opacity) {
        return colorValue << 8 | opacity & 0xFF;
    }

    public static int convertOpaqueRGBA_CLtoRGB(int colorAlpha) {
        return colorAlpha >>> 8;
    }

    public static int convertRGBtoOpaqueRGBA_MC(int colorValue) {
        return GTUtility.convertRGBtoOpaqueRGBA_MC(colorValue, 255);
    }

    public static int convertRGBtoOpaqueRGBA_MC(int colorValue, int opacity) {
        return opacity << 24 | colorValue;
    }

    public static int convertRGBtoARGB(int colorValue) {
        return GTUtility.convertRGBtoARGB(colorValue, 255);
    }

    public static int convertRGBtoARGB(int colorValue, int opacity) {
        if ((colorValue >> 24 & 0xFF) != 0) {
            return colorValue;
        }
        return opacity << 24 | colorValue;
    }

    public static boolean mergeItemStack(ItemStack itemStack, List<Slot> slots, boolean simulate) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        boolean merged = false;
        for (Slot slot : slots) {
            ItemStack stackInSlot;
            if (!slot.func_75214_a(itemStack) || !ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)(stackInSlot = slot.func_75211_c())) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)stackInSlot)) continue;
            int slotMaxStackSize = Math.min(stackInSlot.func_77976_d(), slot.func_178170_b(stackInSlot));
            int amountToInsert = Math.min(itemStack.func_190916_E(), slotMaxStackSize - stackInSlot.func_190916_E());
            if (amountToInsert <= 0) continue;
            if (!simulate) {
                stackInSlot.func_190917_f(amountToInsert);
            }
            itemStack.func_190918_g(amountToInsert);
            slot.func_75218_e();
            merged = true;
            if (!itemStack.func_190926_b()) continue;
            return true;
        }
        for (Slot slot : slots) {
            int amountToInsert;
            if (!slot.func_75214_a(itemStack) || slot.func_75216_d() || (amountToInsert = Math.min(itemStack.func_190916_E(), slot.func_178170_b(itemStack))) == 0) continue;
            ItemStack stackInSlot = itemStack.func_77979_a(amountToInsert);
            if (!simulate) {
                slot.func_75215_d(stackInSlot);
            }
            merged = true;
            if (!itemStack.func_190926_b()) continue;
            return true;
        }
        return merged;
    }

    public static void writeItems(IItemHandler handler, String tagName, NBTTagCompound tag) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74768_a("Slot", i);
            handler.getStackInSlot(i).func_77955_b(stackTag);
            tagList.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a(tagName, (NBTBase)tagList);
    }

    public static void readItems(IItemHandlerModifiable handler, String tagName, NBTTagCompound tag) {
        if (tag.func_74764_b(tagName)) {
            NBTTagList tagList = tag.func_150295_c(tagName, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                int slot = tagList.func_150305_b(i).func_74762_e("Slot");
                if (slot < 0 || slot >= handler.getSlots()) continue;
                handler.setStackInSlot(slot, new ItemStack(tagList.func_150305_b(i)));
            }
        }
    }

    public static int nearestLesserOrEqual(@NotNull long[] array, long value) {
        int low = 0;
        int high = array.length - 1;
        while (true) {
            int median;
            if (array[median = (low + high) / 2] <= value) {
                if (low == high) {
                    return low;
                }
                low = median + 1;
                continue;
            }
            if (low == high) {
                return low - 1;
            }
            high = median - 1;
        }
    }

    public static int nearestLesser(@NotNull long[] array, long value) {
        int low = 0;
        int high = array.length - 1;
        while (true) {
            int median;
            if (array[median = (low + high) / 2] < value) {
                if (low == high) {
                    return low;
                }
                low = median + 1;
                continue;
            }
            if (low == high) {
                return low - 1;
            }
            high = median - 1;
        }
    }

    public static byte getTierByVoltage(long voltage) {
        return (byte)Math.min(14, GTUtility.nearestLesser(GTValues.V, voltage) + 1);
    }

    public static byte getFloorTierByVoltage(long voltage) {
        return (byte)Math.max(0, GTUtility.nearestLesserOrEqual(GTValues.V, voltage));
    }

    public static BiomeDictionary.Type getBiomeTypeTagByName(String name) {
        Map byName = (Map)ReflectionHelper.getPrivateValue(BiomeDictionary.Type.class, null, (String[])new String[]{"byName"});
        return (BiomeDictionary.Type)byName.get(name);
    }

    public static <T> int getRandomItem(Random random, List<? extends Map.Entry<Integer, T>> randomList, int size) {
        if (randomList.isEmpty()) {
            return -1;
        }
        int[] baseOffsets = new int[size];
        int currentIndex = 0;
        for (int i = 0; i < size; ++i) {
            Map.Entry<Integer, T> entry = randomList.get(i);
            if (entry.getKey() <= 0) {
                throw new IllegalArgumentException("Invalid weight: " + entry.getKey());
            }
            baseOffsets[i] = currentIndex += entry.getKey().intValue();
        }
        int randomValue = random.nextInt(currentIndex);
        for (int i = 0; i < size; ++i) {
            if (randomValue >= baseOffsets[i]) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid weight");
    }

    public static <T> int getRandomItem(List<? extends Map.Entry<Integer, T>> randomList, int size) {
        return GTUtility.getRandomItem(GTValues.RNG, randomList, size);
    }

    @Nullable
    public static EnumFacing determineWrenchingSide(EnumFacing facing, float x, float y, float z) {
        EnumFacing opposite = facing.func_176734_d();
        switch (facing) {
            case DOWN: 
            case UP: {
                if ((double)x < 0.25) {
                    if ((double)z < 0.25) {
                        return opposite;
                    }
                    if ((double)z > 0.75) {
                        return opposite;
                    }
                    return EnumFacing.WEST;
                }
                if ((double)x > 0.75) {
                    if ((double)z < 0.25) {
                        return opposite;
                    }
                    if ((double)z > 0.75) {
                        return opposite;
                    }
                    return EnumFacing.EAST;
                }
                if ((double)z < 0.25) {
                    return EnumFacing.NORTH;
                }
                if ((double)z > 0.75) {
                    return EnumFacing.SOUTH;
                }
                return facing;
            }
            case NORTH: 
            case SOUTH: {
                if ((double)x < 0.25) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return EnumFacing.WEST;
                }
                if ((double)x > 0.75) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return EnumFacing.EAST;
                }
                if ((double)y < 0.25) {
                    return EnumFacing.DOWN;
                }
                if ((double)y > 0.75) {
                    return EnumFacing.UP;
                }
                return facing;
            }
            case WEST: 
            case EAST: {
                if ((double)z < 0.25) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return EnumFacing.NORTH;
                }
                if ((double)z > 0.75) {
                    if ((double)y < 0.25) {
                        return opposite;
                    }
                    if ((double)y > 0.75) {
                        return opposite;
                    }
                    return EnumFacing.SOUTH;
                }
                if ((double)y < 0.25) {
                    return EnumFacing.DOWN;
                }
                if ((double)y > 0.75) {
                    return EnumFacing.UP;
                }
                return facing;
            }
        }
        return null;
    }

    @Nullable
    public static EnumFacing getFacingToNeighbor(@NotNull BlockPos main, @NotNull BlockPos neighbor) {
        int difX = neighbor.func_177958_n() - main.func_177958_n();
        int difY = neighbor.func_177956_o() - main.func_177956_o();
        int difZ = neighbor.func_177952_p() - main.func_177952_p();
        if (difX != 0) {
            if (difY != 0 || difZ != 0 || difX != 1 && difX != -1) {
                return null;
            }
            return difX > 0 ? EnumFacing.EAST : EnumFacing.WEST;
        }
        if (difY != 0) {
            if (difZ != 0 || difY != 1 && difY != -1) {
                return null;
            }
            return difY > 0 ? EnumFacing.UP : EnumFacing.DOWN;
        }
        if (difZ != 0) {
            if (difZ != 1 && difZ != -1) {
                return null;
            }
            return difZ > 0 ? EnumFacing.SOUTH : EnumFacing.NORTH;
        }
        return null;
    }

    public static List<ItemStack> itemHandlerToList(final IItemHandlerModifiable inputs) {
        return new AbstractList<ItemStack>(){

            @Override
            public ItemStack set(int index, ItemStack element) {
                ItemStack oldStack = inputs.getStackInSlot(index);
                inputs.setStackInSlot(index, element == null ? ItemStack.field_190927_a : element);
                return oldStack;
            }

            @Override
            public ItemStack get(int index) {
                return inputs.getStackInSlot(index);
            }

            @Override
            public int size() {
                return inputs.getSlots();
            }
        };
    }

    public static List<FluidStack> fluidHandlerToList(IMultipleTankHandler fluidInputs) {
        final List<IMultipleTankHandler.MultiFluidTankEntry> backedList = fluidInputs.getFluidTanks();
        return new AbstractList<FluidStack>(){

            @Override
            public FluidStack set(int index, FluidStack element) {
                IFluidTank fluidTank = ((IMultipleTankHandler.MultiFluidTankEntry)backedList.get(index)).getDelegate();
                FluidStack oldStack = fluidTank.getFluid();
                if (fluidTank instanceof FluidTank) {
                    ((FluidTank)fluidTank).setFluid(element);
                }
                return oldStack;
            }

            @Override
            public FluidStack get(int index) {
                return ((IMultipleTankHandler.MultiFluidTankEntry)backedList.get(index)).getFluid();
            }

            @Override
            public int size() {
                return backedList.size();
            }
        };
    }

    public static NBTTagCompound getOrCreateNbtCompound(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            stack.func_77982_d(compound);
        }
        return compound;
    }

    public static NonNullList<ItemStack> copyStackList(List<ItemStack> itemStacks) {
        Object[] stacks = new ItemStack[itemStacks.size()];
        for (int i = 0; i < itemStacks.size(); ++i) {
            stacks[i] = GTUtility.copy(itemStacks.get(i));
        }
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])stacks);
    }

    public static List<FluidStack> copyFluidList(List<FluidStack> fluidStacks) {
        Object[] stacks = new FluidStack[fluidStacks.size()];
        for (int i = 0; i < fluidStacks.size(); ++i) {
            stacks[i] = fluidStacks.get(i).copy();
        }
        return Lists.newArrayList((Object[])stacks);
    }

    @NotNull
    public static ItemStack copy(@NotNull ItemStack stack) {
        return stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l();
    }

    @NotNull
    public static ItemStack copy(int newCount, @NotNull ItemStack stack) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(newCount);
        return copy;
    }

    @NotNull
    public static ItemStack copyFirst(ItemStack ... stacks) {
        if (stacks.length == 0) {
            throw new IllegalArgumentException("Empty ItemStack candidates");
        }
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            return stack.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    @NotNull
    public static ItemStack copyFirst(int newCount, ItemStack ... stacks) {
        if (stacks.length == 0) {
            throw new IllegalArgumentException("Empty ItemStack candidates");
        }
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(newCount);
            return copy;
        }
        return ItemStack.field_190927_a;
    }

    public static int getExplosionPower(long voltage) {
        return GTUtility.getTierByVoltage(voltage) + 1;
    }

    public static int getRedstonePower(World world, BlockPos blockPos, EnumFacing side) {
        IBlockState offsetState;
        BlockPos offsetPos = blockPos.func_177972_a(side);
        int worldPower = world.func_175651_c(offsetPos, side);
        if (worldPower < 15 && (offsetState = world.func_180495_p(offsetPos)).func_177230_c() instanceof BlockRedstoneWire) {
            int wirePower = (Integer)offsetState.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
            return Math.max(worldPower, wirePower);
        }
        return worldPower;
    }

    public static boolean arePosEqual(BlockPos pos1, BlockPos pos2) {
        return pos1.func_177958_n() == pos2.func_177958_n() & pos1.func_177956_o() == pos2.func_177956_o() & pos1.func_177952_p() == pos2.func_177952_p();
    }

    public static boolean isCoverBehaviorItem(ItemStack itemStack, @Nullable BooleanSupplier hasCoverSupplier, @Nullable Predicate<CoverDefinition> canPlaceCover) {
        Item item = itemStack.func_77973_b();
        if (item instanceof MetaItem) {
            MetaItem metaItem = (MetaItem)itemStack.func_77973_b();
            Object valueItem = metaItem.getItem(itemStack);
            if (valueItem != null) {
                for (IItemBehaviour behaviour : ((MetaItem.MetaValueItem)valueItem).getBehaviours()) {
                    if (!(behaviour instanceof CoverItemBehavior)) continue;
                    CoverItemBehavior coverItemBehavior = (CoverItemBehavior)behaviour;
                    return canPlaceCover == null || canPlaceCover.test(coverItemBehavior.getDefinition());
                }
            }
        } else {
            if (item.getToolClasses(itemStack).contains("crowbar")) {
                return hasCoverSupplier == null || hasCoverSupplier.getAsBoolean();
            }
            if (item.getToolClasses(itemStack).contains("mallet")) {
                return hasCoverSupplier == null || hasCoverSupplier.getAsBoolean();
            }
        }
        return false;
    }

    public static ItemStack toItem(IBlockState state) {
        return GTUtility.toItem(state, 1);
    }

    public static ItemStack toItem(IBlockState state, int amount) {
        return new ItemStack(state.func_177230_c(), amount, state.func_177230_c().func_176201_c(state));
    }

    public static boolean isOre(ItemStack item) {
        OrePrefix orePrefix = OreDictUnifier.getPrefix(item);
        return orePrefix != null && orePrefix.name().startsWith("ore");
    }

    public static boolean isMachineValidForMachineHatch(ItemStack machineStack, String[] recipeMapBlacklist) {
        if (machineStack == null || machineStack.func_190926_b()) {
            return false;
        }
        MetaTileEntity machine = GTUtility.getMetaTileEntity(machineStack);
        if (machine instanceof WorkableTieredMetaTileEntity && !(machine instanceof SimpleGeneratorMetaTileEntity)) {
            RecipeMap<?> recipeMap = machine.getRecipeMap();
            return recipeMap != null && !ArrayUtils.contains((Object[])recipeMapBlacklist, (Object)recipeMap.getUnlocalizedName());
        }
        return false;
    }

    public static String toLowerCaseUnderscore(String string) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (i != 0 && (Character.isUpperCase(string.charAt(i)) || Character.isDigit(string.charAt(i - 1)) ^ Character.isDigit(string.charAt(i)))) {
                result.append("_");
            }
            result.append(Character.toLowerCase(string.charAt(i)));
        }
        return result.toString();
    }

    public static String lowerUnderscoreToUpperCamel(String string) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '_') continue;
            if (i == 0 || string.charAt(i - 1) == '_') {
                result.append(Character.toUpperCase(string.charAt(i)));
                continue;
            }
            result.append(string.charAt(i));
        }
        return result.toString();
    }

    public static MetaTileEntity getMetaTileEntity(IBlockAccess world, BlockPos pos) {
        if (world == null || pos == null) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        return te instanceof IGregTechTileEntity ? ((IGregTechTileEntity)te).getMetaTileEntity() : null;
    }

    public static MetaTileEntity getMetaTileEntity(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof MachineItemBlock)) {
            return null;
        }
        return (MetaTileEntity)GregTechAPI.MTE_REGISTRY.func_148754_a(stack.func_77952_i());
    }

    public static boolean canSeeSunClearly(World world, BlockPos blockPos) {
        if (!world.func_175678_i(blockPos.func_177984_a())) {
            return false;
        }
        Biome biome = world.func_180494_b(blockPos.func_177984_a());
        if (world.func_72896_J() && (biome.func_76738_d() || biome.func_76746_c())) {
            return false;
        }
        Set biomeTypes = BiomeDictionary.getTypes((Biome)biome);
        if (biomeTypes.contains(BiomeDictionary.Type.END)) {
            return false;
        }
        return world.func_72935_r();
    }

    public static MapColor getMapColor(int rgb) {
        MapColor color = MapColor.field_151646_E;
        int originalR = rgb >> 16 & 0xFF;
        int originalG = rgb >> 8 & 0xFF;
        int originalB = rgb & 0xFF;
        int distance = Integer.MAX_VALUE;
        for (MapColor mapColor : MapColor.field_76281_a) {
            int colorB;
            int distB;
            int colorG;
            int distG;
            int colorR;
            int distR;
            int dist;
            int colorValue;
            if (mapColor == null || (colorValue = mapColor.field_76291_p) == 0 || (dist = (distR = originalR - (colorR = colorValue >> 16 & 0xFF)) * distR + (distG = originalG - (colorG = colorValue >> 8 & 0xFF)) * distG + (distB = originalB - (colorB = colorValue & 0xFF)) * distB) >= distance) continue;
            distance = dist;
            color = mapColor;
        }
        return color;
    }

    public static boolean isBlockSnow(@NotNull IBlockState blockState) {
        return blockState.func_177230_c() == Blocks.field_150431_aC || blockState.func_177230_c() == Blocks.field_150433_aE;
    }

    public static boolean tryBreakSnow(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, boolean playSound) {
        boolean success = false;
        if (state.func_177230_c() == Blocks.field_150433_aE) {
            world.func_175656_a(pos, Blocks.field_150431_aC.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(7)));
            success = true;
        } else if (state.func_177230_c() == Blocks.field_150431_aC) {
            int layers = (Integer)state.func_177229_b((IProperty)BlockSnow.field_176315_a);
            if (layers == 1) {
                world.func_175655_b(pos, false);
            } else {
                world.func_175656_a(pos, Blocks.field_150431_aC.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(layers - 1)));
            }
            success = true;
        }
        if (success && playSound) {
            world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return success;
    }

    @NotNull
    public static Set<ItemStack> getAllSubItems(@NotNull Item item) {
        NonNullList subItems = NonNullList.func_191196_a();
        for (CreativeTabs tab : item.getCreativeTabs()) {
            if (tab == null || tab == CreativeTabs.field_78027_g) continue;
            item.func_150895_a(tab, subItems);
        }
        ObjectOpenCustomHashSet set = new ObjectOpenCustomHashSet((Hash.Strategy)ItemStackHashStrategy.comparingItemDamageCount());
        set.addAll(subItems);
        return set;
    }

    @Nullable
    public static FluidStack getFluidFromContainer(Object ingredient) {
        ItemStack itemStack;
        IFluidHandlerItem fluidHandler;
        if (ingredient instanceof FluidStack) {
            return (FluidStack)ingredient;
        }
        if (ingredient instanceof ItemStack && (fluidHandler = (IFluidHandlerItem)(itemStack = (ItemStack)ingredient).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null) {
            return fluidHandler.drain(Integer.MAX_VALUE, false);
        }
        return null;
    }

    @NotNull
    public static ResourceLocation gregtechId(@NotNull String path) {
        return new ResourceLocation("gregtech", path);
    }

    @Contract(value="null -> null")
    public static TextComponentTranslation getFluidTranslation(@Nullable FluidStack stack) {
        if (stack == null) {
            return null;
        }
        Fluid fluid = stack.getFluid();
        if (fluid instanceof GTFluid.GTMaterialFluid) {
            GTFluid.GTMaterialFluid materialFluid = (GTFluid.GTMaterialFluid)fluid;
            return materialFluid.toTextComponentTranslation();
        }
        return new TextComponentTranslation(stack.getUnlocalizedName(), new Object[0]);
    }

    @Contract(value="null -> null")
    public static TextComponentTranslation getFluidTranslation(@Nullable Fluid fluid) {
        if (fluid == null) {
            return null;
        }
        if (fluid instanceof GTFluid.GTMaterialFluid) {
            GTFluid.GTMaterialFluid materialFluid = (GTFluid.GTMaterialFluid)fluid;
            return materialFluid.toTextComponentTranslation();
        }
        return new TextComponentTranslation(fluid.getUnlocalizedName(), new Object[0]);
    }
}

