/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.recipes.FluidKey;
import gregtech.api.util.ItemStackHashStrategy;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.util.Collection;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public final class GTHashMaps {
    private GTHashMaps() {
    }

    @NotNull
    public static Object2IntMap<ItemStack> fromItemHandler(@NotNull IItemHandler inputs) {
        return GTHashMaps.fromItemHandler(inputs, false);
    }

    @NotNull
    public static Object2IntMap<ItemStack> fromItemHandler(@NotNull IItemHandler inputs, boolean linked) {
        Object2IntMap<ItemStack> map = GTHashMaps.createItemStackMap(linked);
        for (int i = 0; i < inputs.getSlots(); ++i) {
            ItemStack stack = inputs.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            map.put((Object)stack.func_77946_l(), map.getInt((Object)stack) + stack.func_190916_E());
        }
        return map;
    }

    @NotNull
    public static Object2IntMap<ItemStack> fromItemStackCollection(@NotNull Iterable<ItemStack> inputs) {
        return GTHashMaps.fromItemStackCollection(inputs, false);
    }

    @NotNull
    public static Object2IntMap<ItemStack> fromItemStackCollection(@NotNull Iterable<ItemStack> inputs, boolean linked) {
        Object2IntMap<ItemStack> map = GTHashMaps.createItemStackMap(linked);
        for (ItemStack stack : inputs) {
            if (stack.func_190926_b()) continue;
            map.put((Object)stack.func_77946_l(), map.getInt((Object)stack) + stack.func_190916_E());
        }
        return map;
    }

    @NotNull
    private static Object2IntMap<ItemStack> createItemStackMap(boolean linked) {
        ItemStackHashStrategy strategy = ItemStackHashStrategy.comparingAllButCount();
        return linked ? new Object2IntLinkedOpenCustomHashMap((Hash.Strategy)strategy) : new Object2IntOpenCustomHashMap((Hash.Strategy)strategy);
    }

    public static Map<FluidKey, Integer> fromFluidHandler(IFluidHandler fluidInputs) {
        Object2IntLinkedOpenHashMap map = new Object2IntLinkedOpenHashMap();
        for (int i = 0; i < fluidInputs.getTankProperties().length; ++i) {
            FluidStack fluidStack = fluidInputs.getTankProperties()[i].getContents();
            if (fluidStack == null || fluidStack.amount <= 0) continue;
            FluidKey key = new FluidKey(fluidStack);
            map.put((Object)key, map.getInt((Object)key) + fluidStack.amount);
        }
        return map;
    }

    public static Map<FluidKey, Integer> fromFluidCollection(Collection<FluidStack> fluidInputs) {
        Object2IntLinkedOpenHashMap map = new Object2IntLinkedOpenHashMap();
        for (FluidStack fluidStack : fluidInputs) {
            if (fluidStack == null || fluidStack.amount <= 0) continue;
            FluidKey key = new FluidKey(fluidStack);
            map.put((Object)key, map.getInt((Object)key) + fluidStack.amount);
        }
        return map;
    }
}

