/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IDataItem;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.AssemblyLineRecipeBuilder;
import gregtech.api.recipes.builders.ComputationRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.recipes.ingredients.nbtmatch.NBTCondition;
import gregtech.api.recipes.ingredients.nbtmatch.NBTMatcher;
import gregtech.api.recipes.machines.IScannerRecipeMap;
import gregtech.api.recipes.machines.RecipeMapScanner;
import gregtech.api.recipes.recipeproperties.ScanProperty;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import gregtech.common.items.MetaItems;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AssemblyLineManager {
    public static final String RESEARCH_NBT_TAG = "assemblylineResearch";
    public static final String RESEARCH_ID_NBT_TAG = "researchId";

    @NotNull
    public static ItemStack getDefaultScannerItem() {
        return MetaItems.TOOL_DATA_STICK.getStackForm();
    }

    @NotNull
    public static ItemStack getDefaultResearchStationItem(int cwut) {
        if (cwut > 32) {
            return MetaItems.TOOL_DATA_MODULE.getStackForm();
        }
        return MetaItems.TOOL_DATA_ORB.getStackForm();
    }

    private AssemblyLineManager() {
    }

    @ApiStatus.Internal
    public static void registerScannerLogic() {
        RecipeMapScanner.registerCustomScannerLogic(new DataStickCopyScannerLogic());
    }

    public static void writeResearchToNBT(@NotNull NBTTagCompound stackCompound, @NotNull String researchId) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a(RESEARCH_ID_NBT_TAG, researchId);
        stackCompound.func_74782_a(RESEARCH_NBT_TAG, (NBTBase)compound);
    }

    @Nullable
    public static String readResearchId(@NotNull ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (!AssemblyLineManager.hasResearchTag(compound)) {
            return null;
        }
        NBTTagCompound researchCompound = compound.func_74775_l(RESEARCH_NBT_TAG);
        String researchId = researchCompound.func_74779_i(RESEARCH_ID_NBT_TAG);
        return researchId.isEmpty() ? null : researchId;
    }

    public static boolean isStackDataItem(@NotNull ItemStack stack, boolean isDataBank) {
        Item item = stack.func_77973_b();
        if (item instanceof MetaItem) {
            MetaItem metaItem = (MetaItem)item;
            Object valueItem = metaItem.getItem(stack);
            if (valueItem == null) {
                return false;
            }
            for (IItemBehaviour behaviour : ((MetaItem.MetaValueItem)valueItem).getBehaviours()) {
                if (!(behaviour instanceof IDataItem)) continue;
                IDataItem dataItem = (IDataItem)((Object)behaviour);
                return !dataItem.requireDataBank() || isDataBank;
            }
        }
        return false;
    }

    public static boolean hasResearchTag(@NotNull ItemStack stack) {
        return AssemblyLineManager.hasResearchTag(stack.func_77978_p());
    }

    private static boolean hasResearchTag(@Nullable NBTTagCompound compound) {
        if (compound == null || compound.func_82582_d()) {
            return false;
        }
        return compound.func_150297_b(RESEARCH_NBT_TAG, 10);
    }

    public static void createDefaultResearchRecipe(@NotNull AssemblyLineRecipeBuilder builder) {
        if (!ConfigHolder.machines.enableResearch) {
            return;
        }
        for (AssemblyLineRecipeBuilder.ResearchRecipeEntry entry : builder.getRecipeEntries()) {
            AssemblyLineManager.createDefaultResearchRecipe(entry.getResearchId(), entry.getResearchStack(), entry.getDataStack(), entry.getIgnoreNBT(), entry.getDuration(), entry.getEUt(), entry.getCWUt());
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.9")
    public static void createDefaultResearchRecipe(@NotNull String researchId, @NotNull ItemStack researchItem, @NotNull ItemStack dataItem, int duration, int EUt, int CWUt) {
        AssemblyLineManager.createDefaultResearchRecipe(researchId, researchItem, dataItem, true, duration, EUt, CWUt);
    }

    public static void createDefaultResearchRecipe(@NotNull String researchId, @NotNull ItemStack researchItem, @NotNull ItemStack dataItem, boolean ignoreNBT, int duration, int EUt, int CWUt) {
        if (!ConfigHolder.machines.enableResearch) {
            return;
        }
        NBTTagCompound compound = GTUtility.getOrCreateNbtCompound(dataItem);
        AssemblyLineManager.writeResearchToNBT(compound, researchId);
        if (CWUt > 0) {
            ComputationRecipeBuilder researchBuilder = ((ComputationRecipeBuilder)((ComputationRecipeBuilder)((ComputationRecipeBuilder)RecipeMaps.RESEARCH_STATION_RECIPES.recipeBuilder().inputNBT(dataItem.func_77973_b(), 1, dataItem.func_77960_j(), NBTMatcher.ANY, NBTCondition.ANY)).outputs(dataItem)).EUt(EUt)).CWUt(CWUt).totalCWU(duration);
            if (ignoreNBT) {
                researchBuilder.inputNBT(researchItem.func_77973_b(), 1, researchItem.func_77960_j(), NBTMatcher.ANY, NBTCondition.ANY);
            } else {
                researchBuilder.inputs(researchItem);
            }
            researchBuilder.buildAndRegister();
        } else {
            Object builder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.SCANNER_RECIPES.recipeBuilder().inputNBT(dataItem.func_77973_b(), 1, dataItem.func_77960_j(), NBTMatcher.ANY, NBTCondition.ANY)).outputs(dataItem)).duration(duration)).EUt(EUt);
            if (ignoreNBT) {
                ((RecipeBuilder)builder).inputNBT(researchItem.func_77973_b(), 1, researchItem.func_77960_j(), NBTMatcher.ANY, NBTCondition.ANY);
            } else {
                ((RecipeBuilder)builder).inputs(researchItem);
            }
            ((RecipeBuilder)builder).applyProperty(ScanProperty.getInstance(), (Object)true);
            ((RecipeBuilder)builder).buildAndRegister();
        }
    }

    public static class DataStickCopyScannerLogic
    implements IScannerRecipeMap.ICustomScannerLogic {
        private static final int EUT = 2;
        private static final int DURATION = 100;

        @Override
        public Recipe createCustomRecipe(long voltage, List<ItemStack> inputs, List<FluidStack> fluidInputs, boolean exactVoltage) {
            if (inputs.size() > 1) {
                Recipe recipe = this.createDataRecipe(inputs.get(0), inputs.get(1));
                if (recipe != null) {
                    return recipe;
                }
                return this.createDataRecipe(inputs.get(1), inputs.get(0));
            }
            return null;
        }

        @Nullable
        private Recipe createDataRecipe(@NotNull ItemStack first, @NotNull ItemStack second) {
            NBTTagCompound compound = second.func_77978_p();
            if (compound == null) {
                return null;
            }
            if (!AssemblyLineManager.isStackDataItem(first, true)) {
                return null;
            }
            if (!AssemblyLineManager.isStackDataItem(second, true)) {
                return null;
            }
            ItemStack output = first.func_77946_l();
            output.func_77982_d(compound.func_74737_b());
            return ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.SCANNER_RECIPES.recipeBuilder().inputs(first)).notConsumable(second)).outputs(output)).duration(100)).EUt(2)).build().getResult();
        }

        @Override
        @Nullable
        public List<Recipe> getRepresentativeRecipes() {
            ItemStack copiedStick = MetaItems.TOOL_DATA_STICK.getStackForm();
            copiedStick.func_190924_f("gregtech.scanner.copy_stick_from");
            ItemStack emptyStick = MetaItems.TOOL_DATA_STICK.getStackForm();
            emptyStick.func_190924_f("gregtech.scanner.copy_stick_empty");
            ItemStack resultStick = MetaItems.TOOL_DATA_STICK.getStackForm();
            resultStick.func_190924_f("gregtech.scanner.copy_stick_to");
            return Collections.singletonList(((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.SCANNER_RECIPES.recipeBuilder().inputs(emptyStick)).notConsumable(copiedStick)).outputs(resultStick)).duration(100)).EUt(2)).build().getResult());
        }
    }
}

