/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.properties;

import crafttweaker.CraftTweakerAPI;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.MaterialProperties;
import gregtech.api.unification.material.properties.PropertyKey;
import org.jetbrains.annotations.NotNull;

public class BlastProperty
implements IMaterialProperty {
    private int blastTemperature;
    private GasTier gasTier = null;
    private int durationOverride = -1;
    private int eutOverride = -1;
    private int vacuumDurationOverride = -1;
    private int vacuumEUtOverride = -1;

    public BlastProperty(int blastTemperature) {
        this.blastTemperature = blastTemperature;
    }

    public BlastProperty(int blastTemperature, GasTier gasTier) {
        this.blastTemperature = blastTemperature;
        this.gasTier = gasTier;
    }

    private BlastProperty(int blastTemperature, GasTier gasTier, int eutOverride, int durationOverride, int vacuumEUtOverride, int vacuumDurationOverride) {
        this.blastTemperature = blastTemperature;
        this.gasTier = gasTier;
        this.eutOverride = eutOverride;
        this.durationOverride = durationOverride;
        this.vacuumEUtOverride = vacuumEUtOverride;
        this.vacuumDurationOverride = vacuumDurationOverride;
    }

    public BlastProperty() {
        this(0);
    }

    public int getBlastTemperature() {
        return this.blastTemperature;
    }

    public void setBlastTemperature(int blastTemp) {
        if (blastTemp <= 0) {
            throw new IllegalArgumentException("Blast Temperature must be greater than zero!");
        }
        this.blastTemperature = blastTemp;
    }

    public GasTier getGasTier() {
        return this.gasTier;
    }

    public void setGasTier(@NotNull GasTier tier) {
        this.gasTier = tier;
    }

    public int getDurationOverride() {
        return this.durationOverride;
    }

    public void setDurationOverride(int duration) {
        this.durationOverride = duration;
    }

    public int getEUtOverride() {
        return this.eutOverride;
    }

    public void setEutOverride(int eut) {
        this.eutOverride = eut;
    }

    public int getVacuumDurationOverride() {
        return this.vacuumDurationOverride;
    }

    public void setVacuumDurationOverride(int duration) {
        this.vacuumDurationOverride = duration;
    }

    public int getVacuumEUtOverride() {
        return this.vacuumEUtOverride;
    }

    public void setVacuumEutOverride(int eut) {
        this.vacuumEUtOverride = eut;
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
        properties.ensureSet(PropertyKey.INGOT, true);
    }

    public static GasTier validateGasTier(String gasTierName) {
        if (gasTierName == null) {
            return null;
        }
        if ("LOW".equalsIgnoreCase(gasTierName)) {
            return GasTier.LOW;
        }
        if ("MID".equalsIgnoreCase(gasTierName)) {
            return GasTier.MID;
        }
        if ("HIGH".equalsIgnoreCase(gasTierName)) {
            return GasTier.HIGH;
        }
        if ("HIGHER".equalsIgnoreCase(gasTierName)) {
            return GasTier.HIGHER;
        }
        if ("HIGHEST".equalsIgnoreCase(gasTierName)) {
            return GasTier.HIGHEST;
        }
        String message = "Gas Tier must be either \"LOW\", \"MID\", \"HIGH\", \"HIGHER\", or \"HIGHEST\"";
        CraftTweakerAPI.logError((String)message);
        throw new IllegalArgumentException("Could not find valid gas tier for name: " + gasTierName + ". " + message);
    }

    public static enum GasTier {
        LOW,
        MID,
        HIGH,
        HIGHER,
        HIGHEST;

        public static final GasTier[] VALUES;

        static {
            VALUES = GasTier.values();
        }
    }

    public static class Builder {
        private int temp;
        private GasTier gasTier;
        private int eutOverride = -1;
        private int durationOverride = -1;
        private int vacuumEUtOverride = -1;
        private int vacuumDurationOverride = -1;

        public Builder temp(int temperature) {
            this.temp = temperature;
            return this;
        }

        public Builder temp(int temperature, GasTier gasTier) {
            this.temp = temperature;
            this.gasTier = gasTier;
            return this;
        }

        public Builder blastStats(int eutOverride) {
            this.eutOverride = eutOverride;
            return this;
        }

        public Builder blastStats(int eutOverride, int durationOverride) {
            this.eutOverride = eutOverride;
            this.durationOverride = durationOverride;
            return this;
        }

        public Builder vacuumStats(int eutOverride) {
            this.vacuumEUtOverride = eutOverride;
            return this;
        }

        public Builder vacuumStats(int eutOverride, int durationOverride) {
            this.vacuumEUtOverride = eutOverride;
            this.vacuumDurationOverride = durationOverride;
            return this;
        }

        public BlastProperty build() {
            return new BlastProperty(this.temp, this.gasTier, this.eutOverride, this.durationOverride, this.vacuumEUtOverride, this.vacuumDurationOverride);
        }
    }
}

