/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.materials;

import gregtech.api.fluids.FluidBuilder;
import gregtech.api.fluids.attribute.FluidAttributes;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlag;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.info.MaterialIconSet;
import gregtech.api.util.GTUtility;

public class OrganicChemistryMaterials {
    public static void register() {
        Materials.SiliconeRubber = new Material.Builder(1000, GTUtility.gregtechId("silicone_rubber")).polymer().liquid(new FluidBuilder().temperature(900)).color(0xDCDCDC).flags(MaterialFlags.GENERATE_GEAR, MaterialFlags.GENERATE_RING, MaterialFlags.GENERATE_FOIL).components(Materials.Carbon, 2, Materials.Hydrogen, 6, Materials.Oxygen, 1, Materials.Silicon, 1).build().setFormula("Si(CH3)2O", true);
        Materials.Nitrobenzene = new Material.Builder(1001, GTUtility.gregtechId("nitrobenzene")).gas().color(7358774).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 6, Materials.Hydrogen, 5, Materials.Nitrogen, 1, Materials.Oxygen, 2).build();
        Materials.RawRubber = new Material.Builder(1002, GTUtility.gregtechId("raw_rubber")).polymer().color(13420425).components(Materials.Carbon, 5, Materials.Hydrogen, 8).build();
        Materials.RawStyreneButadieneRubber = new Material.Builder(1003, GTUtility.gregtechId("raw_styrene_butadiene_rubber")).dust().color(5521469).iconSet(MaterialIconSet.SHINY).flags(MaterialFlags.DISABLE_DECOMPOSITION, MaterialFlags.FLAMMABLE).components(Materials.Carbon, 20, Materials.Hydrogen, 26).build().setFormula("(C4H6)3C8H8", true);
        Materials.StyreneButadieneRubber = new Material.Builder(1004, GTUtility.gregtechId("styrene_butadiene_rubber")).polymer().liquid(new FluidBuilder().temperature(1000)).color(2169368).iconSet(MaterialIconSet.SHINY).flags(MaterialFlags.GENERATE_FOIL, MaterialFlags.GENERATE_RING).components(Materials.Carbon, 20, Materials.Hydrogen, 26).build().setFormula("(C4H6)3C8H8", true);
        Materials.PolyvinylAcetate = new Material.Builder(1005, GTUtility.gregtechId("polyvinyl_acetate")).fluid().color(0xFF9955).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 4, Materials.Hydrogen, 6, Materials.Oxygen, 2).build();
        Materials.ReinforcedEpoxyResin = new Material.Builder(1006, GTUtility.gregtechId("reinforced_epoxy_resin")).polymer().liquid(new FluidBuilder().temperature(600)).color(10517008).flags(Materials.STD_METAL, new MaterialFlag[0]).components(Materials.Carbon, 6, Materials.Hydrogen, 4, Materials.Oxygen, 1).build();
        Materials.PolyvinylChloride = new Material.Builder(1007, GTUtility.gregtechId("polyvinyl_chloride")).polymer().liquid(new FluidBuilder().temperature(373)).color(14149350).flags(Materials.EXT_METAL, MaterialFlags.GENERATE_FOIL).components(Materials.Carbon, 2, Materials.Hydrogen, 3, Materials.Chlorine, 1).itemPipeProperties(512, 4.0f).build();
        Materials.PolyphenyleneSulfide = new Material.Builder(1008, GTUtility.gregtechId("polyphenylene_sulfide")).polymer().liquid(new FluidBuilder().temperature(500)).color(0xAA8800).flags(Materials.EXT_METAL, MaterialFlags.GENERATE_FOIL).components(Materials.Carbon, 6, Materials.Hydrogen, 4, Materials.Sulfur, 1).build();
        Materials.GlycerylTrinitrate = new Material.Builder(1009, GTUtility.gregtechId("glyceryl_trinitrate")).liquid(new FluidBuilder().customStill()).color(279612).flags(MaterialFlags.FLAMMABLE, MaterialFlags.EXPLOSIVE).components(Materials.Carbon, 3, Materials.Hydrogen, 5, Materials.Nitrogen, 3, Materials.Oxygen, 9).build();
        Materials.Polybenzimidazole = new Material.Builder(1010, GTUtility.gregtechId("polybenzimidazole")).polymer().liquid(new FluidBuilder().temperature(1450)).color(0x2D2D2D).flags(MaterialFlags.EXCLUDE_BLOCK_CRAFTING_RECIPES, MaterialFlags.GENERATE_FOIL).components(Materials.Carbon, 20, Materials.Hydrogen, 12, Materials.Nitrogen, 4).fluidPipeProperties(1000, 350, true).build();
        Materials.Polydimethylsiloxane = new Material.Builder(1011, GTUtility.gregtechId("polydimethylsiloxane")).dust().color(0xF5F5F5).flags(MaterialFlags.DISABLE_DECOMPOSITION, MaterialFlags.FLAMMABLE).components(Materials.Carbon, 2, Materials.Hydrogen, 6, Materials.Oxygen, 1, Materials.Silicon, 1).build().setFormula("Si(CH3)2O", true);
        Materials.Polyethylene = new Material.Builder(1012, GTUtility.gregtechId("plastic")).polymer(1).liquid(new FluidBuilder().temperature(408)).color(0xC8C8C8).flags(MaterialFlags.GENERATE_FOIL).components(Materials.Carbon, 2, Materials.Hydrogen, 4).fluidPipeProperties(370, 60, true).build();
        Materials.Epoxy = new Material.Builder(1013, GTUtility.gregtechId("epoxy")).polymer(1).liquid(new FluidBuilder().temperature(400)).color(13143060).flags(Materials.STD_METAL, new MaterialFlag[0]).components(Materials.Carbon, 21, Materials.Hydrogen, 25, Materials.Chlorine, 1, Materials.Oxygen, 5).build();
        Materials.Polycaprolactam = new Material.Builder(1015, GTUtility.gregtechId("polycaprolactam")).polymer(1).liquid(new FluidBuilder().temperature(493)).color(0x323232).flags(Materials.STD_METAL, MaterialFlags.GENERATE_FOIL).components(Materials.Carbon, 6, Materials.Hydrogen, 11, Materials.Nitrogen, 1, Materials.Oxygen, 1).build();
        Materials.Polytetrafluoroethylene = new Material.Builder(1016, GTUtility.gregtechId("polytetrafluoroethylene")).polymer(1).liquid(new FluidBuilder().temperature(600)).color(0x646464).flags(Materials.STD_METAL, MaterialFlags.GENERATE_FRAME, MaterialFlags.GENERATE_FOIL).components(Materials.Carbon, 2, Materials.Fluorine, 4).fluidPipeProperties(600, 100, true, true, false, false).build();
        Materials.Sugar = new Material.Builder(1017, GTUtility.gregtechId("sugar")).gem(1).color(0xFAFAFA).iconSet(MaterialIconSet.FINE).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 6, Materials.Hydrogen, 12, Materials.Oxygen, 6).build();
        Materials.Methane = new Material.Builder(1018, GTUtility.gregtechId("methane")).gas(new FluidBuilder().translation("gregtech.fluid.gas_generic")).color(16711800).components(Materials.Carbon, 1, Materials.Hydrogen, 4).build();
        Materials.Epichlorohydrin = new Material.Builder(1019, GTUtility.gregtechId("epichlorohydrin")).liquid(new FluidBuilder().customStill()).color(6556676).components(Materials.Carbon, 3, Materials.Hydrogen, 5, Materials.Chlorine, 1, Materials.Oxygen, 1).build();
        Materials.Monochloramine = new Material.Builder(1020, GTUtility.gregtechId("monochloramine")).gas().color(4169600).components(Materials.Nitrogen, 1, Materials.Hydrogen, 2, Materials.Chlorine, 1).build();
        Materials.Chloroform = new Material.Builder(1021, GTUtility.gregtechId("chloroform")).fluid().color(8989856).components(Materials.Carbon, 1, Materials.Hydrogen, 1, Materials.Chlorine, 3).build();
        Materials.Cumene = new Material.Builder(1022, GTUtility.gregtechId("cumene")).gas().color(0x552200).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 9, Materials.Hydrogen, 12).build();
        Materials.Tetrafluoroethylene = new Material.Builder(1023, GTUtility.gregtechId("tetrafluoroethylene")).gas().color(0x7D7D7D).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 2, Materials.Fluorine, 4).build();
        Materials.Chloromethane = new Material.Builder(1024, GTUtility.gregtechId("chloromethane")).gas().color(13118624).components(Materials.Carbon, 1, Materials.Hydrogen, 3, Materials.Chlorine, 1).build();
        Materials.AllylChloride = new Material.Builder(1025, GTUtility.gregtechId("allyl_chloride")).fluid().color(8904362).components(Materials.Carbon, 2, Materials.Methane, 1, Materials.HydrochloricAcid, 1).build().setFormula("C3H5Cl", true);
        Materials.Isoprene = new Material.Builder(1026, GTUtility.gregtechId("isoprene")).fluid().color(0x141414).components(Materials.Carbon, 5, Materials.Hydrogen, 8).build();
        Materials.Propane = new Material.Builder(1027, GTUtility.gregtechId("propane")).gas().color(16441936).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 3, Materials.Hydrogen, 8).build();
        Materials.Propene = new Material.Builder(1028, GTUtility.gregtechId("propene")).gas().color(0xFFDD55).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 3, Materials.Hydrogen, 6).build();
        Materials.Ethane = new Material.Builder(1029, GTUtility.gregtechId("ethane")).gas().color(0xC8C8FF).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 2, Materials.Hydrogen, 6).build();
        Materials.Butene = new Material.Builder(1030, GTUtility.gregtechId("butene")).gas().color(13586437).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 4, Materials.Hydrogen, 8).build();
        Materials.Butane = new Material.Builder(1031, GTUtility.gregtechId("butane")).gas().color(11941662).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 4, Materials.Hydrogen, 10).build();
        Materials.DissolvedCalciumAcetate = new Material.Builder(1032, GTUtility.gregtechId("dissolved_calcium_acetate")).fluid().color(14469300).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Calcium, 1, Materials.Carbon, 4, Materials.Oxygen, 4, Materials.Hydrogen, 6, Materials.Water, 1).build();
        Materials.VinylAcetate = new Material.Builder(1033, GTUtility.gregtechId("vinyl_acetate")).fluid().color(14791552).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 4, Materials.Hydrogen, 6, Materials.Oxygen, 2).build();
        Materials.MethylAcetate = new Material.Builder(1034, GTUtility.gregtechId("methyl_acetate")).fluid().color(15648431).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 3, Materials.Hydrogen, 6, Materials.Oxygen, 2).build();
        Materials.Ethenone = new Material.Builder(1035, GTUtility.gregtechId("ethenone")).fluid().color(0x141446).components(Materials.Carbon, 2, Materials.Hydrogen, 2, Materials.Oxygen, 1).build();
        Materials.Tetranitromethane = new Material.Builder(1036, GTUtility.gregtechId("tetranitromethane")).fluid().color(993320).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 1, Materials.Nitrogen, 4, Materials.Oxygen, 8).build();
        Materials.Dimethylamine = new Material.Builder(1037, GTUtility.gregtechId("dimethylamine")).gas().color(5588073).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 2, Materials.Hydrogen, 7, Materials.Nitrogen, 1).build();
        Materials.Dimethylhydrazine = new Material.Builder(1038, GTUtility.gregtechId("dimethylhydrazine")).fluid().color(85).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 2, Materials.Hydrogen, 8, Materials.Nitrogen, 2).build();
        Materials.DinitrogenTetroxide = new Material.Builder(1039, GTUtility.gregtechId("dinitrogen_tetroxide")).gas().color(5704706).components(Materials.Nitrogen, 2, Materials.Oxygen, 4).build();
        Materials.Dimethyldichlorosilane = new Material.Builder(1040, GTUtility.gregtechId("dimethyldichlorosilane")).gas().color(4462160).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 2, Materials.Hydrogen, 6, Materials.Chlorine, 2, Materials.Silicon, 1).build().setFormula("Si(CH3)2Cl2", true);
        Materials.Styrene = new Material.Builder(1041, GTUtility.gregtechId("styrene")).fluid().color(13813950).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 8, Materials.Hydrogen, 8).build();
        Materials.Butadiene = new Material.Builder(1042, GTUtility.gregtechId("butadiene")).gas().color(11885072).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 4, Materials.Hydrogen, 6).build();
        Materials.Dichlorobenzene = new Material.Builder(1043, GTUtility.gregtechId("dichlorobenzene")).fluid().color(17493).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 6, Materials.Hydrogen, 4, Materials.Chlorine, 2).build();
        Materials.AceticAcid = new Material.Builder(1044, GTUtility.gregtechId("acetic_acid")).liquid(new FluidBuilder().attribute(FluidAttributes.ACID)).color(13153440).components(Materials.Carbon, 2, Materials.Hydrogen, 4, Materials.Oxygen, 2).build();
        Materials.Phenol = new Material.Builder(1045, GTUtility.gregtechId("phenol")).fluid().color(7881761).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 6, Materials.Hydrogen, 6, Materials.Oxygen, 1).build();
        Materials.BisphenolA = new Material.Builder(1046, GTUtility.gregtechId("bisphenol_a")).fluid().color(13937152).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 15, Materials.Hydrogen, 16, Materials.Oxygen, 2).build();
        Materials.VinylChloride = new Material.Builder(1047, GTUtility.gregtechId("vinyl_chloride")).gas().color(14807280).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 2, Materials.Hydrogen, 3, Materials.Chlorine, 1).build();
        Materials.Ethylene = new Material.Builder(1048, GTUtility.gregtechId("ethylene")).gas().color(0xE1E1E1).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 2, Materials.Hydrogen, 4).build();
        Materials.Benzene = new Material.Builder(1049, GTUtility.gregtechId("benzene")).fluid().color(0x1A1A1A).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 6, Materials.Hydrogen, 6).build();
        Materials.Acetone = new Material.Builder(1050, GTUtility.gregtechId("acetone")).fluid().color(0xAFAFAF).components(Materials.Carbon, 3, Materials.Hydrogen, 6, Materials.Oxygen, 1).build();
        Materials.Glycerol = new Material.Builder(1051, GTUtility.gregtechId("glycerol")).fluid().color(8904327).components(Materials.Carbon, 3, Materials.Hydrogen, 8, Materials.Oxygen, 3).build();
        Materials.Methanol = new Material.Builder(1052, GTUtility.gregtechId("methanol")).fluid().color(0xAA8800).components(Materials.Carbon, 1, Materials.Hydrogen, 4, Materials.Oxygen, 1).build();
        Materials.Ethanol = new Material.Builder(1054, GTUtility.gregtechId("ethanol")).liquid(new FluidBuilder().customStill().alternativeName("bio.ethanol")).color(16534532).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 2, Materials.Hydrogen, 6, Materials.Oxygen, 1).build();
        Materials.Toluene = new Material.Builder(1055, GTUtility.gregtechId("toluene")).liquid(new FluidBuilder().customStill()).color(7414784).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 7, Materials.Hydrogen, 8).build();
        Materials.DiphenylIsophtalate = new Material.Builder(1056, GTUtility.gregtechId("diphenyl_isophthalate")).fluid().color(2387543).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 20, Materials.Hydrogen, 14, Materials.Oxygen, 4).build();
        Materials.PhthalicAcid = new Material.Builder(1057, GTUtility.gregtechId("phthalic_acid")).liquid(new FluidBuilder().attribute(FluidAttributes.ACID)).color(0xD1D1D1).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 8, Materials.Hydrogen, 6, Materials.Oxygen, 4).build().setFormula("C6H4(CO2H)2", true);
        Materials.Dimethylbenzene = new Material.Builder(1058, GTUtility.gregtechId("dimethylbenzene")).fluid().color(6724672).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 8, Materials.Hydrogen, 10).build().setFormula("C6H4(CH3)2", true);
        Materials.Diaminobenzidine = new Material.Builder(1059, GTUtility.gregtechId("diaminobenzidine")).fluid().color(3374425).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 12, Materials.Hydrogen, 14, Materials.Nitrogen, 4).build().setFormula("(C6H3(NH2)2)2", true);
        Materials.Dichlorobenzidine = new Material.Builder(1060, GTUtility.gregtechId("dichlorobenzidine")).fluid().color(10608294).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 12, Materials.Hydrogen, 10, Materials.Chlorine, 2, Materials.Nitrogen, 2).build().setFormula("(C6H3Cl(NH2))2", true);
        Materials.Nitrochlorobenzene = new Material.Builder(1061, GTUtility.gregtechId("nitrochlorobenzene")).fluid().color(9418010).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 6, Materials.Hydrogen, 4, Materials.Chlorine, 1, Materials.Nitrogen, 1, Materials.Oxygen, 2).build();
        Materials.Chlorobenzene = new Material.Builder(1062, GTUtility.gregtechId("chlorobenzene")).fluid().color(3303998).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 6, Materials.Hydrogen, 5, Materials.Chlorine, 1).build();
        Materials.Octane = new Material.Builder(1063, GTUtility.gregtechId("octane")).fluid().flags(MaterialFlags.DISABLE_DECOMPOSITION).color(9046537).components(Materials.Carbon, 8, Materials.Hydrogen, 18).build();
        Materials.EthylTertButylEther = new Material.Builder(1064, GTUtility.gregtechId("ethyl_tertbutyl_ether")).fluid().flags(MaterialFlags.DISABLE_DECOMPOSITION).color(11623430).components(Materials.Carbon, 6, Materials.Hydrogen, 14, Materials.Oxygen, 1).build();
        Materials.Ethylbenzene = new Material.Builder(1066, GTUtility.gregtechId("ethylbenzene")).fluid().flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 8, Materials.Hydrogen, 10).build();
        Materials.Naphthalene = new Material.Builder(1067, GTUtility.gregtechId("naphthalene")).fluid().flags(MaterialFlags.DISABLE_DECOMPOSITION).color(16053463).components(Materials.Carbon, 10, Materials.Hydrogen, 8).build();
        Materials.Rubber = new Material.Builder(1068, GTUtility.gregtechId("rubber")).polymer(0).liquid(new FluidBuilder().temperature(400)).color(0).iconSet(MaterialIconSet.SHINY).flags(MaterialFlags.GENERATE_GEAR, MaterialFlags.GENERATE_RING, MaterialFlags.GENERATE_FOIL, MaterialFlags.GENERATE_BOLT_SCREW).components(Materials.Carbon, 5, Materials.Hydrogen, 8).build();
        Materials.Cyclohexane = new Material.Builder(1069, GTUtility.gregtechId("cyclohexane")).fluid().color(-218959129).components(Materials.Carbon, 6, Materials.Hydrogen, 12).build();
        Materials.NitrosylChloride = new Material.Builder(1070, GTUtility.gregtechId("nitrosyl_chloride")).gas().flags(MaterialFlags.FLAMMABLE).color(15986944).components(Materials.Nitrogen, 1, Materials.Oxygen, 1, Materials.Chlorine, 1).build();
        Materials.CyclohexanoneOxime = new Material.Builder(1071, GTUtility.gregtechId("cyclohexanone_oxime")).dust().flags(MaterialFlags.DISABLE_DECOMPOSITION, MaterialFlags.FLAMMABLE).color(15461360).iconSet(MaterialIconSet.ROUGH).components(Materials.Carbon, 6, Materials.Hydrogen, 11, Materials.Nitrogen, 1, Materials.Oxygen, 1).build().setFormula("C6H11NO", true);
        Materials.Caprolactam = new Material.Builder(1072, GTUtility.gregtechId("caprolactam")).dust().flags(MaterialFlags.DISABLE_DECOMPOSITION, MaterialFlags.FLAMMABLE).color(0x676768).components(Materials.Carbon, 6, Materials.Hydrogen, 11, Materials.Nitrogen, 1, Materials.Oxygen, 1).build().setFormula("(CH2)5C(O)NH", true);
        Materials.Butyraldehyde = new Material.Builder(1073, GTUtility.gregtechId("butyraldehyde")).fluid().color(5589567).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 4, Materials.Hydrogen, 8, Materials.Oxygen, 1).build();
        Materials.PolyvinylButyral = new Material.Builder(1074, GTUtility.gregtechId("polyvinyl_butyral")).ingot().fluid().color(3439937).flags(MaterialFlags.GENERATE_PLATE, MaterialFlags.DISABLE_DECOMPOSITION, MaterialFlags.NO_SMASHING).components(Materials.Butyraldehyde, 1, Materials.PolyvinylAcetate, 1).build();
        Materials.Biphenyl = new Material.Builder(1075, GTUtility.gregtechId("biphenyl")).dust().color(9145423).iconSet(MaterialIconSet.FINE).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 12, Materials.Hydrogen, 10).build().setFormula("(C6H5)2", true);
        Materials.PolychlorinatedBiphenyl = new Material.Builder(1076, GTUtility.gregtechId("polychlorinated_biphenyl")).fluid().color(13290510).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 12, Materials.Hydrogen, 8, Materials.Chlorine, 2).build().setFormula("(C6H4Cl)2", true);
    }
}

