/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.materials;

import gregtech.api.GTValues;
import gregtech.api.fluids.FluidBuilder;
import gregtech.api.fluids.FluidState;
import gregtech.api.fluids.attribute.FluidAttributes;
import gregtech.api.fluids.store.FluidStorageKeys;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlag;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.info.MaterialIconSet;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.material.properties.ToolProperty;
import gregtech.api.util.GTUtility;
import net.minecraft.init.Enchantments;
import net.minecraftforge.fluids.FluidRegistry;

public class FirstDegreeMaterials {
    public static void register() {
        Materials.Almandine = new Material.Builder(250, GTUtility.gregtechId("almandine")).gem(1).ore(3, 1).color(0xFF0000).components(Materials.Aluminium, 2, Materials.Iron, 3, Materials.Silicon, 3, Materials.Oxygen, 12).build();
        Materials.Andradite = new Material.Builder(251, GTUtility.gregtechId("andradite")).gem(1).color(9861120).iconSet(MaterialIconSet.RUBY).components(Materials.Calcium, 3, Materials.Iron, 2, Materials.Silicon, 3, Materials.Oxygen, 12).build();
        Materials.AnnealedCopper = new Material.Builder(252, GTUtility.gregtechId("annealed_copper")).ingot().liquid(new FluidBuilder().temperature(1358)).color(16747835).iconSet(MaterialIconSet.BRIGHT).flags(Materials.EXT2_METAL, MaterialFlags.MORTAR_GRINDABLE, MaterialFlags.GENERATE_FINE_WIRE).components(Materials.Copper, 1).cableProperties(GTValues.V[2], 1, 1).build();
        Materials.Copper.getProperty(PropertyKey.INGOT).setArcSmeltingInto(Materials.AnnealedCopper);
        Materials.Asbestos = new Material.Builder(253, GTUtility.gregtechId("asbestos")).dust(1).ore(3, 1).color(0xE6E6E6).components(Materials.Magnesium, 3, Materials.Silicon, 2, Materials.Hydrogen, 4, Materials.Oxygen, 9).build();
        Materials.Ash = new Material.Builder(254, GTUtility.gregtechId("ash")).dust(1).color(0x969696).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 1).build();
        Materials.BandedIron = new Material.Builder(255, GTUtility.gregtechId("banded_iron")).dust().ore().color(9525850).components(Materials.Iron, 2, Materials.Oxygen, 3).build();
        Materials.BatteryAlloy = new Material.Builder(256, GTUtility.gregtechId("battery_alloy")).ingot(1).liquid(new FluidBuilder().temperature(660)).color(10255520).flags(Materials.EXT_METAL, new MaterialFlag[0]).components(Materials.Lead, 4, Materials.Antimony, 1).build();
        Materials.BlueTopaz = new Material.Builder(257, GTUtility.gregtechId("blue_topaz")).gem(3).ore(2, 1).color(8099548).iconSet(MaterialIconSet.GEM_HORIZONTAL).flags(Materials.EXT_METAL, MaterialFlags.NO_SMASHING, MaterialFlags.NO_SMELTING, MaterialFlags.HIGH_SIFTER_OUTPUT).components(Materials.Aluminium, 2, Materials.Silicon, 1, Materials.Fluorine, 2, Materials.Hydrogen, 2, Materials.Oxygen, 6).build();
        Materials.Bone = new Material.Builder(258, GTUtility.gregtechId("bone")).dust(1).color(0xFAFAFA).flags(MaterialFlags.MORTAR_GRINDABLE, MaterialFlags.EXCLUDE_BLOCK_CRAFTING_BY_HAND_RECIPES).components(Materials.Calcium, 1).build();
        Materials.Brass = new Material.Builder(259, GTUtility.gregtechId("brass")).ingot(1).liquid(new FluidBuilder().temperature(1160)).color(16757760).iconSet(MaterialIconSet.METALLIC).flags(Materials.EXT2_METAL, MaterialFlags.MORTAR_GRINDABLE, MaterialFlags.GENERATE_DOUBLE_PLATE).components(Materials.Zinc, 1, Materials.Copper, 3).rotorStats(8.0f, 3.0f, 152).itemPipeProperties(2048, 1.0f).build();
        Materials.Bronze = new Material.Builder(260, GTUtility.gregtechId("bronze")).ingot().liquid(new FluidBuilder().temperature(1357)).color(0xFF8000).iconSet(MaterialIconSet.METALLIC).flags(Materials.EXT2_METAL, MaterialFlags.MORTAR_GRINDABLE, MaterialFlags.GENERATE_ROTOR, MaterialFlags.GENERATE_FRAME, MaterialFlags.GENERATE_SMALL_GEAR, MaterialFlags.GENERATE_FOIL, MaterialFlags.GENERATE_GEAR, MaterialFlags.GENERATE_DOUBLE_PLATE).components(Materials.Tin, 1, Materials.Copper, 3).toolStats(ToolProperty.Builder.of(3.0f, 2.0f, 192, 2).enchantability(18).build()).rotorStats(6.0f, 2.5f, 192).fluidPipeProperties(1696, 20, true).build();
        Materials.BrownLimonite = new Material.Builder(261, GTUtility.gregtechId("brown_limonite")).dust(1).ore().color(13132800).iconSet(MaterialIconSet.METALLIC).flags(MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING, MaterialFlags.BLAST_FURNACE_CALCITE_TRIPLE).components(Materials.Iron, 1, Materials.Hydrogen, 1, Materials.Oxygen, 2).build();
        Materials.Calcite = new Material.Builder(262, GTUtility.gregtechId("calcite")).dust(1).ore().color(16443100).components(Materials.Calcium, 1, Materials.Carbon, 1, Materials.Oxygen, 3).build();
        Materials.Cassiterite = new Material.Builder(263, GTUtility.gregtechId("cassiterite")).dust(1).ore(2, 1).color(0xDCDCDC).iconSet(MaterialIconSet.METALLIC).components(Materials.Tin, 1, Materials.Oxygen, 2).build();
        Materials.CassiteriteSand = new Material.Builder(264, GTUtility.gregtechId("cassiterite_sand")).dust(1).ore(2, 1).color(0xDCDCDC).iconSet(MaterialIconSet.SAND).components(Materials.Tin, 1, Materials.Oxygen, 2).build();
        Materials.Chalcopyrite = new Material.Builder(265, GTUtility.gregtechId("chalcopyrite")).dust(1).ore().color(10516520).components(Materials.Copper, 1, Materials.Iron, 1, Materials.Sulfur, 2).build();
        Materials.Charcoal = new Material.Builder(266, GTUtility.gregtechId("charcoal")).gem(1, 1600).color(0x644646).iconSet(MaterialIconSet.FINE).flags(MaterialFlags.FLAMMABLE, MaterialFlags.NO_SMELTING, MaterialFlags.NO_SMASHING, MaterialFlags.MORTAR_GRINDABLE).components(Materials.Carbon, 1).build();
        Materials.Chromite = new Material.Builder(267, GTUtility.gregtechId("chromite")).dust(1).ore().color(2298895).iconSet(MaterialIconSet.METALLIC).components(Materials.Iron, 1, Materials.Chrome, 2, Materials.Oxygen, 4).build();
        Materials.Cinnabar = new Material.Builder(268, GTUtility.gregtechId("cinnabar")).dust(1).ore().color(0x960000).iconSet(MaterialIconSet.EMERALD).flags(MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING).components(Materials.Mercury, 1, Materials.Sulfur, 1).build();
        Materials.Water = new Material.Builder(269, GTUtility.gregtechId("water")).fluid(FluidRegistry.WATER, FluidStorageKeys.LIQUID, FluidState.LIQUID).color(255).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Hydrogen, 2, Materials.Oxygen, 1).build();
        Materials.Coal = new Material.Builder(271, GTUtility.gregtechId("coal")).gem(1, 1600).ore(2, 1).color(0x464646).iconSet(MaterialIconSet.LIGNITE).flags(MaterialFlags.FLAMMABLE, MaterialFlags.NO_SMELTING, MaterialFlags.NO_SMASHING, MaterialFlags.MORTAR_GRINDABLE, MaterialFlags.EXCLUDE_BLOCK_CRAFTING_BY_HAND_RECIPES, MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 1).build();
        Materials.Cobaltite = new Material.Builder(272, GTUtility.gregtechId("cobaltite")).dust(1).ore().color(5263610).iconSet(MaterialIconSet.METALLIC).components(Materials.Cobalt, 1, Materials.Arsenic, 1, Materials.Sulfur, 1).build();
        Materials.Cooperite = new Material.Builder(273, GTUtility.gregtechId("cooperite")).dust(1).ore().color(0xFFFFC8).iconSet(MaterialIconSet.METALLIC).components(Materials.Platinum, 3, Materials.Nickel, 1, Materials.Sulfur, 1, Materials.Palladium, 1).build();
        Materials.Cupronickel = new Material.Builder(274, GTUtility.gregtechId("cupronickel")).ingot(1).liquid(new FluidBuilder().temperature(1542)).color(14915200).iconSet(MaterialIconSet.METALLIC).flags(Materials.EXT_METAL, MaterialFlags.GENERATE_SPRING, MaterialFlags.GENERATE_FINE_WIRE, MaterialFlags.GENERATE_DOUBLE_PLATE).components(Materials.Copper, 1, Materials.Nickel, 1).itemPipeProperties(2048, 1.0f).cableProperties(GTValues.V[2], 1, 1).build();
        Materials.DarkAsh = new Material.Builder(275, GTUtility.gregtechId("dark_ash")).dust(1).color(0x323232).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 1).build();
        Materials.Diamond = new Material.Builder(276, GTUtility.gregtechId("diamond")).gem(3).ore().color(0xC8FFFF).iconSet(MaterialIconSet.DIAMOND).flags(MaterialFlags.GENERATE_BOLT_SCREW, MaterialFlags.GENERATE_LENS, MaterialFlags.GENERATE_GEAR, MaterialFlags.NO_SMASHING, MaterialFlags.NO_SMELTING, MaterialFlags.HIGH_SIFTER_OUTPUT, MaterialFlags.DISABLE_DECOMPOSITION, MaterialFlags.EXCLUDE_BLOCK_CRAFTING_BY_HAND_RECIPES).components(Materials.Carbon, 1).toolStats(ToolProperty.Builder.of(6.0f, 7.0f, 768, 3).attackSpeed(0.1f).enchantability(18).build()).build();
        Materials.Electrum = new Material.Builder(277, GTUtility.gregtechId("electrum")).ingot().liquid(new FluidBuilder().temperature(1285)).color(0xFFFF64).iconSet(MaterialIconSet.SHINY).flags(Materials.EXT2_METAL, MaterialFlags.MORTAR_GRINDABLE, MaterialFlags.GENERATE_FINE_WIRE, MaterialFlags.GENERATE_RING, MaterialFlags.GENERATE_DOUBLE_PLATE).components(Materials.Silver, 1, Materials.Gold, 1).itemPipeProperties(1024, 2.0f).cableProperties(GTValues.V[3], 2, 2).build();
        Materials.Emerald = new Material.Builder(278, GTUtility.gregtechId("emerald")).gem().ore(2, 1).color(0x50FF50).iconSet(MaterialIconSet.EMERALD).flags(Materials.EXT_METAL, MaterialFlags.NO_SMASHING, MaterialFlags.NO_SMELTING, MaterialFlags.HIGH_SIFTER_OUTPUT, MaterialFlags.EXCLUDE_BLOCK_CRAFTING_BY_HAND_RECIPES, MaterialFlags.GENERATE_LENS).components(Materials.Beryllium, 3, Materials.Aluminium, 2, Materials.Silicon, 6, Materials.Oxygen, 18).build();
        Materials.Galena = new Material.Builder(279, GTUtility.gregtechId("galena")).dust(3).ore().color(6569060).flags(MaterialFlags.NO_SMELTING).components(Materials.Lead, 1, Materials.Sulfur, 1).build();
        Materials.Garnierite = new Material.Builder(280, GTUtility.gregtechId("garnierite")).dust(3).ore().color(3328070).iconSet(MaterialIconSet.METALLIC).components(Materials.Nickel, 1, Materials.Oxygen, 1).build();
        Materials.GreenSapphire = new Material.Builder(281, GTUtility.gregtechId("green_sapphire")).gem().ore().color(6604930).iconSet(MaterialIconSet.GEM_HORIZONTAL).flags(Materials.EXT_METAL, MaterialFlags.NO_SMASHING, MaterialFlags.NO_SMELTING, MaterialFlags.HIGH_SIFTER_OUTPUT).components(Materials.Aluminium, 2, Materials.Oxygen, 3).build();
        Materials.Grossular = new Material.Builder(282, GTUtility.gregtechId("grossular")).gem(1).ore(3, 1).color(13132800).iconSet(MaterialIconSet.RUBY).components(Materials.Calcium, 3, Materials.Aluminium, 2, Materials.Silicon, 3, Materials.Oxygen, 12).build();
        Materials.Ice = new Material.Builder(283, GTUtility.gregtechId("ice")).dust(0).liquid(new FluidBuilder().temperature(273).customStill().alternativeName("fluid.ice")).color(0xC8C8FF).iconSet(MaterialIconSet.SHINY).flags(MaterialFlags.NO_SMASHING, MaterialFlags.EXCLUDE_BLOCK_CRAFTING_BY_HAND_RECIPES, MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Hydrogen, 2, Materials.Oxygen, 1).build();
        Materials.Ilmenite = new Material.Builder(284, GTUtility.gregtechId("ilmenite")).dust(3).ore().color(4601650).iconSet(MaterialIconSet.METALLIC).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Iron, 1, Materials.Titanium, 1, Materials.Oxygen, 3).build();
        Materials.Rutile = new Material.Builder(285, GTUtility.gregtechId("rutile")).gem().color(13897052).iconSet(MaterialIconSet.GEM_HORIZONTAL).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Titanium, 1, Materials.Oxygen, 2).build();
        Materials.Bauxite = new Material.Builder(286, GTUtility.gregtechId("bauxite")).dust(1).ore().color(13132800).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Aluminium, 2, Materials.Oxygen, 3).build();
        Materials.Invar = new Material.Builder(287, GTUtility.gregtechId("invar")).ingot().liquid(new FluidBuilder().temperature(1916)).color(11842680).iconSet(MaterialIconSet.METALLIC).flags(Materials.EXT2_METAL, MaterialFlags.MORTAR_GRINDABLE, MaterialFlags.GENERATE_FRAME, MaterialFlags.GENERATE_GEAR).components(Materials.Iron, 2, Materials.Nickel, 1).toolStats(ToolProperty.Builder.of(4.0f, 3.0f, 384, 2).enchantability(18).enchantment(Enchantments.field_180312_n, 3).enchantment(Enchantments.field_185305_q, 1).build()).rotorStats(7.0f, 3.0f, 512).build();
        Materials.Kanthal = new Material.Builder(288, GTUtility.gregtechId("kanthal")).ingot().liquid(new FluidBuilder().temperature(1708)).color(12767967).iconSet(MaterialIconSet.METALLIC).flags(Materials.EXT_METAL, MaterialFlags.GENERATE_SPRING).components(Materials.Iron, 1, Materials.Aluminium, 1, Materials.Chrome, 1).cableProperties(GTValues.V[3], 4, 3).blast(b -> b.temp(1800, BlastProperty.GasTier.LOW).blastStats(GTValues.VA[3], 900)).build();
        Materials.Lazurite = new Material.Builder(289, GTUtility.gregtechId("lazurite")).gem(1).ore(6, 4).color(6584575).iconSet(MaterialIconSet.LAPIS).flags(MaterialFlags.GENERATE_PLATE, MaterialFlags.NO_SMASHING, MaterialFlags.NO_SMELTING, MaterialFlags.CRYSTALLIZABLE, MaterialFlags.GENERATE_ROD, MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING).components(Materials.Aluminium, 6, Materials.Silicon, 6, Materials.Calcium, 8, Materials.Sodium, 8).build();
        Materials.Magnalium = new Material.Builder(290, GTUtility.gregtechId("magnalium")).ingot().liquid(new FluidBuilder().temperature(929)).color(13156095).flags(Materials.EXT2_METAL, MaterialFlags.GENERATE_DOUBLE_PLATE).components(Materials.Magnesium, 1, Materials.Aluminium, 2).rotorStats(6.0f, 2.0f, 256).itemPipeProperties(1024, 2.0f).build();
        Materials.Magnesite = new Material.Builder(291, GTUtility.gregtechId("magnesite")).dust().ore().color(16448180).iconSet(MaterialIconSet.METALLIC).components(Materials.Magnesium, 1, Materials.Carbon, 1, Materials.Oxygen, 3).build();
        Materials.Magnetite = new Material.Builder(292, GTUtility.gregtechId("magnetite")).dust().ore().color(0x1E1E1E).iconSet(MaterialIconSet.METALLIC).components(Materials.Iron, 3, Materials.Oxygen, 4).build();
        Materials.Molybdenite = new Material.Builder(293, GTUtility.gregtechId("molybdenite")).dust().ore().color(0x191919).iconSet(MaterialIconSet.METALLIC).components(Materials.Molybdenum, 1, Materials.Sulfur, 2).build();
        Materials.Nichrome = new Material.Builder(294, GTUtility.gregtechId("nichrome")).ingot().liquid(new FluidBuilder().temperature(1818)).color(13487862).iconSet(MaterialIconSet.METALLIC).flags(Materials.EXT_METAL, MaterialFlags.GENERATE_SPRING).components(Materials.Nickel, 4, Materials.Chrome, 1).cableProperties(GTValues.V[4], 4, 4).blast(b -> b.temp(2700, BlastProperty.GasTier.LOW).blastStats(GTValues.VA[4], 1000).vacuumStats(GTValues.VA[3])).build();
        Materials.NiobiumNitride = new Material.Builder(295, GTUtility.gregtechId("niobium_nitride")).ingot().fluid().color(1911069).flags(Materials.EXT_METAL, MaterialFlags.GENERATE_FOIL).components(Materials.Niobium, 1, Materials.Nitrogen, 1).cableProperties(GTValues.V[6], 1, 1).blast(2846, BlastProperty.GasTier.MID).build();
        Materials.NiobiumTitanium = new Material.Builder(296, GTUtility.gregtechId("niobium_titanium")).ingot().liquid(new FluidBuilder().temperature(2345)).color(1908009).flags(Materials.EXT2_METAL, MaterialFlags.GENERATE_SPRING, MaterialFlags.GENERATE_SPRING_SMALL, MaterialFlags.GENERATE_FOIL, MaterialFlags.GENERATE_FINE_WIRE, MaterialFlags.GENERATE_DOUBLE_PLATE).components(Materials.Niobium, 1, Materials.Titanium, 1).fluidPipeProperties(5900, 175, true).cableProperties(GTValues.V[6], 4, 2).blast(b -> b.temp(4500, BlastProperty.GasTier.HIGH).blastStats(GTValues.VA[3], 1500).vacuumStats(GTValues.VA[3], 200)).build();
        Materials.Obsidian = new Material.Builder(297, GTUtility.gregtechId("obsidian")).dust(3).color(5255780).flags(MaterialFlags.NO_SMASHING, MaterialFlags.EXCLUDE_BLOCK_CRAFTING_RECIPES, MaterialFlags.GENERATE_PLATE, MaterialFlags.GENERATE_DENSE).components(Materials.Magnesium, 1, Materials.Iron, 1, Materials.Silicon, 2, Materials.Oxygen, 4).build();
        Materials.Phosphate = new Material.Builder(298, GTUtility.gregtechId("phosphate")).dust(1).color(0xFFFF00).flags(MaterialFlags.NO_SMASHING, MaterialFlags.NO_SMELTING, MaterialFlags.FLAMMABLE, MaterialFlags.EXPLOSIVE).components(Materials.Phosphorus, 1, Materials.Oxygen, 4).build();
        Materials.PlatinumRaw = new Material.Builder(299, GTUtility.gregtechId("platinum_raw")).dust().color(0xFFFFC8).iconSet(MaterialIconSet.METALLIC).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Platinum, 1, Materials.Chlorine, 2).build();
        Materials.SterlingSilver = new Material.Builder(300, GTUtility.gregtechId("sterling_silver")).ingot().liquid(new FluidBuilder().temperature(1258)).color(16440545).iconSet(MaterialIconSet.SHINY).flags(Materials.EXT2_METAL, MaterialFlags.GENERATE_GEAR, MaterialFlags.GENERATE_DOUBLE_PLATE).components(Materials.Copper, 1, Materials.Silver, 4).toolStats(ToolProperty.Builder.of(3.0f, 8.0f, 768, 2).attackSpeed(0.3f).enchantability(33).enchantment(Enchantments.field_185303_l, 3).build()).rotorStats(13.0f, 2.0f, 196).itemPipeProperties(1024, 2.0f).blast(b -> b.temp(1700, BlastProperty.GasTier.LOW).blastStats(GTValues.VA[2], 1000)).build();
        Materials.RoseGold = new Material.Builder(301, GTUtility.gregtechId("rose_gold")).ingot().liquid(new FluidBuilder().temperature(1341)).color(16770590).iconSet(MaterialIconSet.SHINY).flags(Materials.EXT2_METAL, MaterialFlags.GENERATE_RING, MaterialFlags.GENERATE_GEAR, MaterialFlags.GENERATE_DOUBLE_PLATE).components(Materials.Copper, 1, Materials.Gold, 4).toolStats(ToolProperty.Builder.of(12.0f, 2.0f, 768, 2).enchantability(33).enchantment(Enchantments.field_185308_t, 2).build()).rotorStats(14.0f, 2.0f, 152).itemPipeProperties(1024, 2.0f).blast(b -> b.temp(1600, BlastProperty.GasTier.LOW).blastStats(GTValues.VA[2], 1000)).build();
        Materials.BlackBronze = new Material.Builder(302, GTUtility.gregtechId("black_bronze")).ingot().liquid(new FluidBuilder().temperature(1328)).color(6566525).flags(Materials.EXT2_METAL, MaterialFlags.GENERATE_GEAR, MaterialFlags.GENERATE_DOUBLE_PLATE).components(Materials.Gold, 1, Materials.Silver, 1, Materials.Copper, 3).rotorStats(12.0f, 2.0f, 256).itemPipeProperties(1024, 2.0f).blast(b -> b.temp(2000, BlastProperty.GasTier.LOW).blastStats(GTValues.VA[2], 1000)).build();
        Materials.BismuthBronze = new Material.Builder(303, GTUtility.gregtechId("bismuth_bronze")).ingot().liquid(new FluidBuilder().temperature(1036)).color(6585725).flags(Materials.EXT2_METAL, new MaterialFlag[0]).components(Materials.Bismuth, 1, Materials.Zinc, 1, Materials.Copper, 3).rotorStats(8.0f, 3.0f, 256).blast(b -> b.temp(1100, BlastProperty.GasTier.LOW).blastStats(GTValues.VA[2], 1000)).build();
        Materials.Biotite = new Material.Builder(304, GTUtility.gregtechId("biotite")).dust(1).color(0x141E14).iconSet(MaterialIconSet.METALLIC).components(Materials.Potassium, 1, Materials.Magnesium, 3, Materials.Aluminium, 3, Materials.Fluorine, 2, Materials.Silicon, 3, Materials.Oxygen, 10).build();
        Materials.Powellite = new Material.Builder(305, GTUtility.gregtechId("powellite")).dust().ore().color(0xFFFF00).components(Materials.Calcium, 1, Materials.Molybdenum, 1, Materials.Oxygen, 4).build();
        Materials.Pyrite = new Material.Builder(306, GTUtility.gregtechId("pyrite")).dust(1).ore().color(9861160).iconSet(MaterialIconSet.ROUGH).flags(MaterialFlags.BLAST_FURNACE_CALCITE_DOUBLE).components(Materials.Iron, 1, Materials.Sulfur, 2).build();
        Materials.Pyrolusite = new Material.Builder(307, GTUtility.gregtechId("pyrolusite")).dust().ore().color(0x9696AA).components(Materials.Manganese, 1, Materials.Oxygen, 2).build();
        Materials.Pyrope = new Material.Builder(308, GTUtility.gregtechId("pyrope")).gem().ore(3, 1).color(7877220).iconSet(MaterialIconSet.RUBY).components(Materials.Aluminium, 2, Materials.Magnesium, 3, Materials.Silicon, 3, Materials.Oxygen, 12).build();
        Materials.RockSalt = new Material.Builder(309, GTUtility.gregtechId("rock_salt")).gem(1).ore(2, 1).color(15780040).iconSet(MaterialIconSet.FINE).flags(MaterialFlags.NO_SMASHING).components(Materials.Potassium, 1, Materials.Chlorine, 1).build();
        Materials.Ruridit = new Material.Builder(310, GTUtility.gregtechId("ruridit")).ingot(3).fluid().colorAverage().iconSet(MaterialIconSet.BRIGHT).flags(MaterialFlags.GENERATE_FINE_WIRE, MaterialFlags.GENERATE_GEAR, MaterialFlags.GENERATE_LONG_ROD, MaterialFlags.GENERATE_BOLT_SCREW, MaterialFlags.GENERATE_FRAME).components(Materials.Ruthenium, 2, Materials.Iridium, 1).blast(b -> b.temp(4500, BlastProperty.GasTier.HIGH).blastStats(GTValues.VA[4], 1600).vacuumStats(GTValues.VA[3], 300)).build();
        Materials.Ruby = new Material.Builder(311, GTUtility.gregtechId("ruby")).gem().ore().color(0xFF6464).iconSet(MaterialIconSet.RUBY).flags(Materials.EXT_METAL, MaterialFlags.NO_SMASHING, MaterialFlags.NO_SMELTING, MaterialFlags.HIGH_SIFTER_OUTPUT, MaterialFlags.GENERATE_LENS).components(Materials.Chrome, 1, Materials.Aluminium, 2, Materials.Oxygen, 3).build();
        Materials.Salt = new Material.Builder(312, GTUtility.gregtechId("salt")).gem(1).ore(2, 1).color(0xFAFAFA).iconSet(MaterialIconSet.FINE).flags(MaterialFlags.NO_SMASHING).components(Materials.Sodium, 1, Materials.Chlorine, 1).build();
        Materials.Saltpeter = new Material.Builder(313, GTUtility.gregtechId("saltpeter")).dust(1).ore(2, 1).color(0xE6E6E6).iconSet(MaterialIconSet.FINE).flags(MaterialFlags.NO_SMASHING, MaterialFlags.NO_SMELTING, MaterialFlags.FLAMMABLE).components(Materials.Potassium, 1, Materials.Nitrogen, 1, Materials.Oxygen, 3).build();
        Materials.Sapphire = new Material.Builder(314, GTUtility.gregtechId("sapphire")).gem().ore().color(6579400).iconSet(MaterialIconSet.GEM_VERTICAL).flags(Materials.EXT_METAL, MaterialFlags.NO_SMASHING, MaterialFlags.NO_SMELTING, MaterialFlags.HIGH_SIFTER_OUTPUT, MaterialFlags.GENERATE_LENS).components(Materials.Aluminium, 2, Materials.Oxygen, 3).build();
        Materials.Scheelite = new Material.Builder(315, GTUtility.gregtechId("scheelite")).dust(3).ore().color(13143060).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Calcium, 1, Materials.Tungsten, 1, Materials.Oxygen, 4).build().setFormula("Ca(WO3)O", true);
        Materials.Sodalite = new Material.Builder(316, GTUtility.gregtechId("sodalite")).gem(1).ore(6, 4).color(0x1414FF).iconSet(MaterialIconSet.LAPIS).flags(MaterialFlags.GENERATE_PLATE, MaterialFlags.GENERATE_ROD, MaterialFlags.NO_SMASHING, MaterialFlags.NO_SMELTING, MaterialFlags.CRYSTALLIZABLE, MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING).components(Materials.Aluminium, 3, Materials.Silicon, 3, Materials.Sodium, 4, Materials.Chlorine, 1).build();
        Materials.AluminiumSulfite = new Material.Builder(317, GTUtility.gregtechId("aluminium_sulfite")).dust().color(0xCC4BBB).iconSet(MaterialIconSet.DULL).components(Materials.Aluminium, 2, Materials.Sulfur, 3, Materials.Oxygen, 9).build().setFormula("Al2(SO3)3", true);
        Materials.Tantalite = new Material.Builder(318, GTUtility.gregtechId("tantalite")).dust(3).ore().color(9523240).iconSet(MaterialIconSet.METALLIC).components(Materials.Manganese, 1, Materials.Tantalum, 2, Materials.Oxygen, 6).build();
        Materials.Coke = new Material.Builder(319, GTUtility.gregtechId("coke")).gem(2, 3200).color(0x666666).iconSet(MaterialIconSet.LIGNITE).flags(MaterialFlags.FLAMMABLE, MaterialFlags.NO_SMELTING, MaterialFlags.NO_SMASHING, MaterialFlags.MORTAR_GRINDABLE).components(Materials.Carbon, 1).build();
        Materials.SolderingAlloy = new Material.Builder(320, GTUtility.gregtechId("soldering_alloy")).ingot(1).liquid(new FluidBuilder().temperature(544)).color(9868960).components(Materials.Tin, 6, Materials.Lead, 3, Materials.Antimony, 1).build();
        Materials.Spessartine = new Material.Builder(321, GTUtility.gregtechId("spessartine")).gem().ore(3, 1).color(0xFF6464).iconSet(MaterialIconSet.RUBY).components(Materials.Aluminium, 2, Materials.Manganese, 3, Materials.Silicon, 3, Materials.Oxygen, 12).build();
        Materials.Sphalerite = new Material.Builder(322, GTUtility.gregtechId("sphalerite")).dust(1).ore().color(0xFFFFFF).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Zinc, 1, Materials.Sulfur, 1).build();
        Materials.StainlessSteel = new Material.Builder(323, GTUtility.gregtechId("stainless_steel")).ingot(3).liquid(new FluidBuilder().temperature(2011)).color(0xC8C8DC).iconSet(MaterialIconSet.SHINY).flags(Materials.EXT2_METAL, MaterialFlags.GENERATE_ROTOR, MaterialFlags.GENERATE_SMALL_GEAR, MaterialFlags.GENERATE_FRAME, MaterialFlags.GENERATE_LONG_ROD, MaterialFlags.GENERATE_FOIL, MaterialFlags.GENERATE_GEAR, MaterialFlags.GENERATE_DOUBLE_PLATE).components(Materials.Iron, 6, Materials.Chrome, 1, Materials.Manganese, 1, Materials.Nickel, 1).toolStats(ToolProperty.Builder.of(7.0f, 5.0f, 1024, 3).enchantability(14).build()).rotorStats(7.0f, 4.0f, 480).fluidPipeProperties(2428, 75, true, true, true, false).blast(b -> b.temp(1700, BlastProperty.GasTier.LOW).blastStats(GTValues.VA[3], 1100)).build();
        Materials.Steel = new Material.Builder(324, GTUtility.gregtechId("steel")).ingot(3).liquid(new FluidBuilder().temperature(2046)).color(0x808080).iconSet(MaterialIconSet.METALLIC).flags(Materials.EXT2_METAL, MaterialFlags.MORTAR_GRINDABLE, MaterialFlags.GENERATE_ROTOR, MaterialFlags.GENERATE_SMALL_GEAR, MaterialFlags.GENERATE_SPRING, MaterialFlags.GENERATE_SPRING_SMALL, MaterialFlags.GENERATE_FRAME, MaterialFlags.DISABLE_DECOMPOSITION, MaterialFlags.GENERATE_FINE_WIRE, MaterialFlags.GENERATE_GEAR, MaterialFlags.GENERATE_DOUBLE_PLATE).components(Materials.Iron, 1).toolStats(ToolProperty.Builder.of(5.0f, 3.0f, 512, 3).enchantability(14).build()).rotorStats(6.0f, 3.0f, 512).fluidPipeProperties(1855, 50, true).cableProperties(GTValues.V[4], 2, 2).blast(b -> b.temp(1000).blastStats(GTValues.VA[2], 800)).build();
        Materials.Stibnite = new Material.Builder(325, GTUtility.gregtechId("stibnite")).dust().ore().color(0x464646).iconSet(MaterialIconSet.METALLIC).flags(MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING).components(Materials.Antimony, 2, Materials.Sulfur, 3).build();
        Materials.Tetrahedrite = new Material.Builder(327, GTUtility.gregtechId("tetrahedrite")).dust().ore().color(13115392).components(Materials.Copper, 3, Materials.Antimony, 1, Materials.Sulfur, 3, Materials.Iron, 1).build();
        Materials.TinAlloy = new Material.Builder(328, GTUtility.gregtechId("tin_alloy")).ingot().liquid(new FluidBuilder().temperature(1258)).color(0xC8C8C8).iconSet(MaterialIconSet.METALLIC).flags(Materials.EXT2_METAL, MaterialFlags.GENERATE_DOUBLE_PLATE).components(Materials.Tin, 1, Materials.Iron, 1).fluidPipeProperties(1572, 20, true).build();
        Materials.Topaz = new Material.Builder(329, GTUtility.gregtechId("topaz")).gem(3).ore().color(0xFF8000).iconSet(MaterialIconSet.GEM_HORIZONTAL).flags(Materials.EXT_METAL, MaterialFlags.NO_SMASHING, MaterialFlags.NO_SMELTING, MaterialFlags.HIGH_SIFTER_OUTPUT).components(Materials.Aluminium, 2, Materials.Silicon, 1, Materials.Fluorine, 1, Materials.Hydrogen, 2).build();
        Materials.Tungstate = new Material.Builder(330, GTUtility.gregtechId("tungstate")).dust(3).ore().color(0x373223).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Tungsten, 1, Materials.Lithium, 2, Materials.Oxygen, 4).build().setFormula("Li2(WO3)O", true);
        Materials.Ultimet = new Material.Builder(331, GTUtility.gregtechId("ultimet")).ingot(4).liquid(new FluidBuilder().temperature(1980)).color(11842790).iconSet(MaterialIconSet.SHINY).flags(Materials.EXT2_METAL, MaterialFlags.GENERATE_GEAR, MaterialFlags.GENERATE_DOUBLE_PLATE, MaterialFlags.GENERATE_FRAME).components(Materials.Cobalt, 5, Materials.Chrome, 2, Materials.Nickel, 1, Materials.Molybdenum, 1).toolStats(ToolProperty.Builder.of(10.0f, 7.0f, 2048, 4).attackSpeed(0.1f).enchantability(21).build()).rotorStats(9.0f, 4.0f, 2048).itemPipeProperties(128, 16.0f).blast(b -> b.temp(2700, BlastProperty.GasTier.MID).blastStats(GTValues.VA[3], 1300)).build();
        Materials.Uraninite = new Material.Builder(332, GTUtility.gregtechId("uraninite")).dust(3).ore(true).color(0x232323).iconSet(MaterialIconSet.METALLIC).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Uranium238, 1, Materials.Oxygen, 2).build().setFormula("UO2", true);
        Materials.Uvarovite = new Material.Builder(333, GTUtility.gregtechId("uvarovite")).gem().color(0xB4FFB4).iconSet(MaterialIconSet.RUBY).components(Materials.Calcium, 3, Materials.Chrome, 2, Materials.Silicon, 3, Materials.Oxygen, 12).build();
        Materials.VanadiumGallium = new Material.Builder(334, GTUtility.gregtechId("vanadium_gallium")).ingot().liquid(new FluidBuilder().temperature(1712)).color(0x80808C).iconSet(MaterialIconSet.SHINY).flags(Materials.STD_METAL, MaterialFlags.GENERATE_FOIL, MaterialFlags.GENERATE_SPRING, MaterialFlags.GENERATE_SPRING_SMALL).components(Materials.Vanadium, 3, Materials.Gallium, 1).cableProperties(GTValues.V[7], 4, 2).blast(b -> b.temp(4500, BlastProperty.GasTier.HIGH).blastStats(GTValues.VA[4], 1200).vacuumStats(GTValues.VA[3])).build();
        Materials.WroughtIron = new Material.Builder(335, GTUtility.gregtechId("wrought_iron")).ingot().liquid(new FluidBuilder().temperature(2011)).color(13153460).iconSet(MaterialIconSet.METALLIC).flags(Materials.EXT_METAL, MaterialFlags.GENERATE_GEAR, MaterialFlags.GENERATE_FOIL, MaterialFlags.MORTAR_GRINDABLE, MaterialFlags.GENERATE_RING, MaterialFlags.GENERATE_LONG_ROD, MaterialFlags.GENERATE_BOLT_SCREW, MaterialFlags.DISABLE_DECOMPOSITION, MaterialFlags.BLAST_FURNACE_CALCITE_TRIPLE, MaterialFlags.GENERATE_DOUBLE_PLATE).components(Materials.Iron, 1).toolStats(ToolProperty.Builder.of(2.0f, 2.0f, 384, 2).attackSpeed(-0.2f).enchantability(5).build()).rotorStats(6.0f, 3.5f, 384).build();
        Materials.Iron.getProperty(PropertyKey.INGOT).setSmeltingInto(Materials.WroughtIron);
        Materials.Iron.getProperty(PropertyKey.INGOT).setArcSmeltingInto(Materials.WroughtIron);
        Materials.Wulfenite = new Material.Builder(336, GTUtility.gregtechId("wulfenite")).dust(3).ore().color(0xFF8000).components(Materials.Lead, 1, Materials.Molybdenum, 1, Materials.Oxygen, 4).build();
        Materials.YellowLimonite = new Material.Builder(337, GTUtility.gregtechId("yellow_limonite")).dust().ore().color(0xC8C800).iconSet(MaterialIconSet.METALLIC).flags(MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING, MaterialFlags.BLAST_FURNACE_CALCITE_DOUBLE).components(Materials.Iron, 1, Materials.Hydrogen, 1, Materials.Oxygen, 2).build();
        Materials.YttriumBariumCuprate = new Material.Builder(338, GTUtility.gregtechId("yttrium_barium_cuprate")).ingot().liquid(new FluidBuilder().temperature(1799)).color(5259334).iconSet(MaterialIconSet.METALLIC).flags(Materials.EXT_METAL, MaterialFlags.GENERATE_FINE_WIRE, MaterialFlags.GENERATE_SPRING, MaterialFlags.GENERATE_SPRING_SMALL, MaterialFlags.GENERATE_FOIL, MaterialFlags.GENERATE_BOLT_SCREW).components(Materials.Yttrium, 1, Materials.Barium, 2, Materials.Copper, 3, Materials.Oxygen, 7).cableProperties(GTValues.V[8], 4, 4).blast(b -> b.temp(4500, BlastProperty.GasTier.HIGH).blastStats(GTValues.VA[5], 1000).vacuumStats(GTValues.VA[4], 150)).build();
        Materials.NetherQuartz = new Material.Builder(339, GTUtility.gregtechId("nether_quartz")).gem(1).ore(2, 1).color(15127250).iconSet(MaterialIconSet.QUARTZ).flags(MaterialFlags.GENERATE_PLATE, MaterialFlags.NO_SMELTING, MaterialFlags.CRYSTALLIZABLE, MaterialFlags.EXCLUDE_BLOCK_CRAFTING_BY_HAND_RECIPES, MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Silicon, 1, Materials.Oxygen, 2).build();
        Materials.CertusQuartz = new Material.Builder(214, GTUtility.gregtechId("certus_quartz")).gem(1).ore(2, 1).color(13816550).iconSet(MaterialIconSet.CERTUS).flags(MaterialFlags.GENERATE_PLATE, MaterialFlags.NO_SMELTING, MaterialFlags.CRYSTALLIZABLE, MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Silicon, 1, Materials.Oxygen, 2).build();
        Materials.Quartzite = new Material.Builder(340, GTUtility.gregtechId("quartzite")).gem(1).ore(2, 1).color(13821650).iconSet(MaterialIconSet.QUARTZ).flags(MaterialFlags.NO_SMELTING, MaterialFlags.CRYSTALLIZABLE, MaterialFlags.DISABLE_DECOMPOSITION, MaterialFlags.GENERATE_PLATE).components(Materials.Silicon, 1, Materials.Oxygen, 2).build();
        Materials.Graphite = new Material.Builder(341, GTUtility.gregtechId("graphite")).ore().color(0x808080).flags(MaterialFlags.NO_SMELTING, MaterialFlags.FLAMMABLE, MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 1).build();
        Materials.Graphene = new Material.Builder(342, GTUtility.gregtechId("graphene")).dust().color(0x808080).iconSet(MaterialIconSet.SHINY).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Carbon, 1).cableProperties(GTValues.V[5], 1, 1).build();
        Materials.TungsticAcid = new Material.Builder(343, GTUtility.gregtechId("tungstic_acid")).dust().color(12371968).iconSet(MaterialIconSet.SHINY).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Hydrogen, 2, Materials.Tungsten, 1, Materials.Oxygen, 4).build();
        Materials.Osmiridium = new Material.Builder(344, GTUtility.gregtechId("osmiridium")).ingot(3).liquid(new FluidBuilder().temperature(3012)).color(0x6464FF).iconSet(MaterialIconSet.METALLIC).flags(Materials.EXT2_METAL, MaterialFlags.GENERATE_SMALL_GEAR, MaterialFlags.GENERATE_RING, MaterialFlags.GENERATE_ROTOR, MaterialFlags.GENERATE_ROUND, MaterialFlags.GENERATE_FINE_WIRE, MaterialFlags.GENERATE_GEAR, MaterialFlags.GENERATE_DOUBLE_PLATE).components(Materials.Iridium, 3, Materials.Osmium, 1).rotorStats(9.0f, 3.0f, 3152).itemPipeProperties(64, 32.0f).blast(b -> b.temp(4500, BlastProperty.GasTier.HIGH).blastStats(GTValues.VA[6], 900).vacuumStats(GTValues.VA[4], 200)).build();
        Materials.LithiumChloride = new Material.Builder(345, GTUtility.gregtechId("lithium_chloride")).dust().color(14606074).iconSet(MaterialIconSet.FINE).components(Materials.Lithium, 1, Materials.Chlorine, 1).build();
        Materials.CalciumChloride = new Material.Builder(346, GTUtility.gregtechId("calcium_chloride")).dust().color(15461370).iconSet(MaterialIconSet.FINE).components(Materials.Calcium, 1, Materials.Chlorine, 2).build();
        Materials.Bornite = new Material.Builder(347, GTUtility.gregtechId("bornite")).dust(1).ore().color(9922091).iconSet(MaterialIconSet.METALLIC).components(Materials.Copper, 5, Materials.Iron, 1, Materials.Sulfur, 4).build();
        Materials.Chalcocite = new Material.Builder(348, GTUtility.gregtechId("chalcocite")).dust().ore().color(0x353535).iconSet(MaterialIconSet.GEM_VERTICAL).components(Materials.Copper, 2, Materials.Sulfur, 1).build();
        Materials.GalliumArsenide = new Material.Builder(351, GTUtility.gregtechId("gallium_arsenide")).ingot(1).liquid(new FluidBuilder().temperature(1511)).color(0xA0A0A0).flags(Materials.STD_METAL, MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING).components(Materials.Arsenic, 1, Materials.Gallium, 1).blast(b -> b.temp(1200, BlastProperty.GasTier.LOW).blastStats(GTValues.VA[2], 1200)).build();
        Materials.Potash = new Material.Builder(352, GTUtility.gregtechId("potash")).dust(1).color(7881015).components(Materials.Potassium, 2, Materials.Oxygen, 1).build();
        Materials.SodaAsh = new Material.Builder(353, GTUtility.gregtechId("soda_ash")).dust(1).color(0xDCDCFF).components(Materials.Sodium, 2, Materials.Carbon, 1, Materials.Oxygen, 3).build();
        Materials.IndiumGalliumPhosphide = new Material.Builder(354, GTUtility.gregtechId("indium_gallium_phosphide")).ingot(1).liquid(new FluidBuilder().temperature(350)).color(10521790).flags(Materials.STD_METAL, MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING).components(Materials.Indium, 1, Materials.Gallium, 1, Materials.Phosphorus, 1).build();
        Materials.NickelZincFerrite = new Material.Builder(355, GTUtility.gregtechId("nickel_zinc_ferrite")).ingot(0).liquid(new FluidBuilder().temperature(1410)).color(0x3C3C3C).iconSet(MaterialIconSet.METALLIC).flags(MaterialFlags.GENERATE_RING).components(Materials.Nickel, 1, Materials.Zinc, 1, Materials.Iron, 4, Materials.Oxygen, 8).build();
        Materials.SiliconDioxide = new Material.Builder(356, GTUtility.gregtechId("silicon_dioxide")).dust(1).color(0xC8C8C8).iconSet(MaterialIconSet.QUARTZ).flags(MaterialFlags.NO_SMASHING, MaterialFlags.NO_SMELTING).components(Materials.Silicon, 1, Materials.Oxygen, 2).build();
        Materials.MagnesiumChloride = new Material.Builder(357, GTUtility.gregtechId("magnesium_chloride")).dust(1).color(13897052).components(Materials.Magnesium, 1, Materials.Chlorine, 2).build();
        Materials.SodiumSulfide = new Material.Builder(358, GTUtility.gregtechId("sodium_sulfide")).dust(1).color(16770688).components(Materials.Sodium, 2, Materials.Sulfur, 1).build();
        Materials.PhosphorusPentoxide = new Material.Builder(359, GTUtility.gregtechId("phosphorus_pentoxide")).dust(1).color(0xDCDC00).flags(MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING).components(Materials.Phosphorus, 4, Materials.Oxygen, 10).build();
        Materials.Quicklime = new Material.Builder(360, GTUtility.gregtechId("quicklime")).dust(1).color(0xF0F0F0).components(Materials.Calcium, 1, Materials.Oxygen, 1).build();
        Materials.SodiumBisulfate = new Material.Builder(361, GTUtility.gregtechId("sodium_bisulfate")).dust(1).color(17493).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Sodium, 1, Materials.Hydrogen, 1, Materials.Sulfur, 1, Materials.Oxygen, 4).build();
        Materials.FerriteMixture = new Material.Builder(362, GTUtility.gregtechId("ferrite_mixture")).dust(1).color(0xB4B4B4).iconSet(MaterialIconSet.METALLIC).flags(MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING).components(Materials.Nickel, 1, Materials.Zinc, 1, Materials.Iron, 4).build();
        Materials.Magnesia = new Material.Builder(363, GTUtility.gregtechId("magnesia")).dust(1).color(0x887878).components(Materials.Magnesium, 1, Materials.Oxygen, 1).build();
        Materials.PlatinumGroupSludge = new Material.Builder(364, GTUtility.gregtechId("platinum_group_sludge")).dust(1).color(7680).iconSet(MaterialIconSet.FINE).flags(MaterialFlags.DISABLE_DECOMPOSITION).build();
        Materials.Realgar = new Material.Builder(365, GTUtility.gregtechId("realgar")).gem().ore().color(10297635).iconSet(MaterialIconSet.EMERALD).flags(MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING).components(Materials.Arsenic, 4, Materials.Sulfur, 4).build();
        Materials.SodiumBicarbonate = new Material.Builder(366, GTUtility.gregtechId("sodium_bicarbonate")).dust(1).color(5659542).iconSet(MaterialIconSet.ROUGH).components(Materials.Sodium, 1, Materials.Hydrogen, 1, Materials.Carbon, 1, Materials.Oxygen, 3).build();
        Materials.PotassiumDichromate = new Material.Builder(367, GTUtility.gregtechId("potassium_dichromate")).dust(1).color(16713806).components(Materials.Potassium, 2, Materials.Chrome, 2, Materials.Oxygen, 7).build();
        Materials.ChromiumTrioxide = new Material.Builder(368, GTUtility.gregtechId("chromium_trioxide")).dust(1).color(16770273).components(Materials.Chrome, 1, Materials.Oxygen, 3).build();
        Materials.AntimonyTrioxide = new Material.Builder(369, GTUtility.gregtechId("antimony_trioxide")).dust(1).color(15132400).components(Materials.Antimony, 2, Materials.Oxygen, 3).build();
        Materials.Zincite = new Material.Builder(370, GTUtility.gregtechId("zincite")).dust(1).color(0xFFFFF5).components(Materials.Zinc, 1, Materials.Oxygen, 1).build();
        Materials.CupricOxide = new Material.Builder(371, GTUtility.gregtechId("cupric_oxide")).dust(1).color(986895).components(Materials.Copper, 1, Materials.Oxygen, 1).build();
        Materials.CobaltOxide = new Material.Builder(372, GTUtility.gregtechId("cobalt_oxide")).dust(1).color(0x788000).components(Materials.Cobalt, 1, Materials.Oxygen, 1).build();
        Materials.ArsenicTrioxide = new Material.Builder(373, GTUtility.gregtechId("arsenic_trioxide")).dust(1).iconSet(MaterialIconSet.ROUGH).components(Materials.Arsenic, 2, Materials.Oxygen, 3).build();
        Materials.Massicot = new Material.Builder(374, GTUtility.gregtechId("massicot")).dust(1).color(0xFFDD55).components(Materials.Lead, 1, Materials.Oxygen, 1).build();
        Materials.Ferrosilite = new Material.Builder(375, GTUtility.gregtechId("ferrosilite")).dust(1).color(9921322).components(Materials.Iron, 1, Materials.Silicon, 1, Materials.Oxygen, 3).build();
        Materials.MetalMixture = new Material.Builder(376, GTUtility.gregtechId("metal_mixture")).dust(1).color(5254422).iconSet(MaterialIconSet.METALLIC).flags(MaterialFlags.DISABLE_DECOMPOSITION).build();
        Materials.SodiumHydroxide = new Material.Builder(377, GTUtility.gregtechId("sodium_hydroxide")).dust(1).color(13184).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Sodium, 1, Materials.Oxygen, 1, Materials.Hydrogen, 1).build();
        Materials.SodiumPersulfate = new Material.Builder(378, GTUtility.gregtechId("sodium_persulfate")).liquid(new FluidBuilder().customStill()).color(285788).components(Materials.Sodium, 2, Materials.Sulfur, 2, Materials.Oxygen, 8).build();
        Materials.Bastnasite = new Material.Builder(379, GTUtility.gregtechId("bastnasite")).dust().ore(2, 1).color(13135405).iconSet(MaterialIconSet.FINE).components(Materials.Cerium, 1, Materials.Carbon, 1, Materials.Fluorine, 1, Materials.Oxygen, 3).build();
        Materials.Pentlandite = new Material.Builder(380, GTUtility.gregtechId("pentlandite")).dust().ore().color(10851845).components(Materials.Nickel, 9, Materials.Sulfur, 8).build();
        Materials.Spodumene = new Material.Builder(381, GTUtility.gregtechId("spodumene")).dust().ore().color(0xBEAAAA).components(Materials.Lithium, 1, Materials.Aluminium, 1, Materials.Silicon, 2, Materials.Oxygen, 6).build();
        Materials.Lepidolite = new Material.Builder(382, GTUtility.gregtechId("lepidolite")).dust().ore(2, 1).color(15741580).iconSet(MaterialIconSet.FINE).components(Materials.Potassium, 1, Materials.Lithium, 3, Materials.Aluminium, 4, Materials.Fluorine, 2, Materials.Oxygen, 10).build();
        Materials.GlauconiteSand = new Material.Builder(384, GTUtility.gregtechId("glauconite_sand")).dust().ore(3, 1).color(8565820).iconSet(MaterialIconSet.SAND).components(Materials.Potassium, 1, Materials.Magnesium, 2, Materials.Aluminium, 4, Materials.Hydrogen, 2, Materials.Oxygen, 12).build();
        Materials.Malachite = new Material.Builder(385, GTUtility.gregtechId("malachite")).gem().ore().color(352005).iconSet(MaterialIconSet.LAPIS).components(Materials.Copper, 2, Materials.Carbon, 1, Materials.Hydrogen, 2, Materials.Oxygen, 5).build();
        Materials.Mica = new Material.Builder(386, GTUtility.gregtechId("mica")).dust().ore(2, 1).color(0xC3C3CD).iconSet(MaterialIconSet.FINE).components(Materials.Potassium, 1, Materials.Aluminium, 3, Materials.Silicon, 3, Materials.Fluorine, 2, Materials.Oxygen, 10).build();
        Materials.Barite = new Material.Builder(387, GTUtility.gregtechId("barite")).dust().ore().color(0xE6EBEB).components(Materials.Barium, 1, Materials.Sulfur, 1, Materials.Oxygen, 4).build();
        Materials.Alunite = new Material.Builder(388, GTUtility.gregtechId("alunite")).dust().ore(3, 1).color(14791745).iconSet(MaterialIconSet.METALLIC).components(Materials.Potassium, 1, Materials.Aluminium, 3, Materials.Silicon, 2, Materials.Hydrogen, 6, Materials.Oxygen, 14).build();
        Materials.Talc = new Material.Builder(392, GTUtility.gregtechId("talc")).dust().ore(2, 1).color(5944410).iconSet(MaterialIconSet.FINE).components(Materials.Magnesium, 3, Materials.Silicon, 4, Materials.Hydrogen, 2, Materials.Oxygen, 12).build();
        Materials.Soapstone = new Material.Builder(393, GTUtility.gregtechId("soapstone")).dust(1).ore(3, 1).color(6263135).components(Materials.Magnesium, 3, Materials.Silicon, 4, Materials.Hydrogen, 2, Materials.Oxygen, 12).build();
        Materials.Kyanite = new Material.Builder(394, GTUtility.gregtechId("kyanite")).dust().ore().color(7237370).iconSet(MaterialIconSet.FLINT).components(Materials.Aluminium, 2, Materials.Silicon, 1, Materials.Oxygen, 5).build();
        Materials.IronMagnetic = new Material.Builder(395, GTUtility.gregtechId("iron_magnetic")).ingot().color(0xC8C8C8).iconSet(MaterialIconSet.MAGNETIC).flags(MaterialFlags.GENERATE_BOLT_SCREW, MaterialFlags.IS_MAGNETIC).components(Materials.Iron, 1).ingotSmeltInto(Materials.Iron).arcSmeltInto(Materials.WroughtIron).macerateInto(Materials.Iron).build();
        Materials.Iron.getProperty(PropertyKey.INGOT).setMagneticMaterial(Materials.IronMagnetic);
        Materials.TungstenCarbide = new Material.Builder(396, GTUtility.gregtechId("tungsten_carbide")).ingot(4).fluid().color(0x330066).iconSet(MaterialIconSet.METALLIC).flags(Materials.EXT2_METAL, MaterialFlags.GENERATE_FOIL, MaterialFlags.GENERATE_GEAR, MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING, MaterialFlags.GENERATE_DOUBLE_PLATE).components(Materials.Tungsten, 1, Materials.Carbon, 1).toolStats(ToolProperty.Builder.of(60.0f, 2.0f, 1024, 4).enchantability(21).build()).rotorStats(12.0f, 4.0f, 1280).fluidPipeProperties(3837, 200, true).blast(b -> b.temp(3058, BlastProperty.GasTier.MID).blastStats(GTValues.VA[4], 1200).vacuumStats(GTValues.VA[3])).build();
        Materials.CarbonDioxide = new Material.Builder(397, GTUtility.gregtechId("carbon_dioxide")).gas().color(11129077).components(Materials.Carbon, 1, Materials.Oxygen, 2).build();
        Materials.TitaniumTetrachloride = new Material.Builder(398, GTUtility.gregtechId("titanium_tetrachloride")).liquid(new FluidBuilder().customStill()).color(13897052).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Titanium, 1, Materials.Chlorine, 4).build();
        Materials.NitrogenDioxide = new Material.Builder(399, GTUtility.gregtechId("nitrogen_dioxide")).gas().color(15751168).components(Materials.Nitrogen, 1, Materials.Oxygen, 2).build();
        Materials.HydrogenSulfide = new Material.Builder(400, GTUtility.gregtechId("hydrogen_sulfide")).gas(new FluidBuilder().customStill()).color(16536324).components(Materials.Hydrogen, 2, Materials.Sulfur, 1).build();
        Materials.NitricAcid = new Material.Builder(401, GTUtility.gregtechId("nitric_acid")).liquid(new FluidBuilder().attribute(FluidAttributes.ACID)).color(0xCCCC00).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Hydrogen, 1, Materials.Nitrogen, 1, Materials.Oxygen, 3).build();
        Materials.SulfuricAcid = new Material.Builder(402, GTUtility.gregtechId("sulfuric_acid")).liquid(new FluidBuilder().attribute(FluidAttributes.ACID).customStill()).color(16536324).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Hydrogen, 2, Materials.Sulfur, 1, Materials.Oxygen, 4).build();
        Materials.PhosphoricAcid = new Material.Builder(403, GTUtility.gregtechId("phosphoric_acid")).liquid(new FluidBuilder().attribute(FluidAttributes.ACID)).color(14474241).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Hydrogen, 3, Materials.Phosphorus, 1, Materials.Oxygen, 4).build();
        Materials.SulfurTrioxide = new Material.Builder(404, GTUtility.gregtechId("sulfur_trioxide")).gas().color(10526740).components(Materials.Sulfur, 1, Materials.Oxygen, 3).build();
        Materials.SulfurDioxide = new Material.Builder(405, GTUtility.gregtechId("sulfur_dioxide")).gas().color(13158425).components(Materials.Sulfur, 1, Materials.Oxygen, 2).build();
        Materials.CarbonMonoxide = new Material.Builder(406, GTUtility.gregtechId("carbon_monoxide")).gas().color(936064).components(Materials.Carbon, 1, Materials.Oxygen, 1).build();
        Materials.HypochlorousAcid = new Material.Builder(407, GTUtility.gregtechId("hypochlorous_acid")).liquid(new FluidBuilder().attribute(FluidAttributes.ACID)).color(7309969).components(Materials.Hydrogen, 1, Materials.Chlorine, 1, Materials.Oxygen, 1).build();
        Materials.Ammonia = new Material.Builder(408, GTUtility.gregtechId("ammonia")).gas().color(4142208).components(Materials.Nitrogen, 1, Materials.Hydrogen, 3).build();
        Materials.HydrofluoricAcid = new Material.Builder(409, GTUtility.gregtechId("hydrofluoric_acid")).liquid(new FluidBuilder().attribute(FluidAttributes.ACID)).color(34986).components(Materials.Hydrogen, 1, Materials.Fluorine, 1).build();
        Materials.NitricOxide = new Material.Builder(410, GTUtility.gregtechId("nitric_oxide")).gas().color(8243440).components(Materials.Nitrogen, 1, Materials.Oxygen, 1).build();
        Materials.Iron3Chloride = new Material.Builder(411, GTUtility.gregtechId("iron_iii_chloride")).fluid().color(396043).flags(MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING).components(Materials.Iron, 1, Materials.Chlorine, 3).build();
        Materials.UraniumHexafluoride = new Material.Builder(412, GTUtility.gregtechId("uranium_hexafluoride")).gas().color(4378918).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Uranium238, 1, Materials.Fluorine, 6).build().setFormula("UF6", true);
        Materials.EnrichedUraniumHexafluoride = new Material.Builder(413, GTUtility.gregtechId("enriched_uranium_hexafluoride")).gas().color(4977962).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Uranium235, 1, Materials.Fluorine, 6).build().setFormula("UF6", true);
        Materials.DepletedUraniumHexafluoride = new Material.Builder(414, GTUtility.gregtechId("depleted_uranium_hexafluoride")).gas().color(7649894).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Uranium238, 1, Materials.Fluorine, 6).build().setFormula("UF6", true);
        Materials.NitrousOxide = new Material.Builder(415, GTUtility.gregtechId("nitrous_oxide")).gas().color(8243455).components(Materials.Nitrogen, 2, Materials.Oxygen, 1).build();
        Materials.EnderPearl = new Material.Builder(416, GTUtility.gregtechId("ender_pearl")).gem(1).color(7134408).flags(MaterialFlags.NO_SMASHING, MaterialFlags.NO_SMELTING, MaterialFlags.GENERATE_PLATE).components(Materials.Beryllium, 1, Materials.Potassium, 4, Materials.Nitrogen, 5).build();
        Materials.PotassiumFeldspar = new Material.Builder(417, GTUtility.gregtechId("potassium_feldspar")).dust(1).color(0x782828).iconSet(MaterialIconSet.FINE).components(Materials.Potassium, 1, Materials.Aluminium, 1, Materials.Silicon, 1, Materials.Oxygen, 8).build();
        Materials.NeodymiumMagnetic = new Material.Builder(418, GTUtility.gregtechId("neodymium_magnetic")).ingot().color(0x646464).iconSet(MaterialIconSet.MAGNETIC).flags(MaterialFlags.GENERATE_ROD, MaterialFlags.IS_MAGNETIC).components(Materials.Neodymium, 1).ingotSmeltInto(Materials.Neodymium).arcSmeltInto(Materials.Neodymium).macerateInto(Materials.Neodymium).build();
        Materials.Neodymium.getProperty(PropertyKey.INGOT).setMagneticMaterial(Materials.NeodymiumMagnetic);
        Materials.HydrochloricAcid = new Material.Builder(419, GTUtility.gregtechId("hydrochloric_acid")).liquid(new FluidBuilder().attribute(FluidAttributes.ACID).customStill()).color(0xBCBCB5).components(Materials.Hydrogen, 1, Materials.Chlorine, 1).build();
        Materials.Steam = new Material.Builder(420, GTUtility.gregtechId("steam")).gas(new FluidBuilder().temperature(373).customStill()).color(0xC4C4C4).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Hydrogen, 2, Materials.Oxygen, 1).build();
        Materials.DistilledWater = new Material.Builder(421, GTUtility.gregtechId("distilled_water")).liquid(new FluidBuilder().alternativeName("fluidDistWater")).color(4887807).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Hydrogen, 2, Materials.Oxygen, 1).build();
        Materials.SodiumPotassium = new Material.Builder(422, GTUtility.gregtechId("sodium_potassium")).fluid().color(6618292).flags(MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING).components(Materials.Sodium, 1, Materials.Potassium, 1).build();
        Materials.SamariumMagnetic = new Material.Builder(423, GTUtility.gregtechId("samarium_magnetic")).ingot().color(0xFFFFCD).iconSet(MaterialIconSet.MAGNETIC).flags(MaterialFlags.GENERATE_LONG_ROD, MaterialFlags.IS_MAGNETIC).components(Materials.Samarium, 1).ingotSmeltInto(Materials.Samarium).arcSmeltInto(Materials.Samarium).macerateInto(Materials.Samarium).build();
        Materials.Samarium.getProperty(PropertyKey.INGOT).setMagneticMaterial(Materials.SamariumMagnetic);
        Materials.ManganesePhosphide = new Material.Builder(424, GTUtility.gregtechId("manganese_phosphide")).ingot().liquid(new FluidBuilder().temperature(1368)).color(14791764).iconSet(MaterialIconSet.METALLIC).flags(MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING).components(Materials.Manganese, 1, Materials.Phosphorus, 1).cableProperties(GTValues.V[1], 2, 0, true, 78).blast(1200, BlastProperty.GasTier.LOW).build();
        Materials.MagnesiumDiboride = new Material.Builder(425, GTUtility.gregtechId("magnesium_diboride")).ingot().liquid(new FluidBuilder().temperature(1103)).color(3348736).iconSet(MaterialIconSet.METALLIC).flags(MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING).components(Materials.Magnesium, 1, Materials.Boron, 2).cableProperties(GTValues.V[2], 4, 0, true, 78).blast(b -> b.temp(2500, BlastProperty.GasTier.LOW).blastStats(GTValues.VA[3], 1000).vacuumStats(GTValues.VA[2], 200)).build();
        Materials.MercuryBariumCalciumCuprate = new Material.Builder(426, GTUtility.gregtechId("mercury_barium_calcium_cuprate")).ingot().liquid(new FluidBuilder().temperature(1075)).color(0x555555).iconSet(MaterialIconSet.SHINY).flags(MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING).components(Materials.Mercury, 1, Materials.Barium, 2, Materials.Calcium, 2, Materials.Copper, 3, Materials.Oxygen, 8).cableProperties(GTValues.V[3], 4, 0, true, 78).blast(b -> b.temp(3300, BlastProperty.GasTier.LOW).blastStats(GTValues.VA[3], 1500).vacuumStats(GTValues.VA[3])).build();
        Materials.UraniumTriplatinum = new Material.Builder(427, GTUtility.gregtechId("uranium_triplatinum")).ingot().liquid(new FluidBuilder().temperature(1882)).color(34560).iconSet(MaterialIconSet.SHINY).flags(MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING).components(Materials.Uranium238, 1, Materials.Platinum, 3).cableProperties(GTValues.V[4], 6, 0, true, 30).blast(b -> b.temp(4400, BlastProperty.GasTier.MID).blastStats(GTValues.VA[4], 1000).vacuumStats(GTValues.VA[4], 200)).build().setFormula("UPt3", true);
        Materials.SamariumIronArsenicOxide = new Material.Builder(428, GTUtility.gregtechId("samarium_iron_arsenic_oxide")).ingot().liquid(new FluidBuilder().temperature(1347)).color(0x330033).iconSet(MaterialIconSet.SHINY).flags(MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING).components(Materials.Samarium, 1, Materials.Iron, 1, Materials.Arsenic, 1, Materials.Oxygen, 1).cableProperties(GTValues.V[5], 6, 0, true, 30).blast(b -> b.temp(5200, BlastProperty.GasTier.MID).blastStats(GTValues.VA[4], 1500).vacuumStats(GTValues.VA[5], 200)).build();
        Materials.IndiumTinBariumTitaniumCuprate = new Material.Builder(429, GTUtility.gregtechId("indium_tin_barium_titanium_cuprate")).ingot().liquid(new FluidBuilder().temperature(1012)).color(10046464).iconSet(MaterialIconSet.METALLIC).flags(MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING, MaterialFlags.GENERATE_FINE_WIRE).components(Materials.Indium, 4, Materials.Tin, 2, Materials.Barium, 2, Materials.Titanium, 1, Materials.Copper, 7, Materials.Oxygen, 14).cableProperties(GTValues.V[6], 8, 0, true, 5).blast(b -> b.temp(6000, BlastProperty.GasTier.HIGH).blastStats(GTValues.VA[5], 1000).vacuumStats(GTValues.VA[6])).build();
        Materials.UraniumRhodiumDinaquadide = new Material.Builder(430, GTUtility.gregtechId("uranium_rhodium_dinaquadide")).ingot().liquid(new FluidBuilder().temperature(3410)).color(657930).flags(MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING, MaterialFlags.GENERATE_FINE_WIRE).components(Materials.Uranium238, 1, Materials.Rhodium, 1, Materials.Naquadah, 2).cableProperties(GTValues.V[7], 8, 0, true, 5).blast(b -> b.temp(9000, BlastProperty.GasTier.HIGH).blastStats(GTValues.VA[5], 1500).vacuumStats(GTValues.VA[7], 200)).build().setFormula("URhNq2", true);
        Materials.EnrichedNaquadahTriniumEuropiumDuranide = new Material.Builder(431, GTUtility.gregtechId("enriched_naquadah_trinium_europium_duranide")).ingot().liquid(new FluidBuilder().temperature(5930)).color(8230515).iconSet(MaterialIconSet.METALLIC).flags(MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING, MaterialFlags.GENERATE_FINE_WIRE).components(Materials.NaquadahEnriched, 4, Materials.Trinium, 3, Materials.Europium, 2, Materials.Duranium, 1).cableProperties(GTValues.V[8], 16, 0, true, 3).blast(b -> b.temp(9900, BlastProperty.GasTier.HIGH).blastStats(GTValues.VA[6], 1200).vacuumStats(GTValues.VA[8], 200)).build();
        Materials.RutheniumTriniumAmericiumNeutronate = new Material.Builder(432, GTUtility.gregtechId("ruthenium_trinium_americium_neutronate")).ingot().liquid(new FluidBuilder().temperature(23691)).color(0xFFFFFF).iconSet(MaterialIconSet.BRIGHT).flags(MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING).components(Materials.Ruthenium, 1, Materials.Trinium, 2, Materials.Americium, 1, Materials.Neutronium, 2, Materials.Oxygen, 8).cableProperties(GTValues.V[9], 24, 0, true, 3).blast(b -> b.temp(10800, BlastProperty.GasTier.HIGHER).blastStats(GTValues.VA[7], 1000).vacuumStats(GTValues.VA[9], 200)).build();
        Materials.InertMetalMixture = new Material.Builder(433, GTUtility.gregtechId("inert_metal_mixture")).dust().color(14855794).iconSet(MaterialIconSet.METALLIC).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Rhodium, 1, Materials.Ruthenium, 1, Materials.Oxygen, 4).build();
        Materials.RhodiumSulfate = new Material.Builder(434, GTUtility.gregtechId("rhodium_sulfate")).liquid(new FluidBuilder().temperature(1128)).color(0xEEAA55).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Rhodium, 2, Materials.Sulfur, 3, Materials.Oxygen, 12).build().setFormula("Rh2(SO4)3", true);
        Materials.RutheniumTetroxide = new Material.Builder(435, GTUtility.gregtechId("ruthenium_tetroxide")).dust().color(0xC7C7C7).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Ruthenium, 1, Materials.Oxygen, 4).build();
        Materials.OsmiumTetroxide = new Material.Builder(436, GTUtility.gregtechId("osmium_tetroxide")).dust().color(11316593).iconSet(MaterialIconSet.METALLIC).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Osmium, 1, Materials.Oxygen, 4).build();
        Materials.IridiumChloride = new Material.Builder(437, GTUtility.gregtechId("iridium_chloride")).dust().color(78368).iconSet(MaterialIconSet.METALLIC).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Iridium, 1, Materials.Chlorine, 3).build();
        Materials.FluoroantimonicAcid = new Material.Builder(438, GTUtility.gregtechId("fluoroantimonic_acid")).liquid(new FluidBuilder().attribute(FluidAttributes.ACID).customStill()).color(9217220).components(Materials.Hydrogen, 2, Materials.Antimony, 1, Materials.Fluorine, 7).build();
        Materials.TitaniumTrifluoride = new Material.Builder(439, GTUtility.gregtechId("titanium_trifluoride")).dust().color(0x8F00FF).iconSet(MaterialIconSet.SHINY).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Titanium, 1, Materials.Fluorine, 3).build();
        Materials.CalciumPhosphide = new Material.Builder(440, GTUtility.gregtechId("calcium_phosphide")).dust().color(0xA52A2A).iconSet(MaterialIconSet.METALLIC).components(Materials.Calcium, 1, Materials.Phosphorus, 1).build();
        Materials.IndiumPhosphide = new Material.Builder(441, GTUtility.gregtechId("indium_phosphide")).dust().color(5779036).iconSet(MaterialIconSet.SHINY).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Indium, 1, Materials.Phosphorus, 1).build();
        Materials.BariumSulfide = new Material.Builder(442, GTUtility.gregtechId("barium_sulfide")).dust().color(15788758).iconSet(MaterialIconSet.METALLIC).components(Materials.Barium, 1, Materials.Sulfur, 1).build();
        Materials.TriniumSulfide = new Material.Builder(443, GTUtility.gregtechId("trinium_sulfide")).dust().color(15106150).iconSet(MaterialIconSet.SHINY).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Trinium, 1, Materials.Sulfur, 1).build();
        Materials.ZincSulfide = new Material.Builder(444, GTUtility.gregtechId("zinc_sulfide")).dust().color(0xFFFFF6).iconSet(MaterialIconSet.DULL).components(Materials.Zinc, 1, Materials.Sulfur, 1).build();
        Materials.GalliumSulfide = new Material.Builder(445, GTUtility.gregtechId("gallium_sulfide")).dust().color(16774558).iconSet(MaterialIconSet.SHINY).components(Materials.Gallium, 1, Materials.Sulfur, 1).build();
        Materials.AntimonyTrifluoride = new Material.Builder(446, GTUtility.gregtechId("antimony_trifluoride")).dust().color(16247484).iconSet(MaterialIconSet.METALLIC).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Antimony, 1, Materials.Fluorine, 3).build();
        Materials.EnrichedNaquadahSulfate = new Material.Builder(447, GTUtility.gregtechId("enriched_naquadah_sulfate")).dust().color(3026460).iconSet(MaterialIconSet.METALLIC).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.NaquadahEnriched, 1, Materials.Sulfur, 1, Materials.Oxygen, 4).build();
        Materials.NaquadriaSulfate = new Material.Builder(448, GTUtility.gregtechId("naquadria_sulfate")).dust().color(26163).iconSet(MaterialIconSet.SHINY).flags(MaterialFlags.DISABLE_DECOMPOSITION).components(Materials.Naquadria, 1, Materials.Sulfur, 1, Materials.Oxygen, 4).build();
        Materials.Pyrochlore = new Material.Builder(449, GTUtility.gregtechId("pyrochlore")).dust().ore().color(2822400).iconSet(MaterialIconSet.METALLIC).flags(new MaterialFlag[0]).components(Materials.Calcium, 2, Materials.Niobium, 2, Materials.Oxygen, 7).build();
        Materials.RTMAlloy = new Material.Builder(451, GTUtility.gregtechId("rtm_alloy")).ingot().fluid().color(3158123).iconSet(MaterialIconSet.SHINY).components(Materials.Ruthenium, 4, Materials.Tungsten, 2, Materials.Molybdenum, 1).flags(MaterialFlags.GENERATE_SPRING).cableProperties(GTValues.V[4], 6, 2).blast(b -> b.temp(3000, BlastProperty.GasTier.MID).blastStats(GTValues.VA[4], 1400).vacuumStats(GTValues.VA[3], 250)).build();
    }
}

