/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import crafttweaker.annotations.ZenRegister;
import gregtech.api.GregTechAPI;
import gregtech.api.fluids.FluidBuilder;
import gregtech.api.fluids.FluidState;
import gregtech.api.fluids.store.FluidStorageKey;
import gregtech.api.fluids.store.FluidStorageKeys;
import gregtech.api.unification.Element;
import gregtech.api.unification.Elements;
import gregtech.api.unification.material.info.MaterialFlag;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.info.MaterialIconSet;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.DustProperty;
import gregtech.api.unification.material.properties.FluidPipeProperties;
import gregtech.api.unification.material.properties.FluidProperty;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.ItemPipeProperties;
import gregtech.api.unification.material.properties.MaterialProperties;
import gregtech.api.unification.material.properties.OreProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.material.properties.RotorProperty;
import gregtech.api.unification.material.properties.ToolProperty;
import gregtech.api.unification.material.properties.WireProperties;
import gregtech.api.unification.material.properties.WoodProperty;
import gregtech.api.unification.material.registry.MaterialRegistry;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.util.FluidTooltipUtil;
import gregtech.api.util.GTUtility;
import gregtech.api.util.LocalizationUtils;
import gregtech.api.util.SmallDigits;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenOperator;

@ZenClass(value="mods.gregtech.material.Material")
@ZenRegister
public class Material
implements Comparable<Material> {
    @NotNull
    private final MaterialInfo materialInfo;
    @NotNull
    private final MaterialProperties properties;
    @NotNull
    private final MaterialFlags flags;
    private String chemicalFormula;

    @NotNull
    private String calculateChemicalFormula() {
        if (this.chemicalFormula != null) {
            return this.chemicalFormula;
        }
        if (this.materialInfo.element != null) {
            return this.materialInfo.element.getSymbol();
        }
        if (!this.materialInfo.componentList.isEmpty()) {
            if (this.materialInfo.componentList.size() == 1) {
                MaterialStack stack = (MaterialStack)this.materialInfo.componentList.get(0);
                if (stack.amount == 1L) {
                    return stack.material.getChemicalFormula();
                }
            }
            StringBuilder components = new StringBuilder();
            for (MaterialStack component : this.materialInfo.componentList) {
                components.append(component.toFormatted());
            }
            return components.toString();
        }
        return "";
    }

    @ZenGetter
    public String getChemicalFormula() {
        return this.chemicalFormula;
    }

    @ZenMethod
    public Material setFormula(String formula) {
        return this.setFormula(formula, false);
    }

    @ZenMethod
    public Material setFormula(String formula, boolean withFormatting) {
        this.chemicalFormula = withFormatting ? SmallDigits.toSmallDownNumbers(formula) : formula;
        return this;
    }

    public ImmutableList<MaterialStack> getMaterialComponents() {
        return this.materialInfo.componentList;
    }

    @ZenGetter(value="components")
    public MaterialStack[] getMaterialComponentsCt() {
        return (MaterialStack[])this.getMaterialComponents().toArray((Object[])new MaterialStack[0]);
    }

    private Material(@NotNull MaterialInfo materialInfo, @NotNull MaterialProperties properties, @NotNull MaterialFlags flags) {
        this.materialInfo = materialInfo;
        this.properties = properties;
        this.flags = flags;
        this.properties.setMaterial(this);
        this.registerMaterial();
    }

    protected Material(@NotNull ResourceLocation resourceLocation) {
        this.materialInfo = new MaterialInfo(0, resourceLocation);
        this.materialInfo.iconSet = MaterialIconSet.DULL;
        this.properties = new MaterialProperties();
        this.flags = new MaterialFlags();
    }

    protected void registerMaterial() {
        this.verifyMaterial();
        GregTechAPI.materialManager.getRegistry(this.getModid()).register(this);
    }

    public void addFlags(MaterialFlag ... flags) {
        if (!GregTechAPI.materialManager.canModifyMaterials()) {
            throw new IllegalStateException("Cannot add flag to material when registry is frozen!");
        }
        this.flags.addFlags(flags).verify(this);
    }

    @ZenMethod
    public void addFlags(String ... names) {
        this.addFlags((MaterialFlag[])Arrays.stream(names).map(MaterialFlag::getByName).filter(Objects::nonNull).toArray(MaterialFlag[]::new));
    }

    public boolean hasFlag(MaterialFlag flag) {
        return this.flags.hasFlag(flag);
    }

    public boolean isElement() {
        return this.materialInfo.element != null;
    }

    @Nullable
    public Element getElement() {
        return this.materialInfo.element;
    }

    public boolean hasFlags(MaterialFlag ... flags) {
        return Arrays.stream(flags).allMatch(this::hasFlag);
    }

    public boolean hasAnyOfFlags(MaterialFlag ... flags) {
        return Arrays.stream(flags).anyMatch(this::hasFlag);
    }

    protected void calculateDecompositionType() {
        if (!(this.materialInfo.componentList.isEmpty() || this.hasFlag(MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING) || this.hasFlag(MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING) || this.hasFlag(MaterialFlags.DISABLE_DECOMPOSITION))) {
            boolean onlyMetalMaterials = true;
            for (MaterialStack materialStack : this.materialInfo.componentList) {
                Material material = materialStack.material;
                onlyMetalMaterials &= material.hasProperty(PropertyKey.INGOT);
            }
            if (onlyMetalMaterials) {
                this.flags.addFlags(MaterialFlags.DECOMPOSITION_BY_CENTRIFUGING);
            } else {
                this.flags.addFlags(MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING);
            }
        }
    }

    public Fluid getFluid() {
        FluidProperty prop = this.getProperty(PropertyKey.FLUID);
        if (prop == null) {
            throw new IllegalArgumentException("Material " + this.getResourceLocation() + " does not have a Fluid!");
        }
        FluidStorageKey key = prop.getPrimaryKey();
        Fluid fluid = null;
        if (key != null) {
            fluid = prop.getStorage().get(key);
        }
        if (fluid != null) {
            return fluid;
        }
        fluid = this.getFluid(FluidStorageKeys.LIQUID);
        if (fluid != null) {
            return fluid;
        }
        return this.getFluid(FluidStorageKeys.GAS);
    }

    public Fluid getFluid(@NotNull FluidStorageKey key) {
        FluidProperty prop = this.getProperty(PropertyKey.FLUID);
        if (prop == null) {
            throw new IllegalArgumentException("Material " + this.getResourceLocation() + " does not have a Fluid!");
        }
        return prop.getStorage().get(key);
    }

    public FluidStack getFluid(int amount) {
        return new FluidStack(this.getFluid(), amount);
    }

    public FluidStack getFluid(@NotNull FluidStorageKey key, int amount) {
        return new FluidStack(this.getFluid(key), amount);
    }

    public int getBlockHarvestLevel() {
        if (!this.hasProperty(PropertyKey.DUST)) {
            throw new IllegalArgumentException("Material " + this.getResourceLocation() + " does not have a harvest level! Is probably a Fluid");
        }
        int harvestLevel = this.getProperty(PropertyKey.DUST).getHarvestLevel();
        return harvestLevel > 0 ? harvestLevel - 1 : harvestLevel;
    }

    public int getToolHarvestLevel() {
        if (!this.hasProperty(PropertyKey.TOOL)) {
            throw new IllegalArgumentException("Material " + this.getResourceLocation() + " does not have a tool harvest level! Is probably not a Tool Material");
        }
        return this.getProperty(PropertyKey.TOOL).getToolHarvestLevel();
    }

    @ZenMethod
    public void setMaterialRGB(int materialRGB) {
        this.materialInfo.color = materialRGB;
    }

    @ZenGetter(value="materialRGB")
    public int getMaterialRGB() {
        return this.materialInfo.color;
    }

    public void setMaterialIconSet(MaterialIconSet materialIconSet) {
        this.materialInfo.iconSet = materialIconSet;
    }

    public MaterialIconSet getMaterialIconSet() {
        return this.materialInfo.iconSet;
    }

    @ZenGetter(value="radioactive")
    public boolean isRadioactive() {
        if (this.materialInfo.element != null) {
            return ((MaterialInfo)this.materialInfo).element.halfLifeSeconds >= 0L;
        }
        for (MaterialStack material : this.materialInfo.componentList) {
            if (!material.material.isRadioactive()) continue;
            return true;
        }
        return false;
    }

    @ZenGetter(value="protons")
    public long getProtons() {
        if (this.materialInfo.element != null) {
            return this.materialInfo.element.getProtons();
        }
        if (this.materialInfo.componentList.isEmpty()) {
            return Math.max(1L, Elements.Tc.getProtons());
        }
        long totalProtons = 0L;
        long totalAmount = 0L;
        for (MaterialStack material : this.materialInfo.componentList) {
            totalAmount += material.amount;
            totalProtons += material.amount * material.material.getProtons();
        }
        return totalProtons / totalAmount;
    }

    @ZenGetter(value="neutrons")
    public long getNeutrons() {
        if (this.materialInfo.element != null) {
            return this.materialInfo.element.getNeutrons();
        }
        if (this.materialInfo.componentList.isEmpty()) {
            return Elements.Tc.getNeutrons();
        }
        long totalNeutrons = 0L;
        long totalAmount = 0L;
        for (MaterialStack material : this.materialInfo.componentList) {
            totalAmount += material.amount;
            totalNeutrons += material.amount * material.material.getNeutrons();
        }
        return totalNeutrons / totalAmount;
    }

    @ZenGetter(value="mass")
    public long getMass() {
        if (this.materialInfo.element != null) {
            return this.materialInfo.element.getMass();
        }
        if (this.materialInfo.componentList.size() == 0) {
            return Elements.Tc.getMass();
        }
        long totalMass = 0L;
        long totalAmount = 0L;
        for (MaterialStack material : this.materialInfo.componentList) {
            totalAmount += material.amount;
            totalMass += material.amount * material.material.getMass();
        }
        return totalMass / totalAmount;
    }

    @ZenGetter(value="blastTemperature")
    public int getBlastTemperature() {
        BlastProperty prop = this.properties.getProperty(PropertyKey.BLAST);
        return prop == null ? 0 : prop.getBlastTemperature();
    }

    public FluidStack getPlasma(int amount) {
        return this.getFluid(FluidStorageKeys.PLASMA, amount);
    }

    @ZenGetter(value="name")
    @NotNull
    public String getName() {
        return this.getResourceLocation().func_110623_a();
    }

    @NotNull
    public String getModid() {
        return this.getResourceLocation().func_110624_b();
    }

    @NotNull
    public ResourceLocation getResourceLocation() {
        return this.materialInfo.resourceLocation;
    }

    @ZenGetter(value="camelCaseName")
    public String toCamelCaseString() {
        return GTUtility.lowerUnderscoreToUpperCamel(this.toString());
    }

    @ZenGetter(value="unlocalizedName")
    public String getUnlocalizedName() {
        ResourceLocation location = this.getResourceLocation();
        return location.func_110624_b() + ".material." + location.func_110623_a();
    }

    @NotNull
    public String getRegistryName() {
        ResourceLocation location = this.getResourceLocation();
        return location.func_110624_b() + ':' + location.func_110623_a();
    }

    @ZenGetter(value="localizedName")
    public String getLocalizedName() {
        return LocalizationUtils.format(this.getUnlocalizedName(), new Object[0]);
    }

    @Override
    @ZenMethod
    public int compareTo(Material material) {
        return this.getName().compareTo(material.getName());
    }

    public String toString() {
        return this.getName();
    }

    public int getId() {
        return this.materialInfo.metaItemSubId;
    }

    @ZenOperator(value=OperatorType.MUL)
    public MaterialStack multiply(long amount) {
        return new MaterialStack(this, amount);
    }

    @NotNull
    public MaterialProperties getProperties() {
        return this.properties;
    }

    public <T extends IMaterialProperty> boolean hasProperty(PropertyKey<T> key) {
        return this.getProperty(key) != null;
    }

    public <T extends IMaterialProperty> T getProperty(PropertyKey<T> key) {
        return this.properties.getProperty(key);
    }

    public <T extends IMaterialProperty> void setProperty(PropertyKey<T> key, IMaterialProperty property) {
        if (!GregTechAPI.materialManager.canModifyMaterials()) {
            throw new IllegalStateException("Cannot add properties to a Material when registry is frozen!");
        }
        this.properties.setProperty(key, property);
        this.properties.verify();
    }

    public boolean isSolid() {
        return this.hasProperty(PropertyKey.INGOT) || this.hasProperty(PropertyKey.GEM);
    }

    public boolean hasFluid() {
        return this.hasProperty(PropertyKey.FLUID);
    }

    public void verifyMaterial() {
        this.properties.verify();
        this.flags.verify(this);
        this.chemicalFormula = this.calculateChemicalFormula();
        this.calculateDecompositionType();
    }

    @NotNull
    public MaterialRegistry getRegistry() {
        return GregTechAPI.materialManager.getRegistry(this.getModid());
    }

    private static class MaterialInfo {
        private final ResourceLocation resourceLocation;
        private final int metaItemSubId;
        private int color = -1;
        private MaterialIconSet iconSet;
        private ImmutableList<MaterialStack> componentList;
        private Element element;

        private MaterialInfo(int metaItemSubId, @NotNull ResourceLocation resourceLocation) {
            this.metaItemSubId = metaItemSubId;
            String name = resourceLocation.func_110623_a();
            if (!GTUtility.toLowerCaseUnderscore(GTUtility.lowerUnderscoreToUpperCamel(name)).equals(name)) {
                throw new IllegalArgumentException("Cannot add materials with names like 'materialnumber'! Use 'material_number' instead.");
            }
            this.resourceLocation = resourceLocation;
        }

        private void verifyInfo(MaterialProperties p, boolean averageRGB) {
            if (this.iconSet == null) {
                this.iconSet = p.hasProperty(PropertyKey.GEM) ? MaterialIconSet.GEM_VERTICAL : (p.hasProperty(PropertyKey.DUST) || p.hasProperty(PropertyKey.INGOT) || p.hasProperty(PropertyKey.POLYMER) ? MaterialIconSet.DULL : (p.hasProperty(PropertyKey.FLUID) ? MaterialIconSet.FLUID : MaterialIconSet.DULL));
            }
            if (this.color == -1) {
                if (!averageRGB || this.componentList.isEmpty()) {
                    this.color = 0xFFFFFF;
                } else {
                    long colorTemp = 0L;
                    int divisor = 0;
                    for (MaterialStack stack : this.componentList) {
                        colorTemp += (long)stack.material.getMaterialRGB() * stack.amount;
                        divisor = (int)((long)divisor + stack.amount);
                    }
                    this.color = (int)(colorTemp / (long)divisor);
                }
            }
        }
    }

    public static class Builder {
        private final MaterialInfo materialInfo;
        private final MaterialProperties properties;
        private final MaterialFlags flags;
        private final List<Consumer<Material>> postProcessors = new ArrayList<Consumer<Material>>(1);
        private List<MaterialStack> composition = new ArrayList<MaterialStack>();
        private boolean averageRGB = false;

        public Builder(int id, @NotNull ResourceLocation resourceLocation) {
            String name = resourceLocation.func_110623_a();
            if (name.charAt(name.length() - 1) == '_') {
                throw new IllegalArgumentException("Material name cannot end with a '_'!");
            }
            this.materialInfo = new MaterialInfo(id, resourceLocation);
            this.properties = new MaterialProperties();
            this.flags = new MaterialFlags();
        }

        public Builder fluid() {
            return this.fluid(FluidStorageKeys.LIQUID, new FluidBuilder());
        }

        public Builder fluid(@NotNull FluidStorageKey key, @NotNull FluidState state) {
            return this.fluid(key, new FluidBuilder().state(state));
        }

        public Builder fluid(@NotNull FluidStorageKey key, @NotNull FluidBuilder builder) {
            this.properties.ensureSet(PropertyKey.FLUID);
            FluidProperty property = this.properties.getProperty(PropertyKey.FLUID);
            property.getStorage().enqueueRegistration(key, builder);
            return this;
        }

        public Builder fluid(@NotNull Fluid fluid, @NotNull FluidStorageKey key, @NotNull FluidState state) {
            this.properties.ensureSet(PropertyKey.FLUID);
            FluidProperty property = this.properties.getProperty(PropertyKey.FLUID);
            property.getStorage().store(key, fluid);
            this.postProcessors.add(m -> FluidTooltipUtil.registerTooltip(fluid, FluidTooltipUtil.createFluidTooltip(m, fluid, state)));
            return this;
        }

        public Builder liquid() {
            return this.fluid(FluidStorageKeys.LIQUID, FluidState.LIQUID);
        }

        public Builder liquid(@NotNull FluidBuilder builder) {
            return this.fluid(FluidStorageKeys.LIQUID, builder.state(FluidState.LIQUID));
        }

        public Builder plasma() {
            return this.fluid(FluidStorageKeys.PLASMA, FluidState.PLASMA);
        }

        public Builder plasma(@NotNull FluidBuilder builder) {
            return this.fluid(FluidStorageKeys.PLASMA, builder.state(FluidState.PLASMA));
        }

        public Builder gas() {
            return this.fluid(FluidStorageKeys.GAS, FluidState.GAS);
        }

        public Builder gas(@NotNull FluidBuilder builder) {
            return this.fluid(FluidStorageKeys.GAS, builder.state(FluidState.GAS));
        }

        public Builder dust() {
            this.properties.ensureSet(PropertyKey.DUST);
            return this;
        }

        public Builder dust(int harvestLevel) {
            return this.dust(harvestLevel, 0);
        }

        public Builder dust(int harvestLevel, int burnTime) {
            this.properties.setProperty(PropertyKey.DUST, new DustProperty(harvestLevel, burnTime));
            return this;
        }

        public Builder wood() {
            return this.wood(0, 300);
        }

        public Builder wood(int harvestLevel) {
            return this.wood(harvestLevel, 300);
        }

        public Builder wood(int harvestLevel, int burnTime) {
            this.properties.setProperty(PropertyKey.DUST, new DustProperty(harvestLevel, burnTime));
            this.properties.setProperty(PropertyKey.WOOD, new WoodProperty());
            return this;
        }

        public Builder ingot() {
            this.properties.ensureSet(PropertyKey.INGOT);
            return this;
        }

        public Builder ingot(int harvestLevel) {
            return this.ingot(harvestLevel, 0);
        }

        public Builder ingot(int harvestLevel, int burnTime) {
            DustProperty prop = this.properties.getProperty(PropertyKey.DUST);
            if (prop == null) {
                this.dust(harvestLevel, burnTime);
            } else {
                if (prop.getHarvestLevel() == 2) {
                    prop.setHarvestLevel(harvestLevel);
                }
                if (prop.getBurnTime() == 0) {
                    prop.setBurnTime(burnTime);
                }
            }
            this.properties.ensureSet(PropertyKey.INGOT);
            return this;
        }

        public Builder gem() {
            this.properties.ensureSet(PropertyKey.GEM);
            return this;
        }

        public Builder gem(int harvestLevel) {
            return this.gem(harvestLevel, 0);
        }

        public Builder gem(int harvestLevel, int burnTime) {
            DustProperty prop = this.properties.getProperty(PropertyKey.DUST);
            if (prop == null) {
                this.dust(harvestLevel, burnTime);
            } else {
                if (prop.getHarvestLevel() == 2) {
                    prop.setHarvestLevel(harvestLevel);
                }
                if (prop.getBurnTime() == 0) {
                    prop.setBurnTime(burnTime);
                }
            }
            this.properties.ensureSet(PropertyKey.GEM);
            return this;
        }

        public Builder polymer() {
            this.properties.ensureSet(PropertyKey.POLYMER);
            return this;
        }

        public Builder polymer(int harvestLevel) {
            DustProperty prop = this.properties.getProperty(PropertyKey.DUST);
            if (prop == null) {
                this.dust(harvestLevel, 0);
            } else if (prop.getHarvestLevel() == 2) {
                prop.setHarvestLevel(harvestLevel);
            }
            this.properties.ensureSet(PropertyKey.POLYMER);
            return this;
        }

        public Builder burnTime(int burnTime) {
            DustProperty prop = this.properties.getProperty(PropertyKey.DUST);
            if (prop == null) {
                this.dust();
                prop = this.properties.getProperty(PropertyKey.DUST);
            }
            prop.setBurnTime(burnTime);
            return this;
        }

        public Builder color(int color) {
            this.materialInfo.color = color;
            return this;
        }

        public Builder colorAverage() {
            this.averageRGB = true;
            return this;
        }

        public Builder iconSet(MaterialIconSet iconSet) {
            this.materialInfo.iconSet = iconSet;
            return this;
        }

        public Builder components(Object ... components) {
            Preconditions.checkArgument((components.length % 2 == 0 ? 1 : 0) != 0, (Object)"Material Components list malformed!");
            for (int i = 0; i < components.length; i += 2) {
                if (components[i] == null) {
                    throw new IllegalArgumentException("Material in Components List is null for Material " + this.materialInfo.resourceLocation);
                }
                this.composition.add(new MaterialStack((Material)components[i], ((Integer)components[i + 1]).intValue()));
            }
            return this;
        }

        public Builder components(MaterialStack ... components) {
            this.composition = Arrays.asList(components);
            return this;
        }

        public Builder components(ImmutableList<MaterialStack> components) {
            this.composition = components;
            return this;
        }

        public Builder flags(MaterialFlag ... flags) {
            this.flags.addFlags(flags);
            return this;
        }

        public Builder flags(Collection<MaterialFlag> f1, MaterialFlag ... f2) {
            this.flags.addFlags(f1.toArray(new MaterialFlag[0]));
            this.flags.addFlags(f2);
            return this;
        }

        public Builder element(Element element) {
            this.materialInfo.element = element;
            return this;
        }

        public Builder toolStats(ToolProperty toolProperty) {
            this.properties.setProperty(PropertyKey.TOOL, toolProperty);
            return this;
        }

        public Builder rotorStats(float speed, float damage, int durability) {
            this.properties.setProperty(PropertyKey.ROTOR, new RotorProperty(speed, damage, durability));
            return this;
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2.9")
        public Builder blastTemp(int temp) {
            return this.blast(temp);
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2.9")
        public Builder blastTemp(int temp, BlastProperty.GasTier gasTier) {
            return this.blast(temp, gasTier);
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2.9")
        public Builder blastTemp(int temp, BlastProperty.GasTier gasTier, int eutOverride) {
            return this.blast(b -> b.temp(temp, gasTier).blastStats(eutOverride));
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2.9")
        public Builder blastTemp(int temp, BlastProperty.GasTier gasTier, int eutOverride, int durationOverride) {
            return this.blast(b -> b.temp(temp, gasTier).blastStats(eutOverride, durationOverride));
        }

        public Builder blast(int temp) {
            this.properties.setProperty(PropertyKey.BLAST, new BlastProperty(temp));
            return this;
        }

        public Builder blast(int temp, BlastProperty.GasTier gasTier) {
            this.properties.setProperty(PropertyKey.BLAST, new BlastProperty(temp, gasTier));
            return this;
        }

        public Builder blast(UnaryOperator<BlastProperty.Builder> b) {
            this.properties.setProperty(PropertyKey.BLAST, ((BlastProperty.Builder)b.apply(new BlastProperty.Builder())).build());
            return this;
        }

        public Builder ore() {
            this.properties.ensureSet(PropertyKey.ORE);
            return this;
        }

        public Builder ore(boolean emissive) {
            this.properties.setProperty(PropertyKey.ORE, new OreProperty(1, 1, emissive));
            return this;
        }

        public Builder ore(int oreMultiplier, int byproductMultiplier) {
            this.properties.setProperty(PropertyKey.ORE, new OreProperty(oreMultiplier, byproductMultiplier));
            return this;
        }

        public Builder ore(int oreMultiplier, int byproductMultiplier, boolean emissive) {
            this.properties.setProperty(PropertyKey.ORE, new OreProperty(oreMultiplier, byproductMultiplier, emissive));
            return this;
        }

        public Builder washedIn(Material m) {
            this.properties.ensureSet(PropertyKey.ORE);
            this.properties.getProperty(PropertyKey.ORE).setWashedIn(m);
            return this;
        }

        public Builder washedIn(Material m, int washedAmount) {
            this.properties.ensureSet(PropertyKey.ORE);
            this.properties.getProperty(PropertyKey.ORE).setWashedIn(m, washedAmount);
            return this;
        }

        public Builder separatedInto(Material ... m) {
            this.properties.ensureSet(PropertyKey.ORE);
            this.properties.getProperty(PropertyKey.ORE).setSeparatedInto(m);
            return this;
        }

        public Builder oreSmeltInto(Material m) {
            this.properties.ensureSet(PropertyKey.ORE);
            this.properties.getProperty(PropertyKey.ORE).setDirectSmeltResult(m);
            return this;
        }

        public Builder polarizesInto(Material m) {
            this.properties.ensureSet(PropertyKey.INGOT);
            this.properties.getProperty(PropertyKey.INGOT).setMagneticMaterial(m);
            return this;
        }

        public Builder arcSmeltInto(Material m) {
            this.properties.ensureSet(PropertyKey.INGOT);
            this.properties.getProperty(PropertyKey.INGOT).setArcSmeltingInto(m);
            return this;
        }

        public Builder macerateInto(Material m) {
            this.properties.ensureSet(PropertyKey.INGOT);
            this.properties.getProperty(PropertyKey.INGOT).setMacerateInto(m);
            return this;
        }

        public Builder ingotSmeltInto(Material m) {
            this.properties.ensureSet(PropertyKey.INGOT);
            this.properties.getProperty(PropertyKey.INGOT).setSmeltingInto(m);
            return this;
        }

        public Builder addOreByproducts(Material ... byproducts) {
            this.properties.ensureSet(PropertyKey.ORE);
            this.properties.getProperty(PropertyKey.ORE).addOreByProducts(byproducts);
            return this;
        }

        public Builder cableProperties(long voltage, int amperage, int loss) {
            this.cableProperties((int)voltage, amperage, loss, false);
            return this;
        }

        public Builder cableProperties(long voltage, int amperage, int loss, boolean isSuperCon) {
            this.properties.setProperty(PropertyKey.WIRE, new WireProperties((int)voltage, amperage, loss, isSuperCon));
            return this;
        }

        public Builder cableProperties(long voltage, int amperage, int loss, boolean isSuperCon, int criticalTemperature) {
            this.properties.setProperty(PropertyKey.WIRE, new WireProperties((int)voltage, amperage, loss, isSuperCon, criticalTemperature));
            return this;
        }

        public Builder fluidPipeProperties(int maxTemp, int throughput, boolean gasProof) {
            return this.fluidPipeProperties(maxTemp, throughput, gasProof, false, false, false);
        }

        public Builder fluidPipeProperties(int maxTemp, int throughput, boolean gasProof, boolean acidProof, boolean cryoProof, boolean plasmaProof) {
            this.properties.setProperty(PropertyKey.FLUID_PIPE, new FluidPipeProperties(maxTemp, throughput, gasProof, acidProof, cryoProof, plasmaProof));
            return this;
        }

        public Builder itemPipeProperties(int priority, float stacksPerSec) {
            this.properties.setProperty(PropertyKey.ITEM_PIPE, new ItemPipeProperties(priority, stacksPerSec));
            return this;
        }

        @Deprecated
        public Builder addDefaultEnchant(Enchantment enchant, int level) {
            if (!this.properties.hasProperty(PropertyKey.TOOL)) {
                throw new IllegalArgumentException("Material cannot have an Enchant without Tools!");
            }
            this.properties.getProperty(PropertyKey.TOOL).addEnchantmentForTools(enchant, level);
            return this;
        }

        public Material build() {
            this.materialInfo.componentList = ImmutableList.copyOf(this.composition);
            this.materialInfo.verifyInfo(this.properties, this.averageRGB);
            Material m = new Material(this.materialInfo, this.properties, this.flags);
            if (!this.postProcessors.isEmpty()) {
                this.postProcessors.forEach(p -> p.accept(m));
            }
            return m;
        }
    }
}

