/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification;

import com.google.common.base.CaseFormat;
import crafttweaker.annotations.ZenRegister;
import gregtech.api.unification.Element;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.material.Elements")
@ZenRegister
public class Elements {
    private static final Map<String, Element> elements = new HashMap<String, Element>();
    public static final Element H = Elements.add(1L, 0L, -1L, null, "Hydrogen", "H", false);
    public static final Element D = Elements.add(1L, 1L, -1L, "H", "Deuterium", "D", true);
    public static final Element T = Elements.add(1L, 2L, -1L, "D", "Tritium", "T", true);
    public static final Element He = Elements.add(2L, 2L, -1L, null, "Helium", "He", false);
    public static final Element He3 = Elements.add(2L, 1L, -1L, "H&D", "Helium-3", "He-3", true);
    public static final Element Li = Elements.add(3L, 4L, -1L, null, "Lithium", "Li", false);
    public static final Element Be = Elements.add(4L, 5L, -1L, null, "Beryllium", "Be", false);
    public static final Element B = Elements.add(5L, 5L, -1L, null, "Boron", "B", false);
    public static final Element C = Elements.add(6L, 6L, -1L, null, "Carbon", "C", false);
    public static final Element N = Elements.add(7L, 7L, -1L, null, "Nitrogen", "N", false);
    public static final Element O = Elements.add(8L, 8L, -1L, null, "Oxygen", "O", false);
    public static final Element F = Elements.add(9L, 9L, -1L, null, "Fluorine", "F", false);
    public static final Element Ne = Elements.add(10L, 10L, -1L, null, "Neon", "Ne", false);
    public static final Element Na = Elements.add(11L, 11L, -1L, null, "Sodium", "Na", false);
    public static final Element Mg = Elements.add(12L, 12L, -1L, null, "Magnesium", "Mg", false);
    public static final Element Al = Elements.add(13L, 13L, -1L, null, "Aluminium", "Al", false);
    public static final Element Si = Elements.add(14L, 14L, -1L, null, "Silicon", "Si", false);
    public static final Element P = Elements.add(15L, 15L, -1L, null, "Phosphorus", "P", false);
    public static final Element S = Elements.add(16L, 16L, -1L, null, "Sulfur", "S", false);
    public static final Element Cl = Elements.add(17L, 18L, -1L, null, "Chlorine", "Cl", false);
    public static final Element Ar = Elements.add(18L, 22L, -1L, null, "Argon", "Ar", false);
    public static final Element K = Elements.add(19L, 20L, -1L, null, "Potassium", "K", false);
    public static final Element Ca = Elements.add(20L, 20L, -1L, null, "Calcium", "Ca", false);
    public static final Element Sc = Elements.add(21L, 24L, -1L, null, "Scandium", "Sc", false);
    public static final Element Ti = Elements.add(22L, 26L, -1L, null, "Titanium", "Ti", false);
    public static final Element V = Elements.add(23L, 28L, -1L, null, "Vanadium", "V", false);
    public static final Element Cr = Elements.add(24L, 28L, -1L, null, "Chrome", "Cr", false);
    public static final Element Mn = Elements.add(25L, 30L, -1L, null, "Manganese", "Mn", false);
    public static final Element Fe = Elements.add(26L, 30L, -1L, null, "Iron", "Fe", false);
    public static final Element Co = Elements.add(27L, 32L, -1L, null, "Cobalt", "Co", false);
    public static final Element Ni = Elements.add(28L, 30L, -1L, null, "Nickel", "Ni", false);
    public static final Element Cu = Elements.add(29L, 34L, -1L, null, "Copper", "Cu", false);
    public static final Element Zn = Elements.add(30L, 35L, -1L, null, "Zinc", "Zn", false);
    public static final Element Ga = Elements.add(31L, 39L, -1L, null, "Gallium", "Ga", false);
    public static final Element Ge = Elements.add(32L, 40L, -1L, null, "Germanium", "Ge", false);
    public static final Element As = Elements.add(33L, 42L, -1L, null, "Arsenic", "As", false);
    public static final Element Se = Elements.add(34L, 45L, -1L, null, "Selenium", "Se", false);
    public static final Element Br = Elements.add(35L, 45L, -1L, null, "Bromine", "Br", false);
    public static final Element Kr = Elements.add(36L, 48L, -1L, null, "Krypton", "Kr", false);
    public static final Element Rb = Elements.add(37L, 48L, -1L, null, "Rubidium", "Rb", false);
    public static final Element Sr = Elements.add(38L, 49L, -1L, null, "Strontium", "Sr", false);
    public static final Element Y = Elements.add(39L, 50L, -1L, null, "Yttrium", "Y", false);
    public static final Element Zr = Elements.add(40L, 51L, -1L, null, "Zirconium", "Zr", false);
    public static final Element Nb = Elements.add(41L, 53L, -1L, null, "Niobium", "Nb", false);
    public static final Element Mo = Elements.add(42L, 53L, -1L, null, "Molybdenum", "Mo", false);
    public static final Element Tc = Elements.add(43L, 55L, -1L, null, "Technetium", "Tc", false);
    public static final Element Ru = Elements.add(44L, 57L, -1L, null, "Ruthenium", "Ru", false);
    public static final Element Rh = Elements.add(45L, 58L, -1L, null, "Rhodium", "Rh", false);
    public static final Element Pd = Elements.add(46L, 60L, -1L, null, "Palladium", "Pd", false);
    public static final Element Ag = Elements.add(47L, 60L, -1L, null, "Silver", "Ag", false);
    public static final Element Cd = Elements.add(48L, 64L, -1L, null, "Cadmium", "Cd", false);
    public static final Element In = Elements.add(49L, 65L, -1L, null, "Indium", "In", false);
    public static final Element Sn = Elements.add(50L, 68L, -1L, null, "Tin", "Sn", false);
    public static final Element Sb = Elements.add(51L, 70L, -1L, null, "Antimony", "Sb", false);
    public static final Element Te = Elements.add(52L, 75L, -1L, null, "Tellurium", "Te", false);
    public static final Element I = Elements.add(53L, 74L, -1L, null, "Iodine", "I", false);
    public static final Element Xe = Elements.add(54L, 77L, -1L, null, "Xenon", "Xe", false);
    public static final Element Cs = Elements.add(55L, 77L, -1L, null, "Caesium", "Cs", false);
    public static final Element Ba = Elements.add(56L, 81L, -1L, null, "Barium", "Ba", false);
    public static final Element La = Elements.add(57L, 81L, -1L, null, "Lanthanum", "La", false);
    public static final Element Ce = Elements.add(58L, 82L, -1L, null, "Cerium", "Ce", false);
    public static final Element Pr = Elements.add(59L, 81L, -1L, null, "Praseodymium", "Pr", false);
    public static final Element Nd = Elements.add(60L, 84L, -1L, null, "Neodymium", "Nd", false);
    public static final Element Pm = Elements.add(61L, 83L, -1L, null, "Promethium", "Pm", false);
    public static final Element Sm = Elements.add(62L, 88L, -1L, null, "Samarium", "Sm", false);
    public static final Element Eu = Elements.add(63L, 88L, -1L, null, "Europium", "Eu", false);
    public static final Element Gd = Elements.add(64L, 93L, -1L, null, "Gadolinium", "Gd", false);
    public static final Element Tb = Elements.add(65L, 93L, -1L, null, "Terbium", "Tb", false);
    public static final Element Dy = Elements.add(66L, 96L, -1L, null, "Dysprosium", "Dy", false);
    public static final Element Ho = Elements.add(67L, 97L, -1L, null, "Holmium", "Ho", false);
    public static final Element Er = Elements.add(68L, 99L, -1L, null, "Erbium", "Er", false);
    public static final Element Tm = Elements.add(69L, 99L, -1L, null, "Thulium", "Tm", false);
    public static final Element Yb = Elements.add(70L, 103L, -1L, null, "Ytterbium", "Yb", false);
    public static final Element Lu = Elements.add(71L, 103L, -1L, null, "Lutetium", "Lu", false);
    public static final Element Hf = Elements.add(72L, 106L, -1L, null, "Hafnium", "Hf", false);
    public static final Element Ta = Elements.add(73L, 107L, -1L, null, "Tantalum", "Ta", false);
    public static final Element W = Elements.add(74L, 109L, -1L, null, "Tungsten", "W", false);
    public static final Element Re = Elements.add(75L, 111L, -1L, null, "Rhenium", "Re", false);
    public static final Element Os = Elements.add(76L, 114L, -1L, null, "Osmium", "Os", false);
    public static final Element Ir = Elements.add(77L, 115L, -1L, null, "Iridium", "Ir", false);
    public static final Element Pt = Elements.add(78L, 117L, -1L, null, "Platinum", "Pt", false);
    public static final Element Au = Elements.add(79L, 117L, -1L, null, "Gold", "Au", false);
    public static final Element Hg = Elements.add(80L, 120L, -1L, null, "Mercury", "Hg", false);
    public static final Element Tl = Elements.add(81L, 123L, -1L, null, "Thallium", "Tl", false);
    public static final Element Pb = Elements.add(82L, 125L, -1L, null, "Lead", "Pb", false);
    public static final Element Bi = Elements.add(83L, 125L, -1L, null, "Bismuth", "Bi", false);
    public static final Element Po = Elements.add(84L, 124L, -1L, null, "Polonium", "Po", false);
    public static final Element At = Elements.add(85L, 124L, -1L, null, "Astatine", "At", false);
    public static final Element Rn = Elements.add(86L, 134L, -1L, null, "Radon", "Rn", false);
    public static final Element Fr = Elements.add(87L, 134L, -1L, null, "Francium", "Fr", false);
    public static final Element Ra = Elements.add(88L, 136L, -1L, null, "Radium", "Ra", false);
    public static final Element Ac = Elements.add(89L, 136L, -1L, null, "Actinium", "Ac", false);
    public static final Element Th = Elements.add(90L, 140L, -1L, null, "Thorium", "Th", false);
    public static final Element Pa = Elements.add(91L, 138L, -1L, null, "Protactinium", "Pa", false);
    public static final Element U = Elements.add(92L, 146L, -1L, null, "Uranium", "U", false);
    public static final Element U238 = Elements.add(92L, 146L, -1L, null, "Uranium-238", "U-238", false);
    public static final Element U235 = Elements.add(92L, 143L, -1L, null, "Uranium-235", "U-235", true);
    public static final Element Np = Elements.add(93L, 144L, -1L, null, "Neptunium", "Np", false);
    public static final Element Pu = Elements.add(94L, 152L, -1L, null, "Plutonium", "Pu", false);
    public static final Element Pu239 = Elements.add(94L, 145L, -1L, null, "Plutonium-239", "Pu-239", false);
    public static final Element Pu241 = Elements.add(94L, 149L, -1L, null, "Plutonium-241", "Pu-241", true);
    public static final Element Am = Elements.add(95L, 150L, -1L, null, "Americium", "Am", false);
    public static final Element Cm = Elements.add(96L, 153L, -1L, null, "Curium", "Cm", false);
    public static final Element Bk = Elements.add(97L, 152L, -1L, null, "Berkelium", "Bk", false);
    public static final Element Cf = Elements.add(98L, 153L, -1L, null, "Californium", "Cf", false);
    public static final Element Es = Elements.add(99L, 153L, -1L, null, "Einsteinium", "Es", false);
    public static final Element Fm = Elements.add(100L, 157L, -1L, null, "Fermium", "Fm", false);
    public static final Element Md = Elements.add(101L, 157L, -1L, null, "Mendelevium", "Md", false);
    public static final Element No = Elements.add(102L, 157L, -1L, null, "Nobelium", "No", false);
    public static final Element Lr = Elements.add(103L, 159L, -1L, null, "Lawrencium", "Lr", false);
    public static final Element Rf = Elements.add(104L, 161L, -1L, null, "Rutherfordium", "Rf", false);
    public static final Element Db = Elements.add(105L, 163L, -1L, null, "Dubnium", "Db", false);
    public static final Element Sg = Elements.add(106L, 165L, -1L, null, "Seaborgium", "Sg", false);
    public static final Element Bh = Elements.add(107L, 163L, -1L, null, "Bohrium", "Bh", false);
    public static final Element Hs = Elements.add(108L, 169L, -1L, null, "Hassium", "Hs", false);
    public static final Element Mt = Elements.add(109L, 167L, -1L, null, "Meitnerium", "Mt", false);
    public static final Element Ds = Elements.add(110L, 171L, -1L, null, "Darmstadtium", "Ds", false);
    public static final Element Rg = Elements.add(111L, 169L, -1L, null, "Roentgenium", "Rg", false);
    public static final Element Cn = Elements.add(112L, 173L, -1L, null, "Copernicium", "Cn", false);
    public static final Element Nh = Elements.add(113L, 171L, -1L, null, "Nihonium", "Nh", false);
    public static final Element Fl = Elements.add(114L, 175L, -1L, null, "Flerovium", "Fl", false);
    public static final Element Mc = Elements.add(115L, 173L, -1L, null, "Moscovium", "Mc", false);
    public static final Element Lv = Elements.add(116L, 177L, -1L, null, "Livermorium", "Lv", false);
    public static final Element Ts = Elements.add(117L, 177L, -1L, null, "Tennessine", "Ts", false);
    public static final Element Og = Elements.add(118L, 176L, -1L, null, "Oganesson", "Og", false);
    public static final Element Tr = Elements.add(119L, 178L, -1L, null, "Tritanium", "Tr", false);
    public static final Element Dr = Elements.add(120L, 180L, -1L, null, "Duranium", "Dr", false);
    public static final Element Ke = Elements.add(125L, 198L, -1L, null, "Trinium", "Ke", false);
    public static final Element Nq = Elements.add(174L, 352L, 140L, null, "Naquadah", "Nq", true);
    public static final Element Nq1 = Elements.add(174L, 354L, 140L, null, "NaquadahEnriched", "Nq+", true);
    public static final Element Nq2 = Elements.add(174L, 348L, 140L, null, "Naquadria", "*Nq*", true);
    public static final Element Nt = Elements.add(0L, 1000L, -1L, null, "Neutronium", "Nt", false);
    public static final Element Sp = Elements.add(1L, 0L, -1L, null, "Space", "Sp", false);
    public static final Element Ma = Elements.add(1L, 0L, -1L, null, "Magic", "Ma", false);

    private Elements() {
    }

    @ZenMethod
    public static Element add(long protons, long neutrons, long halfLifeSeconds, String decayTo, String name, String symbol, boolean isIsotope) {
        Element element = new Element(protons, neutrons, halfLifeSeconds, decayTo, name, symbol, isIsotope);
        elements.put(name, element);
        return element;
    }

    public static List<Element> getAllElements() {
        return Collections.unmodifiableList(new ArrayList<Element>(elements.values()));
    }

    @ZenMethod(value="getAllElements")
    public static Element[] getAllElementsCT() {
        return elements.values().toArray(new Element[0]);
    }

    @ZenMethod
    public static Element get(String name) {
        return elements.get(CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, name));
    }
}

