/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.terminal.os.menu;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.terminal.app.AbstractApplication;
import gregtech.api.terminal.gui.widgets.CircleButtonWidget;
import gregtech.api.terminal.os.SystemCall;
import gregtech.api.terminal.os.TerminalOSWidget;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.api.terminal.os.menu.IMenuComponent;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.api.util.interpolate.Eases;
import gregtech.api.util.interpolate.Interpolator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TerminalMenuWidget
extends WidgetGroup {
    @SideOnly(value=Side.CLIENT)
    private Interpolator interpolator;
    private IGuiTexture background;
    private final TerminalOSWidget os;
    private final List<Tuple<IMenuComponent, WidgetGroup>> components;
    public boolean isHide;

    public TerminalMenuWidget(Position position, Size size, TerminalOSWidget os) {
        super(position, size);
        this.addSelfPosition(-size.width, 0);
        this.setVisible(false);
        this.isHide = true;
        this.os = os;
        this.components = new ArrayList<Tuple<IMenuComponent, WidgetGroup>>();
        this.addWidget(new CircleButtonWidget(5, 10, 4, 1, 0).setColors(0, TerminalTheme.COLOR_7.getColor(), TerminalTheme.COLOR_3.getColor()).setHoverText("terminal.menu.close").setClickListener(this::close));
        this.addWidget(new CircleButtonWidget(15, 10, 4, 1, 0).setColors(0, TerminalTheme.COLOR_7.getColor(), TerminalTheme.COLOR_2.getColor()).setHoverText("terminal.menu.minimize").setClickListener(this::minimize));
        this.addWidget(new CircleButtonWidget(25, 10, 4, 1, 0).setColors(0, TerminalTheme.COLOR_7.getColor(), TerminalTheme.COLOR_1.getColor()).setHoverText("terminal.menu.maximize").setClickListener(this::maximize));
    }

    public TerminalMenuWidget setBackground(IGuiTexture background) {
        this.background = background;
        return this;
    }

    public void close(Widget.ClickData clickData) {
        SystemCall.CLOSE_FOCUS_APP.call(this.os, clickData.isClient, new String[0]);
    }

    public void minimize(Widget.ClickData clickData) {
        SystemCall.MINIMIZE_FOCUS_APP.call(this.os, clickData.isClient, new String[0]);
    }

    public void maximize(Widget.ClickData clickData) {
        SystemCall.FULL_SCREEN.call(this.os, clickData.isClient, new String[0]);
    }

    public void addComponent(IMenuComponent component) {
        WidgetGroup group = new WidgetGroup();
        int x = 15;
        int y = 40 + this.components.size() * 25;
        CircleButtonWidget button = new CircleButtonWidget(x, y, 10, 1, 16).setColors(0, -1, 0).setHoverText(component.hoverText()).setIcon(component.buttonIcon());
        button.setClickListener(c -> {
            this.components.forEach(tuple -> {
                if (tuple.func_76341_a() instanceof Widget && tuple.func_76341_a() != component) {
                    ((Widget)tuple.func_76341_a()).setActive(false);
                    ((Widget)tuple.func_76341_a()).setVisible(false);
                    ((CircleButtonWidget)((WidgetGroup)tuple.func_76340_b()).widgets.get(0)).setFill(0);
                }
            });
            if (component instanceof Widget) {
                Widget widget;
                widget.setVisible(!(widget = (Widget)((Object)component)).isVisible());
                widget.setActive(!widget.isActive());
                button.setFill(widget.isVisible() ? -7019839 : 0);
            }
            component.click((Widget.ClickData)c);
        });
        group.addWidget(button);
        if (component instanceof Widget) {
            Widget widget = (Widget)((Object)component);
            widget.setSelfPosition(new Position(x + 20, 0));
            widget.setVisible(false);
            widget.setActive(false);
            group.addWidget(widget);
        }
        this.addWidget(group);
        this.components.add((Tuple<IMenuComponent, WidgetGroup>)new Tuple((Object)component, (Object)group));
    }

    public void loadComponents(AbstractApplication app) {
        this.removeComponents();
        if (app != null) {
            app.getMenuComponents().forEach(this::addComponent);
        }
    }

    public void removeComponents() {
        this.components.forEach(component -> this.removeWidget((Widget)component.func_76340_b()));
        this.components.clear();
    }

    @SideOnly(value=Side.CLIENT)
    public void hideMenu() {
        if (!this.isHide && this.interpolator == null) {
            int y = this.getSelfPosition().y;
            this.interpolator = new Interpolator(this.getSelfPosition().x, this.getSelfPosition().x - this.getSize().width, 6, Eases.LINEAR, value -> this.setSelfPosition(new Position(value.intValue(), y)), value -> {
                this.setVisible(false);
                this.interpolator = null;
                this.isHide = true;
            });
            this.interpolator.start();
            this.os.desktop.removeTopWidget(this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void showMenu() {
        if (this.isHide && this.interpolator == null) {
            this.setVisible(true);
            int y = this.getSelfPosition().y;
            this.interpolator = new Interpolator(this.getSelfPosition().x, this.getSelfPosition().x + this.getSize().width, 6, Eases.LINEAR, value -> this.setSelfPosition(new Position(value.intValue(), y)), value -> {
                this.interpolator = null;
                this.isHide = false;
            });
            this.interpolator.start();
            this.os.desktop.addTopWidget(this);
        }
    }

    @Override
    public void updateScreenOnFrame() {
        if (this.interpolator != null) {
            this.interpolator.func_73660_a();
        }
        super.updateScreenOnFrame();
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        if (this.background != null) {
            this.background.draw(this.getPosition().x, this.getPosition().y, this.getSize().width, this.getSize().height);
        } else {
            TerminalMenuWidget.drawGradientRect(this.getPosition().x, this.getPosition().y, this.getSize().width, this.getSize().height, -16777216, -16777216);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (!super.mouseClicked(mouseX, mouseY, button)) {
            if (this.isMouseOverElement(mouseX, mouseY)) {
                return true;
            }
            if (!this.isHide) {
                this.hideMenu();
            }
            return false;
        }
        return true;
    }
}

