/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.map;

import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.map.AbstractMapIngredient;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class MapItemStackIngredient
extends AbstractMapIngredient {
    protected ItemStack stack;
    protected int meta;
    protected NBTTagCompound tag;
    protected GTRecipeInput gtRecipeInput = null;

    public MapItemStackIngredient(ItemStack stack, int meta, NBTTagCompound tag) {
        this.stack = stack;
        this.meta = meta;
        this.tag = tag;
    }

    public MapItemStackIngredient(ItemStack stack, GTRecipeInput gtRecipeInput) {
        this.stack = stack;
        this.meta = stack.func_77960_j();
        this.tag = stack.func_77978_p();
        this.gtRecipeInput = gtRecipeInput;
    }

    @NotNull
    public static List<AbstractMapIngredient> from(@NotNull GTRecipeInput r) {
        ObjectArrayList list = new ObjectArrayList();
        for (ItemStack s : r.getInputStacks()) {
            list.add((Object)new MapItemStackIngredient(s, r));
        }
        return list;
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            MapItemStackIngredient other = (MapItemStackIngredient)o;
            if (this.stack.func_77973_b() != other.stack.func_77973_b()) {
                return false;
            }
            if (this.meta != other.meta) {
                return false;
            }
            if (this.gtRecipeInput != null) {
                if (other.gtRecipeInput != null) {
                    return this.gtRecipeInput.equalIgnoreAmount(other.gtRecipeInput);
                }
            } else if (other.gtRecipeInput != null) {
                return other.gtRecipeInput.acceptsStack(this.stack);
            }
        }
        return false;
    }

    @Override
    protected int hash() {
        int hash = this.stack.func_77973_b().hashCode() * 31;
        hash += 31 * this.meta;
        return hash += 31 * (this.tag != null ? this.tag.hashCode() : 0);
    }

    public String toString() {
        return "MapItemStackIngredient{item=" + this.stack.func_77973_b().getRegistryName() + "} {meta=" + this.meta + "} {tag=" + this.tag + "}";
    }
}

