/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.logic;

import org.jetbrains.annotations.NotNull;

public class OverclockingLogic {
    public static final double STANDARD_OVERCLOCK_VOLTAGE_MULTIPLIER = 4.0;
    public static final double STANDARD_OVERCLOCK_DURATION_DIVISOR = 2.0;
    public static final double PERFECT_OVERCLOCK_DURATION_DIVISOR = 4.0;
    public static final int COIL_EUT_DISCOUNT_TEMPERATURE = 900;

    public static int @NotNull [] standardOverclockingLogic(int recipeEUt, long maxVoltage, int recipeDuration, int numberOfOCs, double durationDivisor, double voltageMultiplier) {
        double potentialVoltage;
        double resultDuration = recipeDuration;
        double resultVoltage = recipeEUt;
        while (numberOfOCs > 0 && resultDuration != 1.0 && !((potentialVoltage = resultVoltage * voltageMultiplier) > (double)maxVoltage)) {
            double potentialDuration = resultDuration / durationDivisor;
            if (potentialDuration < 1.0) {
                potentialDuration = 1.0;
            }
            resultDuration = potentialDuration;
            resultVoltage = potentialVoltage;
            --numberOfOCs;
        }
        return new int[]{(int)resultVoltage, (int)resultDuration};
    }

    private static int calculateAmountCoilEUtDiscount(int providedTemp, int requiredTemp) {
        return Math.max(0, (providedTemp - requiredTemp) / 900);
    }

    public static int applyCoilEUtDiscount(int recipeEUt, int providedTemp, int requiredTemp) {
        if (requiredTemp < 900) {
            return recipeEUt;
        }
        int amountEUtDiscount = OverclockingLogic.calculateAmountCoilEUtDiscount(providedTemp, requiredTemp);
        if (amountEUtDiscount < 1) {
            return recipeEUt;
        }
        return (int)((double)recipeEUt * Math.min(1.0, Math.pow(0.95, amountEUtDiscount)));
    }

    public static int @NotNull [] heatingCoilOverclockingLogic(int recipeEUt, long maximumVoltage, int recipeDuration, int maxOverclocks, int currentTemp, int recipeRequiredTemp) {
        int amountPerfectOC = OverclockingLogic.calculateAmountCoilEUtDiscount(currentTemp, recipeRequiredTemp) / 2;
        if (amountPerfectOC > 0) {
            int[] overclock = OverclockingLogic.standardOverclockingLogic(recipeEUt, maximumVoltage, recipeDuration, amountPerfectOC, 4.0, 4.0);
            return OverclockingLogic.standardOverclockingLogic(overclock[0], maximumVoltage, overclock[1], maxOverclocks - amountPerfectOC, 2.0, 4.0);
        }
        return OverclockingLogic.standardOverclockingLogic(recipeEUt, maximumVoltage, recipeDuration, maxOverclocks, 2.0, 4.0);
    }
}

