/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.ingredients.nbtmatch;

import gregtech.api.recipes.ingredients.nbtmatch.ListNBTCondition;
import gregtech.api.recipes.ingredients.nbtmatch.NBTCondition;
import gregtech.api.recipes.ingredients.nbtmatch.NBTTagType;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface NBTMatcher {
    public static final NBTMatcher ANY = (tag, condition) -> true;
    public static final NBTMatcher LESS_THAN = (tag, condition) -> {
        if (condition == null || condition.tagType == null) {
            return false;
        }
        if (NBTMatcher.hasKey(tag, condition.nbtKey, condition.tagType.typeId) && NBTTagType.isNumeric(condition.tagType)) {
            return tag.func_74763_f(condition.nbtKey) < (Long)condition.value;
        }
        return false;
    };
    public static final NBTMatcher LESS_THAN_OR_EQUAL_TO = (tag, condition) -> {
        if (condition == null || condition.tagType == null) {
            return false;
        }
        if (NBTMatcher.hasKey(tag, condition.nbtKey, condition.tagType.typeId) && NBTTagType.isNumeric(condition.tagType)) {
            return tag.func_74763_f(condition.nbtKey) <= (Long)condition.value;
        }
        return false;
    };
    public static final NBTMatcher GREATER_THAN = (tag, condition) -> {
        if (condition == null || condition.tagType == null) {
            return false;
        }
        if (NBTMatcher.hasKey(tag, condition.nbtKey, condition.tagType.typeId) && NBTTagType.isNumeric(condition.tagType)) {
            return tag.func_74763_f(condition.nbtKey) > (Long)condition.value;
        }
        return false;
    };
    public static final NBTMatcher GREATER_THAN_OR_EQUAL_TO = (tag, condition) -> {
        if (condition == null || condition.tagType == null) {
            return false;
        }
        if (NBTMatcher.hasKey(tag, condition.nbtKey, condition.tagType.typeId) && NBTTagType.isNumeric(condition.tagType)) {
            return tag.func_74763_f(condition.nbtKey) >= (Long)condition.value;
        }
        return false;
    };
    public static final NBTMatcher EQUAL_TO = (tag, condition) -> {
        if (condition == null || condition.tagType == null) {
            return false;
        }
        if (NBTMatcher.hasKey(tag, condition.nbtKey, condition.tagType.typeId)) {
            if (NBTTagType.isNumeric(condition.tagType)) {
                return tag.func_74763_f(condition.nbtKey) == ((Long)condition.value).longValue();
            }
            switch (condition.tagType) {
                case BOOLEAN: {
                    return tag.func_74767_n(condition.nbtKey) == ((Boolean)condition.value).booleanValue();
                }
                case BYTE_ARRAY: {
                    return tag.func_74770_j(condition.nbtKey).equals(condition.value);
                }
                case STRING: {
                    return tag.func_74779_i(condition.nbtKey).equals(condition.value);
                }
                case LIST: {
                    if (condition instanceof ListNBTCondition) {
                        return tag.func_150295_c((String)condition.nbtKey, (int)((ListNBTCondition)condition).listTagType.typeId).field_74747_a.equals(condition.value);
                    }
                    return false;
                }
                case COMPOUND: {
                    return tag.func_74775_l(condition.nbtKey).equals(condition.value);
                }
                case INT_ARRAY: {
                    return tag.func_74759_k(condition.nbtKey).equals(condition.value);
                }
                case LONG_ARRAY: {
                    return ((NBTTagLongArray)tag.func_74781_a((String)condition.nbtKey)).field_193587_b.equals(condition.value);
                }
            }
        }
        return false;
    };
    public static final NBTMatcher RECURSIVE_EQUAL_TO = new NBTMatcher(){

        @Override
        public boolean evaluate(@Nullable NBTTagCompound tag, @Nullable NBTCondition condition) {
            if (condition == null || condition.tagType == null) {
                return false;
            }
            if (NBTMatcher.hasKey(tag, condition.nbtKey, condition.tagType.typeId)) {
                if (NBTTagType.isNumeric(condition.tagType)) {
                    return Objects.equals(tag.func_74763_f(condition.nbtKey), ((Number)condition.value).longValue());
                }
                switch (condition.tagType) {
                    case BOOLEAN: {
                        return tag.func_74767_n(condition.nbtKey) == ((Boolean)condition.value).booleanValue();
                    }
                    case BYTE_ARRAY: {
                        return tag.func_74770_j(condition.nbtKey).equals(condition.value);
                    }
                    case STRING: {
                        return tag.func_74779_i(condition.nbtKey).equals(condition.value);
                    }
                    case LIST: {
                        if (condition instanceof ListNBTCondition) {
                            return tag.func_150295_c((String)condition.nbtKey, (int)((ListNBTCondition)condition).listTagType.typeId).field_74747_a.equals(condition.value);
                        }
                        return false;
                    }
                    case COMPOUND: {
                        if (condition.value instanceof NBTCondition) {
                            return this.evaluate(tag.func_74775_l(condition.nbtKey), (NBTCondition)condition.value);
                        }
                        return tag.func_74775_l(condition.nbtKey).equals(condition.value);
                    }
                    case INT_ARRAY: {
                        return tag.func_74759_k(condition.nbtKey).equals(condition.value);
                    }
                    case LONG_ARRAY: {
                        return ((NBTTagLongArray)tag.func_74781_a((String)condition.nbtKey)).field_193587_b.equals(condition.value);
                    }
                }
            }
            return false;
        }
    };
    public static final NBTMatcher NOT_PRESENT_OR_DEFAULT = (tag, condition) -> {
        if (tag == null || condition == null || condition.tagType == null) {
            return true;
        }
        if (NBTTagType.isNumeric(condition.tagType)) {
            return tag.func_74763_f(condition.nbtKey) == 0L;
        }
        switch (condition.tagType) {
            case BOOLEAN: {
                return !tag.func_74767_n(condition.nbtKey);
            }
            case BYTE_ARRAY: {
                return tag.func_74770_j(condition.nbtKey).length == 0;
            }
            case STRING: {
                return tag.func_74779_i(condition.nbtKey).isEmpty();
            }
            case LIST: {
                if (condition instanceof ListNBTCondition) {
                    return tag.func_150295_c(condition.nbtKey, ((ListNBTCondition)condition).listTagType.typeId).func_82582_d();
                }
                return false;
            }
            case COMPOUND: {
                return tag.func_74775_l(condition.nbtKey).func_82582_d();
            }
            case INT_ARRAY: {
                return tag.func_74759_k(condition.nbtKey).length == 0;
            }
            case LONG_ARRAY: {
                return ((NBTTagLongArray)tag.func_74781_a((String)condition.nbtKey)).field_193587_b.length == 0;
            }
        }
        return false;
    };
    public static final NBTMatcher NOT_PRESENT_OR_HAS_KEY = (tag, condition) -> {
        if (tag == null || condition == null || condition.tagType == null) {
            return true;
        }
        return NBTMatcher.hasKey(tag, condition.nbtKey, condition.tagType.typeId);
    };

    public static boolean hasKey(NBTTagCompound tag, String key, int tagType) {
        if (tag != null) {
            return tag.func_150297_b(key, tagType);
        }
        return false;
    }

    public boolean evaluate(@Nullable NBTTagCompound var1, @Nullable NBTCondition var2);

    default public boolean evaluate(@NotNull ItemStack stack, @Nullable NBTCondition nbtCondition) {
        return this.evaluate(stack.func_77978_p(), nbtCondition);
    }

    default public boolean evaluate(@NotNull FluidStack stack, @Nullable NBTCondition nbtCondition) {
        return this.evaluate(stack.tag, nbtCondition);
    }
}

