/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.ingredients;

import gregtech.api.items.gui.PlayerInventoryHolder;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.ingredients.nbtmatch.NBTCondition;
import gregtech.api.recipes.ingredients.nbtmatch.NBTMatcher;
import gregtech.common.items.MetaItems;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import org.jetbrains.annotations.Nullable;

public class IntCircuitIngredient
extends GTRecipeInput {
    public static final int CIRCUIT_MIN = 0;
    public static final int CIRCUIT_MAX = 32;
    private static final IntCircuitIngredient[] INGREDIENTS = new IntCircuitIngredient[33];
    private final int matchingConfigurations;
    private ItemStack[] inputStacks;

    public static IntCircuitIngredient circuitInput(int meta) {
        if (meta < 0 || meta > 32) {
            throw new IndexOutOfBoundsException("Circuit meta " + meta + " is out of range");
        }
        IntCircuitIngredient ingredient = INGREDIENTS[meta];
        if (ingredient == null) {
            IntCircuitIngredient.INGREDIENTS[meta] = ingredient = new IntCircuitIngredient(meta);
            ingredient.isConsumable = false;
            ingredient.setCached();
        }
        return ingredient;
    }

    @Deprecated
    public static IntCircuitIngredient getOrCreate(IntCircuitIngredient ri) {
        return ri;
    }

    public IntCircuitIngredient(int matchingConfigurations) {
        this.amount = 1;
        this.matchingConfigurations = matchingConfigurations;
    }

    @Override
    protected IntCircuitIngredient copy() {
        IntCircuitIngredient copy = new IntCircuitIngredient(this.matchingConfigurations);
        copy.isConsumable = this.isConsumable;
        return copy;
    }

    @Override
    public GTRecipeInput copyWithAmount(int amount) {
        return this.copy();
    }

    @Override
    public GTRecipeInput setNBTMatchingCondition(NBTMatcher nbtMatcher, NBTCondition nbtCondition) {
        return this;
    }

    @Override
    public int getAmount() {
        return 1;
    }

    @Override
    public ItemStack[] getInputStacks() {
        if (this.inputStacks == null) {
            this.inputStacks = new ItemStack[]{IntCircuitIngredient.getIntegratedCircuit(this.matchingConfigurations)};
        }
        return this.inputStacks;
    }

    @Override
    public boolean acceptsStack(@Nullable ItemStack itemStack) {
        return itemStack != null && MetaItems.INTEGRATED_CIRCUIT.isItemEqual(itemStack) && this.matchingConfigurations == IntCircuitIngredient.getCircuitConfiguration(itemStack);
    }

    @Override
    protected int computeHash() {
        return Objects.hash(this.matchingConfigurations, this.isConsumable);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntCircuitIngredient)) {
            return false;
        }
        IntCircuitIngredient other = (IntCircuitIngredient)obj;
        return this.isConsumable == other.isConsumable && this.matchingConfigurations == other.matchingConfigurations;
    }

    @Override
    public boolean equalIgnoreAmount(GTRecipeInput input) {
        if (this == input) {
            return true;
        }
        if (!(input instanceof IntCircuitIngredient)) {
            return false;
        }
        IntCircuitIngredient other = (IntCircuitIngredient)input;
        return this.matchingConfigurations == other.matchingConfigurations;
    }

    @Override
    public int getSortingOrder() {
        return this.isNonConsumable() ? 10 : super.getSortingOrder();
    }

    public String toString() {
        return "1xcircuit(" + this.matchingConfigurations + ")";
    }

    public static ItemStack getIntegratedCircuit(int configuration) {
        ItemStack stack = MetaItems.INTEGRATED_CIRCUIT.getStackForm();
        IntCircuitIngredient.setCircuitConfiguration(stack, configuration);
        return stack;
    }

    public static void setCircuitConfiguration(ItemStack itemStack, int configuration) {
        if (!MetaItems.INTEGRATED_CIRCUIT.isItemEqual(itemStack)) {
            throw new IllegalArgumentException("Given item stack is not an integrated circuit!");
        }
        if (configuration < 0 || configuration > 32) {
            throw new IllegalArgumentException("Given configuration number is out of range!");
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            itemStack.func_77982_d(tagCompound);
        }
        tagCompound.func_74768_a("Configuration", configuration);
    }

    public static int getCircuitConfiguration(ItemStack itemStack) {
        if (!IntCircuitIngredient.isIntegratedCircuit(itemStack)) {
            return 0;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            return tagCompound.func_74762_e("Configuration");
        }
        return 0;
    }

    public static boolean isIntegratedCircuit(ItemStack itemStack) {
        boolean isCircuit = MetaItems.INTEGRATED_CIRCUIT.isItemEqual(itemStack);
        if (isCircuit && !itemStack.func_77942_o()) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("Configuration", 0);
            itemStack.func_77982_d(compound);
        }
        return isCircuit;
    }

    public static void adjustConfiguration(PlayerInventoryHolder holder, int amount) {
        IntCircuitIngredient.adjustConfiguration(holder.getCurrentItem(), amount);
        holder.markAsDirty();
    }

    public static void adjustConfiguration(ItemStack stack, int amount) {
        if (!IntCircuitIngredient.isIntegratedCircuit(stack)) {
            return;
        }
        int configuration = IntCircuitIngredient.getCircuitConfiguration(stack);
        configuration += amount;
        configuration = MathHelper.func_76125_a((int)configuration, (int)0, (int)32);
        IntCircuitIngredient.setCircuitConfiguration(stack, configuration);
    }
}

