/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.ingredients;

import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.Nullable;

public class GTRecipeOreInput
extends GTRecipeInput {
    private final int ore;
    private ItemStack[] inputStacks;

    public GTRecipeOreInput(String ore) {
        this(ore, 1);
    }

    public GTRecipeOreInput(String ore, int amount) {
        this.ore = OreDictionary.getOreID((String)ore);
        this.amount = amount;
    }

    public GTRecipeOreInput(OrePrefix prefix, Material material) {
        this(new UnificationEntry(prefix, material).toString(), 1);
    }

    public GTRecipeOreInput(OrePrefix prefix, Material material, int amount) {
        this(new UnificationEntry(prefix, material).toString(), amount);
    }

    protected GTRecipeOreInput(int ore, int amount) {
        this.ore = ore;
        this.amount = amount;
    }

    @Deprecated
    public static GTRecipeInput getOrCreate(String ore, int amount) {
        return new GTRecipeOreInput(ore, amount);
    }

    @Deprecated
    public static GTRecipeInput getOrCreate(String ore) {
        return new GTRecipeOreInput(ore);
    }

    @Deprecated
    public static GTRecipeInput getOrCreate(OrePrefix prefix, Material material, int amount) {
        return new GTRecipeOreInput(prefix, material, amount);
    }

    @Deprecated
    public static GTRecipeInput getOrCreate(OrePrefix prefix, Material material) {
        return new GTRecipeOreInput(prefix, material);
    }

    @Override
    protected GTRecipeOreInput copy() {
        GTRecipeOreInput copy = new GTRecipeOreInput(this.ore, this.amount);
        copy.isConsumable = this.isConsumable;
        copy.nbtMatcher = this.nbtMatcher;
        copy.nbtCondition = this.nbtCondition;
        return copy;
    }

    @Override
    public GTRecipeInput copyWithAmount(int amount) {
        GTRecipeOreInput copy = new GTRecipeOreInput(this.ore, amount);
        copy.isConsumable = this.isConsumable;
        copy.nbtMatcher = this.nbtMatcher;
        copy.nbtCondition = this.nbtCondition;
        return copy;
    }

    @Override
    public ItemStack[] getInputStacks() {
        if (this.inputStacks == null) {
            this.inputStacks = (ItemStack[])OreDictionary.getOres((String)OreDictionary.getOreName((int)this.ore)).stream().map(is -> {
                is = is.func_77946_l();
                is.func_190920_e(this.amount);
                return is;
            }).toArray(ItemStack[]::new);
        }
        return this.inputStacks;
    }

    @Override
    public boolean isOreDict() {
        return true;
    }

    @Override
    public int getOreDict() {
        return this.ore;
    }

    @Override
    public boolean acceptsStack(@Nullable ItemStack input) {
        if (input == null || input.func_190926_b()) {
            return false;
        }
        for (ItemStack target : this.getInputStacks()) {
            if (!OreDictionary.itemMatches((ItemStack)target, (ItemStack)input, (boolean)false)) continue;
            return this.nbtMatcher == null || this.nbtMatcher.evaluate(input, this.nbtCondition);
        }
        return false;
    }

    @Override
    protected int computeHash() {
        return Objects.hash(this.amount, this.ore, this.isConsumable, this.nbtMatcher, this.nbtCondition);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GTRecipeOreInput)) {
            return false;
        }
        GTRecipeOreInput other = (GTRecipeOreInput)obj;
        if (this.amount != other.amount || this.isConsumable != other.isConsumable) {
            return false;
        }
        if (!Objects.equals(this.nbtMatcher, other.nbtMatcher)) {
            return false;
        }
        if (!Objects.equals(this.nbtCondition, other.nbtCondition)) {
            return false;
        }
        return this.ore == other.ore;
    }

    @Override
    public boolean equalIgnoreAmount(GTRecipeInput input) {
        if (this == input) {
            return true;
        }
        if (!(input instanceof GTRecipeOreInput)) {
            return false;
        }
        GTRecipeOreInput other = (GTRecipeOreInput)input;
        if (!Objects.equals(this.nbtMatcher, other.nbtMatcher)) {
            return false;
        }
        if (!Objects.equals(this.nbtCondition, other.nbtCondition)) {
            return false;
        }
        return this.ore == other.ore;
    }

    public String toString() {
        return this.amount + "x" + OreDictionary.getOreName((int)this.ore);
    }
}

