/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes;

import com.cleanroommc.groovyscript.api.GroovyLog;
import com.google.common.collect.ImmutableList;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.gui.widgets.RecipeProgressWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.category.GTRecipeCategory;
import gregtech.api.recipes.chance.boost.ChanceBoostFunction;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.api.recipes.map.AbstractMapIngredient;
import gregtech.api.recipes.map.Branch;
import gregtech.api.recipes.map.Either;
import gregtech.api.recipes.map.MapFluidIngredient;
import gregtech.api.recipes.map.MapItemStackIngredient;
import gregtech.api.recipes.map.MapItemStackNBTIngredient;
import gregtech.api.recipes.map.MapOreDictIngredient;
import gregtech.api.recipes.map.MapOreDictNBTIngredient;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.EnumValidationResult;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.api.util.LocalizationUtils;
import gregtech.api.util.ValidationResult;
import gregtech.common.ConfigHolder;
import gregtech.integration.crafttweaker.CTRecipeHelper;
import gregtech.integration.crafttweaker.recipe.CTRecipe;
import gregtech.integration.crafttweaker.recipe.CTRecipeBuilder;
import gregtech.integration.groovy.GroovyScriptModule;
import gregtech.integration.groovy.VirtualizedRecipeMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenClass(value="mods.gregtech.recipe.RecipeMap")
@ZenRegister
public class RecipeMap<R extends RecipeBuilder<R>> {
    private static final Map<String, RecipeMap<?>> RECIPE_MAP_REGISTRY = new Object2ReferenceOpenHashMap();
    private static final Comparator<Recipe> RECIPE_DURATION_THEN_EU = Comparator.comparingInt(Recipe::getDuration).thenComparingInt(Recipe::getEUt).thenComparing(Recipe::hashCode);
    private static boolean foundInvalidRecipe = false;
    public static final ChanceBoostFunction DEFAULT_CHANCE_FUNCTION = ChanceBoostFunction.OVERCLOCK;
    public ChanceBoostFunction chanceFunction = DEFAULT_CHANCE_FUNCTION;
    public final String unlocalizedName;
    private final R recipeBuilderSample;
    private int maxInputs;
    private int maxOutputs;
    private int maxFluidInputs;
    private int maxFluidOutputs;
    private final boolean modifyItemInputs;
    private final boolean modifyItemOutputs;
    private final boolean modifyFluidInputs;
    private final boolean modifyFluidOutputs;
    protected final Byte2ObjectMap<TextureArea> slotOverlays;
    protected TextureArea specialTexture;
    protected int[] specialTexturePosition;
    protected TextureArea progressBarTexture;
    protected ProgressWidget.MoveType moveType;
    public final boolean isHidden;
    private boolean allowEmptyOutput;
    private final Object grsVirtualizedRecipeMap;
    private final Branch lookup = new Branch();
    private boolean hasOreDictedInputs = false;
    private boolean hasNBTMatcherInputs = false;
    private static final WeakHashMap<AbstractMapIngredient, WeakReference<AbstractMapIngredient>> ingredientRoot = new WeakHashMap();
    private final WeakHashMap<AbstractMapIngredient, WeakReference<AbstractMapIngredient>> fluidIngredientRoot = new WeakHashMap();
    private final Map<GTRecipeCategory, List<Recipe>> recipeByCategory = new Object2ObjectOpenHashMap();
    private Consumer<R> onRecipeBuildAction;
    protected SoundEvent sound;
    private RecipeMap<?> smallRecipeMap;

    public RecipeMap(@NotNull String unlocalizedName, int maxInputs, int maxOutputs, int maxFluidInputs, int maxFluidOutputs, @NotNull R defaultRecipeBuilder, boolean isHidden) {
        this(unlocalizedName, maxInputs, true, maxOutputs, true, maxFluidInputs, true, maxFluidOutputs, true, defaultRecipeBuilder, isHidden);
    }

    public RecipeMap(@NotNull String unlocalizedName, int maxInputs, boolean modifyItemInputs, int maxOutputs, boolean modifyItemOutputs, int maxFluidInputs, boolean modifyFluidInputs, int maxFluidOutputs, boolean modifyFluidOutputs, @NotNull R defaultRecipeBuilder, boolean isHidden) {
        this.unlocalizedName = unlocalizedName;
        this.slotOverlays = new Byte2ObjectOpenHashMap();
        this.progressBarTexture = GuiTextures.PROGRESS_BAR_ARROW;
        this.moveType = ProgressWidget.MoveType.HORIZONTAL;
        this.maxInputs = maxInputs;
        this.maxFluidInputs = maxFluidInputs;
        this.maxOutputs = maxOutputs;
        this.maxFluidOutputs = maxFluidOutputs;
        this.modifyItemInputs = modifyItemInputs;
        this.modifyItemOutputs = modifyItemOutputs;
        this.modifyFluidInputs = modifyFluidInputs;
        this.modifyFluidOutputs = modifyFluidOutputs;
        this.isHidden = isHidden;
        ((RecipeBuilder)defaultRecipeBuilder).setRecipeMap(this);
        ((RecipeBuilder)defaultRecipeBuilder).category(GTRecipeCategory.create("gregtech", unlocalizedName, this.getTranslationKey(), this));
        this.recipeBuilderSample = defaultRecipeBuilder;
        RECIPE_MAP_REGISTRY.put(unlocalizedName, this);
        this.grsVirtualizedRecipeMap = GregTechAPI.moduleManager.isModuleEnabled("grs_integration") ? new VirtualizedRecipeMap(this) : null;
    }

    @ZenMethod
    public static List<RecipeMap<?>> getRecipeMaps() {
        return ImmutableList.copyOf(RECIPE_MAP_REGISTRY.values());
    }

    @ZenMethod
    public static RecipeMap<?> getByName(String unlocalizedName) {
        return RECIPE_MAP_REGISTRY.get(unlocalizedName);
    }

    @ZenMethod
    public ChanceBoostFunction getChanceFunction() {
        return this.chanceFunction;
    }

    public static boolean isFoundInvalidRecipe() {
        return foundInvalidRecipe;
    }

    public static void setFoundInvalidRecipe(boolean foundInvalidRecipe) {
        RecipeMap.foundInvalidRecipe |= foundInvalidRecipe;
        OrePrefix currentOrePrefix = OrePrefix.getCurrentProcessingPrefix();
        if (currentOrePrefix != null) {
            Material currentMaterial = OrePrefix.getCurrentMaterial();
            GTLog.logger.error("Error happened during processing ore registration of prefix {} and material {}. Seems like cross-mod compatibility issue. Report to GTCEu github.", (Object)currentOrePrefix, (Object)currentMaterial);
        }
    }

    public RecipeMap<R> setProgressBar(TextureArea progressBar, ProgressWidget.MoveType moveType) {
        this.progressBarTexture = progressBar;
        this.moveType = moveType;
        return this;
    }

    public RecipeMap<R> setSlotOverlay(boolean isOutput, boolean isFluid, TextureArea slotOverlay) {
        return this.setSlotOverlay(isOutput, isFluid, false, slotOverlay).setSlotOverlay(isOutput, isFluid, true, slotOverlay);
    }

    public RecipeMap<R> setSlotOverlay(boolean isOutput, boolean isFluid, boolean isLast, TextureArea slotOverlay) {
        this.slotOverlays.put((byte)((isOutput ? 2 : 0) + (isFluid ? 1 : 0) + (isLast ? 4 : 0)), (Object)slotOverlay);
        return this;
    }

    public RecipeMap<R> setSound(SoundEvent sound) {
        this.sound = sound;
        return this;
    }

    public RecipeMap<R> setChanceFunction(@NotNull ChanceBoostFunction function) {
        this.chanceFunction = function;
        return this;
    }

    public RecipeMap<R> onRecipeBuild(Consumer<R> consumer) {
        this.onRecipeBuildAction = consumer;
        return this;
    }

    public RecipeMap<R> allowEmptyOutput() {
        this.allowEmptyOutput = true;
        return this;
    }

    public RecipeMap<R> setSmallRecipeMap(RecipeMap<?> recipeMap) {
        this.smallRecipeMap = recipeMap;
        return this;
    }

    public RecipeMap<?> getSmallRecipeMap() {
        return this.smallRecipeMap;
    }

    public boolean addRecipe(@NotNull ValidationResult<Recipe> validationResult) {
        validationResult = this.postValidateRecipe(validationResult);
        switch (validationResult.getType()) {
            case SKIP: {
                return false;
            }
            case INVALID: {
                RecipeMap.setFoundInvalidRecipe(true);
                return false;
            }
        }
        Recipe recipe = validationResult.getResult();
        if (recipe.isGroovyRecipe()) {
            this.getGroovyScriptRecipeMap().addScripted(recipe);
        }
        return this.compileRecipe(recipe);
    }

    public boolean compileRecipe(Recipe recipe) {
        if (recipe == null) {
            return false;
        }
        List<List<AbstractMapIngredient>> items = this.fromRecipe(recipe);
        if (this.recurseIngredientTreeAdd(recipe, items, this.lookup, 0, 0)) {
            this.recipeByCategory.compute(recipe.getRecipeCategory(), (k, v) -> {
                if (v == null) {
                    v = new ArrayList<Recipe>();
                }
                v.add(recipe);
                return v;
            });
            return true;
        }
        return false;
    }

    public boolean removeRecipe(@NotNull Recipe recipe) {
        List<List<AbstractMapIngredient>> items = this.fromRecipe(recipe);
        if (this.recurseIngredientTreeRemove(recipe, items, this.lookup, 0) != null) {
            if (GroovyScriptModule.isCurrentlyRunning()) {
                this.getGroovyScriptRecipeMap().addBackup(recipe);
            }
            this.recipeByCategory.compute(recipe.getRecipeCategory(), (k, v) -> {
                if (v != null) {
                    v.remove(recipe);
                }
                return v == null || v.isEmpty() ? null : v;
            });
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    void removeAllRecipes() {
        if (GroovyScriptModule.isCurrentlyRunning()) {
            this.lookup.getRecipes(false).forEach(arg_0 -> ((VirtualizedRecipeMap)this.getGroovyScriptRecipeMap()).addBackup(arg_0));
        }
        this.lookup.getNodes().clear();
        this.lookup.getSpecialNodes().clear();
        this.recipeByCategory.clear();
    }

    @NotNull
    protected ValidationResult<Recipe> postValidateRecipe(@NotNull ValidationResult<Recipe> validationResult) {
        int amount;
        boolean emptyOutputs;
        boolean emptyInputs;
        EnumValidationResult recipeStatus = validationResult.getType();
        Recipe recipe = validationResult.getResult();
        if (recipe.isGroovyRecipe()) {
            return validationResult;
        }
        boolean bl = emptyInputs = recipe.getInputs().isEmpty() && recipe.getFluidInputs().isEmpty();
        if (emptyInputs) {
            GTLog.logger.error("Invalid amount of recipe inputs. Recipe inputs are empty.");
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException("Invalid number of Inputs"));
            if (recipe.getIsCTRecipe()) {
                CraftTweakerAPI.logError((String)"Invalid amount of recipe inputs. Recipe inputs are empty.");
                CraftTweakerAPI.logError((String)"Stacktrace:", (Throwable)new IllegalArgumentException("Invalid number of Inputs"));
            }
            recipeStatus = EnumValidationResult.INVALID;
        }
        boolean bl2 = emptyOutputs = !this.allowEmptyOutput && recipe.getEUt() > 0 && recipe.getOutputs().isEmpty() && recipe.getFluidOutputs().isEmpty() && recipe.getChancedOutputs().getChancedEntries().isEmpty() && recipe.getChancedFluidOutputs().getChancedEntries().isEmpty();
        if (emptyOutputs) {
            GTLog.logger.error("Invalid amount of recipe outputs. Recipe outputs are empty.");
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException("Invalid number of Outputs"));
            if (recipe.getIsCTRecipe()) {
                CraftTweakerAPI.logError((String)"Invalid amount of outputs inputs. Recipe outputs are empty.");
                CraftTweakerAPI.logError((String)"Stacktrace:", (Throwable)new IllegalArgumentException("Invalid number of Outputs"));
            }
            recipeStatus = EnumValidationResult.INVALID;
        }
        if ((amount = recipe.getInputs().size()) > this.getMaxInputs()) {
            GTLog.logger.error("Invalid amount of recipe inputs. Actual: {}. Should be at most {}.", (Object)amount, (Object)this.getMaxInputs());
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException("Invalid number of Inputs"));
            if (recipe.getIsCTRecipe()) {
                CraftTweakerAPI.logError((String)String.format("Invalid amount of recipe inputs. Actual: %s. Should be at most %s.", amount, this.getMaxInputs()));
                CraftTweakerAPI.logError((String)"Stacktrace:", (Throwable)new IllegalArgumentException("Invalid number of Inputs"));
            }
            recipeStatus = EnumValidationResult.INVALID;
        }
        if ((amount = recipe.getOutputs().size() + recipe.getChancedOutputs().getChancedEntries().size()) > this.getMaxOutputs()) {
            GTLog.logger.error("Invalid amount of recipe outputs. Actual: {}. Should be at most {}.", (Object)amount, (Object)this.getMaxOutputs());
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException("Invalid number of Outputs"));
            if (recipe.getIsCTRecipe()) {
                CraftTweakerAPI.logError((String)String.format("Invalid amount of recipe outputs. Actual: %s. Should be at most %s.", amount, this.getMaxOutputs()));
                CraftTweakerAPI.logError((String)"Stacktrace:", (Throwable)new IllegalArgumentException("Invalid number of Outputs"));
            }
            recipeStatus = EnumValidationResult.INVALID;
        }
        if ((amount = recipe.getFluidInputs().size()) > this.getMaxFluidInputs()) {
            GTLog.logger.error("Invalid amount of recipe fluid inputs. Actual: {}. Should be at most {}.", (Object)amount, (Object)this.getMaxFluidInputs());
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException("Invalid number of Fluid Inputs"));
            if (recipe.getIsCTRecipe()) {
                CraftTweakerAPI.logError((String)String.format("Invalid amount of recipe fluid inputs. Actual: %s. Should be at most %s.", amount, this.getMaxFluidInputs()));
                CraftTweakerAPI.logError((String)"Stacktrace:", (Throwable)new IllegalArgumentException("Invalid number of Fluid Inputs"));
            }
            recipeStatus = EnumValidationResult.INVALID;
        }
        if ((amount = recipe.getFluidOutputs().size() + recipe.getChancedFluidOutputs().getChancedEntries().size()) > this.getMaxFluidOutputs()) {
            GTLog.logger.error("Invalid amount of recipe fluid outputs. Actual: {}. Should be at most {}.", (Object)amount, (Object)this.getMaxFluidOutputs());
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException("Invalid number of Fluid Outputs"));
            if (recipe.getIsCTRecipe()) {
                CraftTweakerAPI.logError((String)String.format("Invalid amount of recipe fluid outputs. Actual: %s. Should be at most %s.", amount, this.getMaxFluidOutputs()));
                CraftTweakerAPI.logError((String)"Stacktrace:", (Throwable)new IllegalArgumentException("Invalid number of Fluid Outputs"));
            }
            recipeStatus = EnumValidationResult.INVALID;
        }
        return ValidationResult.newResult(recipeStatus, recipe);
    }

    @Nullable
    public Recipe findRecipe(long voltage, IItemHandlerModifiable inputs, IMultipleTankHandler fluidInputs) {
        return this.findRecipe(voltage, GTUtility.itemHandlerToList(inputs), GTUtility.fluidHandlerToList(fluidInputs));
    }

    @Nullable
    public Recipe findRecipe(long voltage, List<ItemStack> inputs, List<FluidStack> fluidInputs) {
        return this.findRecipe(voltage, inputs, fluidInputs, false);
    }

    @Nullable
    public Recipe findRecipe(long voltage, List<ItemStack> inputs, List<FluidStack> fluidInputs, boolean exactVoltage) {
        List<ItemStack> items = inputs.stream().filter(s -> !s.func_190926_b()).collect(Collectors.toList());
        List<FluidStack> fluids = fluidInputs.stream().filter(f -> f != null && f.amount != 0).collect(Collectors.toList());
        return this.find(items, fluids, recipe -> {
            if (exactVoltage && (long)recipe.getEUt() != voltage) {
                return false;
            }
            if ((long)recipe.getEUt() > voltage) {
                return false;
            }
            return recipe.matches(false, inputs, fluidInputs);
        });
    }

    @Nullable
    protected List<List<AbstractMapIngredient>> prepareRecipeFind(@NotNull Collection<ItemStack> items, @NotNull Collection<FluidStack> fluids) {
        if (items.size() == Integer.MAX_VALUE || fluids.size() == Integer.MAX_VALUE) {
            return null;
        }
        if (items.size() == 0 && fluids.size() == 0) {
            return null;
        }
        ObjectArrayList list = new ObjectArrayList(items.size() + fluids.size());
        if (items.size() > 0) {
            this.buildFromItemStacks((List<List<AbstractMapIngredient>>)list, RecipeMap.uniqueItems(items));
        }
        if (fluids.size() > 0) {
            this.buildFromFluidStacks((List<List<AbstractMapIngredient>>)list, fluids);
        }
        if (list.size() == 0) {
            return null;
        }
        return list;
    }

    @Nullable
    public Recipe find(@NotNull Collection<ItemStack> items, @NotNull Collection<FluidStack> fluids, @NotNull Predicate<Recipe> canHandle) {
        List<List<AbstractMapIngredient>> list = this.prepareRecipeFind(items, fluids);
        if (list == null) {
            return null;
        }
        return this.recurseIngredientTreeFindRecipe(list, this.lookup, canHandle);
    }

    @NotNull
    public static ItemStack[] uniqueItems(@NotNull Collection<ItemStack> inputs) {
        int index = 0;
        ItemStack[] uniqueItems = new ItemStack[inputs.size()];
        block0: for (ItemStack input : inputs) {
            if (input.func_190926_b()) continue;
            if (index > 0) {
                for (ItemStack unique : uniqueItems) {
                    if (unique == null) break;
                    if (input.func_77969_a(unique) && ItemStack.func_77970_a((ItemStack)input, (ItemStack)unique)) continue block0;
                }
            }
            uniqueItems[index++] = input;
        }
        if (index == uniqueItems.length) {
            return uniqueItems;
        }
        ItemStack[] retUniqueItems = new ItemStack[index];
        System.arraycopy(uniqueItems, 0, retUniqueItems, 0, index);
        return retUniqueItems;
    }

    @NotNull
    public static List<GTRecipeInput> uniqueIngredientsList(@NotNull Collection<GTRecipeInput> inputs) {
        ObjectArrayList list = new ObjectArrayList(inputs.size());
        for (GTRecipeInput item : inputs) {
            boolean isEqual = false;
            for (GTRecipeInput obj : list) {
                if (!item.equalIgnoreAmount(obj)) continue;
                isEqual = true;
                break;
            }
            if (isEqual) continue;
            if (item instanceof IntCircuitIngredient) {
                list.add(0, item);
                continue;
            }
            list.add(item);
        }
        return list;
    }

    @Nullable
    private Recipe recurseIngredientTreeFindRecipe(@NotNull List<List<AbstractMapIngredient>> ingredients, @NotNull Branch branchRoot, @NotNull Predicate<Recipe> canHandle) {
        for (int i = 0; i < ingredients.size(); ++i) {
            Recipe r = this.recurseIngredientTreeFindRecipe(ingredients, branchRoot, canHandle, i, 0, 1L << i);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    @Nullable
    private Recipe recurseIngredientTreeFindRecipe(@NotNull List<List<AbstractMapIngredient>> ingredients, @NotNull Branch branchMap, @NotNull Predicate<Recipe> canHandle, int index, int count, long skip) {
        if (count == ingredients.size()) {
            return null;
        }
        for (AbstractMapIngredient obj : ingredients.get(index)) {
            Recipe r;
            Map<AbstractMapIngredient, Either<Recipe, Branch>> targetMap = RecipeMap.determineRootNodes(obj, branchMap);
            Either<Recipe, Branch> result = targetMap.get(obj);
            if (result == null || (r = result.map(potentialRecipe -> canHandle.test((Recipe)potentialRecipe) ? potentialRecipe : null, potentialBranch -> this.diveIngredientTreeFindRecipe(ingredients, (Branch)potentialBranch, canHandle, index, count, skip))) == null) continue;
            return r;
        }
        return null;
    }

    @Nullable
    private Recipe diveIngredientTreeFindRecipe(@NotNull List<List<AbstractMapIngredient>> ingredients, @NotNull Branch map, @NotNull Predicate<Recipe> canHandle, int currentIndex, int count, long skip) {
        int i = (currentIndex + 1) % ingredients.size();
        while (i != currentIndex) {
            Recipe found;
            if ((skip & 1L << i) == 0L && (found = this.recurseIngredientTreeFindRecipe(ingredients, map, canHandle, i, count + 1, skip | 1L << i)) != null) {
                return found;
            }
            i = (i + 1) % ingredients.size();
        }
        return null;
    }

    @Nullable
    public Set<Recipe> findRecipeCollisions(Collection<ItemStack> items, Collection<FluidStack> fluids) {
        List<List<AbstractMapIngredient>> list = this.prepareRecipeFind(items, fluids);
        if (list == null) {
            return null;
        }
        ObjectOpenHashSet collidingRecipes = new ObjectOpenHashSet();
        this.recurseIngredientTreeFindRecipeCollisions(list, this.lookup, (Set<Recipe>)collidingRecipes);
        return collidingRecipes;
    }

    private void recurseIngredientTreeFindRecipeCollisions(@NotNull List<List<AbstractMapIngredient>> ingredients, @NotNull Branch branchRoot, @NotNull Set<Recipe> collidingRecipes) {
        for (int i = 0; i < ingredients.size(); ++i) {
            this.recurseIngredientTreeFindRecipeCollisions(ingredients, branchRoot, i, 0, 1L << i, collidingRecipes);
        }
    }

    @Nullable
    private Recipe recurseIngredientTreeFindRecipeCollisions(@NotNull List<List<AbstractMapIngredient>> ingredients, @NotNull Branch branchMap, int index, int count, long skip, @NotNull Set<Recipe> collidingRecipes) {
        if (count == ingredients.size()) {
            return null;
        }
        List<AbstractMapIngredient> wr = ingredients.get(index);
        for (AbstractMapIngredient obj : wr) {
            Recipe r;
            Map<AbstractMapIngredient, Either<Recipe, Branch>> targetMap = RecipeMap.determineRootNodes(obj, branchMap);
            Either<Recipe, Branch> result = targetMap.get(obj);
            if (result == null || (r = result.map(recipe -> recipe, right -> this.diveIngredientTreeFindRecipeCollisions(ingredients, (Branch)right, index, count, skip, collidingRecipes))) == null) continue;
            collidingRecipes.add(r);
        }
        return null;
    }

    @Nullable
    private Recipe diveIngredientTreeFindRecipeCollisions(@NotNull List<List<AbstractMapIngredient>> ingredients, @NotNull Branch map, int currentIndex, int count, long skip, @NotNull Set<Recipe> collidingRecipes) {
        int i = (currentIndex + 1) % ingredients.size();
        while (i != currentIndex) {
            Recipe r;
            if ((skip & 1L << i) == 0L && (r = this.recurseIngredientTreeFindRecipeCollisions(ingredients, map, i, count + 1, skip | 1L << i, collidingRecipes)) != null) {
                return r;
            }
            i = (i + 1) % ingredients.size();
        }
        return null;
    }

    public ModularUI.Builder createJeiUITemplate(IItemHandlerModifiable importItems, IItemHandlerModifiable exportItems, FluidTankList importFluids, FluidTankList exportFluids, int yOffset) {
        ModularUI.Builder builder = ModularUI.defaultBuilder(yOffset);
        builder.widget(new RecipeProgressWidget(200, 78, 23 + yOffset, 20, 20, this.progressBarTexture, this.moveType, this));
        this.addInventorySlotGroup(builder, importItems, importFluids, false, yOffset);
        this.addInventorySlotGroup(builder, exportItems, exportFluids, true, yOffset);
        if (this.specialTexture != null && this.specialTexturePosition != null) {
            this.addSpecialTexture(builder);
        }
        return builder;
    }

    public ModularUI.Builder createUITemplate(DoubleSupplier progressSupplier, IItemHandlerModifiable importItems, IItemHandlerModifiable exportItems, FluidTankList importFluids, FluidTankList exportFluids, int yOffset) {
        ModularUI.Builder builder = ModularUI.defaultBuilder(yOffset);
        builder.widget(new RecipeProgressWidget(progressSupplier, 78, 23 + yOffset, 20, 20, this.progressBarTexture, this.moveType, this));
        this.addInventorySlotGroup(builder, importItems, importFluids, false, yOffset);
        this.addInventorySlotGroup(builder, exportItems, exportFluids, true, yOffset);
        if (this.specialTexture != null && this.specialTexturePosition != null) {
            this.addSpecialTexture(builder);
        }
        return builder;
    }

    public ModularUI.Builder createUITemplateNoOutputs(DoubleSupplier progressSupplier, IItemHandlerModifiable importItems, IItemHandlerModifiable exportItems, FluidTankList importFluids, FluidTankList exportFluids, int yOffset) {
        ModularUI.Builder builder = ModularUI.defaultBuilder(yOffset);
        builder.widget(new RecipeProgressWidget(progressSupplier, 78, 23 + yOffset, 20, 20, this.progressBarTexture, this.moveType, this));
        this.addInventorySlotGroup(builder, importItems, importFluids, false, yOffset);
        if (this.specialTexture != null && this.specialTexturePosition != null) {
            this.addSpecialTexture(builder);
        }
        return builder;
    }

    protected void addInventorySlotGroup(ModularUI.Builder builder, IItemHandlerModifiable itemHandler, FluidTankList fluidHandler, boolean isOutputs, int yOffset) {
        block11: {
            int i;
            boolean wasGroup;
            int itemInputsCount = itemHandler.getSlots();
            int fluidInputsCount = fluidHandler.getTanks();
            boolean invertFluids = false;
            if (itemInputsCount == 0) {
                int tmp = itemInputsCount;
                itemInputsCount = fluidInputsCount;
                fluidInputsCount = tmp;
                invertFluids = true;
            }
            int[] inputSlotGrid = RecipeMap.determineSlotsGrid(itemInputsCount);
            int itemSlotsToLeft = inputSlotGrid[0];
            int itemSlotsToDown = inputSlotGrid[1];
            int startInputsX = isOutputs ? 106 : 70 - itemSlotsToLeft * 18;
            int startInputsY = 33 - (int)((double)itemSlotsToDown / 2.0 * 18.0) + yOffset;
            boolean bl = wasGroup = itemHandler.getSlots() + fluidHandler.getTanks() == 12;
            if (wasGroup) {
                startInputsY -= 9;
            } else if (itemHandler.getSlots() >= 6 && fluidHandler.getTanks() >= 2 && !isOutputs) {
                startInputsY -= 9;
            }
            for (int i2 = 0; i2 < itemSlotsToDown; ++i2) {
                int slotIndex;
                for (int j = 0; j < itemSlotsToLeft && (slotIndex = i2 * itemSlotsToLeft + j) < itemInputsCount; ++j) {
                    int x = startInputsX + 18 * j;
                    int y = startInputsY + 18 * i2;
                    this.addSlot(builder, x, y, slotIndex, itemHandler, fluidHandler, invertFluids, isOutputs);
                }
            }
            if (wasGroup) {
                startInputsY += 2;
            }
            if (fluidInputsCount <= 0 && !invertFluids) break block11;
            if (itemSlotsToDown >= fluidInputsCount && itemSlotsToLeft < 3) {
                int startSpecX = isOutputs ? startInputsX + itemSlotsToLeft * 18 : startInputsX - 18;
                for (i = 0; i < fluidInputsCount; ++i) {
                    int y = startInputsY + 18 * i;
                    this.addSlot(builder, startSpecX, y, i, itemHandler, fluidHandler, !invertFluids, isOutputs);
                }
            } else {
                int startSpecY = startInputsY + itemSlotsToDown * 18;
                for (i = 0; i < fluidInputsCount; ++i) {
                    int x = isOutputs ? startInputsX + 18 * (i % 3) : startInputsX + itemSlotsToLeft * 18 - 18 - 18 * (i % 3);
                    int y = startSpecY + i / 3 * 18;
                    this.addSlot(builder, x, y, i, itemHandler, fluidHandler, !invertFluids, isOutputs);
                }
            }
        }
    }

    protected void addSlot(ModularUI.Builder builder, int x, int y, int slotIndex, IItemHandlerModifiable itemHandler, FluidTankList fluidHandler, boolean isFluid, boolean isOutputs) {
        if (!isFluid) {
            builder.widget(new SlotWidget((IItemHandler)itemHandler, slotIndex, x, y, true, !isOutputs).setBackgroundTexture(this.getOverlaysForSlot(isOutputs, false, slotIndex == itemHandler.getSlots() - 1)));
        } else {
            builder.widget(new TankWidget(fluidHandler.getTankAt(slotIndex), x, y, 18, 18).setAlwaysShowFull(true).setBackgroundTexture(this.getOverlaysForSlot(isOutputs, true, slotIndex == fluidHandler.getTanks() - 1)).setContainerClicking(true, !isOutputs));
        }
    }

    protected TextureArea[] getOverlaysForSlot(boolean isOutput, boolean isFluid, boolean isLast) {
        TextureArea base = isFluid ? GuiTextures.FLUID_SLOT : GuiTextures.SLOT;
        byte overlayKey = (byte)((isOutput ? 2 : 0) + (isFluid ? 1 : 0) + (isLast ? 4 : 0));
        if (this.slotOverlays.containsKey(overlayKey)) {
            return new TextureArea[]{base, (TextureArea)this.slotOverlays.get(overlayKey)};
        }
        return new TextureArea[]{base};
    }

    protected static int[] determineSlotsGrid(int itemInputsCount) {
        int itemSlotsToLeft;
        int itemSlotsToDown;
        double sqrt = Math.sqrt(itemInputsCount);
        if (sqrt % 1.0 == 0.0) {
            itemSlotsToLeft = itemSlotsToDown = (int)sqrt;
        } else if (itemInputsCount == 3) {
            itemSlotsToLeft = 3;
            itemSlotsToDown = 1;
        } else {
            itemSlotsToLeft = (int)Math.ceil(sqrt);
            if (itemInputsCount > itemSlotsToLeft * (itemSlotsToDown = itemSlotsToLeft - 1)) {
                itemSlotsToDown = itemSlotsToLeft;
            }
        }
        return new int[]{itemSlotsToLeft, itemSlotsToDown};
    }

    public int getPropertyHeightShift() {
        int maxPropertyCount = 0;
        if (this.shouldShiftWidgets()) {
            for (Recipe recipe : this.getRecipeList()) {
                if (recipe.getPropertyCount() <= maxPropertyCount) continue;
                maxPropertyCount = recipe.getPropertyCount();
            }
        }
        return maxPropertyCount * 10;
    }

    private boolean shouldShiftWidgets() {
        return this.getMaxInputs() + this.getMaxOutputs() >= 6 || this.getMaxFluidInputs() + this.getMaxFluidOutputs() >= 6;
    }

    @Optional.Method(modid="groovyscript")
    private VirtualizedRecipeMap getGroovyScriptRecipeMap() {
        return (VirtualizedRecipeMap)((Object)this.grsVirtualizedRecipeMap);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.9")
    public int getPropertyListHeight(Recipe recipe) {
        return 0;
    }

    private boolean recurseIngredientTreeAdd(@NotNull Recipe recipe, @NotNull List<List<AbstractMapIngredient>> ingredients, @NotNull Branch branchMap, int index, int count) {
        if (count >= ingredients.size()) {
            return true;
        }
        if (index >= ingredients.size()) {
            throw new RuntimeException("Index out of bounds for recurseItemTreeAdd, should not happen");
        }
        List<AbstractMapIngredient> current = ingredients.get(index);
        Branch branchRight = new Branch();
        for (AbstractMapIngredient obj : current) {
            Map<AbstractMapIngredient, Either<Recipe, Branch>> targetMap = RecipeMap.determineRootNodes(obj, branchMap);
            Either r = targetMap.compute(obj, (k, v) -> {
                if (count == ingredients.size() - 1) {
                    if (v != null) {
                        if (!v.left().isPresent() || v.left().get() != recipe) {
                            if (recipe.getIsCTRecipe()) {
                                CraftTweakerAPI.logError((String)String.format("Recipe duplicate or conflict found in RecipeMap %s and was not added. See next lines for details.", this.unlocalizedName));
                                CraftTweakerAPI.logError((String)String.format("Attempted to add Recipe: %s", CTRecipeHelper.getRecipeAddLine(this, recipe)));
                                if (v.left().isPresent()) {
                                    CraftTweakerAPI.logError((String)String.format("Which conflicts with: %s", CTRecipeHelper.getRecipeAddLine(this, (Recipe)v.left().get())));
                                } else {
                                    CraftTweakerAPI.logError((String)"Could not identify exact duplicate/conflict.");
                                }
                            }
                            if (recipe.isGroovyRecipe()) {
                                GroovyLog log = GroovyLog.get();
                                log.warn("Recipe duplicate or conflict found in RecipeMap {} and was not added. See next lines for details", new Object[]{this.unlocalizedName});
                                log.warn("Attempted to add Recipe: {}", new Object[]{recipe.toString()});
                                if (v.left().isPresent()) {
                                    log.warn("Which conflicts with: {}", new Object[]{((Recipe)v.left().get()).toString()});
                                } else {
                                    log.warn((Object)"Could not find exact duplicate/conflict.");
                                }
                            }
                            if (ConfigHolder.misc.debug || GTValues.isDeobfEnvironment()) {
                                GTLog.logger.warn("Recipe duplicate or conflict found in RecipeMap {} and was not added. See next lines for details", (Object)this.unlocalizedName);
                                GTLog.logger.warn("Attempted to add Recipe: {}", (Object)recipe.toString());
                                if (v.left().isPresent()) {
                                    GTLog.logger.warn("Which conflicts with: {}", (Object)((Recipe)v.left().get()).toString());
                                } else {
                                    GTLog.logger.warn("Could not find exact duplicate/conflict.");
                                }
                            }
                        }
                        return v;
                    }
                    return Either.left(recipe);
                }
                if (v == null) {
                    return Either.right(branchRight);
                }
                return v;
            });
            if (r.left().isPresent()) {
                if (r.left().get() == recipe) continue;
                return false;
            }
            boolean addedNextBranch = r.right().filter(m -> this.recurseIngredientTreeAdd(recipe, ingredients, (Branch)m, (index + 1) % ingredients.size(), count + 1)).isPresent();
            if (addedNextBranch) continue;
            if (count == ingredients.size() - 1) {
                targetMap.remove(obj);
            } else if (targetMap.get(obj).right().isPresent() && targetMap.get(obj).right().get().isEmptyBranch()) {
                targetMap.remove(obj);
            }
            return false;
        }
        return true;
    }

    @NotNull
    protected static Map<AbstractMapIngredient, Either<Recipe, Branch>> determineRootNodes(@NotNull AbstractMapIngredient ingredient, @NotNull Branch branchMap) {
        return ingredient.isSpecialIngredient() ? branchMap.getSpecialNodes() : branchMap.getNodes();
    }

    protected void buildFromRecipeFluids(@NotNull List<List<AbstractMapIngredient>> list, @NotNull List<GTRecipeInput> fluidInputs) {
        for (GTRecipeInput fluidInput : fluidInputs) {
            MapFluidIngredient ingredient = new MapFluidIngredient(fluidInput);
            RecipeMap.retrieveCachedIngredient(list, ingredient, this.fluidIngredientRoot);
        }
    }

    protected static void retrieveCachedIngredient(@NotNull List<List<AbstractMapIngredient>> list, @NotNull AbstractMapIngredient defaultIngredient, @NotNull WeakHashMap<AbstractMapIngredient, WeakReference<AbstractMapIngredient>> cache) {
        WeakReference<AbstractMapIngredient> cached = cache.get(defaultIngredient);
        if (cached != null && cached.get() != null) {
            list.add(Collections.singletonList((AbstractMapIngredient)cached.get()));
        } else {
            cache.put(defaultIngredient, new WeakReference<AbstractMapIngredient>(defaultIngredient));
            list.add(Collections.singletonList(defaultIngredient));
        }
    }

    protected void buildFromFluidStacks(@NotNull List<List<AbstractMapIngredient>> list, @NotNull Iterable<FluidStack> ingredients) {
        for (FluidStack t : ingredients) {
            list.add(Collections.singletonList(new MapFluidIngredient(t)));
        }
    }

    @NotNull
    protected List<List<AbstractMapIngredient>> fromRecipe(@NotNull Recipe r) {
        ObjectArrayList list = new ObjectArrayList(r.getInputs().size() + r.getFluidInputs().size());
        if (r.getInputs().size() > 0) {
            this.buildFromRecipeItems((List<List<AbstractMapIngredient>>)list, RecipeMap.uniqueIngredientsList(r.getInputs()));
        }
        if (r.getFluidInputs().size() > 0) {
            this.buildFromRecipeFluids((List<List<AbstractMapIngredient>>)list, r.getFluidInputs());
        }
        return list;
    }

    protected void buildFromRecipeItems(List<List<AbstractMapIngredient>> list, @NotNull List<GTRecipeInput> inputs) {
        for (GTRecipeInput r : inputs) {
            List<AbstractMapIngredient> ingredients;
            if (r.isOreDict()) {
                MapOreDictIngredient ingredient;
                this.hasOreDictedInputs = true;
                if (r.hasNBTMatchingCondition()) {
                    this.hasNBTMatcherInputs = true;
                    ingredient = new MapOreDictNBTIngredient(r.getOreDict(), r.getNBTMatcher(), r.getNBTMatchingCondition());
                } else {
                    ingredient = new MapOreDictIngredient(r.getOreDict());
                }
                RecipeMap.retrieveCachedIngredient(list, ingredient, ingredientRoot);
                continue;
            }
            if (r.hasNBTMatchingCondition()) {
                ingredients = MapItemStackNBTIngredient.from(r);
                this.hasNBTMatcherInputs = true;
            } else {
                ingredients = MapItemStackIngredient.from(r);
            }
            for (int i = 0; i < ingredients.size(); ++i) {
                AbstractMapIngredient mappedIngredient = ingredients.get(i);
                WeakReference<AbstractMapIngredient> cached = ingredientRoot.get(mappedIngredient);
                if (cached != null && cached.get() != null) {
                    ingredients.set(i, (AbstractMapIngredient)cached.get());
                    continue;
                }
                ingredientRoot.put(mappedIngredient, new WeakReference<AbstractMapIngredient>(mappedIngredient));
            }
            list.add(ingredients);
        }
    }

    protected void buildFromItemStacks(@NotNull List<List<AbstractMapIngredient>> list, @NotNull ItemStack[] ingredients) {
        for (ItemStack stack : ingredients) {
            int meta = stack.func_77960_j();
            NBTTagCompound nbt = stack.func_77978_p();
            ObjectArrayList ls = new ObjectArrayList(1);
            ls.add(new MapItemStackIngredient(stack, meta, nbt));
            if (this.hasOreDictedInputs) {
                for (int i : OreDictionary.getOreIDs((ItemStack)stack)) {
                    MapOreDictIngredient ingredient = new MapOreDictIngredient(i);
                    ls.add(ingredient);
                    if (!this.hasNBTMatcherInputs) continue;
                    ingredient = new MapOreDictNBTIngredient(i, nbt);
                    ls.add(ingredient);
                }
            }
            if (this.hasNBTMatcherInputs) {
                ls.add(new MapItemStackNBTIngredient(stack, meta, nbt));
            }
            if (ls.isEmpty()) continue;
            list.add((List<AbstractMapIngredient>)ls);
        }
    }

    protected RecipeMap<R> setSpecialTexture(int x, int y, int width, int height, TextureArea area) {
        this.specialTexturePosition = new int[]{x, y, width, height};
        this.specialTexture = area;
        return this;
    }

    protected ModularUI.Builder addSpecialTexture(ModularUI.Builder builder) {
        builder.image(this.specialTexturePosition[0], this.specialTexturePosition[1], this.specialTexturePosition[2], this.specialTexturePosition[3], this.specialTexture);
        return builder;
    }

    public Collection<Recipe> getRecipeList() {
        ObjectOpenHashSet recipes = new ObjectOpenHashSet();
        return this.lookup.getRecipes(true).filter(arg_0 -> ((ObjectOpenHashSet)recipes).add(arg_0)).sorted(RECIPE_DURATION_THEN_EU).collect(Collectors.toList());
    }

    public SoundEvent getSound() {
        return this.sound;
    }

    @ZenMethod(value="findRecipe")
    @Optional.Method(modid="crafttweaker")
    @Nullable
    public CTRecipe ctFindRecipe(long maxVoltage, IItemStack[] itemInputs, ILiquidStack[] fluidInputs, @Optional(valueLong=0x7FFFFFFFL) int outputFluidTankCapacity) {
        List<ItemStack> mcItemInputs = itemInputs == null ? Collections.emptyList() : Arrays.stream(itemInputs).map(CraftTweakerMC::getItemStack).collect(Collectors.toList());
        List<FluidStack> mcFluidInputs = fluidInputs == null ? Collections.emptyList() : Arrays.stream(fluidInputs).map(CraftTweakerMC::getLiquidStack).collect(Collectors.toList());
        Recipe backingRecipe = this.findRecipe(maxVoltage, mcItemInputs, mcFluidInputs, true);
        return backingRecipe == null ? null : new CTRecipe(this, backingRecipe);
    }

    @ZenGetter(value="recipes")
    @Optional.Method(modid="crafttweaker")
    public List<CTRecipe> ccGetRecipeList() {
        return this.getRecipeList().stream().map(recipe -> new CTRecipe(this, (Recipe)recipe)).collect(Collectors.toList());
    }

    @ZenGetter(value="localizedName")
    public String getLocalizedName() {
        return LocalizationUtils.format(this.getTranslationKey(), new Object[0]);
    }

    @ZenGetter(value="translationKey")
    public String getTranslationKey() {
        return "recipemap." + this.unlocalizedName + ".name";
    }

    @ZenGetter(value="unlocalizedName")
    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public R recipeBuilder() {
        return ((RecipeBuilder)((RecipeBuilder)this.recipeBuilderSample).copy()).onBuild(this.onRecipeBuildAction);
    }

    @Nullable
    private Recipe recurseIngredientTreeRemove(@NotNull Recipe recipeToRemove, @NotNull List<List<AbstractMapIngredient>> ingredients, @NotNull Branch branchMap, int depth) {
        for (List<AbstractMapIngredient> current : ingredients) {
            for (AbstractMapIngredient obj : current) {
                Branch branch;
                Map<AbstractMapIngredient, Either<Recipe, Branch>> targetMap = RecipeMap.determineRootNodes(obj, branchMap);
                Recipe found = null;
                Either<Recipe, Branch> result = targetMap.get(obj);
                if (result != null) {
                    Recipe r = result.map(potentialRecipe -> potentialRecipe, potentialBranch -> this.recurseIngredientTreeRemove(recipeToRemove, ingredients.subList(1, ingredients.size()), (Branch)potentialBranch, depth + 1));
                    if (r == recipeToRemove) {
                        found = r;
                    } else {
                        if (recipeToRemove.getIsCTRecipe()) {
                            CraftTweakerAPI.logError((String)String.format("Failed to remove Recipe from RecipeMap %s: %s", this.unlocalizedName, CTRecipeHelper.getRecipeRemoveLine(this, recipeToRemove)));
                        }
                        if (ConfigHolder.misc.debug || GTValues.isDeobfEnvironment()) {
                            GTLog.logger.warn("Failed to remove recipe from RecipeMap {}. See next lines for details", (Object)this.unlocalizedName);
                            GTLog.logger.warn("Failed to remove Recipe: {}", (Object)recipeToRemove.toString());
                        }
                    }
                }
                if (found == null) continue;
                if (ingredients.size() == 1) {
                    targetMap.remove(obj);
                } else if (targetMap.get(obj).right().isPresent() && (branch = targetMap.get(obj).right().get()).isEmptyBranch()) {
                    targetMap.remove(obj);
                }
                return found;
            }
        }
        return null;
    }

    @ZenMethod(value="recipeBuilder")
    @Optional.Method(modid="crafttweaker")
    public CTRecipeBuilder ctRecipeBuilder() {
        return new CTRecipeBuilder((RecipeBuilder<?>)this.recipeBuilder());
    }

    @ZenGetter(value="maxInputs")
    public int getMaxInputs() {
        return this.maxInputs;
    }

    @ZenSetter(value="maxInputs")
    public void setMaxInputs(int maxInputs) {
        if (!this.modifyItemInputs) {
            throw new UnsupportedOperationException("Cannot change max item input amount for " + this.getUnlocalizedName());
        }
        this.maxInputs = Math.max(this.maxInputs, maxInputs);
    }

    @ZenGetter(value="maxOutputs")
    public int getMaxOutputs() {
        return this.maxOutputs;
    }

    @ZenSetter(value="maxOutputs")
    public void setMaxOutputs(int maxOutputs) {
        if (!this.modifyItemOutputs) {
            throw new UnsupportedOperationException("Cannot change max item output amount for " + this.getUnlocalizedName());
        }
        this.maxOutputs = Math.max(this.maxOutputs, maxOutputs);
    }

    @ZenGetter(value="maxFluidInputs")
    public int getMaxFluidInputs() {
        return this.maxFluidInputs;
    }

    @ZenSetter(value="maxFluidInputs")
    public void setMaxFluidInputs(int maxFluidInputs) {
        if (!this.modifyFluidInputs) {
            throw new UnsupportedOperationException("Cannot change max fluid input amount for " + this.getUnlocalizedName());
        }
        this.maxFluidInputs = Math.max(this.maxFluidInputs, maxFluidInputs);
    }

    @ZenGetter(value="maxFluidOutputs")
    public int getMaxFluidOutputs() {
        return this.maxFluidOutputs;
    }

    @ZenSetter(value="maxFluidOutputs")
    public void setMaxFluidOutputs(int maxFluidOutputs) {
        if (!this.modifyFluidOutputs) {
            throw new UnsupportedOperationException("Cannot change max fluid output amount for " + this.getUnlocalizedName());
        }
        this.maxFluidOutputs = Math.max(this.maxFluidOutputs, maxFluidOutputs);
    }

    @NotNull
    public Map<GTRecipeCategory, List<Recipe>> getRecipesByCategory() {
        return Collections.unmodifiableMap(this.recipeByCategory);
    }

    @ZenMethod
    public String toString() {
        return "RecipeMap{unlocalizedName='" + this.unlocalizedName + '\'' + '}';
    }

    public int hashCode() {
        return this.unlocalizedName.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RecipeMap)) {
            return false;
        }
        return ((RecipeMap)obj).unlocalizedName.equals(this.unlocalizedName);
    }
}

