/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes;

import com.google.common.collect.ImmutableList;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.recipes.GTRecipeInputCache;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.category.GTRecipeCategory;
import gregtech.api.recipes.chance.boost.ChanceBoostFunction;
import gregtech.api.recipes.chance.output.ChancedOutputList;
import gregtech.api.recipes.chance.output.ChancedOutputLogic;
import gregtech.api.recipes.chance.output.impl.ChancedFluidOutput;
import gregtech.api.recipes.chance.output.impl.ChancedItemOutput;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.recipeproperties.EmptyRecipePropertyStorage;
import gregtech.api.recipes.recipeproperties.IRecipePropertyStorage;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ItemStackHashStrategy;
import gregtech.integration.groovy.GroovyScriptModule;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class Recipe {
    private static final NonNullList<ItemStack> EMPTY = NonNullList.func_191196_a();
    private final List<GTRecipeInput> inputs;
    private final NonNullList<ItemStack> outputs;
    private final ChancedOutputList<ItemStack, ChancedItemOutput> chancedOutputs;
    private final List<GTRecipeInput> fluidInputs;
    private final List<FluidStack> fluidOutputs;
    private final ChancedOutputList<FluidStack, ChancedFluidOutput> chancedFluidOutputs;
    private final int duration;
    private final int EUt;
    private final boolean hidden;
    private final GTRecipeCategory recipeCategory;
    private final boolean isCTRecipe;
    private final boolean groovyRecipe;
    private final IRecipePropertyStorage recipePropertyStorage;
    private final int hashCode;

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.9")
    public static int getMaxChancedValue() {
        return ChancedOutputLogic.getMaxChancedValue();
    }

    public Recipe(@NotNull List<GTRecipeInput> inputs, List<ItemStack> outputs, @NotNull ChancedOutputList<ItemStack, ChancedItemOutput> chancedOutputs, List<GTRecipeInput> fluidInputs, List<FluidStack> fluidOutputs, @NotNull ChancedOutputList<FluidStack, ChancedFluidOutput> chancedFluidOutputs, int duration, int EUt, boolean hidden, boolean isCTRecipe, IRecipePropertyStorage recipePropertyStorage, @NotNull GTRecipeCategory recipeCategory) {
        this.recipePropertyStorage = recipePropertyStorage == null ? EmptyRecipePropertyStorage.INSTANCE : recipePropertyStorage;
        this.inputs = GTRecipeInputCache.deduplicateInputs(inputs);
        if (outputs.isEmpty()) {
            this.outputs = EMPTY;
        } else {
            this.outputs = NonNullList.func_191196_a();
            this.outputs.addAll(outputs);
        }
        this.chancedOutputs = chancedOutputs;
        this.chancedFluidOutputs = chancedFluidOutputs;
        this.fluidInputs = GTRecipeInputCache.deduplicateInputs(fluidInputs);
        this.fluidOutputs = fluidOutputs.isEmpty() ? Collections.emptyList() : ImmutableList.copyOf(fluidOutputs);
        this.duration = duration;
        this.EUt = EUt;
        this.hidden = hidden;
        this.recipeCategory = recipeCategory;
        this.isCTRecipe = isCTRecipe;
        this.hashCode = this.makeHashCode();
        this.groovyRecipe = GroovyScriptModule.isCurrentlyRunning();
    }

    @NotNull
    public Recipe copy() {
        return new Recipe(this.inputs, (List<ItemStack>)this.outputs, this.chancedOutputs, this.fluidInputs, this.fluidOutputs, this.chancedFluidOutputs, this.duration, this.EUt, this.hidden, this.isCTRecipe, this.recipePropertyStorage, this.recipeCategory);
    }

    public static Recipe trimRecipeOutputs(Recipe currentRecipe, RecipeMap<?> recipeMap, int itemTrimLimit, int fluidTrimLimit) {
        if (itemTrimLimit == -1 && fluidTrimLimit == -1) {
            return currentRecipe;
        }
        currentRecipe = currentRecipe.copy();
        RecipeBuilder builder = new RecipeBuilder(currentRecipe, recipeMap);
        builder.clearOutputs();
        builder.clearChancedOutput();
        builder.clearFluidOutputs();
        builder.clearChancedFluidOutputs();
        Pair<List<ItemStack>, List<ChancedItemOutput>> recipeOutputs = currentRecipe.getItemAndChanceOutputs(itemTrimLimit);
        builder.chancedOutputs((List)recipeOutputs.getRight());
        builder.outputs((Collection)recipeOutputs.getLeft());
        Pair<List<FluidStack>, List<ChancedFluidOutput>> recipeFluidOutputs = currentRecipe.getFluidAndChanceOutputs(fluidTrimLimit);
        builder.chancedFluidOutputs((List)recipeFluidOutputs.getRight());
        builder.fluidOutputs((Collection)recipeFluidOutputs.getLeft());
        return builder.build().getResult();
    }

    public final boolean matches(boolean consumeIfSuccessful, IItemHandlerModifiable inputs, IMultipleTankHandler fluidInputs) {
        return this.matches(consumeIfSuccessful, GTUtility.itemHandlerToList(inputs), GTUtility.fluidHandlerToList(fluidInputs));
    }

    public boolean matches(boolean consumeIfSuccessful, List<ItemStack> inputs, List<FluidStack> fluidInputs) {
        Pair<Boolean, int[]> fluids = null;
        Pair<Boolean, int[]> items = null;
        if (fluidInputs.size() > 0 && !((Boolean)(fluids = this.matchesFluid(fluidInputs)).getKey()).booleanValue()) {
            return false;
        }
        if (inputs.size() > 0 && !((Boolean)(items = this.matchesItems(inputs)).getKey()).booleanValue()) {
            return false;
        }
        if (consumeIfSuccessful) {
            int i;
            if (fluids != null) {
                int[] fluidAmountInTank = (int[])fluids.getValue();
                for (i = 0; i < fluidAmountInTank.length; ++i) {
                    FluidStack fluidStack = fluidInputs.get(i);
                    int fluidAmount = fluidAmountInTank[i];
                    if (fluidStack == null || fluidStack.amount == fluidAmount) continue;
                    fluidStack.amount = fluidAmount;
                    if (fluidStack.amount != 0) continue;
                    fluidInputs.set(i, null);
                }
            }
            if (items != null) {
                int[] itemAmountInSlot = (int[])items.getValue();
                for (i = 0; i < itemAmountInSlot.length; ++i) {
                    ItemStack itemInSlot = inputs.get(i);
                    int itemAmount = itemAmountInSlot[i];
                    if (itemInSlot.func_190926_b() || itemInSlot.func_190916_E() == itemAmount) continue;
                    itemInSlot.func_190920_e(itemAmountInSlot[i]);
                }
            }
        }
        return true;
    }

    private Pair<Boolean, int[]> matchesItems(List<ItemStack> inputs) {
        int[] itemAmountInSlot = new int[inputs.size()];
        int indexed = 0;
        List<GTRecipeInput> gtRecipeInputs = this.inputs;
        for (GTRecipeInput ingredient : gtRecipeInputs) {
            int ingredientAmount = ingredient.getAmount();
            for (int j = 0; j < inputs.size(); ++j) {
                ItemStack inputStack = inputs.get(j);
                if (j == indexed) {
                    itemAmountInSlot[j] = inputStack.func_190926_b() ? 0 : inputStack.func_190916_E();
                    ++indexed;
                }
                if (inputStack.func_190926_b() || !ingredient.acceptsStack(inputStack)) continue;
                int itemAmountToConsume = Math.min(itemAmountInSlot[j], ingredientAmount);
                ingredientAmount -= itemAmountToConsume;
                if (!ingredient.isNonConsumable()) {
                    int n = j;
                    itemAmountInSlot[n] = itemAmountInSlot[n] - itemAmountToConsume;
                }
                if (ingredientAmount == 0) break;
            }
            if (ingredientAmount <= 0) continue;
            return Pair.of((Object)false, (Object)itemAmountInSlot);
        }
        int[] retItemAmountInSlot = new int[indexed];
        System.arraycopy(itemAmountInSlot, 0, retItemAmountInSlot, 0, indexed);
        return Pair.of((Object)true, (Object)retItemAmountInSlot);
    }

    private Pair<Boolean, int[]> matchesFluid(List<FluidStack> fluidInputs) {
        int[] fluidAmountInTank = new int[fluidInputs.size()];
        int indexed = 0;
        List<GTRecipeInput> gtRecipeInputs = this.fluidInputs;
        for (GTRecipeInput fluid : gtRecipeInputs) {
            int fluidAmount = fluid.getAmount();
            for (int j = 0; j < fluidInputs.size(); ++j) {
                FluidStack tankFluid = fluidInputs.get(j);
                if (j == indexed) {
                    ++indexed;
                    int n = fluidAmountInTank[j] = tankFluid == null ? 0 : tankFluid.amount;
                }
                if (tankFluid == null || !fluid.acceptsFluid(tankFluid)) continue;
                int fluidAmountToConsume = Math.min(fluidAmountInTank[j], fluidAmount);
                fluidAmount -= fluidAmountToConsume;
                if (!fluid.isNonConsumable()) {
                    int n = j;
                    fluidAmountInTank[n] = fluidAmountInTank[n] - fluidAmountToConsume;
                }
                if (fluidAmount == 0) break;
            }
            if (fluidAmount <= 0) continue;
            return Pair.of((Object)false, (Object)fluidAmountInTank);
        }
        int[] retfluidAmountInTank = new int[indexed];
        System.arraycopy(fluidAmountInTank, 0, retfluidAmountInTank, 0, indexed);
        return Pair.of((Object)true, (Object)retfluidAmountInTank);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recipe recipe = (Recipe)o;
        return this.hasSameInputs(recipe) && this.hasSameFluidInputs(recipe);
    }

    private int makeHashCode() {
        int hash = 31 * this.hashInputs();
        hash = 31 * hash + Recipe.hashFluidList(this.fluidInputs);
        return hash;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int hashInputs() {
        int hash = 0;
        for (GTRecipeInput recipeIngredient : this.inputs) {
            if (!recipeIngredient.isOreDict()) {
                for (ItemStack is : recipeIngredient.getInputStacks()) {
                    hash = 31 * hash + ItemStackHashStrategy.comparingAll().hashCode(is);
                }
                continue;
            }
            hash = 31 * hash + recipeIngredient.getOreDict();
        }
        return hash;
    }

    private boolean hasSameInputs(Recipe otherRecipe) {
        ObjectArrayList otherStackList = new ObjectArrayList(otherRecipe.inputs.size());
        for (GTRecipeInput otherInputs : otherRecipe.inputs) {
            otherStackList.addAll(Arrays.asList(otherInputs.getInputStacks()));
        }
        if (!((Boolean)this.matchesItems((List<ItemStack>)otherStackList).getLeft()).booleanValue()) {
            return false;
        }
        ObjectArrayList thisStackList = new ObjectArrayList(this.inputs.size());
        for (GTRecipeInput thisInputs : this.inputs) {
            thisStackList.addAll(Arrays.asList(thisInputs.getInputStacks()));
        }
        return (Boolean)otherRecipe.matchesItems((List<ItemStack>)thisStackList).getLeft();
    }

    public static int hashFluidList(@NotNull List<GTRecipeInput> fluids) {
        int hash = 0;
        for (GTRecipeInput fluidInput : fluids) {
            hash = 31 * hash + fluidInput.hashCode();
        }
        return hash;
    }

    private boolean hasSameFluidInputs(Recipe otherRecipe) {
        ObjectArrayList otherFluidList = new ObjectArrayList(otherRecipe.fluidInputs.size());
        for (GTRecipeInput otherInputs : otherRecipe.fluidInputs) {
            FluidStack fluidStack = otherInputs.getInputFluidStack();
            otherFluidList.add(fluidStack);
        }
        if (!((Boolean)this.matchesFluid((List<FluidStack>)otherFluidList).getLeft()).booleanValue()) {
            return false;
        }
        ObjectArrayList thisFluidsList = new ObjectArrayList(this.fluidInputs.size());
        for (GTRecipeInput thisFluidInputs : this.fluidInputs) {
            FluidStack fluidStack = thisFluidInputs.getInputFluidStack();
            thisFluidsList.add(fluidStack);
        }
        return (Boolean)otherRecipe.matchesFluid((List<FluidStack>)thisFluidsList).getLeft();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("inputs", this.inputs).append("outputs", this.outputs).append("chancedOutputs", this.chancedOutputs).append("fluidInputs", this.fluidInputs).append("fluidOutputs", this.fluidOutputs).append("duration", this.duration).append("EUt", this.EUt).append("hidden", this.hidden).append("CTRecipe", this.isCTRecipe).append("GSRecipe", this.groovyRecipe).toString();
    }

    public List<GTRecipeInput> getInputs() {
        return this.inputs;
    }

    public NonNullList<ItemStack> getOutputs() {
        return this.outputs;
    }

    public List<ItemStack> getResultItemOutputs(int recipeTier, int machineTier, RecipeMap<?> recipeMap) {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>((Collection<ItemStack>)GTUtility.copyStackList(this.getOutputs()));
        ChanceBoostFunction function = recipeMap.getChanceFunction();
        List<ChancedItemOutput> chancedOutputsList = this.getChancedOutputs().roll(function, recipeTier, machineTier);
        if (chancedOutputsList == null) {
            return outputs;
        }
        ArrayList<ItemStack> resultChanced = new ArrayList<ItemStack>();
        for (ChancedItemOutput chancedOutput : chancedOutputsList) {
            ItemStack stackToAdd = ((ItemStack)chancedOutput.getIngredient()).func_77946_l();
            for (ItemStack stackInList : resultChanced) {
                int insertable = stackInList.func_77976_d() - stackInList.func_190916_E();
                if (insertable <= 0 || !ItemHandlerHelper.canItemStacksStack((ItemStack)stackInList, (ItemStack)stackToAdd)) continue;
                if (insertable >= stackToAdd.func_190916_E()) {
                    stackInList.func_190917_f(stackToAdd.func_190916_E());
                    stackToAdd = ItemStack.field_190927_a;
                    break;
                }
                stackInList.func_190917_f(insertable);
                stackToAdd.func_190918_g(insertable);
            }
            if (stackToAdd.func_190926_b()) continue;
            resultChanced.add(stackToAdd);
        }
        outputs.addAll(resultChanced);
        return outputs;
    }

    public Pair<List<ItemStack>, List<ChancedItemOutput>> getItemAndChanceOutputs(int outputLimit) {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        List<ChancedItemOutput> chancedOutputs = new ArrayList<ChancedItemOutput>(this.getChancedOutputs().getChancedEntries());
        if (outputLimit == -1) {
            outputs.addAll((Collection<ItemStack>)GTUtility.copyStackList(this.getOutputs()));
        } else if (this.getOutputs().size() >= outputLimit) {
            outputs.addAll(GTUtility.copyStackList(this.getOutputs()).subList(0, Math.min(outputLimit, this.getOutputs().size())));
            chancedOutputs.clear();
        } else if (!this.getOutputs().isEmpty() && this.getOutputs().size() + chancedOutputs.size() >= outputLimit) {
            outputs.addAll((Collection<ItemStack>)GTUtility.copyStackList(this.getOutputs()));
            int numChanced = outputLimit - this.getOutputs().size();
            chancedOutputs = chancedOutputs.subList(0, Math.min(numChanced, chancedOutputs.size()));
        } else if (this.getOutputs().isEmpty()) {
            chancedOutputs = chancedOutputs.subList(0, Math.min(outputLimit, chancedOutputs.size()));
        } else {
            outputs.addAll((Collection<ItemStack>)GTUtility.copyStackList(this.getOutputs()));
        }
        return Pair.of(outputs, chancedOutputs);
    }

    public List<ItemStack> getAllItemOutputs() {
        ArrayList<ItemStack> recipeOutputs = new ArrayList<ItemStack>((Collection<ItemStack>)this.outputs);
        for (ChancedItemOutput entry : this.chancedOutputs.getChancedEntries()) {
            recipeOutputs.add(((ItemStack)entry.getIngredient()).func_77946_l());
        }
        return recipeOutputs;
    }

    public ChancedOutputList<ItemStack, ChancedItemOutput> getChancedOutputs() {
        return this.chancedOutputs;
    }

    public List<GTRecipeInput> getFluidInputs() {
        return this.fluidInputs;
    }

    public ChancedOutputList<FluidStack, ChancedFluidOutput> getChancedFluidOutputs() {
        return this.chancedFluidOutputs;
    }

    public boolean hasInputFluid(FluidStack fluid) {
        for (GTRecipeInput fluidInput : this.fluidInputs) {
            FluidStack fluidStack = fluidInput.getInputFluidStack();
            if (fluid.getFluid() != fluidStack.getFluid()) continue;
            return fluidStack.isFluidEqual(fluid);
        }
        return false;
    }

    public List<FluidStack> getFluidOutputs() {
        return this.fluidOutputs;
    }

    public Pair<List<FluidStack>, List<ChancedFluidOutput>> getFluidAndChanceOutputs(int outputLimit) {
        ArrayList<FluidStack> outputs = new ArrayList<FluidStack>();
        List<ChancedFluidOutput> chancedOutputs = new ArrayList<ChancedFluidOutput>(this.getChancedFluidOutputs().getChancedEntries());
        if (outputLimit == -1) {
            outputs.addAll(GTUtility.copyFluidList(this.getFluidOutputs()));
        } else if (this.getFluidOutputs().size() >= outputLimit) {
            outputs.addAll(GTUtility.copyFluidList(this.getFluidOutputs()).subList(0, Math.min(outputLimit, this.getFluidOutputs().size())));
            chancedOutputs.clear();
        } else if (!this.getFluidOutputs().isEmpty() && this.getFluidOutputs().size() + chancedOutputs.size() >= outputLimit) {
            outputs.addAll(GTUtility.copyFluidList(this.getFluidOutputs()));
            int numChanced = outputLimit - this.getFluidOutputs().size();
            chancedOutputs = chancedOutputs.subList(0, Math.min(numChanced, chancedOutputs.size()));
        } else if (this.getFluidOutputs().isEmpty()) {
            chancedOutputs = chancedOutputs.subList(0, Math.min(outputLimit, chancedOutputs.size()));
        } else {
            outputs.addAll(GTUtility.copyFluidList(this.getFluidOutputs()));
        }
        return Pair.of(outputs, chancedOutputs);
    }

    public List<FluidStack> getAllFluidOutputs() {
        ArrayList<FluidStack> recipeOutputs = new ArrayList<FluidStack>(this.fluidOutputs);
        for (ChancedFluidOutput entry : this.chancedFluidOutputs.getChancedEntries()) {
            recipeOutputs.add(((FluidStack)entry.getIngredient()).copy());
        }
        return recipeOutputs;
    }

    public List<FluidStack> getResultFluidOutputs(int recipeTier, int machineTier, RecipeMap<?> recipeMap) {
        ArrayList<FluidStack> outputs = new ArrayList<FluidStack>(GTUtility.copyFluidList(this.getFluidOutputs()));
        ChanceBoostFunction function = recipeMap.getChanceFunction();
        List<ChancedFluidOutput> chancedOutputsList = this.getChancedFluidOutputs().roll(function, recipeTier, machineTier);
        if (chancedOutputsList == null) {
            return outputs;
        }
        ArrayList<FluidStack> resultChanced = new ArrayList<FluidStack>();
        for (ChancedFluidOutput chancedOutput : chancedOutputsList) {
            FluidStack stackToAdd = ((FluidStack)chancedOutput.getIngredient()).copy();
            for (FluidStack stackInList : resultChanced) {
                int insertable = stackInList.amount;
                if (insertable <= 0 || stackInList.getFluid() != stackToAdd.getFluid()) continue;
                stackInList.amount += stackToAdd.amount;
                stackToAdd = null;
                break;
            }
            if (stackToAdd == null) continue;
            resultChanced.add(stackToAdd);
        }
        outputs.addAll(resultChanced);
        return outputs;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getEUt() {
        return this.EUt;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean getIsCTRecipe() {
        return this.isCTRecipe;
    }

    public boolean isGroovyRecipe() {
        return this.groovyRecipe;
    }

    public boolean hasValidInputsForDisplay() {
        for (GTRecipeInput ingredient : this.inputs) {
            if (!(ingredient.isOreDict() ? OreDictionary.getOres((String)OreDictionary.getOreName((int)ingredient.getOreDict())).stream().anyMatch(s -> !s.func_190926_b()) : Arrays.stream(ingredient.getInputStacks()).anyMatch(s -> !s.func_190926_b()))) continue;
            return true;
        }
        for (GTRecipeInput fluidInput : this.fluidInputs) {
            FluidStack fluidIngredient = fluidInput.getInputFluidStack();
            if (fluidIngredient == null || fluidIngredient.amount <= 0) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public GTRecipeCategory getRecipeCategory() {
        return this.recipeCategory;
    }

    public <T> T getProperty(RecipeProperty<T> property, T defaultValue) {
        return this.recipePropertyStorage.getRecipePropertyValue(property, defaultValue);
    }

    public Object getPropertyRaw(String key) {
        return this.recipePropertyStorage.getRawRecipePropertyValue(key);
    }

    public Set<Map.Entry<RecipeProperty<?>, Object>> getPropertyValues() {
        return this.recipePropertyStorage.getRecipeProperties();
    }

    public Set<String> getPropertyKeys() {
        return this.recipePropertyStorage.getRecipePropertyKeys();
    }

    public Set<RecipeProperty<?>> getPropertyTypes() {
        return this.recipePropertyStorage.getPropertyTypes();
    }

    public boolean hasProperty(RecipeProperty<?> property) {
        return this.recipePropertyStorage.hasRecipeProperty(property);
    }

    public int getPropertyCount() {
        return this.recipePropertyStorage.getSize();
    }

    public int getUnhiddenPropertyCount() {
        return (int)this.recipePropertyStorage.getRecipeProperties().stream().filter(property -> !((RecipeProperty)property.getKey()).isHidden()).count();
    }

    public IRecipePropertyStorage getRecipePropertyStorage() {
        return this.recipePropertyStorage;
    }
}

