/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes;

import gregtech.api.GTValues;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.util.GTLog;
import gregtech.common.ConfigHolder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GTRecipeInputCache {
    private static final int EXPECTED_CACHE_SIZE = 16384;
    private static ObjectOpenHashSet<GTRecipeInput> INSTANCES;

    public static boolean isCacheEnabled() {
        return INSTANCES != null;
    }

    public static void enableCache() {
        if (!GTRecipeInputCache.isCacheEnabled()) {
            INSTANCES = new ObjectOpenHashSet(16384, 1.0f);
            if (ConfigHolder.misc.debug || GTValues.isDeobfEnvironment()) {
                GTLog.logger.info("GTRecipeInput cache enabled");
            }
        }
    }

    public static void disableCache() {
        if (GTRecipeInputCache.isCacheEnabled()) {
            if (ConfigHolder.misc.debug || GTValues.isDeobfEnvironment()) {
                GTLog.logger.info("GTRecipeInput cache disabled; releasing {} unique instances", (Object)INSTANCES.size());
            }
            INSTANCES = null;
        }
    }

    public static GTRecipeInput deduplicate(GTRecipeInput recipeInput) {
        if (!GTRecipeInputCache.isCacheEnabled() || recipeInput.isCached()) {
            return recipeInput;
        }
        GTRecipeInput cached = (GTRecipeInput)INSTANCES.addOrGet((Object)recipeInput);
        if (cached == recipeInput) {
            cached.setCached();
        }
        return cached;
    }

    public static List<GTRecipeInput> deduplicateInputs(List<GTRecipeInput> inputs) {
        if (!GTRecipeInputCache.isCacheEnabled()) {
            return inputs;
        }
        if (inputs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<GTRecipeInput> list = new ArrayList<GTRecipeInput>(inputs.size());
        for (GTRecipeInput input : inputs) {
            list.add(GTRecipeInputCache.deduplicate(input));
        }
        return list;
    }
}

