/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes;

import java.util.Objects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidKey {
    public final String fluid;
    public NBTTagCompound tag;
    private final int amount;

    public FluidKey(FluidStack fluidStack) {
        this.fluid = fluidStack.getFluid().getName();
        this.tag = fluidStack.tag;
        this.amount = fluidStack.amount;
    }

    public FluidKey copy() {
        return new FluidKey(new FluidStack(this.getFluid(), this.amount, this.tag));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FluidKey)) {
            return false;
        }
        FluidKey fluidKey = (FluidKey)o;
        if (!Objects.equals(this.fluid, fluidKey.fluid)) {
            return false;
        }
        if (this.tag == null && fluidKey.tag != null) {
            return false;
        }
        return this.tag == null || this.tag.equals((Object)fluidKey.tag);
    }

    public int hashCode() {
        int hash = 0;
        hash += Objects.hash(this.fluid);
        if (this.tag != null && !this.tag.func_82582_d()) {
            hash += this.tag.hashCode();
        }
        return hash;
    }

    public String toString() {
        return "FluidKey{fluid=" + this.fluid + ", tag=" + this.tag + '}';
    }

    public Fluid getFluid() {
        return FluidRegistry.getFluid((String)this.fluid);
    }
}

