/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet.longdist;

import gregtech.api.GregTechAPI;
import gregtech.api.pipenet.longdist.ILDEndpoint;
import gregtech.api.pipenet.longdist.ILDNetworkPart;
import gregtech.api.pipenet.longdist.LongDistanceNetwork;
import gregtech.api.pipenet.longdist.LongDistancePipeType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLongDistancePipe
extends Block
implements ILDNetworkPart {
    private final LongDistancePipeType pipeType;

    public BlockLongDistancePipe(LongDistancePipeType pipeType) {
        super(Material.field_151573_f);
        this.pipeType = pipeType;
        this.func_149663_c("long_distance_" + pipeType.getName() + "_pipeline");
        this.func_149647_a(GregTechAPI.TAB_GREGTECH);
        this.setHarvestLevel("wrench", 1);
    }

    public void func_180633_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityLivingBase placer, @NotNull ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (worldIn.field_72995_K) {
            return;
        }
        ArrayList<LongDistanceNetwork> networks = new ArrayList<LongDistanceNetwork>();
        BlockPos.PooledMutableBlockPos offsetPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            offsetPos.func_189533_g((Vec3i)pos).func_189536_c(facing);
            IBlockState neighborState = worldIn.func_180495_p((BlockPos)offsetPos);
            ILDNetworkPart networkPart = ILDNetworkPart.tryGet(worldIn, (BlockPos)offsetPos, neighborState);
            if (networkPart == null || networkPart.getPipeType() != this.getPipeType()) continue;
            LongDistanceNetwork network = LongDistanceNetwork.get(worldIn, (BlockPos)offsetPos);
            if (network == null) {
                network = networkPart.getPipeType().createNetwork(worldIn);
                network.recalculateNetwork(Collections.singleton(offsetPos.func_185334_h()));
                return;
            }
            if (!network.getPipeType().isValidPart(networkPart)) {
                throw new IllegalStateException("NetworkPart " + networkPart + " pipeType " + network.getPipeType() + " is not valid for network type " + network.getPipeType());
            }
            ILDEndpoint endpoint = ILDEndpoint.tryGet(worldIn, (BlockPos)offsetPos);
            if (endpoint != null && endpoint.getFrontFacing().func_176740_k() != facing.func_176740_k()) continue;
            networks.add(network);
        }
        offsetPos.func_185344_t();
        if (networks.isEmpty()) {
            LongDistanceNetwork network = this.pipeType.createNetwork(worldIn);
            network.onPlacePipe(pos);
        } else if (networks.size() == 1) {
            ((LongDistanceNetwork)networks.get(0)).onPlacePipe(pos);
        } else {
            LongDistanceNetwork main = (LongDistanceNetwork)networks.get(0);
            main.onPlacePipe(pos);
            networks.remove(0);
            for (LongDistanceNetwork network : networks) {
                main.mergePipeNet(network);
            }
        }
    }

    public void func_180663_b(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        if (worldIn.field_72995_K) {
            return;
        }
        LongDistanceNetwork network = LongDistanceNetwork.get(worldIn, pos);
        if (network != null) {
            network.onRemovePipe(pos);
        }
    }

    public void func_149666_a(@NotNull CreativeTabs itemIn, @NotNull NonNullList<ItemStack> items) {
        if (itemIn == GregTechAPI.TAB_GREGTECH) {
            items.add((Object)new ItemStack((Block)this));
        }
    }

    public boolean canCreatureSpawn(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public void func_190948_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<String> tooltip, @NotNull ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_135052_a((String)"gregtech.block.tooltip.no_mob_spawning", (Object[])new Object[0]));
    }

    @Override
    @NotNull
    public LongDistancePipeType getPipeType() {
        return this.pipeType;
    }
}

