/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet.block;

import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.common.ConfigHolder;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ItemBlockPipe<PipeType extends Enum<PipeType>, NodeDataType>
extends ItemBlock {
    protected final BlockPipe<PipeType, NodeDataType, ?> blockPipe;

    public ItemBlockPipe(BlockPipe<PipeType, NodeDataType, ?> block) {
        super(block);
        this.blockPipe = block;
        this.func_77627_a(true);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public boolean placeBlockAt(@NotNull ItemStack stack, @NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull EnumFacing side, float hitX, float hitY, float hitZ, @NotNull IBlockState newState) {
        boolean superVal = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        if (superVal && !world.field_72995_K) {
            IPipeTile selfTile = (IPipeTile)world.func_175625_s(pos);
            if (selfTile == null) {
                return superVal;
            }
            if (selfTile.getPipeBlock().canConnect(selfTile, side.func_176734_d())) {
                selfTile.setConnection(side.func_176734_d(), true, false);
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                TileEntity te = selfTile.getNeighbor(facing);
                if (te instanceof IPipeTile) {
                    IPipeTile otherPipe = (IPipeTile)te;
                    if (!otherPipe.isConnected(facing.func_176734_d())) continue;
                    if (otherPipe.getPipeBlock().canPipesConnect(otherPipe, facing.func_176734_d(), selfTile)) {
                        selfTile.setConnection(facing, true, true);
                        continue;
                    }
                    otherPipe.setConnection(facing.func_176734_d(), false, true);
                    continue;
                }
                if (ConfigHolder.machines.gt6StylePipesCables || !selfTile.getPipeBlock().canPipeConnectToBlock(selfTile, facing, te)) continue;
                selfTile.setConnection(facing, true, false);
            }
        }
        return superVal;
    }
}

