/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.multiblock;

import gregtech.api.capability.impl.FluidHandlerProxy;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.ItemHandlerProxy;
import gregtech.api.capability.impl.NotifiableFluidTank;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.capability.impl.PrimitiveRecipeLogic;
import gregtech.api.metatileentity.MTETrait;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.recipes.RecipeMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.items.IItemHandler;

public abstract class RecipeMapPrimitiveMultiblockController
extends MultiblockWithDisplayBase {
    protected PrimitiveRecipeLogic recipeMapWorkable;

    public RecipeMapPrimitiveMultiblockController(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap) {
        super(metaTileEntityId);
        this.recipeMapWorkable = new PrimitiveRecipeLogic(this, recipeMap);
        this.initializeAbilities();
    }

    protected void initializeAbilities() {
        this.importItems = new NotifiableItemStackHandler(this, this.recipeMapWorkable.getRecipeMap().getMaxInputs(), this, false);
        this.importFluids = new FluidTankList(true, this.makeFluidTanks(this.recipeMapWorkable.getRecipeMap().getMaxFluidInputs(), false));
        this.exportItems = new NotifiableItemStackHandler(this, this.recipeMapWorkable.getRecipeMap().getMaxOutputs(), this, true);
        this.exportFluids = new FluidTankList(false, this.makeFluidTanks(this.recipeMapWorkable.getRecipeMap().getMaxFluidOutputs(), true));
        this.itemInventory = new ItemHandlerProxy((IItemHandler)this.importItems, (IItemHandler)this.exportItems);
        this.fluidInventory = new FluidHandlerProxy(this.importFluids, this.exportFluids);
    }

    private List<FluidTank> makeFluidTanks(int length, boolean isExport) {
        ArrayList<FluidTank> fluidTankList = new ArrayList<FluidTank>(length);
        for (int i = 0; i < length; ++i) {
            fluidTankList.add(new NotifiableFluidTank(32000, this, isExport));
        }
        return fluidTankList;
    }

    @Override
    protected void updateFormedValid() {
        this.recipeMapWorkable.update();
    }

    @Override
    public boolean isActive() {
        return super.isActive() && this.recipeMapWorkable.isWorkingEnabled() && this.recipeMapWorkable.isActive();
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.recipeMapWorkable.invalidate();
    }

    @Override
    protected boolean shouldUpdate(MTETrait trait) {
        return !(trait instanceof PrimitiveRecipeLogic);
    }

    @Override
    public SoundEvent getSound() {
        return this.recipeMapWorkable.getRecipeMap().getSound();
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return this.isStructureFormed();
    }

    @Override
    public boolean allowsExtendedFacing() {
        return false;
    }
}

