/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.multiblock;

import gregtech.api.GTValues;
import gregtech.api.block.VariantActiveBlock;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IDistinctBusController;
import gregtech.api.capability.IMaintenanceHatch;
import gregtech.api.capability.IMufflerHatch;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.AdvancedTextWidget;
import gregtech.api.gui.widgets.ImageCycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.IndicatorImageWidget;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.metatileentity.IVoidable;
import gregtech.api.metatileentity.multiblock.IMaintenance;
import gregtech.api.metatileentity.multiblock.IProgressBarMultiblock;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class MultiblockWithDisplayBase
extends MultiblockControllerBase
implements IMaintenance {
    private static final String NBT_VOIDING_MODE = "VoidingMode";
    private static final String NBT_VOIDING_ITEMS = "VoidingItems";
    private static final String NBT_VOIDING_FLUIDS = "VoidingFluids";
    private boolean voidingItems = false;
    private boolean voidingFluids = false;
    private IVoidable.VoidingMode voidingMode;
    private boolean fluidInfSink = false;
    private boolean itemInfSink = false;
    private IMaintenanceHatch maintenanceHatch;
    protected final List<ItemStack> recoveryItems = new ArrayList<ItemStack>(Collections.singleton(OreDictUnifier.get(OrePrefix.dustTiny, Materials.Ash)));
    private int timeActive;
    protected byte maintenance_problems = 0;
    private boolean initialMaintenanceDone;
    private boolean storedTaped = false;
    protected List<BlockPos> variantActiveBlocks;
    protected boolean lastActive;

    public MultiblockWithDisplayBase(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
        this.voidingMode = IVoidable.VoidingMode.VOID_NONE;
    }

    @Override
    public void setMaintenanceFixed(int index) {
        this.maintenance_problems = (byte)(this.maintenance_problems | 1 << index);
    }

    @Override
    public void causeMaintenanceProblems() {
        this.maintenance_problems = (byte)(this.maintenance_problems & ~(1 << (int)(GTValues.RNG.nextFloat() * 5.0f)));
        this.getWorld().func_184148_a(null, (double)this.getPos().func_177958_n(), (double)this.getPos().func_177956_o(), (double)this.getPos().func_177952_p(), this.getBreakdownSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    public byte getMaintenanceProblems() {
        return ConfigHolder.machines.enableMaintenance && this.hasMaintenanceMechanics() ? this.maintenance_problems : (byte)63;
    }

    @Override
    public int getNumMaintenanceProblems() {
        return ConfigHolder.machines.enableMaintenance && this.hasMaintenanceMechanics() ? 6 - Integer.bitCount(this.maintenance_problems) : 0;
    }

    @Override
    public boolean hasMaintenanceProblems() {
        return ConfigHolder.machines.enableMaintenance && this.hasMaintenanceMechanics() && this.maintenance_problems < 63;
    }

    @Override
    public boolean hasMaintenanceMechanics() {
        return true;
    }

    public boolean hasMufflerMechanics() {
        return false;
    }

    public void calculateMaintenance() {
        int n;
        if (!ConfigHolder.machines.enableMaintenance || !this.hasMaintenanceMechanics() || this.maintenanceHatch == null) {
            return;
        }
        if (this.maintenanceHatch.isFullAuto()) {
            return;
        }
        ++this.timeActive;
        if ((double)n >= 1000.0 / this.maintenanceHatch.getTimeMultiplier()) {
            this.timeActive = 0;
            if (GTValues.RNG.nextInt(6000) == 0) {
                this.causeMaintenanceProblems();
                this.maintenanceHatch.setTaped(false);
            }
        }
    }

    public double getMaintenanceDurationMultiplier() {
        if (!ConfigHolder.machines.enableMaintenance || !this.hasMaintenanceMechanics() || this.maintenanceHatch == null) {
            return 1.0;
        }
        return this.maintenanceHatch.getDurationMultiplier();
    }

    @Override
    public boolean isStructureObstructed() {
        return this.hasMufflerMechanics() && !this.isMufflerFaceFree();
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        if (this.hasMaintenanceMechanics() && ConfigHolder.machines.enableMaintenance) {
            if (this.getAbilities(MultiblockAbility.MAINTENANCE_HATCH).isEmpty()) {
                return;
            }
            this.maintenanceHatch = this.getAbilities(MultiblockAbility.MAINTENANCE_HATCH).get(0);
            if (this.maintenanceHatch.startWithoutProblems() && !this.initialMaintenanceDone) {
                this.maintenance_problems = (byte)63;
                this.timeActive = 0;
                this.initialMaintenanceDone = true;
            }
            this.readMaintenanceData(this.maintenanceHatch);
            if (this.storedTaped) {
                this.maintenanceHatch.setTaped(true);
                this.storeTaped(false);
            }
        }
        this.variantActiveBlocks = context.getOrDefault("VABlock", new LinkedList());
        this.replaceVariantBlocksActive(false);
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K) {
            boolean state = this.isActive();
            if (this.lastActive != state) {
                this.setLastActive(state);
                this.markDirty();
                this.replaceVariantBlocksActive(this.lastActive);
            }
            if (state) {
                this.calculateMaintenance();
            }
        }
    }

    public void setLastActive(boolean lastActive) {
        this.lastActive = lastActive;
        this.writeCustomData(GregtechDataCodes.IS_WORKING, buf -> buf.writeBoolean(lastActive));
    }

    @Override
    public void storeTaped(boolean isTaped) {
        this.storedTaped = isTaped;
        this.writeCustomData(GregtechDataCodes.STORE_TAPED, buf -> buf.writeBoolean(isTaped));
    }

    private void readMaintenanceData(IMaintenanceHatch hatch) {
        if (hatch.hasMaintenanceData()) {
            Tuple<Byte, Integer> data = hatch.readMaintenanceData();
            this.maintenance_problems = (Byte)data.func_76341_a();
            this.timeActive = (Integer)data.func_76340_b();
        }
    }

    public void outputRecoveryItems() {
        IMufflerHatch muffler = this.getAbilities(MultiblockAbility.MUFFLER_HATCH).get(0);
        muffler.recoverItemsTable(this.recoveryItems);
    }

    public void outputRecoveryItems(int parallel) {
        IMufflerHatch muffler = this.getAbilities(MultiblockAbility.MUFFLER_HATCH).get(0);
        for (int i = 0; i < parallel; ++i) {
            muffler.recoverItemsTable(this.recoveryItems);
        }
    }

    public boolean isMufflerFaceFree() {
        if (this.hasMufflerMechanics() && this.getAbilities(MultiblockAbility.MUFFLER_HATCH).size() == 0) {
            return false;
        }
        return this.isStructureFormed() && this.hasMufflerMechanics() && this.getAbilities(MultiblockAbility.MUFFLER_HATCH).get(0).isFrontFaceFree();
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    @ApiStatus.ScheduledForRemoval(inVersion="2.9")
    public void runMufflerEffect(float xPos, float yPos, float zPos, float xSpd, float ySpd, float zSpd) {
        this.getWorld().func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)xPos, (double)yPos, (double)zPos, (double)xSpd, (double)ySpd, (double)zSpd, new int[0]);
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public EnumParticleTypes getMufflerParticle() {
        return EnumParticleTypes.SMOKE_LARGE;
    }

    protected void setRecoveryItems(ItemStack ... recoveryItems) {
        this.recoveryItems.clear();
        this.recoveryItems.addAll(Arrays.asList(recoveryItems));
    }

    @Override
    public boolean isActive() {
        return this.isStructureFormed();
    }

    @Override
    public void invalidateStructure() {
        if (this.hasMaintenanceMechanics() && ConfigHolder.machines.enableMaintenance && !this.getAbilities(MultiblockAbility.MAINTENANCE_HATCH).isEmpty()) {
            this.getAbilities(MultiblockAbility.MAINTENANCE_HATCH).get(0).storeMaintenanceData(this.maintenance_problems, this.timeActive);
        }
        this.lastActive = false;
        this.replaceVariantBlocksActive(false);
        this.fluidInfSink = false;
        this.itemInfSink = false;
        this.maintenanceHatch = null;
        super.invalidateStructure();
    }

    protected void replaceVariantBlocksActive(boolean isActive) {
        if (this.variantActiveBlocks != null && !this.variantActiveBlocks.isEmpty()) {
            int id = this.getWorld().field_73011_w.getDimension();
            this.writeCustomData(GregtechDataCodes.VARIANT_RENDER_UPDATE, buf -> {
                buf.writeInt(id);
                buf.writeBoolean(isActive);
                buf.writeInt(this.variantActiveBlocks.size());
                for (BlockPos blockPos : this.variantActiveBlocks) {
                    VariantActiveBlock.setBlockActive(id, blockPos, isActive);
                    buf.func_179255_a(blockPos);
                }
            });
        }
    }

    public TraceabilityPredicate autoAbilities() {
        return this.autoAbilities(true, true);
    }

    public TraceabilityPredicate autoAbilities(boolean checkMaintenance, boolean checkMuffler) {
        TraceabilityPredicate predicate = new TraceabilityPredicate();
        if (checkMaintenance && this.hasMaintenanceMechanics()) {
            predicate = predicate.or(this.maintenancePredicate());
        }
        if (checkMuffler && this.hasMufflerMechanics()) {
            predicate = predicate.or(MultiblockWithDisplayBase.abilities(MultiblockAbility.MUFFLER_HATCH).setMinGlobalLimited(1).setMaxGlobalLimited(1));
        }
        return predicate;
    }

    protected TraceabilityPredicate maintenancePredicate() {
        if (this.hasMaintenanceMechanics()) {
            return MultiblockWithDisplayBase.abilities(MultiblockAbility.MAINTENANCE_HATCH).setMinGlobalLimited(ConfigHolder.machines.enableMaintenance ? 1 : 0).setMaxGlobalLimited(1);
        }
        return new TraceabilityPredicate();
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, this.isStructureFormed());
    }

    protected void handleDisplayClick(String componentData, Widget.ClickData clickData) {
    }

    protected ModularUI.Builder createUITemplate(EntityPlayer entityPlayer) {
        IDistinctBusController distinct;
        IProgressBarMultiblock progressMulti;
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, 198, 208);
        MultiblockWithDisplayBase multiblockWithDisplayBase = this;
        if (multiblockWithDisplayBase instanceof IProgressBarMultiblock && (progressMulti = (IProgressBarMultiblock)((Object)multiblockWithDisplayBase)).showProgressBar()) {
            ProgressWidget progressBar;
            builder.image(4, 4, 190, 109, GuiTextures.DISPLAY);
            if (progressMulti.getNumProgressBars() == 3) {
                progressBar = new ProgressWidget(() -> progressMulti.getFillPercentage(0), 4, 115, 62, 7, progressMulti.getProgressBarTexture(0), ProgressWidget.MoveType.HORIZONTAL).setHoverTextConsumer(list -> progressMulti.addBarHoverText((List<ITextComponent>)list, 0));
                builder.widget(progressBar);
                progressBar = new ProgressWidget(() -> progressMulti.getFillPercentage(1), 68, 115, 62, 7, progressMulti.getProgressBarTexture(1), ProgressWidget.MoveType.HORIZONTAL).setHoverTextConsumer(list -> progressMulti.addBarHoverText((List<ITextComponent>)list, 1));
                builder.widget(progressBar);
                progressBar = new ProgressWidget(() -> progressMulti.getFillPercentage(2), 132, 115, 62, 7, progressMulti.getProgressBarTexture(2), ProgressWidget.MoveType.HORIZONTAL).setHoverTextConsumer(list -> progressMulti.addBarHoverText((List<ITextComponent>)list, 2));
                builder.widget(progressBar);
            } else if (progressMulti.getNumProgressBars() == 2) {
                progressBar = new ProgressWidget(() -> progressMulti.getFillPercentage(0), 4, 115, 94, 7, progressMulti.getProgressBarTexture(0), ProgressWidget.MoveType.HORIZONTAL).setHoverTextConsumer(list -> progressMulti.addBarHoverText((List<ITextComponent>)list, 0));
                builder.widget(progressBar);
                progressBar = new ProgressWidget(() -> progressMulti.getFillPercentage(1), 100, 115, 94, 7, progressMulti.getProgressBarTexture(1), ProgressWidget.MoveType.HORIZONTAL).setHoverTextConsumer(list -> progressMulti.addBarHoverText((List<ITextComponent>)list, 1));
                builder.widget(progressBar);
            } else {
                progressBar = new ProgressWidget(() -> progressMulti.getFillPercentage(0), 4, 115, 190, 7, progressMulti.getProgressBarTexture(0), ProgressWidget.MoveType.HORIZONTAL).setHoverTextConsumer(list -> progressMulti.addBarHoverText((List<ITextComponent>)list, 0));
                builder.widget(progressBar);
            }
            builder.widget(new IndicatorImageWidget(174, 93, 17, 17, this.getLogo()).setWarningStatus(this.getWarningLogo(), this::addWarningText).setErrorStatus(this.getErrorLogo(), this::addErrorText));
        } else {
            builder.image(4, 4, 190, 117, GuiTextures.DISPLAY);
            builder.widget(new IndicatorImageWidget(174, 101, 17, 17, this.getLogo()).setWarningStatus(this.getWarningLogo(), this::addWarningText).setErrorStatus(this.getErrorLogo(), this::addErrorText));
        }
        builder.label(9, 9, this.getMetaFullName(), 0xFFFFFF);
        builder.widget(new AdvancedTextWidget(9, 20, this::addDisplayText, 0xFFFFFF).setMaxWidthLimit(181).setClickHandler(this::handleDisplayClick));
        IControllable controllable = this.getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, null);
        if (controllable != null) {
            builder.widget(new ImageCycleButtonWidget(173, 183, 18, 18, GuiTextures.BUTTON_POWER, controllable::isWorkingEnabled, controllable::setWorkingEnabled));
            builder.widget(new ImageWidget(173, 201, 18, 6, GuiTextures.BUTTON_POWER_DETAIL));
        }
        if (this.shouldShowVoidingModeButton()) {
            builder.widget(new ImageCycleButtonWidget(173, 161, 18, 18, GuiTextures.BUTTON_VOID_MULTIBLOCK, 4, this::getVoidingMode, this::setVoidingMode).setTooltipHoverString(MultiblockWithDisplayBase::getVoidingModeTooltip));
        } else {
            builder.widget(new ImageWidget(173, 161, 18, 18, GuiTextures.BUTTON_VOID_NONE).setTooltip("gregtech.gui.multiblock_voiding_not_supported"));
        }
        MultiblockWithDisplayBase multiblockWithDisplayBase2 = this;
        if (multiblockWithDisplayBase2 instanceof IDistinctBusController && (distinct = (IDistinctBusController)((Object)multiblockWithDisplayBase2)).canBeDistinct()) {
            builder.widget(new ImageCycleButtonWidget(173, 143, 18, 18, GuiTextures.BUTTON_DISTINCT_BUSES, distinct::isDistinct, distinct::setDistinct).setTooltipHoverString(i -> "gregtech.multiblock.universal.distinct_" + (i == 0 ? "disabled" : "enabled")));
        } else {
            builder.widget(new ImageWidget(173, 143, 18, 18, GuiTextures.BUTTON_NO_DISTINCT_BUSES).setTooltip("gregtech.multiblock.universal.distinct_not_supported"));
        }
        builder.widget(this.getFlexButton(173, 125, 18, 18));
        builder.bindPlayerInventory(entityPlayer.field_71071_by, 125);
        return builder;
    }

    @NotNull
    protected Widget getFlexButton(int x, int y, int width, int height) {
        return new ImageWidget(x, y, width, height, GuiTextures.BUTTON_NO_FLEX).setTooltip("gregtech.multiblock.universal.no_flex_button");
    }

    @NotNull
    protected TextureArea getLogo() {
        return GuiTextures.GREGTECH_LOGO_DARK;
    }

    @NotNull
    protected TextureArea getWarningLogo() {
        return GuiTextures.GREGTECH_LOGO_BLINKING_YELLOW;
    }

    @NotNull
    protected TextureArea getErrorLogo() {
        return GuiTextures.GREGTECH_LOGO_BLINKING_RED;
    }

    protected void addWarningText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, this.isStructureFormed(), false).addMaintenanceProblemLines(this.getMaintenanceProblems());
    }

    protected void addErrorText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, this.isStructureFormed()).addMufflerObstructedLine(this.hasMufflerMechanics() && !this.isMufflerFaceFree());
    }

    protected boolean shouldShowVoidingModeButton() {
        return true;
    }

    protected int getVoidingMode() {
        return this.voidingMode.ordinal();
    }

    protected void setVoidingMode(int mode) {
        this.voidingMode = IVoidable.VoidingMode.VALUES[mode];
        this.voidingFluids = mode >= 2;
        this.voidingItems = mode == 1 || mode == 3;
        for (IFluidTank tank : this.getAbilities(MultiblockAbility.IMPORT_FLUIDS)) {
            this.getNotifiedFluidInputList().add((IFluidHandler)tank);
        }
        this.getNotifiedItemInputList().addAll(this.getAbilities(MultiblockAbility.IMPORT_ITEMS));
        this.markDirty();
    }

    protected static String getVoidingModeTooltip(int mode) {
        return IVoidable.VoidingMode.VALUES[mode].func_176610_l();
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return this.createUITemplate(entityPlayer).build(this.getHolder(), entityPlayer);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74774_a("Maintenance", this.maintenance_problems);
        data.func_74757_a("InitialMaintenance", this.initialMaintenanceDone);
        data.func_74768_a("ActiveTimer", this.timeActive);
        data.func_74757_a(NBT_VOIDING_ITEMS, this.voidingItems);
        data.func_74757_a(NBT_VOIDING_FLUIDS, this.voidingFluids);
        data.func_74768_a(NBT_VOIDING_MODE, this.voidingMode.ordinal());
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.maintenance_problems = data.func_74771_c("Maintenance");
        this.initialMaintenanceDone = data.func_74767_n("InitialMaintenance");
        this.timeActive = data.func_74762_e("ActiveTimer");
        if (data.func_74764_b(NBT_VOIDING_ITEMS)) {
            this.voidingItems = data.func_74767_n(NBT_VOIDING_ITEMS);
        }
        if (data.func_74764_b(NBT_VOIDING_FLUIDS)) {
            this.voidingFluids = data.func_74767_n(NBT_VOIDING_FLUIDS);
        }
        if (data.func_74764_b(NBT_VOIDING_MODE)) {
            this.voidingMode = IVoidable.VoidingMode.values()[data.func_74762_e(NBT_VOIDING_MODE)];
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeByte((int)this.maintenance_problems);
        buf.writeInt(this.timeActive);
        buf.writeBoolean(this.voidingFluids);
        buf.writeBoolean(this.voidingItems);
        buf.writeInt(this.voidingMode.ordinal());
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.maintenance_problems = buf.readByte();
        this.timeActive = buf.readInt();
        this.voidingFluids = buf.readBoolean();
        this.voidingItems = buf.readBoolean();
        this.voidingMode = IVoidable.VoidingMode.values()[buf.readInt()];
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.STORE_TAPED) {
            this.storedTaped = buf.readBoolean();
        }
        if (dataId == GregtechDataCodes.VARIANT_RENDER_UPDATE) {
            int minZ = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int minX = Integer.MAX_VALUE;
            int maxZ = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            int maxX = Integer.MIN_VALUE;
            int id = buf.readInt();
            boolean isActive = buf.readBoolean();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                BlockPos blockPos = buf.func_179259_c();
                VariantActiveBlock.setBlockActive(id, blockPos, isActive);
                minX = Math.min(minX, blockPos.func_177958_n());
                minY = Math.min(minY, blockPos.func_177956_o());
                minZ = Math.min(minZ, blockPos.func_177952_p());
                maxX = Math.max(maxX, blockPos.func_177958_n());
                maxY = Math.max(maxY, blockPos.func_177956_o());
                maxZ = Math.max(maxZ, blockPos.func_177952_p());
            }
            if (this.getWorld().field_73011_w.getDimension() == id) {
                this.getWorld().func_175704_b(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ));
            }
        }
        if (dataId == GregtechDataCodes.IS_WORKING) {
            this.lastActive = buf.readBoolean();
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        T capabilityResult = super.getCapability(capability, side);
        if (capabilityResult != null) {
            return capabilityResult;
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_MAINTENANCE && this.hasMaintenanceMechanics() && ConfigHolder.machines.enableMaintenance) {
            return (T)GregtechTileCapabilities.CAPABILITY_MAINTENANCE.cast((Object)this);
        }
        return null;
    }

    @Override
    public boolean canVoidRecipeFluidOutputs() {
        return this.voidingFluids || this.fluidInfSink;
    }

    @Override
    public boolean canVoidRecipeItemOutputs() {
        return this.voidingItems || this.itemInfSink;
    }

    public void enableFluidInfSink() {
        this.fluidInfSink = true;
    }

    public void enableItemInfSink() {
        this.itemInfSink = true;
    }
}

