/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.multiblock;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IMultipleRecipeMaps;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.ImageCycleButtonWidget;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.LocalizationUtils;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiMapMultiblockController
extends RecipeMapMultiblockController
implements IMultipleRecipeMaps {
    private final RecipeMap<?>[] recipeMaps;
    private int recipeMapIndex = 0;

    public MultiMapMultiblockController(ResourceLocation metaTileEntityId, RecipeMap<?>[] recipeMaps) {
        super(metaTileEntityId, recipeMaps[0]);
        this.recipeMaps = recipeMaps;
    }

    @Override
    public boolean onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (this.recipeMaps.length == 1) {
            return true;
        }
        if (!this.getWorld().field_72995_K) {
            if (!this.recipeMapWorkable.isActive()) {
                RecipeMap<?>[] recipeMaps = this.getAvailableRecipeMaps();
                int index = playerIn.func_70093_af() ? (this.recipeMapIndex - 1 < 0 ? recipeMaps.length - 1 : this.recipeMapIndex - 1) % recipeMaps.length : (this.recipeMapIndex + 1) % recipeMaps.length;
                this.setRecipeMapIndex(index);
                this.recipeMapWorkable.forceRecipeRecheck();
            } else {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.multiblock.multiple_recipemaps.switch_message", new Object[0]), true);
            }
        }
        return true;
    }

    @Override
    public RecipeMap<?>[] getAvailableRecipeMaps() {
        return this.recipeMaps;
    }

    @Override
    public void setRecipeMapIndex(int index) {
        this.recipeMapIndex = index;
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(GregtechDataCodes.RECIPE_MAP_INDEX, buf -> buf.writeByte(index));
            this.markDirty();
        }
    }

    @Override
    public int getRecipeMapIndex() {
        return this.recipeMapIndex;
    }

    @Override
    public RecipeMap<?> getCurrentRecipeMap() {
        return this.getAvailableRecipeMaps()[this.recipeMapIndex];
    }

    @Override
    public TraceabilityPredicate autoAbilities(boolean checkEnergyIn, boolean checkMaintenance, boolean checkItemIn, boolean checkItemOut, boolean checkFluidIn, boolean checkFluidOut, boolean checkMuffler) {
        boolean checkedItemIn = false;
        boolean checkedItemOut = false;
        boolean checkedFluidIn = false;
        boolean checkedFluidOut = false;
        TraceabilityPredicate predicate = super.autoAbilities(checkMaintenance, checkMuffler).or(checkEnergyIn ? MultiMapMultiblockController.abilities(MultiblockAbility.INPUT_ENERGY).setMinGlobalLimited(1).setMaxGlobalLimited(3).setPreviewCount(1) : new TraceabilityPredicate());
        for (RecipeMap<?> recipeMap : this.getAvailableRecipeMaps()) {
            if (!checkedItemIn && checkItemIn && recipeMap.getMaxInputs() > 0) {
                checkedItemIn = true;
                predicate = predicate.or(MultiMapMultiblockController.abilities(MultiblockAbility.IMPORT_ITEMS).setPreviewCount(1));
            }
            if (!checkedItemOut && checkItemOut && recipeMap.getMaxOutputs() > 0) {
                checkedItemOut = true;
                predicate = predicate.or(MultiMapMultiblockController.abilities(MultiblockAbility.EXPORT_ITEMS).setPreviewCount(1));
            }
            if (!checkedFluidIn && checkFluidIn && recipeMap.getMaxFluidInputs() > 0) {
                checkedFluidIn = true;
                predicate = predicate.or(MultiMapMultiblockController.abilities(MultiblockAbility.IMPORT_FLUIDS).setPreviewCount(1));
            }
            if (checkedFluidOut || !checkFluidOut || recipeMap.getMaxFluidOutputs() <= 0) continue;
            checkedFluidOut = true;
            predicate = predicate.or(MultiMapMultiblockController.abilities(MultiblockAbility.EXPORT_FLUIDS).setPreviewCount(1));
        }
        return predicate;
    }

    @Override
    @NotNull
    protected Widget getFlexButton(int x, int y, int width, int height) {
        if (this.getAvailableRecipeMaps() != null && this.getAvailableRecipeMaps().length > 1) {
            return new ImageCycleButtonWidget(x, y, width, height, GuiTextures.BUTTON_MULTI_MAP, this.getAvailableRecipeMaps().length, this::getRecipeMapIndex, this::setRecipeMapIndex).shouldUseBaseBackground().singleTexture().setTooltipHoverString(i -> LocalizationUtils.format("gregtech.multiblock.multiple_recipemaps.header", new Object[0]) + " " + LocalizationUtils.format("recipemap." + this.getAvailableRecipeMaps()[i].getUnlocalizedName() + ".name", new Object[0]));
        }
        return super.getFlexButton(x, y, width, height);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        if (this.recipeMaps.length == 1) {
            return;
        }
        tooltip.add(I18n.func_135052_a((String)"gregtech.multiblock.multiple_recipemaps_recipes.tooltip", (Object[])new Object[]{this.recipeMapsToString()}));
    }

    @SideOnly(value=Side.CLIENT)
    public String recipeMapsToString() {
        StringBuilder recipeMapsString = new StringBuilder();
        RecipeMap<?>[] recipeMaps = this.getAvailableRecipeMaps();
        for (int i = 0; i < recipeMaps.length; ++i) {
            recipeMapsString.append(recipeMaps[i].getLocalizedName());
            if (recipeMaps.length - 1 == i) continue;
            recipeMapsString.append(", ");
        }
        return recipeMapsString.toString();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("RecipeMapIndex", this.recipeMapIndex);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.recipeMapIndex = data.func_74762_e("RecipeMapIndex");
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeByte(this.recipeMapIndex);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.recipeMapIndex = buf.readByte();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.RECIPE_MAP_INDEX) {
            this.recipeMapIndex = buf.readByte();
            this.scheduleRenderUpdate();
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        T capabilityResult = super.getCapability(capability, side);
        if (capabilityResult == null && capability == GregtechTileCapabilities.CAPABILITY_MULTIPLE_RECIPEMAPS) {
            return (T)GregtechTileCapabilities.CAPABILITY_MULTIPLE_RECIPEMAPS.cast((Object)this);
        }
        return capabilityResult;
    }
}

