/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.metaitem;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import gregtech.api.items.metaitem.StandardMetaItem;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.info.MaterialIconSet;
import gregtech.api.unification.material.info.MaterialIconType;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.GTUtility;
import gregtech.api.util.SmallDigits;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MetaOreDictItem
extends StandardMetaItem {
    public final Map<String, String> OREDICT_TO_FORMULA = new HashMap<String, String>();
    private final Map<Short, OreDictValueItem> ITEMS = new HashMap<Short, OreDictValueItem>();
    private static final List<MaterialIconType> DISALLOWED_TYPES = ImmutableList.of((Object)MaterialIconType.block, (Object)MaterialIconType.ore, (Object)MaterialIconType.oreSmall, (Object)MaterialIconType.frameGt);
    private static final ModelResourceLocation MISSING_LOCATION = new ModelResourceLocation("builtin/missing", "inventory");

    public MetaOreDictItem(short metaItemOffset) {
        super(metaItemOffset);
    }

    @Override
    public void registerSubItems() {
        for (OreDictValueItem item : this.ITEMS.values()) {
            this.addItem(item.id, item.getName());
            OreDictUnifier.registerOre(new ItemStack((Item)this, 1, (int)item.id), item.getOre());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected int getColorForItemStack(ItemStack stack, int tintIndex) {
        if (tintIndex == 0) {
            OreDictValueItem item = this.ITEMS.get((short)stack.func_77952_i());
            return item == null ? 0xFFFFFF : item.materialRGB;
        }
        return super.getColorForItemStack(stack, tintIndex);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        Int2ObjectOpenHashMap alreadyRegistered = new Int2ObjectOpenHashMap();
        for (Map.Entry<Short, OreDictValueItem> metaItem : this.ITEMS.entrySet()) {
            ModelResourceLocation resourceLocation;
            OrePrefix prefix = metaItem.getValue().orePrefix;
            MaterialIconSet materialIconSet = metaItem.getValue().materialIconSet;
            if (prefix.materialIconType == null || DISALLOWED_TYPES.contains(prefix.materialIconType)) continue;
            int registrationKey = prefix.id * 1000 + materialIconSet.id;
            if (!alreadyRegistered.containsKey(registrationKey)) {
                prefix.materialIconType.getItemModelPath(materialIconSet);
                resourceLocation = prefix.materialIconType.getItemModelPath(materialIconSet);
                ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{resourceLocation});
                alreadyRegistered.put(registrationKey, (Object)new ModelResourceLocation((ResourceLocation)resourceLocation, "inventory"));
            }
            resourceLocation = (ModelResourceLocation)alreadyRegistered.get(registrationKey);
            this.metaItemsModels.put((Object)metaItem.getKey(), (Object)resourceLocation);
        }
    }

    public OreDictValueItem addOreDictItem(int id, String materialName, int rgb, MaterialIconSet materialIconSet, OrePrefix orePrefix) {
        return this.addOreDictItem(id, materialName, rgb, materialIconSet, orePrefix, null);
    }

    public OreDictValueItem addOreDictItem(int id, String materialName, int materialRGB, MaterialIconSet materialIconSet, OrePrefix orePrefix, String chemicalFormula) {
        return new OreDictValueItem((short)id, materialName, materialRGB, materialIconSet, orePrefix, chemicalFormula);
    }

    public class OreDictValueItem {
        private final String materialName;
        private final int materialRGB;
        private final MaterialIconSet materialIconSet;
        private final short id;
        private final OrePrefix orePrefix;
        protected String chemicalFormula;

        private OreDictValueItem(short id, String materialName, int materialRGB, MaterialIconSet materialIconSet, OrePrefix orePrefix, String chemicalFormula) {
            this.id = id;
            this.materialName = materialName;
            this.materialRGB = materialRGB;
            this.materialIconSet = materialIconSet;
            this.orePrefix = orePrefix;
            this.chemicalFormula = chemicalFormula;
            MetaOreDictItem.this.ITEMS.put(this.id, this);
            MetaOreDictItem.this.OREDICT_TO_FORMULA.put(this.getOre(), this.calculateChemicalFormula(chemicalFormula));
        }

        public String getOre() {
            return this.orePrefix.name() + CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.materialName);
        }

        public ItemStack getItemStack(int amount) {
            ItemStack stack = OreDictUnifier.get(this.getOre());
            stack.func_190920_e(amount);
            return stack;
        }

        public ItemStack getItemStack() {
            return this.getItemStack(1);
        }

        public String getName() {
            return this.materialName + '_' + GTUtility.toLowerCaseUnderscore(this.orePrefix.name());
        }

        protected String calculateChemicalFormula(String unformattedFormula) {
            StringBuilder sb = new StringBuilder();
            if (unformattedFormula != null && !unformattedFormula.isEmpty()) {
                for (char c : unformattedFormula.toCharArray()) {
                    if (Character.isDigit(c)) {
                        sb.append(SmallDigits.toSmallDownNumbers(Character.toString(c)));
                        continue;
                    }
                    sb.append(c);
                }
            }
            return sb.toString();
        }

        public String getFormula() {
            return this.chemicalFormula;
        }

        public int getMaterialRGB() {
            return this.materialRGB;
        }
    }
}

