/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.metaitem;

import com.enderio.core.common.interfaces.IOverlayRenderAware;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.capability.IFilter;
import gregtech.api.capability.IFilteredFluidContainer;
import gregtech.api.capability.IPropertyFluidFilter;
import gregtech.api.capability.impl.CombinedCapabilityProvider;
import gregtech.api.capability.impl.ElectricItem;
import gregtech.api.gui.ModularUI;
import gregtech.api.items.OreDictNames;
import gregtech.api.items.gui.ItemUIFactory;
import gregtech.api.items.gui.PlayerInventoryHolder;
import gregtech.api.items.metaitem.DefaultSubItemHandler;
import gregtech.api.items.metaitem.FoodUseManager;
import gregtech.api.items.metaitem.stats.IEnchantabilityHelper;
import gregtech.api.items.metaitem.stats.IFoodBehavior;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.items.metaitem.stats.IItemCapabilityProvider;
import gregtech.api.items.metaitem.stats.IItemColorProvider;
import gregtech.api.items.metaitem.stats.IItemComponent;
import gregtech.api.items.metaitem.stats.IItemContainerItemProvider;
import gregtech.api.items.metaitem.stats.IItemDurabilityManager;
import gregtech.api.items.metaitem.stats.IItemMaxStackSizeProvider;
import gregtech.api.items.metaitem.stats.IItemNameProvider;
import gregtech.api.items.metaitem.stats.IItemUseManager;
import gregtech.api.items.metaitem.stats.ISubItemHandler;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.ItemMaterialInfo;
import gregtech.api.util.GTUtility;
import gregtech.api.util.LocalizationUtils;
import gregtech.client.utils.ToolChargeBarRenderer;
import gregtech.common.ConfigHolder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.shorts.Short2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Optional.Interface(modid="endercore", iface="com.enderio.core.common.interfaces.IOverlayRenderAware")
public abstract class MetaItem<T extends MetaValueItem>
extends Item
implements ItemUIFactory,
IOverlayRenderAware {
    private static final List<MetaItem<?>> META_ITEMS = new ArrayList();
    private final Map<String, T> names = new Object2ObjectOpenHashMap();
    protected final Short2ObjectMap<T> metaItems = new Short2ObjectLinkedOpenHashMap();
    protected final Short2ObjectMap<ModelResourceLocation> metaItemsModels = new Short2ObjectOpenHashMap();
    protected final Short2ObjectMap<ModelResourceLocation[]> specialItemsModels = new Short2ObjectOpenHashMap();
    protected static final ModelResourceLocation MISSING_LOCATION = new ModelResourceLocation("builtin/missing", "inventory");
    protected final short metaItemOffset;
    private CreativeTabs[] defaultCreativeTabs = new CreativeTabs[]{GregTechAPI.TAB_GREGTECH};
    private final Set<CreativeTabs> additionalCreativeTabs = new ObjectArraySet();
    private String translationKey = "metaitem";

    public static List<MetaItem<?>> getMetaItems() {
        return Collections.unmodifiableList(META_ITEMS);
    }

    public MetaItem(short metaItemOffset) {
        this.func_77627_a(true);
        this.metaItemOffset = metaItemOffset;
        META_ITEMS.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerColor() {
        Minecraft.func_71410_x().getItemColors().func_186730_a(this::getColorForItemStack, new Item[]{this});
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ShortIterator shortIterator = this.metaItems.keySet().iterator();
        while (shortIterator.hasNext()) {
            short itemMetaKey = (Short)shortIterator.next();
            MetaValueItem metaValueItem = (MetaValueItem)this.metaItems.get(itemMetaKey);
            int numberOfModels = metaValueItem.getModelAmount();
            if (numberOfModels > 1) {
                ModelResourceLocation[] resourceLocations = new ModelResourceLocation[numberOfModels];
                for (int i = 0; i < resourceLocations.length; ++i) {
                    ResourceLocation resourceLocation = this.createItemModelPath(metaValueItem, "/" + (i + 1));
                    ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{resourceLocation});
                    resourceLocations[i] = new ModelResourceLocation(resourceLocation, "inventory");
                }
                this.specialItemsModels.put((short)(this.metaItemOffset + itemMetaKey), (Object)resourceLocations);
                continue;
            }
            ResourceLocation resourceLocation = this.createItemModelPath(metaValueItem, "");
            if (numberOfModels > 0) {
                ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{resourceLocation});
            }
            this.metaItemsModels.put((short)(this.metaItemOffset + itemMetaKey), (Object)new ModelResourceLocation(resourceLocation, "inventory"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerTextureMesh() {
        ModelLoader.setCustomMeshDefinition((Item)this, itemStack -> {
            short itemDamage = this.formatRawItemDamage((short)itemStack.func_77952_i());
            if (this.specialItemsModels.containsKey(itemDamage)) {
                int modelIndex = this.getModelIndex(itemStack);
                return ((ModelResourceLocation[])this.specialItemsModels.get(itemDamage))[modelIndex];
            }
            if (this.metaItemsModels.containsKey(itemDamage)) {
                return (ModelResourceLocation)this.metaItemsModels.get(itemDamage);
            }
            return MISSING_LOCATION;
        });
    }

    public ResourceLocation createItemModelPath(T metaValueItem, String postfix) {
        return GTUtility.gregtechId(this.formatModelPath(metaValueItem) + postfix);
    }

    protected String formatModelPath(T metaValueItem) {
        return "metaitems/" + ((MetaValueItem)metaValueItem).unlocalizedName;
    }

    protected int getModelIndex(ItemStack itemStack) {
        T metaValueItem = this.getItem(itemStack);
        IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (electricItem != null) {
            return (int)Math.min((double)electricItem.getCharge() / ((double)electricItem.getMaxCharge() * 1.0) * 7.0, 7.0);
        }
        if (metaValueItem != null) {
            return IntCircuitIngredient.getCircuitConfiguration(itemStack);
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    protected int getColorForItemStack(ItemStack stack, int tintIndex) {
        T metaValueItem = this.getItem(stack);
        if (metaValueItem != null && ((MetaValueItem)metaValueItem).getColorProvider() != null) {
            return ((MetaValueItem)metaValueItem).getColorProvider().getItemStackColor(stack, tintIndex);
        }
        return 0xFFFFFF;
    }

    public boolean showDurabilityBar(@NotNull ItemStack stack) {
        return false;
    }

    public double getDurabilityForDisplay(@NotNull ItemStack stack) {
        T metaValueItem = this.getItem(stack);
        if (metaValueItem != null && ((MetaValueItem)metaValueItem).getDurabilityManager() != null) {
            return ((MetaValueItem)metaValueItem).getDurabilityManager().getDurabilityForDisplay(stack);
        }
        return -1.0;
    }

    @NotNull
    public EnumRarity func_77613_e(@NotNull ItemStack stack) {
        T metaValueItem = this.getItem(stack);
        if (metaValueItem != null && ((MetaValueItem)metaValueItem).getRarity() != null) {
            return ((MetaValueItem)metaValueItem).getRarity();
        }
        return super.func_77613_e(stack);
    }

    protected abstract T constructMetaValueItem(short var1, String var2);

    public final T addItem(int metaValue, String unlocalizedName) {
        Validate.inclusiveBetween((long)0L, (long)32766L, (long)(metaValue + this.metaItemOffset), (String)"MetaItem ID should be in range from 0 to Short.MAX_VALUE-1");
        T metaValueItem = this.constructMetaValueItem((short)metaValue, unlocalizedName);
        if (this.metaItems.containsKey((short)metaValue)) {
            MetaValueItem registeredItem = (MetaValueItem)this.metaItems.get((short)metaValue);
            throw new IllegalArgumentException(String.format("MetaId %d is already occupied by item %s (requested by item %s)", metaValue, registeredItem.unlocalizedName, unlocalizedName));
        }
        this.metaItems.put((short)metaValue, metaValueItem);
        this.names.put(unlocalizedName, metaValueItem);
        return metaValueItem;
    }

    public final Collection<T> getAllItems() {
        return Collections.unmodifiableCollection(this.metaItems.values());
    }

    @Nullable
    public final T getItem(short metaValue) {
        return (T)((MetaValueItem)this.metaItems.get(this.formatRawItemDamage(metaValue)));
    }

    @Nullable
    public final T getItem(String valueName) {
        return (T)((MetaValueItem)this.names.get(valueName));
    }

    @Nullable
    public final T getItem(ItemStack itemStack) {
        return this.getItem((short)(itemStack.func_77952_i() - this.metaItemOffset));
    }

    protected short formatRawItemDamage(short metaValue) {
        return metaValue;
    }

    public void registerSubItems() {
    }

    public ICapabilityProvider initCapabilities(@NotNull ItemStack stack, @Nullable NBTTagCompound nbt) {
        T metaValueItem = this.getItem(stack);
        if (metaValueItem == null) {
            return null;
        }
        ArrayList<ICapabilityProvider> providers = new ArrayList<ICapabilityProvider>();
        for (IItemComponent itemComponent : ((MetaValueItem)metaValueItem).getAllStats()) {
            if (!(itemComponent instanceof IItemCapabilityProvider)) continue;
            IItemCapabilityProvider provider = (IItemCapabilityProvider)itemComponent;
            providers.add(provider.createProvider(stack));
        }
        return new CombinedCapabilityProvider(providers);
    }

    public int getItemBurnTime(@NotNull ItemStack itemStack) {
        T metaValueItem = this.getItem(itemStack);
        if (metaValueItem == null) {
            return super.getItemBurnTime(itemStack);
        }
        return ((MetaValueItem)metaValueItem).getBurnValue();
    }

    private IItemUseManager getUseManager(ItemStack itemStack) {
        T metaValueItem = this.getItem(itemStack);
        if (metaValueItem == null) {
            return null;
        }
        return ((MetaValueItem)metaValueItem).getUseManager();
    }

    public List<IItemBehaviour> getBehaviours(ItemStack itemStack) {
        T metaValueItem = this.getItem(itemStack);
        if (metaValueItem == null) {
            return ImmutableList.of();
        }
        return ((MetaValueItem)metaValueItem).getBehaviours();
    }

    public int getItemStackLimit(@NotNull ItemStack stack) {
        T metaValueItem = this.getItem(stack);
        if (metaValueItem == null) {
            return 64;
        }
        return ((MetaValueItem)metaValueItem).getMaxStackSize(stack);
    }

    @NotNull
    public EnumAction func_77661_b(@NotNull ItemStack stack) {
        IItemUseManager useManager = this.getUseManager(stack);
        if (useManager != null) {
            return useManager.getUseAction(stack);
        }
        return EnumAction.NONE;
    }

    public int func_77626_a(@NotNull ItemStack stack) {
        IItemUseManager useManager = this.getUseManager(stack);
        if (useManager != null) {
            return useManager.getMaxItemUseDuration(stack);
        }
        return 0;
    }

    public void onUsingTick(@NotNull ItemStack stack, @NotNull EntityLivingBase player, int count) {
        IItemUseManager useManager;
        if (player instanceof EntityPlayer && (useManager = this.getUseManager(stack)) != null) {
            useManager.onItemUsingTick(stack, (EntityPlayer)player, count);
        }
    }

    public void func_77615_a(@NotNull ItemStack stack, @NotNull World world, @NotNull EntityLivingBase player, int timeLeft) {
        IItemUseManager useManager;
        if (player instanceof EntityPlayer && (useManager = this.getUseManager(stack)) != null) {
            useManager.onPlayerStoppedItemUsing(stack, (EntityPlayer)player, timeLeft);
        }
    }

    @NotNull
    public ItemStack func_77654_b(@NotNull ItemStack stack, @NotNull World world, @NotNull EntityLivingBase player) {
        IItemUseManager useManager;
        if (player instanceof EntityPlayer && (useManager = this.getUseManager(stack)) != null) {
            return useManager.onItemUseFinish(stack, (EntityPlayer)player);
        }
        return stack;
    }

    public boolean onLeftClickEntity(@NotNull ItemStack stack, @NotNull EntityPlayer player, @NotNull Entity entity) {
        boolean returnValue = false;
        for (IItemBehaviour behaviour : this.getBehaviours(stack)) {
            if (!behaviour.onLeftClickEntity(stack, player, entity)) continue;
            returnValue = true;
        }
        return returnValue;
    }

    public boolean func_111207_a(@NotNull ItemStack stack, @NotNull EntityPlayer playerIn, @NotNull EntityLivingBase target, @NotNull EnumHand hand) {
        boolean returnValue = false;
        for (IItemBehaviour behaviour : this.getBehaviours(stack)) {
            if (!behaviour.itemInteractionForEntity(stack, playerIn, target, hand)) continue;
            returnValue = true;
        }
        return returnValue;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, EntityPlayer player, @NotNull EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        for (IItemBehaviour behaviour : this.getBehaviours(itemStack)) {
            ActionResult<ItemStack> behaviourResult = behaviour.onItemRightClick(world, player, hand);
            itemStack = (ItemStack)behaviourResult.func_188398_b();
            if (behaviourResult.func_188397_a() != EnumActionResult.PASS) {
                return ActionResult.newResult((EnumActionResult)behaviourResult.func_188397_a(), (Object)itemStack);
            }
            if (!itemStack.func_190926_b()) continue;
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)ItemStack.field_190927_a);
        }
        IItemUseManager useManager = this.getUseManager(itemStack);
        if (useManager != null && useManager.canStartUsing(itemStack, player)) {
            useManager.onItemUseStart(itemStack, player);
            player.func_184598_c(hand);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStack);
    }

    @NotNull
    public EnumActionResult onItemUseFirst(EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull EnumFacing side, float hitX, float hitY, float hitZ, @NotNull EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        for (IItemBehaviour behaviour : this.getBehaviours(itemStack)) {
            EnumActionResult behaviourResult = behaviour.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
            if (behaviourResult != EnumActionResult.PASS) {
                return behaviourResult;
            }
            if (!itemStack.func_190926_b()) continue;
            return EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    @NotNull
    public EnumActionResult func_180614_a(EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack originalStack = stack.func_77946_l();
        for (IItemBehaviour behaviour : this.getBehaviours(stack)) {
            ActionResult<ItemStack> behaviourResult = behaviour.onItemUse(player, world, pos, hand, facing, hitX, hitY, hitZ);
            stack = (ItemStack)behaviourResult.func_188398_b();
            if (behaviourResult.func_188397_a() != EnumActionResult.PASS) {
                if (!ItemStack.func_77989_b((ItemStack)originalStack, (ItemStack)stack)) {
                    player.func_184611_a(hand, stack);
                }
                return behaviourResult.func_188397_a();
            }
            if (!stack.func_190926_b()) continue;
            player.func_184611_a(hand, ItemStack.field_190927_a);
            return EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    @NotNull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@NotNull EntityEquipmentSlot slot, @NotNull ItemStack stack) {
        HashMultimap modifiers = HashMultimap.create();
        T metaValueItem = this.getItem(stack);
        if (metaValueItem != null) {
            for (IItemBehaviour behaviour : this.getBehaviours(stack)) {
                modifiers.putAll(behaviour.getAttributeModifiers(slot, stack));
            }
        }
        return modifiers;
    }

    public boolean func_77616_k(@NotNull ItemStack stack) {
        T metaValueItem = this.getItem(stack);
        if (metaValueItem != null) {
            IEnchantabilityHelper helper = ((MetaValueItem)metaValueItem).getEnchantabilityHelper();
            return helper != null && helper.isEnchantable(stack);
        }
        return super.func_77616_k(stack);
    }

    public int getItemEnchantability(@NotNull ItemStack stack) {
        T metaValueItem = this.getItem(stack);
        if (metaValueItem != null) {
            IEnchantabilityHelper helper = ((MetaValueItem)metaValueItem).getEnchantabilityHelper();
            return helper == null ? 0 : helper.getItemEnchantability(stack);
        }
        return super.getItemEnchantability(stack);
    }

    public boolean canApplyAtEnchantingTable(@NotNull ItemStack stack, @NotNull Enchantment enchantment) {
        T metaValueItem = this.getItem(stack);
        if (metaValueItem != null) {
            IEnchantabilityHelper helper = ((MetaValueItem)metaValueItem).getEnchantabilityHelper();
            return helper != null && helper.canApplyAtEnchantingTable(stack, enchantment);
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public void func_77663_a(@NotNull ItemStack stack, @NotNull World worldIn, @NotNull Entity entityIn, int itemSlot, boolean isSelected) {
        for (IItemBehaviour behaviour : this.getBehaviours(stack)) {
            behaviour.onUpdate(stack, entityIn);
        }
    }

    public boolean shouldCauseReequipAnimation(@NotNull ItemStack oldStack, @NotNull ItemStack newStack, boolean slotChanged) {
        if (ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack) && oldStack.hasCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null) && oldStack.func_77942_o() && newStack.func_77942_o()) {
            oldStack = oldStack.func_77946_l();
            newStack = newStack.func_77946_l();
            NBTTagCompound oldTag = oldStack.func_77978_p();
            NBTTagCompound newTag = newStack.func_77978_p();
            if (oldTag != null && newTag != null) {
                oldTag.func_82580_o("Charge");
                newTag.func_82580_o("Charge");
                if (oldTag.func_74764_b("terminal")) {
                    oldTag.func_74775_l("terminal").func_74775_l("_hw").func_82580_o("battery");
                    newTag.func_74775_l("terminal").func_74775_l("_hw").func_82580_o("battery");
                }
            }
        }
        return !ItemStack.func_77989_b((ItemStack)oldStack, (ItemStack)newStack);
    }

    @NotNull
    public MetaItem<T> setTranslationKey(@NotNull String key) {
        this.translationKey = Objects.requireNonNull(key, "key == null");
        return this;
    }

    @NotNull
    public String func_77658_a() {
        return this.getTranslationKey(null);
    }

    @NotNull
    public String func_77667_c(@NotNull ItemStack stack) {
        return this.getTranslationKey(this.getItem(stack));
    }

    @NotNull
    protected String getTranslationKey(@Nullable T metaValueItem) {
        return metaValueItem == null ? this.translationKey : this.translationKey + "." + ((MetaValueItem)metaValueItem).unlocalizedName;
    }

    @NotNull
    public String func_77653_i(ItemStack stack) {
        if (stack.func_77952_i() >= this.metaItemOffset) {
            T item = this.getItem(stack);
            if (item == null) {
                return "invalid item";
            }
            String unlocalizedName = this.getTranslationKey(item) + ".name";
            if (((MetaValueItem)item).getNameProvider() != null) {
                return ((MetaValueItem)item).getNameProvider().getItemStackDisplayName(stack, unlocalizedName);
            }
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (fluidHandlerItem != null) {
                FluidStack fluidInside = fluidHandlerItem.drain(Integer.MAX_VALUE, false);
                return LocalizationUtils.format(unlocalizedName, fluidInside == null ? LocalizationUtils.format("metaitem.fluid_cell.empty", new Object[0]) : fluidInside.getLocalizedName());
            }
            return LocalizationUtils.format(unlocalizedName, new Object[0]);
        }
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@NotNull ItemStack itemStack, @Nullable World worldIn, @NotNull List<String> lines, @NotNull ITooltipFlag tooltipFlag) {
        IFluidHandlerItem fluidHandler;
        IElectricItem electricItem;
        T item = this.getItem(itemStack);
        if (item == null) {
            return;
        }
        String unlocalizedTooltip = this.getTranslationKey(item) + ".tooltip";
        if (I18n.func_188566_a((String)unlocalizedTooltip)) {
            Collections.addAll(lines, LocalizationUtils.formatLines(unlocalizedTooltip, new Object[0]));
        }
        if ((electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null)) != null) {
            if (electricItem.canProvideChargeExternally()) {
                MetaItem.addDischargeItemTooltip(lines, electricItem.getMaxCharge(), electricItem.getCharge(), electricItem.getTier());
            } else {
                lines.add(I18n.func_135052_a((String)"metaitem.generic.electric_item.tooltip", (Object[])new Object[]{electricItem.getCharge(), electricItem.getMaxCharge(), GTValues.VNF[electricItem.getTier()]}));
            }
        }
        if ((fluidHandler = (IFluidHandlerItem)ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)1).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null) {
            IFilteredFluidContainer filtered;
            IFilter<FluidStack> iFilter;
            IFluidTankProperties fluidTankProperties = fluidHandler.getTankProperties()[0];
            FluidStack fluid = fluidTankProperties.getContents();
            lines.add(I18n.func_135052_a((String)"metaitem.generic.fluid_container.tooltip", (Object[])new Object[]{fluid == null ? 0 : fluid.amount, fluidTankProperties.getCapacity(), fluid == null ? "" : fluid.getLocalizedName()}));
            if (fluidHandler instanceof IFilteredFluidContainer && (iFilter = (filtered = (IFilteredFluidContainer)fluidHandler).getFilter()) instanceof IPropertyFluidFilter) {
                IPropertyFluidFilter propertyFilter = (IPropertyFluidFilter)iFilter;
                propertyFilter.appendTooltips(lines, false, true);
            }
        }
        for (IItemBehaviour behaviour : this.getBehaviours(itemStack)) {
            behaviour.addInformation(itemStack, lines);
        }
        if (ConfigHolder.misc.debug) {
            lines.add("MetaItem Id: " + ((MetaValueItem)item).unlocalizedName);
        }
    }

    private static void addDischargeItemTooltip(List<String> tooltip, long maxCharge, long currentCharge, int tier) {
        String unit;
        long timeRemaining;
        if (currentCharge == 0L) {
            tooltip.add(I18n.func_135052_a((String)"metaitem.generic.electric_item.tooltip", (Object[])new Object[]{currentCharge, maxCharge, GTValues.VNF[tier]}));
            return;
        }
        Instant start = Instant.now();
        Instant end = Instant.now().plusSeconds((long)((double)currentCharge * 1.0 / (double)GTValues.V[tier] / 20.0));
        Duration duration = Duration.between(start, end);
        double percentRemaining = (double)currentCharge * 1.0 / (double)maxCharge * 100.0;
        if (duration.getSeconds() <= 180L) {
            timeRemaining = duration.getSeconds();
            unit = I18n.func_135052_a((String)"metaitem.battery.charge_unit.second", (Object[])new Object[0]);
        } else if (duration.toMinutes() <= 180L) {
            timeRemaining = duration.toMinutes();
            unit = I18n.func_135052_a((String)"metaitem.battery.charge_unit.minute", (Object[])new Object[0]);
        } else {
            timeRemaining = duration.toHours();
            unit = I18n.func_135052_a((String)"metaitem.battery.charge_unit.hour", (Object[])new Object[0]);
        }
        tooltip.add(I18n.func_135052_a((String)"metaitem.battery.charge_detailed", (Object[])new Object[]{currentCharge, maxCharge, GTValues.VNF[tier], Character.valueOf((char)(percentRemaining < 30.0 ? 99 : (percentRemaining < 60.0 ? 101 : 97))), timeRemaining, unit}));
    }

    public boolean hasContainerItem(@NotNull ItemStack itemStack) {
        T item = this.getItem(itemStack);
        if (item == null) {
            return false;
        }
        return ((MetaValueItem)item).getContainerItemProvider() != null;
    }

    @NotNull
    public ItemStack getContainerItem(@NotNull ItemStack itemStack) {
        T item = this.getItem(itemStack);
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        itemStack = itemStack.func_77946_l();
        itemStack.func_190920_e(1);
        IItemContainerItemProvider provider = ((MetaValueItem)item).getContainerItemProvider();
        return provider == null ? ItemStack.field_190927_a : provider.getContainerItem(itemStack);
    }

    @NotNull
    public @NotNull CreativeTabs @NotNull [] getCreativeTabs() {
        if (this.additionalCreativeTabs.isEmpty()) {
            return this.defaultCreativeTabs;
        }
        ObjectArraySet tabs = new ObjectArraySet(this.additionalCreativeTabs);
        tabs.addAll(Arrays.asList(this.defaultCreativeTabs));
        return tabs.toArray(new CreativeTabs[0]);
    }

    @NotNull
    public MetaItem<T> setCreativeTab(@NotNull CreativeTabs tab) {
        this.defaultCreativeTabs = new CreativeTabs[]{tab};
        return this;
    }

    @NotNull
    public MetaItem<T> setCreativeTabs(CreativeTabs ... tabs) {
        this.defaultCreativeTabs = tabs;
        return this;
    }

    public void addAdditionalCreativeTabs(CreativeTabs ... tabs) {
        for (CreativeTabs tab : tabs) {
            if (ArrayUtils.contains((Object[])this.defaultCreativeTabs, (Object)tab) || tab == CreativeTabs.field_78027_g) continue;
            this.additionalCreativeTabs.add(tab);
        }
    }

    protected boolean func_194125_a(@NotNull CreativeTabs tab) {
        return tab == CreativeTabs.field_78027_g || ArrayUtils.contains((Object[])this.defaultCreativeTabs, (Object)tab) || this.additionalCreativeTabs.contains(tab);
    }

    public void func_150895_a(@NotNull CreativeTabs tab, @NotNull NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (MetaValueItem item : this.metaItems.values()) {
            if (!item.isInCreativeTab(tab)) continue;
            item.getSubItemHandler().getSubItems(item.getStackForm(), tab, subItems);
        }
    }

    @Override
    public ModularUI createUI(PlayerInventoryHolder holder, EntityPlayer entityPlayer) {
        ItemStack itemStack = holder.getCurrentItem();
        T metaValueItem = this.getItem(itemStack);
        ItemUIFactory uiFactory = metaValueItem == null ? null : ((MetaValueItem)metaValueItem).getUIManager();
        return uiFactory == null ? null : uiFactory.createUI(holder, entityPlayer);
    }

    public void renderItemOverlayIntoGUI(@NotNull ItemStack stack, int xPosition, int yPosition) {
        ToolChargeBarRenderer.renderBarsItem(this, stack, xPosition, yPosition);
    }

    public class MetaValueItem {
        public final int metaValue;
        public final String unlocalizedName;
        private IItemNameProvider nameProvider;
        private IItemMaxStackSizeProvider stackSizeProvider;
        private IItemContainerItemProvider containerItemProvider;
        private ISubItemHandler subItemHandler = DefaultSubItemHandler.INSTANCE;
        private final List<IItemComponent> allStats = new ArrayList<IItemComponent>();
        private final List<IItemBehaviour> behaviours = new ArrayList<IItemBehaviour>();
        private IItemUseManager useManager;
        private ItemUIFactory uiManager;
        private IItemColorProvider colorProvider;
        private IItemDurabilityManager durabilityManager;
        private IEnchantabilityHelper enchantabilityHelper;
        private EnumRarity rarity;
        private int burnValue = 0;
        private int maxStackSize = 64;
        private int modelAmount = 1;
        @Nullable
        private CreativeTabs[] creativeTabsOverride;

        public MetaItem<T> getMetaItem() {
            return MetaItem.this;
        }

        protected MetaValueItem(int metaValue, String unlocalizedName) {
            this.metaValue = metaValue;
            this.unlocalizedName = unlocalizedName;
        }

        public MetaValueItem setMaterialInfo(ItemMaterialInfo materialInfo) {
            if (materialInfo == null) {
                throw new IllegalArgumentException("Cannot add null ItemMaterialInfo.");
            }
            OreDictUnifier.registerOre(this.getStackForm(), materialInfo);
            return this;
        }

        public MetaValueItem setUnificationData(OrePrefix prefix, @Nullable Material material) {
            if (prefix == null) {
                throw new IllegalArgumentException("Cannot add null OrePrefix.");
            }
            OreDictUnifier.registerOre(this.getStackForm(), prefix, material);
            return this;
        }

        public MetaValueItem addOreDict(String oreDictName) {
            if (oreDictName == null) {
                throw new IllegalArgumentException("Cannot add null OreDictName.");
            }
            OreDictionary.registerOre((String)oreDictName, (ItemStack)this.getStackForm());
            return this;
        }

        public MetaValueItem addOreDict(OreDictNames oreDictName) {
            if (oreDictName == null) {
                throw new IllegalArgumentException("Cannot add null OreDictName.");
            }
            OreDictionary.registerOre((String)oreDictName.name(), (ItemStack)this.getStackForm());
            return this;
        }

        public MetaValueItem setCreativeTabs(CreativeTabs ... tabs) {
            this.creativeTabsOverride = tabs;
            MetaItem.this.addAdditionalCreativeTabs(tabs);
            return this;
        }

        public MetaValueItem setInvisibleIf(boolean hide) {
            if (hide) {
                this.creativeTabsOverride = new CreativeTabs[0];
            }
            return this;
        }

        public MetaValueItem setInvisible() {
            this.creativeTabsOverride = new CreativeTabs[0];
            return this;
        }

        public MetaValueItem setMaxStackSize(int maxStackSize) {
            if (maxStackSize <= 0) {
                throw new IllegalArgumentException("Cannot set Max Stack Size to negative or zero value.");
            }
            this.maxStackSize = maxStackSize;
            return this;
        }

        public MetaValueItem setBurnValue(int burnValue) {
            if (burnValue <= 0) {
                throw new IllegalArgumentException("Cannot set Burn Value to negative or zero number.");
            }
            this.burnValue = burnValue;
            return this;
        }

        public MetaValueItem disableModelLoading() {
            this.modelAmount = 0;
            return this;
        }

        public MetaValueItem setModelAmount(int modelAmount) {
            if (modelAmount <= 0) {
                throw new IllegalArgumentException("Cannot set amount of models to negative or zero number.");
            }
            this.modelAmount = modelAmount;
            return this;
        }

        public MetaValueItem setRarity(EnumRarity rarity) {
            this.rarity = rarity;
            return this;
        }

        public MetaValueItem addComponents(IItemComponent ... stats) {
            this.addItemComponentsInternal(stats);
            return this;
        }

        protected void addItemComponentsInternal(IItemComponent ... stats) {
            for (IItemComponent itemComponent : stats) {
                if (itemComponent instanceof IItemNameProvider) {
                    this.nameProvider = (IItemNameProvider)itemComponent;
                }
                if (itemComponent instanceof IItemMaxStackSizeProvider) {
                    this.stackSizeProvider = (IItemMaxStackSizeProvider)itemComponent;
                }
                if (itemComponent instanceof ISubItemHandler) {
                    this.subItemHandler = (ISubItemHandler)itemComponent;
                }
                if (itemComponent instanceof IItemContainerItemProvider) {
                    this.containerItemProvider = (IItemContainerItemProvider)itemComponent;
                }
                if (itemComponent instanceof IItemDurabilityManager) {
                    this.durabilityManager = (IItemDurabilityManager)itemComponent;
                }
                if (itemComponent instanceof IItemUseManager) {
                    this.useManager = (IItemUseManager)itemComponent;
                }
                if (itemComponent instanceof IFoodBehavior) {
                    this.useManager = new FoodUseManager((IFoodBehavior)itemComponent);
                }
                if (itemComponent instanceof ItemUIFactory) {
                    this.uiManager = (ItemUIFactory)itemComponent;
                }
                if (itemComponent instanceof IItemColorProvider) {
                    this.colorProvider = (IItemColorProvider)itemComponent;
                }
                if (itemComponent instanceof IItemBehaviour) {
                    this.behaviours.add((IItemBehaviour)itemComponent);
                    ((IItemBehaviour)itemComponent).addPropertyOverride(this.getMetaItem());
                }
                if (itemComponent instanceof IEnchantabilityHelper) {
                    this.enchantabilityHelper = (IEnchantabilityHelper)itemComponent;
                }
                this.allStats.add(itemComponent);
            }
        }

        public int getMetaValue() {
            return this.metaValue;
        }

        public List<IItemComponent> getAllStats() {
            return Collections.unmodifiableList(this.allStats);
        }

        public List<IItemBehaviour> getBehaviours() {
            return Collections.unmodifiableList(this.behaviours);
        }

        public ISubItemHandler getSubItemHandler() {
            return this.subItemHandler;
        }

        @Nullable
        public IItemDurabilityManager getDurabilityManager() {
            return this.durabilityManager;
        }

        @Nullable
        public IItemUseManager getUseManager() {
            return this.useManager;
        }

        @Nullable
        public ItemUIFactory getUIManager() {
            return this.uiManager;
        }

        @Nullable
        public IItemColorProvider getColorProvider() {
            return this.colorProvider;
        }

        @Nullable
        public IItemNameProvider getNameProvider() {
            return this.nameProvider;
        }

        @Nullable
        public IItemContainerItemProvider getContainerItemProvider() {
            return this.containerItemProvider;
        }

        @Nullable
        public IEnchantabilityHelper getEnchantabilityHelper() {
            return this.enchantabilityHelper;
        }

        public int getBurnValue() {
            return this.burnValue;
        }

        public int getMaxStackSize(ItemStack stack) {
            return this.stackSizeProvider == null ? this.maxStackSize : this.stackSizeProvider.getMaxStackSize(stack, this.maxStackSize);
        }

        public boolean isVisible() {
            return this.creativeTabsOverride == null || this.creativeTabsOverride.length > 0;
        }

        public int getModelAmount() {
            return this.modelAmount;
        }

        public EnumRarity getRarity() {
            return this.rarity;
        }

        public ItemStack getStackForm(int amount) {
            return new ItemStack((Item)MetaItem.this, amount, MetaItem.this.metaItemOffset + this.metaValue);
        }

        public boolean isItemEqual(ItemStack itemStack) {
            return itemStack.func_77973_b() == MetaItem.this && itemStack.func_77952_i() == MetaItem.this.metaItemOffset + this.metaValue;
        }

        public ItemStack getStackForm() {
            return this.getStackForm(1);
        }

        public ItemStack getChargedStack(long chargeAmount) {
            ItemStack itemStack = this.getStackForm(1);
            IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            if (electricItem == null) {
                throw new IllegalStateException("Not an electric item.");
            }
            electricItem.charge(chargeAmount, Integer.MAX_VALUE, true, false);
            return itemStack;
        }

        public ItemStack getInfiniteChargedStack() {
            ItemStack itemStack = this.getStackForm(1);
            IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            if (!(electricItem instanceof ElectricItem)) {
                throw new IllegalStateException("Not a supported electric item.");
            }
            ((ElectricItem)electricItem).setInfiniteCharge(true);
            return itemStack;
        }

        public ItemStack getMaxChargeOverrideStack(long maxCharge) {
            ItemStack itemStack = this.getStackForm(1);
            IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            if (electricItem == null) {
                throw new IllegalStateException("Not an electric item.");
            }
            if (!(electricItem instanceof ElectricItem)) {
                throw new IllegalStateException("Only standard ElectricItem implementation supported, but this item uses " + electricItem.getClass());
            }
            ((ElectricItem)electricItem).setMaxChargeOverride(maxCharge);
            return itemStack;
        }

        public ItemStack getChargedStackWithOverride(IElectricItem source) {
            ItemStack itemStack = this.getStackForm(1);
            IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            if (electricItem == null) {
                throw new IllegalStateException("Not an electric item.");
            }
            if (!(electricItem instanceof ElectricItem)) {
                throw new IllegalStateException("Only standard ElectricItem implementation supported, but this item uses " + electricItem.getClass());
            }
            ((ElectricItem)electricItem).setMaxChargeOverride(source.getMaxCharge());
            long charge = source.discharge(Long.MAX_VALUE, Integer.MAX_VALUE, true, false, true);
            electricItem.charge(charge, Integer.MAX_VALUE, true, false);
            return itemStack;
        }

        public boolean isInCreativeTab(CreativeTabs tab) {
            Object[] tabs = this.creativeTabsOverride != null ? this.creativeTabsOverride : MetaItem.this.defaultCreativeTabs;
            return tabs.length > 0 && (tab == CreativeTabs.field_78027_g || ArrayUtils.contains((Object[])tabs, (Object)tab));
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("metaValue", this.metaValue).append("unlocalizedName", (Object)this.unlocalizedName).toString();
        }
    }
}

